/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.ResumeForm;
import com.pingidentity.adapters.htmlform.pwdreset.type.ResumeResult;
import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class ResumeHandler
extends BaseHandler {
    private static Log logger = LogFactory.getLog(ResumeHandler.class);

    public ResumeHandler(PasswordResetConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        super(configuration, request, response);
    }

    public ResumeResult validateLink(ResumeForm resumeForm, HttpServletRequest request, HttpServletResponse response, Map<String, AttributeValue> attrs) {
        if (resumeForm.getReferenceId() == null || resumeForm.getReferenceId().isEmpty()) {
            logger.debug((Object)"No Reference Id found in the form data");
            return ResumeResult.NoReferenceId;
        }
        if (attrs == null || attrs.isEmpty()) {
            logger.debug((Object)("No attributes found for reference id " + resumeForm.getReferenceId()));
            return ResumeResult.InvalidLink;
        }
        AttributeMap refAttributes = new AttributeMap(attrs);
        if (this.isReplayed(attrs.get("prCodeMapCode").getValue())) {
            logger.debug((Object)("The reference id has already been used for a successful password reset and cannot be re-used " + resumeForm.getReferenceId()));
            return ResumeResult.LinkUsed;
        }
        AttributeMap codeAttrMap = new AttributeMap();
        codeAttrMap.put("prCodeMapCode", refAttributes.getSingleValue("prCodeMapCode"));
        codeAttrMap.put("prExpTime", refAttributes.getSingleValue("prExpTime"));
        PasswordResetSessionState sessionState = this.getSessionState();
        sessionState.setCodeAttributeMap(codeAttrMap);
        sessionState.setUsername(refAttributes.getSingleValue("prUsername"));
        sessionState.setAdapterId(refAttributes.getSingleValue("adapterId"));
        sessionState.setPcvId(refAttributes.getSingleValue("pcvId"));
        sessionState.setRememberUsername(Boolean.parseBoolean(refAttributes.getSingleValue("prEnableRememberUsername")));
        Map<String, Object> defaultParams = this.populateDefaultParams(refAttributes);
        sessionState.setDefaultTemplateParams(defaultParams);
        return ResumeResult.Success;
    }

    private Map<String, Object> populateDefaultParams(AttributeMap refAttributes) {
        String entityId = refAttributes.getSingleValue(AdapterDefaultTemplateParams.ENTITY_ID.getParamName());
        String clientId = refAttributes.getSingleValue(AdapterDefaultTemplateParams.CLIENT_ID.getParamName());
        String baseUrl = BaseUrlAccessor.getCurrentBaseUrl();
        return new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.IDP).entityId(entityId).clientId(clientId).baseUrl(baseUrl).build();
    }

    private boolean isReplayed(String code) {
        AssertionReplayPreventionService replaySvc = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
        return replaySvc.containsId(code);
    }
}

