/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.SecurityCodeForm;
import com.pingidentity.adapters.htmlform.pwdreset.type.SecurityCodeResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.log.AttributeMap;

public class SecurityCodeHandler
extends BaseHandler {
    private static Log logger = LogFactory.getLog(SecurityCodeHandler.class);

    public SecurityCodeHandler(PasswordResetConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        super(configuration, request, response);
    }

    public SecurityCodeResult validateCode(SecurityCodeForm securityCodeForm, HttpServletRequest request, HttpServletResponse response) {
        if (!securityCodeForm.isSubmit()) {
            logger.debug((Object)"Form was not submitted");
            return SecurityCodeResult.Cancel;
        }
        if (StringUtils.isEmpty((String)securityCodeForm.getSecurityCode())) {
            logger.debug((Object)"No Security Code found in the form data");
            return SecurityCodeResult.NoCode;
        }
        AttributeMap userAttributes = this.getCodeAttributeMap();
        String trimmedCode = securityCodeForm.getSecurityCode().trim();
        if (userAttributes != null && !trimmedCode.isEmpty()) {
            return this.validateCode(this.getSessionState().getUsername(), trimmedCode, userAttributes, request, response).asSecurityCodeResult();
        }
        return SecurityCodeResult.InvalidCode;
    }
}

