/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfigHelper;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.AccountUnlockHandler;
import com.pingidentity.adapters.htmlform.pwdreset.type.ResetResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.pwdreset.util.UrlUtil;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.impl.proxy.LockingServiceFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public abstract class AbstractPasswordResetServlet
extends AbstractPasswordManagementServlet {
    private final LockingServiceFactory lockingServiceFactory;
    public static final String INVALID_STATE_MESSAGE = "Invalid state (unauthorized method)";

    public AbstractPasswordResetServlet() {
        this(MgmtFactory.getAccountLockingService());
    }

    public AbstractPasswordResetServlet(LockingServiceFactory lockingServiceFactory) {
        this.lockingServiceFactory = lockingServiceFactory;
    }

    @Override
    protected PasswordResetSessionState getSessionState(HttpServletRequest request, HttpServletResponse response) {
        return PasswordResetSessionState.get(request, response);
    }

    protected PasswordResetConfiguration getConfiguration(String adapterId) {
        return PasswordResetConfigHelper.get(adapterId);
    }

    @Override
    protected PasswordResetConfiguration getConfiguration(HttpServletRequest request, HttpServletResponse response) {
        String adapterId = this.getAdapterId(request, response);
        return PasswordResetConfigHelper.get(adapterId);
    }

    protected String validateCSRFToken(HttpServletRequest request, HttpServletResponse response) {
        String cSRFToken = CrossSiteRequestForgeryHelper.getCSRFToken((HttpServletRequest)request, (HttpServletResponse)response);
        String cSRFTokenForm = request.getParameter(TemplateKey.CSRF_TOKEN.getKey());
        CrossSiteRequestForgeryHelper.ValidationStatus validationStatus = CrossSiteRequestForgeryHelper.validateCSRFToken((String)cSRFToken, (String)cSRFTokenForm);
        return validationStatus.getValue();
    }

    protected void resetLoginAttempt(HttpServletRequest request, HttpServletResponse response) {
        String username = this.getUsername(request, response);
        LockingService lockingService = this.lockingServiceFactory.getInstance(HtmlFormIdpAuthnAdapter.class.getSimpleName() + this.getAdapterId(request, response));
        lockingService.clearFailedLogins(request.getRemoteAddr() + username);
    }

    private String getUnlockSuccessful(HttpServletRequest request) {
        UrlUtil urlUtil = new UrlUtil(request);
        try {
            return urlUtil.buildUnlockSuccessUrl();
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error while processing a account unlock. ", (Throwable)ex);
        }
    }

    private void handleAuthnApiAccountUnlock(HttpServletRequest request, HttpServletResponse response, AccountUnlockHandler unlockHandler) throws IOException {
        String username = this.getUsername(request, response);
        PwdResetAuditLogger.init("ACCOUNT_UNLOCK", request, response);
        ResetResult result = unlockHandler.unlockAccount(username, request, response);
        if (result == ResetResult.Success) {
            PasswordResetSessionState passwordManagementSessionState = this.getSessionState(request, response);
            passwordManagementSessionState.setSuccessAuthenticationStageCompleted();
            PwdResetAuditLogger.log();
            this.resetLoginAttempt(request, response);
            PasswordResetHandler.reissueRequestToPasswordResetAccountUnlockedServlet(request, response);
        } else {
            PwdResetAuditLogger.logFailure();
            this.handleError(request, response, "account-unlock.error");
        }
    }

    protected void handleAuthnApiSuccessActionRequestReissue(HttpServletRequest request, HttpServletResponse response, PasswordResetConfiguration configuration) throws IOException {
        ResetResult accountStatus = ResetResult.None;
        if (ResetResult.Error == (accountStatus = this.handleAccountUnlock(request, response, configuration, accountStatus, true))) {
            PwdResetAuditLogger.logFailure();
            this.handleError(request, response, "account-unlock.error");
        } else if (ResetResult.Locked != accountStatus) {
            PwdResetAuditLogger.log();
            PasswordResetHandler.reissueRequestToPasswordResetServlet(request, response);
        }
    }

    private ResetResult handleAccountUnlock(HttpServletRequest request, HttpServletResponse response, PasswordResetConfiguration configuration, ResetResult accountStatus, boolean handleAuthApiUnlock) throws IOException {
        AccountUnlockHandler unlockHandler = null;
        if (configuration.isEnableAccountUnlock()) {
            unlockHandler = new AccountUnlockHandler(configuration, request, response);
            String username = this.getUsername(request, response);
            accountStatus = unlockHandler.isUserAccountLocked(username, request, response);
        }
        if (ResetResult.Locked == accountStatus) {
            if (handleAuthApiUnlock) {
                this.handleAuthnApiAccountUnlock(request, response, unlockHandler);
            } else {
                this.handleAccountUnlock(request, response, unlockHandler);
            }
        }
        return accountStatus;
    }

    private void handleAuthnApiAccountUnlockRedirect(HttpServletRequest request, HttpServletResponse response, AccountUnlockHandler unlockHandler, String authnApiAppId, String authnApiFlowId) throws IOException {
        PwdResetAuditLogger.init("ACCOUNT_UNLOCK", request, response);
        String username = this.getUsername(request, response);
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        ResetResult result = unlockHandler.unlockAccount(username, request, response);
        if (result == ResetResult.Success) {
            PwdResetAuditLogger.log();
            PasswordResetSessionState passwordManagementSessionState = this.getSessionState(request, response);
            passwordManagementSessionState.setSuccessAuthenticationStageCompleted();
            this.resetLoginAttempt(request, response);
            PasswordResetHandler.redirectToPasswordResetAccountUnlockedServlet(request, response, authnApiAppId, authnApiFlowId);
        } else {
            PwdResetAuditLogger.logFailure();
            sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
            sessionState.setErrorMessageKey("account-unlock.error");
            PasswordResetHandler.redirectToPasswordResetErrorServlet(request, response, authnApiAppId, authnApiFlowId);
        }
    }

    protected void handleAuthnApiSuccessActionRedirect(HttpServletRequest request, HttpServletResponse response, PasswordResetConfiguration configuration, String authnApiAppId, String authnApiFlowId) throws IOException {
        ResetResult accountStatus = ResetResult.None;
        AccountUnlockHandler unlockHandler = null;
        if (configuration.isEnableAccountUnlock()) {
            unlockHandler = new AccountUnlockHandler(configuration, request, response);
            String username = this.getUsername(request, response);
            accountStatus = unlockHandler.isUserAccountLocked(username, request, response);
        }
        if (ResetResult.Locked == accountStatus) {
            this.handleAuthnApiAccountUnlockRedirect(request, response, unlockHandler, authnApiAppId, authnApiFlowId);
        } else if (ResetResult.Error == accountStatus) {
            PwdResetAuditLogger.logFailure();
            PasswordResetSessionState sessionState = this.getSessionState(request, response);
            sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
            sessionState.setErrorMessageKey("account-unlock.error");
            PasswordResetHandler.redirectToPasswordResetErrorServlet(request, response, authnApiAppId, authnApiFlowId);
        } else {
            PwdResetAuditLogger.log();
            PasswordResetHandler.redirectToPasswordResetServlet(request, response, authnApiAppId, authnApiFlowId);
        }
    }

    protected void handleSuccessAction(HttpServletRequest request, HttpServletResponse response, PasswordResetConfiguration configuration) throws IOException {
        ResetResult accountStatus = ResetResult.None;
        accountStatus = this.handleAccountUnlock(request, response, configuration, accountStatus, false);
        if (!response.isCommitted()) {
            if (ResetResult.Error == accountStatus) {
                PwdResetAuditLogger.logFailure();
                this.handleError(request, response, "account-unlock.error");
            } else {
                PwdResetAuditLogger.log();
                UrlUtil urlUtil = new UrlUtil(request);
                this.redirect(response, urlUtil.buildResetUrl());
            }
        }
    }

    private void handleAccountUnlock(HttpServletRequest request, HttpServletResponse response, AccountUnlockHandler unlockHandler) throws IOException {
        PwdResetAuditLogger.init("ACCOUNT_UNLOCK", request, response);
        String username = this.getUsername(request, response);
        ResetResult result = unlockHandler.unlockAccount(username, request, response);
        if (result == ResetResult.Success) {
            PasswordResetSessionState passwordManagementSessionState = this.getSessionState(request, response);
            passwordManagementSessionState.setSuccessAuthenticationStageCompleted();
            PwdResetAuditLogger.log();
            this.resetLoginAttempt(request, response);
            this.redirect(response, this.getUnlockSuccessful(request));
        } else {
            PwdResetAuditLogger.logFailure();
            this.handleError(request, response, "account-unlock.error");
        }
    }

    @Override
    protected void populateAdapterActionParam(Map<String, Object> stateParams) {
        stateParams.put("PartnerEntityId", "com.pingidentity.pf.passwordreset");
        stateParams.put("adapterAction", "com.pingidentity.pf.passwordreset");
    }

    protected void doCancel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey("forgot-password-error.cancel");
        if (AuthnApiSupport.getDefault().isApiRequest(request) && sessionState.isFromHtmlFormAdapter()) {
            PasswordResetHandler.reissueRequestToHtmlFormAdapter(request, response);
        } else if (!AuthnApiSupport.getDefault().isApiRequest(request) && sessionState.getTargetResource() != null) {
            this.redirect(response, sessionState.getTargetResource());
        } else {
            this.handleError(request, response, "forgot-password-error.cancel");
        }
    }

    protected void handleError(HttpServletRequest request, HttpServletResponse response, String errorMessageKey) throws IOException {
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey(errorMessageKey);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            PasswordResetHandler.reissueRequestToPasswordResetErrorServlet(request, response);
        } else {
            UrlUtil urlUtil = new UrlUtil(request);
            this.redirect(response, urlUtil.buildErrorUrl());
        }
    }
}

