/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.handler.AccountUnlockHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.AccountUnlockSuccessForm;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.util.UrlUtil;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class AccountUnlockServlet
extends AbstractPasswordResetServlet {
    private static final Log logger = LogFactory.getLog(AccountUnlockServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdreset/Unlock");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.COMPLETED, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        String target = this.getSessionState(request, response).getTargetResource();
        if (target != null && !target.isEmpty()) {
            defaultParams.put("successContinue", "true");
        }
        boolean isVerificationSecurityCode = !"OTL".equals(configuration.getResetType());
        defaultParams.put("showAction", isVerificationSecurityCode);
        if (isVerificationSecurityCode && StringUtils.isNotEmpty((String)target)) {
            defaultParams.put("successMessage", "account-unlock.info");
        } else {
            defaultParams.put("successMessage", "account-unlock.unlockedMessage");
        }
        this.render(request, response, defaultParams);
    }

    private void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        params.put("url", request.getContextPath() + "/");
        params.put(TemplateKey.OK.getKey(), "Unlock");
        params.put("reset", "Reset");
        params.put(TemplateKey.CANCEL.getKey(), "Cancel");
        try {
            PasswordResetConfiguration configuration = this.getConfiguration(request, response);
            ResponseHandler.renderPasswordResetSuccessfulAccountUnlockResponse(request, response, configuration.getUnlockTemplate(), params);
        }
        catch (Exception ex) {
            logger.error((Object)"Error on Request to /ext/pwdreset/Unlock", (Throwable)ex);
            throw new ProcessRuntimeException((Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdreset/Unlock");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.COMPLETED, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(request) && !PasswordResetHandler.isValidApiPostRequest(request, response, CommonStateSpec.SUCCESSFUL_ACCOUNT_UNLOCK)) {
            return;
        }
        UrlUtil urlUtil = new UrlUtil(request);
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        AccountUnlockHandler successHandler = new AccountUnlockHandler(configuration, request, response);
        AccountUnlockSuccessForm form = new AccountUnlockSuccessForm(request);
        AccountUnlockHandler.AccountUnlockSuccessAction formAction = successHandler.action(form, request, response);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            if (CommonActionSpec.CONTINUE_AUTHENTICATION.isRequested(request)) {
                PasswordResetHandler.reissueRequestToHtmlFormAdapter(request, response);
                return;
            } else {
                if (!CommonActionSpec.CONTINUE_ACCOUNT_RECOVERY.isRequested(request)) throw new ProcessRuntimeException("Unexpected authentication api request.");
                this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response);
                PasswordResetHandler.reissueRequestToPasswordResetServlet(request, response);
            }
            return;
        } else if (formAction.equals((Object)AccountUnlockHandler.AccountUnlockSuccessAction.Continue)) {
            String target = this.getSessionState(request, response).getTargetResource();
            this.redirect(response, target);
            return;
        } else if (formAction.equals((Object)AccountUnlockHandler.AccountUnlockSuccessAction.Reset)) {
            this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response);
            this.redirect(response, urlUtil.buildResetUrl());
            return;
        } else {
            if (!formAction.equals((Object)AccountUnlockHandler.AccountUnlockSuccessAction.Cancel)) return;
            this.doCancel(request, response);
        }
    }
}

