/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ErrorServlet
extends AbstractPasswordResetServlet {
    private static Log logger = LogFactory.getLog(ErrorServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        logger.debug((Object)"GET Request to /ext/pwdreset/Error");
        this.render(request, response, this.getDefaultTemplateParams(request, response));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdreset/Error");
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            AuthnApiSupport.getDefault().writeErrorResponse(request, response, CommonErrorSpec.INVALID_ACTION_ID.makeInstanceBuilder().build());
        }
        this.render(request, response, this.getDefaultTemplateParams(request, response));
    }

    protected void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        String message = this.getSessionState(request, response).getErrorMessageKey();
        if (message != null) {
            params.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), message);
        }
        params.put("forgotTitle", "account.recovery.title");
        params.put("url", request.getContextPath() + "/");
        try {
            String templateName = "forgot-password-error.html";
            String adapterId = this.getAdapterId(request, response);
            if (adapterId != null) {
                templateName = this.getConfiguration(adapterId).getErrorTemplate();
            }
            ResponseHandler.renderPasswordResetErrorResponse(request, response, templateName, params);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error on Request to /ext/pwdreset/Error", (Throwable)ex);
        }
    }

    @Override
    protected boolean canSkipStageValidation() {
        return true;
    }
}

