/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetAuthnSourceSupport;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.state.PasswordResetStateSupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.idp.PasswordResetAuthenticationResult;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PolicyServlet
extends AbstractPasswordResetServlet
implements ResumeRequestFromAuthnResponseHandler {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(PolicyServlet.class);
    private transient PasswordResetStateSupport stateSupport = new PasswordResetStateSupport(MetaDataFactory.getLocalMetaData());

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdreset/Policy");
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || !this.validResetType(configuration.getResetType())) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        PwdResetAuditLogger.init("PWD_RESET_REQUEST_RESPONSE", request, response);
        if (this.stateSupport.isResumeRequest(request)) {
            this.resume(request, response);
        } else {
            this.createResetFlow(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdreset/Policy");
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || !this.validResetType(configuration.getResetType())) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        PwdResetAuditLogger.init("PWD_RESET_REQUEST_RESPONSE", request, response);
        if (this.stateSupport.isResumeRequest(request)) {
            this.resume(request, response);
        } else {
            this.createResetFlow(request, response);
        }
    }

    private void resume(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String stateKey = this.stateSupport.getStateKey(request, response);
        try {
            State state = StateMgmtFactory.retrieveAndRemoveState((String)stateKey, (boolean)false, (HttpServletRequest)request, (HttpServletResponse)response);
            if (state == null) {
                PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
                this.handleError(request, response, "forgot-password-error.invalidState");
                return;
            }
            this.resumeAuthn(state.getInMsgCtx(), request, response, state.getOutMsgCtx(), state.getParameters());
        }
        catch (RenderPageException renderPageException) {
            // empty catch block
        }
    }

    private void createResetFlow(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> stateParams = new HashMap<String, Object>();
        InMessageContext inMsgCtx = new InMessageContext();
        this.populateStateParamsForFlow(request, response, stateParams, inMsgCtx);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            String contextRoot = PropertyInfo.getContextPath();
            contextRoot = contextRoot.equals("/") ? "" : contextRoot;
            String policyPath = contextRoot + "/ext/pwdreset/Policy";
            String flowId = AuthnApiSupport.getDefault().getFlowId(request.getPathInfo());
            StateSupport.overridePath((HttpServletRequest)request, (String)this.stateSupport.makeResumePath(policyPath, false, flowId));
        }
        this.resumeAuthn(inMsgCtx, request, response, null, stateParams);
    }

    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest request, HttpServletResponse response, OutMessageContext outMsgCtx, Map<String, Object> stateParams) throws IOException {
        boolean isValid = this.validateTransactionId(request, response, stateParams.get("PRPS.PolicyTransactionId"));
        if (!isValid) {
            String msg = "The password reset transaction failed due to authentication policy transaction ID change";
            PwdResetAuditLogger.logFailure(msg);
            logger.debug((Object)msg);
            this.handleError(request, response, "forgot-password-error.unknownError");
            return;
        }
        String resumePath = this.stateSupport.saveState(request, response, inMsgCtx, outMsgCtx, stateParams, null);
        try {
            PasswordResetAuthnSourceSupport pwdResetAuthnSourceSupport = new PasswordResetAuthnSourceSupport();
            AuthnPolicy authnPolicy = new AuthnPolicy(true, true);
            PasswordResetAuthenticationResult authnResult = pwdResetAuthnSourceSupport.lookupAuthNs(request, response, authnPolicy, resumePath, stateParams, inMsgCtx, null, (ResumeRequestFromAuthnResponseHandler)this, false);
            if (authnResult != null) {
                this.handleAuthnResult(request, response, authnResult, stateParams);
            } else if (!response.isCommitted()) {
                PwdResetAuditLogger.logFailure("Unable to select an authentication policy for user authentication.");
                this.handleError(request, response, "forgot-password-error.unknownError");
            }
        }
        catch (IOException | AuthnAdapterException | AuthorizationException | AuthnProcessorException e) {
            this.restoreParentFlowState(request, response, stateParams);
            PwdResetAuditLogger.logFailure("Error while processing authentication sources from the selected policy. Refer to server logs for details.");
            logger.error((Object)("Error processing selected policy for policy contract ID: " + stateParams.get("policy_contract_id") + ". " + (Exception)e));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), e);
            }
            this.handleErrorWithException(request, response, "forgot-password-error.unknownError", (Exception)e);
        }
    }

    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext respOutMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) {
    }

    public boolean isAuthnApiHandlesException(HttpServletRequest req, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        return this.isAuthnApiHandlesResult(req, stateParams);
    }

    public boolean isAuthnApiHandlesResult(HttpServletRequest req, Map<String, Object> stateParams) {
        return AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(stateParams) || this.getOrigAuthnApiAppId(stateParams) != null;
    }

    public AuthnApiApplication getAuthnApiAppOverride(HttpServletRequest req, Map<String, Object> stateParams) {
        String authnApiAppId = this.getOrigAuthnApiAppId(stateParams);
        if (authnApiAppId == null) {
            return null;
        }
        return MgmtFactory.getAuthnApiManager().getApiApplication(authnApiAppId);
    }

    private void handleAuthnResult(HttpServletRequest request, HttpServletResponse response, PasswordResetAuthenticationResult authnResult, Map<String, Object> stateParams) throws IOException {
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        switch (authnResult.getStatus()) {
            case RESTART: {
                break;
            }
            case FINISHED: {
                this.restoreParentFlowState(request, response, stateParams);
                if (authnResult.getAuthnBeans() == null) {
                    PwdResetAuditLogger.logFailure("User authentication through authentication policy failed.");
                    this.handleError(request, response, "forgot-password-error.authFailed");
                    break;
                }
                if (configuration.getPasswordUpdateTimeout() != null) {
                    this.getSessionState(request, response).refreshPasswordUpdateSession();
                }
                this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response);
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    this.handleAuthnApiSuccessActionRequestReissue(request, response, configuration);
                    break;
                }
                this.handleSuccessAction(request, response, configuration);
                break;
            }
            case FALL_THROUGH: {
                this.restoreParentFlowState(request, response, stateParams);
                PwdResetAuditLogger.logFailure("User authentication through authentication policy failed.");
                logger.debug((Object)("Failed to select a Policy during Password Reset for Adapter ID:" + configuration.getAdapterId()));
                this.handleError(request, response, "forgot-password-error.unknownError");
                break;
            }
        }
    }

    private boolean validResetType(String resetType) {
        return "POLICY".equals(resetType);
    }

    private void handleErrorWithException(HttpServletRequest request, HttpServletResponse response, String errorMessage, Exception exception) throws IOException {
        if (exception instanceof AuthorizationException && exception.getMessage() != null) {
            errorMessage = exception.getMessage();
        }
        this.handleError(request, response, errorMessage);
    }
}

