/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.SecurityCodeHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.SecurityCodeForm;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.pwdreset.type.SecurityCodeResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class SecurityCodeServlet
extends AbstractPasswordResetServlet {
    private static Log logger = LogFactory.getLog(SecurityCodeServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdreset/SecurityCode");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || !this.validResetType(request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        Map<String, Object> userAttributes = this.getSessionState(request, response).getUserAttributes();
        defaultParams.putAll(userAttributes);
        String cSRFToken = CrossSiteRequestForgeryHelper.getCSRFToken((HttpServletRequest)request, (HttpServletResponse)response);
        defaultParams.put(TemplateKey.CSRF_TOKEN.getKey(), cSRFToken);
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        if (configuration.getResetType() != null) {
            if (configuration.getResetType().equals("SMS")) {
                defaultParams.put("sms", "true");
            } else {
                defaultParams.put("email", "true");
            }
        } else {
            defaultParams.put("email", "true");
        }
        this.render(request, response, defaultParams);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdreset/SecurityCode");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        PwdResetAuditLogger.init("PWD_RESET_REQUEST_RESPONSE", request, response);
        if (!HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, CommonStateSpec.RECOVERY_CODE_REQUIRED)) {
            return;
        }
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || !this.validResetType(request, response)) {
            PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        if (!AuthnApiSupport.getDefault().isApiRequest(request)) {
            String cSRFToken = this.validateCSRFToken(request, response);
            if (cSRFToken == null) {
                PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
                this.handleError(request, response, "forgot-password-error.invalidState");
                return;
            }
            defaultParams.put(TemplateKey.CSRF_TOKEN.getKey(), cSRFToken);
        }
        SecurityCodeForm form = new SecurityCodeForm(request);
        PwdResetAuditLogger.setUserName((String)this.getUsername(request, response));
        SecurityCodeHandler handler = new SecurityCodeHandler(configuration, request, response);
        SecurityCodeResult validationResult = handler.validateCode(form, request, response);
        if (configuration.getResetType() != null) {
            if (configuration.getResetType().equals("SMS")) {
                defaultParams.put("sms", "true");
            } else {
                defaultParams.put("email", "true");
            }
        } else {
            defaultParams.put("email", "true");
        }
        PasswordResetSessionState sessionState = this.getSessionState(request, response);
        switch (validationResult) {
            case Error: {
                PwdResetAuditLogger.logFailure();
                this.handleError(request, response, "forgot-password-error.codeMismatch");
                break;
            }
            case Success: {
                if (configuration.getPasswordUpdateTimeout() != null) {
                    sessionState.refreshPasswordUpdateSession();
                }
                this.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED, request, response);
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    this.handleAuthnApiSuccessActionRequestReissue(request, response, configuration);
                    break;
                }
                this.handleSuccessAction(request, response, configuration);
                break;
            }
            case CodeExpired: {
                PwdResetAuditLogger.logFailure("OTP expired");
                this.handleError(request, response, "forgot-password-error.codeExpired");
                break;
            }
            case InvalidCode: {
                PwdResetAuditLogger.logFailure("Invalid OTP");
                defaultParams.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), "forgot-password-error.codeMismatch");
                this.render(request, response, defaultParams);
                break;
            }
            case Cancel: {
                logger.debug((Object)"OTP request canceled");
                this.doCancel(request, response);
                break;
            }
            case TooManyAttempts: {
                PwdResetAuditLogger.logFailure("Exceeded OTP retry attempts");
                this.handleError(request, response, "forgot-password-error.codeValidationCountExceeded");
                break;
            }
            case NoCode: {
                PwdResetAuditLogger.logFailure("No OTP provided");
                defaultParams.put("errorMessageKey", "forgot-password-resume.noSecurityCode");
                this.render(request, response, defaultParams);
            }
        }
    }

    private void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        params.put("url", request.getContextPath() + "/");
        params.put("name", "SecurityCode");
        params.put(TemplateKey.OK.getKey(), "Change");
        params.put(TemplateKey.CANCEL.getKey(), "Cancel");
        Map<String, Object> userAttributes = this.getSessionState(request, response).getUserAttributes();
        params.put(TemplateKey.USER_ATTRIBUTES.getKey(), userAttributes);
        try {
            PasswordResetConfiguration configuration = this.getConfiguration(request, response);
            ResponseHandler.renderPasswordResetRecoveryCodeRequiredResponse(request, response, configuration.getCodeTemplate(), params);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error on Request to /ext/pwdreset/SecurityCode", (Throwable)ex);
        }
    }

    private boolean validResetType(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetConfiguration configuration = this.getConfiguration(request, response);
        return "OTP".equals(configuration.getResetType()) || "SMS".equals(configuration.getResetType());
    }
}

