/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.servlet;

import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.servlet.AbstractPasswordResetServlet;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordreset.PasswordResetHandler;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class SuccessServlet
extends AbstractPasswordResetServlet {
    private static Log logger = LogFactory.getLog(SuccessServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdreset/Success");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.COMPLETED, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        this.render(request, response, this.getDefaultTemplateParams(request, response));
    }

    private AuthnStateSpec getExpectedState(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetSessionState sessionState;
        String successMessageKey = this.getSessionState(request, response).getSuccessMessageKey();
        if ("forgot-password-success.onetimeLinkSent".equals(successMessageKey)) {
            return CommonStateSpec.ACCOUNT_RECOVERY_OTL_VERIFICATION_REQUIRED;
        }
        if (("forgot-password-success.passwordChangeSuccessful".equals(successMessageKey) || "forgot-password-success.passwordChangeSuccessfulNoContinue".equals(successMessageKey)) && (sessionState = this.getSessionState(request, response)).isFromHtmlFormAdapter() && this.getSessionState(request, response).getTargetResource() != null) {
            return CommonStateSpec.SUCCESSFUL_PASSWORD_RESET;
        }
        return null;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdreset/Success");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.COMPLETED, request, response)) {
            this.handleError(request, response, "forgot-password-error.invalidState");
            return;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(request) && !HtmlFormAuthnApiHandler.isValidApiPostRequest(request, response, this.getExpectedState(request, response))) {
            return;
        }
        PasswordResetSessionState passwordResetSession = this.getSessionState(request, response);
        String target = passwordResetSession.getTargetResource();
        if (this.getConfiguration(passwordResetSession.getAdapterId()).isReAuthenticateAfterPasswordReset()) {
            this.clearState(request, response);
        }
        if (CommonActionSpec.CONTINUE_AUTHENTICATION.isRequested(request)) {
            PasswordResetHandler.reissueRequestToHtmlFormAdapter(request, response);
        } else {
            this.redirect(response, target);
        }
    }

    private void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        String message = this.getSessionState(request, response).getSuccessMessageKey();
        if (message != null) {
            params.put("messageKey", message);
        }
        params.put("url", request.getContextPath() + "/");
        String target = this.getSessionState(request, response).getTargetResource();
        if (target != null && !target.isEmpty()) {
            params.put("successContinue", "true");
        }
        try {
            PasswordResetConfiguration configuration = this.getConfiguration(request, response);
            ResponseHandler.renderPasswordResetSuccessResponse(request, response, configuration.getSuccessTemplate(), params);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error on Request to /ext/pwdreset/Success", (Throwable)ex);
        }
    }
}

