/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api;

import com.pingidentity.adapters.htmlform.render.handler.api.login.ApiLoginHandler;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.PasswordPolicyValidatorResult;
import com.pingidentity.sdk.api.authn.model.PasswordPolicyViolationDetail;
import com.pingidentity.sdk.api.authn.model.state.Resume;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public abstract class HtmlFormAuthnApiHandler
implements Serializable {
    protected static final Log log = LogFactory.getLog(HtmlFormAuthnApiHandler.class);
    private static final String HTML_FORM_ADAPTER_SAVED_API_STATE_KEY = "html_form_adapter_saved_api_state";
    private static final String SAVED_API_STATE_NULL_VALUE = "(null)";

    public abstract AuthnState<?> getAuthnState(HttpServletRequest var1, HttpServletResponse var2, Map<String, Object> var3);

    public abstract Object getApiModel(HttpServletRequest var1, HttpServletResponse var2, Map<String, Object> var3);

    public abstract AuthnError getApiError(HttpServletRequest var1, HttpServletResponse var2, Map<String, Object> var3);

    public abstract Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest var1, HttpServletResponse var2);

    public static String getAdapterId(HttpServletRequest request) {
        return AuthnPolicyUtil.getDefault().getCurrentAdapterId(request, InternalAuthnApiSupport.getDefault().getStateParams(request));
    }

    public static String getNonConnBasedAdapterId(HttpServletRequest request) {
        return AuthnPolicyUtil.getDefault().getNonConnBasedAdapterId(request, InternalAuthnApiSupport.getDefault().getStateParams(request));
    }

    public static void renderPreviousApiResponse(HttpServletRequest request, HttpServletResponse response, String resumeUrl) throws IOException {
        SavedApiState savedState = HtmlFormAuthnApiHandler.getSavedApiState(request, response, resumeUrl);
        HtmlFormAuthnApiHandler previousHandler = savedState.getHtmlFormAuthnApiHandler();
        AuthnApiSupport.getDefault().writeAuthnStateResponse(request, response, previousHandler.getAuthnState(request, response, savedState.getTemplateParams()));
    }

    public void renderApiResponse(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) throws IOException {
        AuthnError authnError = this.getApiError(request, response, templateParams);
        if (authnError != null) {
            AuthnApiSupport.getDefault().writeErrorResponse(request, response, authnError);
        } else {
            this.saveApiState(request, response, templateParams);
            AuthnApiSupport.getDefault().writeAuthnStateResponse(request, response, this.getAuthnState(request, response, templateParams));
        }
    }

    private void saveApiState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        String resumeUrl = HtmlFormAuthnApiHandler.getAuthnPolicyInitialResumeUrl(request);
        if (resumeUrl != null) {
            TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
            SavedApiState savedApiState = new SavedApiState(this, templateParams);
            transactionalStateSupport.setAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY, (Object)savedApiState, request, response);
            request.setAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY, (Object)savedApiState);
        }
    }

    public static void clearApiState(HttpServletRequest request, HttpServletResponse response) {
        String resumeUrl = HtmlFormAuthnApiHandler.getAuthnPolicyInitialResumeUrl(request);
        if (HtmlFormAuthnApiHandler.isSavedApiStateFound(request, response, resumeUrl)) {
            request.setAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY, (Object)SAVED_API_STATE_NULL_VALUE);
            TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
            transactionalStateSupport.removeAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY, request, response);
        }
    }

    private static String getAuthnPolicyInitialResumeUrl(HttpServletRequest request) {
        return (String)HtmlFormAuthnApiHandler.getApiStateParam(request, "authnPolicyInitialResumeUrl");
    }

    private static SavedApiState getSavedApiState(HttpServletRequest request, HttpServletResponse response, String resumeUrl) {
        Object savedApiStateObj = request.getAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY);
        if (SAVED_API_STATE_NULL_VALUE.equals(savedApiStateObj)) {
            return null;
        }
        if (savedApiStateObj != null) {
            return (SavedApiState)savedApiStateObj;
        }
        TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
        SavedApiState result = (SavedApiState)transactionalStateSupport.getAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY, request, response);
        if (result == null) {
            request.setAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY, (Object)SAVED_API_STATE_NULL_VALUE);
        } else {
            request.setAttribute(HTML_FORM_ADAPTER_SAVED_API_STATE_KEY, (Object)result);
        }
        return result;
    }

    public static boolean isSavedApiStateFound(HttpServletRequest request, HttpServletResponse response, String resumeUrl) {
        return HtmlFormAuthnApiHandler.getSavedApiState(request, response, resumeUrl) != null;
    }

    public static boolean isApiPostRequest(HttpServletRequest request) {
        return AuthnApiSupport.getDefault().isApiRequest(request) && "POST".equals(request.getMethod());
    }

    public static boolean isApiGetRequest(HttpServletRequest request) {
        return AuthnApiSupport.getDefault().isApiRequest(request) && "GET".equals(request.getMethod());
    }

    public static boolean isValidApiPostRequest(HttpServletRequest request, HttpServletResponse response, AuthnStateSpec<?> expectedState) throws IOException {
        HashMap expectedActionIdToModelMapping = new HashMap();
        if (expectedState != null) {
            expectedState.getActions().forEach(action -> expectedActionIdToModelMapping.put(action.getId(), action.getModelClass()));
        }
        return AuthnApiSupport.getDefault().isValidAuthnApiPostRequest(request, response, expectedActionIdToModelMapping);
    }

    public static boolean isValidApiPostRequest(HttpServletRequest request, HttpServletResponse response, String resumeUrl, String localIdentityProfileId) throws IOException {
        Map<String, Class<?>> expectedActionIdToModelClassMapping = HtmlFormAuthnApiHandler.getExpectedActionIdToModelClassMapping(request, response, resumeUrl, localIdentityProfileId);
        return AuthnApiSupport.getDefault().isValidAuthnApiPostRequest(request, response, expectedActionIdToModelClassMapping);
    }

    private static Map<String, Class<?>> getExpectedActionIdToModelClassMapping(HttpServletRequest request, HttpServletResponse response, String resumeUrl, String localIdentityProfileId) {
        HtmlFormAuthnApiHandler apiHandler = new ApiLoginHandler(localIdentityProfileId);
        SavedApiState savedApiState = HtmlFormAuthnApiHandler.getSavedApiState(request, response, resumeUrl);
        if (savedApiState != null) {
            apiHandler = savedApiState.getHtmlFormAuthnApiHandler();
        }
        return ((HtmlFormAuthnApiHandler)apiHandler).getActionIdToModelMapping(request, response);
    }

    protected static void reissueRequestToHandler(HttpServletRequest request, HttpServletResponse response, String handlerPath) {
        HtmlFormAuthnApiHandler.clearApiState(request, response);
        InternalAuthnApiSupport.getDefault().saveHandlerPath(request, handlerPath);
        InternalAuthnApiSupport.getDefault().setReissueRequest(request, response, true);
    }

    public static void reissueRequestToHtmlFormAdapter(HttpServletRequest request, HttpServletResponse response) {
        HtmlFormAuthnApiHandler.clearApiState(request, response);
        InternalAuthnApiSupport.getDefault().cleanHandlerState(request);
        InternalAuthnApiSupport.getDefault().setReissueRequest(request, response, true);
    }

    public static boolean isMissingAuthnApiCaptchaResponse(HttpServletRequest request) throws IOException {
        Map modelAction = AuthnApiSupport.getDefault().deserializeAsMap(request);
        return modelAction.get("captchaResponse") == null;
    }

    public static void sendCaptchaResponseMissingResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthnApiSupport.getDefault().writeErrorResponse(request, response, CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.FIELD_REQUIRED.makeInstanceBuilder().message("Captcha response must be provided when captcha validation is enabled.").target("captchaResponse").build()).build());
    }

    public static void writeResumeAtTargeResourceResponse(HttpServletRequest request, HttpServletResponse response, String targetResource) throws IOException {
        Resume resume = new Resume();
        resume.setResumeUrl(targetResource);
        AuthnApiSupport.getDefault().writeAuthnStateResponse(request, response, CommonStateSpec.RESUME.makeInstance(request, (Object)resume));
    }

    protected PasswordPolicyViolationDetail getPasswordPolicyViolationDetail(String code, String message, String userMessageKey, List<String> satisfiedValidators, List<String> failedValidators) {
        return new PasswordPolicyViolationDetail(code, message, userMessageKey, satisfiedValidators.stream().map(PasswordPolicyValidatorResult::new).collect(Collectors.toList()), failedValidators.stream().map(PasswordPolicyValidatorResult::new).collect(Collectors.toList()));
    }

    protected static Object getApiStateParam(HttpServletRequest request, String paramKey) {
        Map stateParams = InternalAuthnApiSupport.getDefault().getStateParams(request);
        return stateParams == null ? null : InternalAuthnApiSupport.getDefault().getStateParams(request).get(paramKey);
    }

    protected static Object retrieveApiStateParam(HttpServletRequest request, String paramKey) {
        Object value = InternalAuthnApiSupport.getDefault().getStateParams(request).get(paramKey);
        InternalAuthnApiSupport.getDefault().getStateParams(request).remove(paramKey);
        return value;
    }

    protected static void putApiStateParam(HttpServletRequest request, String paramKey, Object paramValue) {
        InternalAuthnApiSupport.getDefault().getStateParams(request).put(paramKey, paramValue);
    }

    protected static void removeApiStateParam(HttpServletRequest request, String paramKey) {
        InternalAuthnApiSupport.getDefault().getStateParams(request).remove(paramKey);
    }

    public static class SavedApiState
    implements Serializable {
        private HtmlFormAuthnApiHandler handler;
        private Map<String, Object> templateParams;

        public SavedApiState(HtmlFormAuthnApiHandler handler, Map<String, Object> templateParams) {
            this.handler = handler;
            this.templateParams = templateParams;
        }

        public HtmlFormAuthnApiHandler getHtmlFormAuthnApiHandler() {
            return this.handler;
        }

        public Map<String, Object> getTemplateParams() {
            return this.templateParams;
        }

        public void setTemplateParams(Map<String, Object> templateParams) {
            this.templateParams = templateParams;
        }
    }
}

