/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.login;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfigHelper;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.AlternativeAuthenticationSource;
import com.pingidentity.sdk.api.authn.model.state.UsernamePasswordRequired;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaProviderEnabledState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ApiLoginHandler
extends HtmlFormAuthnApiHandler {
    private List<String> alternativeAuthenticationSources = new ArrayList<String>();
    private boolean isRegistrationEnabled = false;

    public ApiLoginHandler(String localIdentityProfileId) {
        LocalIdentityProfile localIdentityProfile;
        if (localIdentityProfileId != null && (localIdentityProfile = MgmtFactory.getLocalIdentityProfileManager().getProfile(localIdentityProfileId)) != null) {
            if (localIdentityProfile.getAuthSourceStrings() != null) {
                this.alternativeAuthenticationSources = localIdentityProfile.getAuthSourceStrings();
            }
            if (localIdentityProfile.isRegistrationEnabled()) {
                this.isRegistrationEnabled = true;
            }
        }
    }

    private static ChangePasswordConfiguration getPasswordChangeConfiguration(HttpServletRequest request) {
        String adapterId = ApiLoginHandler.getAdapterId(request);
        if (adapterId == null) {
            throw new ProcessRuntimeException("Adapter id not found in html form authentication api transaction.");
        }
        ChangePasswordConfiguration changePasswordConfiguration = ChangePasswordConfigHelper.get(adapterId);
        if (changePasswordConfiguration == null) {
            throw new ProcessRuntimeException("Password change configuration not found in html form authentication api transaction.");
        }
        return changePasswordConfiguration;
    }

    private static boolean isPasswordChangeSupported(ChangePasswordConfiguration changePasswordConfiguration) {
        return changePasswordConfiguration.isAllowsChangePassword() && HtmlFormIdpAuthnAdapter.supportsPasswordChange(changePasswordConfiguration.getPcvIds(), changePasswordConfiguration.getPwmLocation());
    }

    private static boolean isPasswordResetSupported(ChangePasswordConfiguration changePasswordConfiguration) {
        return changePasswordConfiguration.isAllowsChangePassword() && HtmlFormIdpAuthnAdapter.supportsPasswordReset(changePasswordConfiguration.getPcvIds()) && !HtmlFormIdpAuthnAdapter.isResetTypeNone(changePasswordConfiguration.getResetType());
    }

    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthnState authnState = CommonStateSpec.USERNAME_PASSWORD_REQUIRED.makeInstance(request, (Object)((UsernamePasswordRequired)this.getApiModel(request, response, templateParams)));
        ChangePasswordConfiguration changePasswordConfiguration = ApiLoginHandler.getPasswordChangeConfiguration(request);
        if (!ApiLoginHandler.isPasswordChangeSupported(changePasswordConfiguration)) {
            authnState.removeAction(CommonActionSpec.INITIATE_PASSWORD_CHANGE.getId());
        }
        if (!ApiLoginHandler.isPasswordResetSupported(changePasswordConfiguration)) {
            authnState.removeAction(CommonActionSpec.INITIATE_ACCOUNT_RECOVERY.getId());
        }
        if (!changePasswordConfiguration.isEnableUsernameRecovery()) {
            authnState.removeAction(CommonActionSpec.RECOVER_USERNAME.getId());
        }
        if (this.alternativeAuthenticationSources.isEmpty()) {
            authnState.removeAction(CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId());
        }
        if (!this.isRegistrationEnabled) {
            authnState.removeAction(CommonActionSpec.INITIATE_REGISTRATION.getId());
        }
        return authnState;
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        UsernamePasswordRequired model = new UsernamePasswordRequired();
        String username = TemplateKey.USERNAME.getStringValue(templateParams);
        if (!StringUtils.isBlank((String)username)) {
            model.setUsername(username);
        }
        Boolean allowUsernameEdit = StringUtils.isNotBlank((String)username) ? TemplateKey.USERNAME_EDITABLE.getBooleanValue(templateParams) : null;
        model.setAllowUsernameEdits(allowUsernameEdit);
        Boolean rememberUsernameOptionAvailable = TemplateKey.ENABLE_REMEMBER_USERNAME.getBooleanValue(templateParams);
        model.setShowRememberMyUsername(rememberUsernameOptionAvailable == null ? false : rememberUsernameOptionAvailable);
        Boolean usernameCookieExists = TemplateKey.REMEMBER_USERNAME_COOKIE_EXISTS.getBooleanValue(templateParams);
        model.setRememberMyUsernameSelected(model.getShowRememberMyUsername() && usernameCookieExists != null && usernameCookieExists != false);
        Boolean thisIsMyDeviceOptionAvailable = TemplateKey.SHOW_MY_DEVICE_CHECKBOX.getBooleanValue(templateParams);
        model.setShowThisIsMyDevice(thisIsMyDeviceOptionAvailable == null ? false : thisIsMyDeviceOptionAvailable);
        model.setThisIsMyDeviceSelected(model.getShowThisIsMyDevice() && "checked".equals(TemplateKey.MY_DEVICE_CHECKED.getStringValue(templateParams)));
        CaptchaProviderRenderUtil.addCaptchaProviderParametersToModels((CaptchaProviderEnabledState)model, templateParams);
        if (!this.alternativeAuthenticationSources.isEmpty()) {
            model.setAlternativeAuthenticationSources(this.alternativeAuthenticationSources.stream().map(AlternativeAuthenticationSource::new).collect(Collectors.toList()));
        }
        return model;
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthnError authnError = null;
        Boolean loginFailed = TemplateKey.LOGIN_FAILED.getBooleanValue(templateParams);
        if (loginFailed == null || loginFailed.booleanValue()) {
            AuthnError.Builder authnErrorBuilder = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder();
            String authnMessageKey = TemplateKey.AUTHN_MESSAGE_KEY.getStringValue(templateParams);
            if (authnMessageKey != null) {
                AuthnErrorDetail errorDetail = CommonErrorDetailSpec.CREDENTIAL_VALIDATION_FAILED.makeInstanceBuilder().userMessageKey(authnMessageKey).build();
                authnErrorBuilder = authnErrorBuilder.detail(errorDetail);
            }
            authnError = authnErrorBuilder.build();
        }
        return authnError;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        ChangePasswordConfiguration changePasswordConfiguration = ApiLoginHandler.getPasswordChangeConfiguration(request);
        HashMap mapping = new HashMap();
        mapping.put(CommonActionSpec.CHECK_USERNAME_PASSWORD.getId(), CommonActionSpec.CHECK_USERNAME_PASSWORD.getModelClass());
        if (ApiLoginHandler.isPasswordChangeSupported(changePasswordConfiguration)) {
            mapping.put(CommonActionSpec.INITIATE_PASSWORD_CHANGE.getId(), CommonActionSpec.INITIATE_PASSWORD_CHANGE.getModelClass());
        }
        if (ApiLoginHandler.isPasswordResetSupported(changePasswordConfiguration)) {
            mapping.put(CommonActionSpec.INITIATE_ACCOUNT_RECOVERY.getId(), CommonActionSpec.INITIATE_ACCOUNT_RECOVERY.getModelClass());
        }
        if (changePasswordConfiguration.isEnableUsernameRecovery()) {
            mapping.put(CommonActionSpec.RECOVER_USERNAME.getId(), CommonActionSpec.RECOVER_USERNAME.getModelClass());
        }
        if (!this.alternativeAuthenticationSources.isEmpty()) {
            mapping.put(CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getId(), CommonActionSpec.ALTERNATIVE_AUTHENTICATION.getModelClass());
        }
        if (this.isRegistrationEnabled) {
            mapping.put(CommonActionSpec.INITIATE_REGISTRATION.getId(), CommonActionSpec.INITIATE_REGISTRATION.getModelClass());
        }
        return mapping;
    }
}

