/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordchange;

import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfigHelper;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordchange.PasswordChangeHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.ChangePasswordExternal;
import com.pingidentity.sdk.api.authn.model.state.CurrentCredentialsRequired;
import com.pingidentity.sdk.api.authn.model.state.NewPasswordRequired;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaProviderEnabledState;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthenticationResultEnum;

public class ApiPasswordChangeHandler
extends PasswordChangeHandler {
    private static final String HTML_FORM_PASSWORD_CHANGE_TEMPLATE_ERROR_MESSAGE_KEY_PREFIX = "html.form.change.password.template.";
    private static final List<AuthenticationResultEnum> MUST_CHANGE_PASSWORD_AUTHN_RESULT = Stream.of(AuthenticationResultEnum.PASSWORD_EXPIRED, AuthenticationResultEnum.USER_MUST_RESET_PASSWORD).collect(Collectors.toList());

    @Override
    public AuthnState<?> getAuthnState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        boolean mustchangePwd = this.isUserMustChangePassword(TemplateKey.AUTHN_MESSAGE_KEY.getStringValue(templateParams));
        if (TemplateKey.IS_AUTHN_POLICY.getBooleanValue(templateParams).booleanValue() && TemplateKey.STAGE_IDENTIFYING.getBooleanValue(templateParams).booleanValue()) {
            AuthnStateSpec stateSpec = CommonStateSpec.CURRENT_CREDENTIALS_REQUIRED;
            return stateSpec.makeInstance(request, (Object)((CurrentCredentialsRequired)this.getApiModel(request, response, templateParams)));
        }
        if (StringUtils.isNotBlank((String)TemplateKey.PWM_LOCATION.getStringValue(templateParams))) {
            AuthnStateSpec stateSpec = CommonStateSpec.CHANGE_PASSWORD_EXTERNAL;
            return stateSpec.makeInstance(request, (Object)((ChangePasswordExternal)this.getApiModel(request, response, templateParams)));
        }
        AuthnStateSpec stateSpec = mustchangePwd ? CommonStateSpec.MUST_CHANGE_PASSWORD : CommonStateSpec.NEW_PASSWORD_REQUIRED;
        return stateSpec.makeInstance(request, (Object)((NewPasswordRequired)this.getApiModel(request, response, templateParams)));
    }

    @Override
    public Object getApiModel(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        ChangePasswordExternal apiModel = null;
        if (TemplateKey.IS_AUTHN_POLICY.getBooleanValue(templateParams).booleanValue() && TemplateKey.STAGE_IDENTIFYING.getBooleanValue(templateParams).booleanValue()) {
            CurrentCredentialsRequired model = new CurrentCredentialsRequired();
            String username = TemplateKey.USERNAME.getStringValue(templateParams);
            model.setUsername(StringUtils.isBlank((String)username) ? null : username);
            CaptchaProviderRenderUtil.addCaptchaProviderParametersToModels((CaptchaProviderEnabledState)model, templateParams);
            apiModel = model;
        } else if (StringUtils.isNotBlank((String)TemplateKey.PWM_LOCATION.getStringValue(templateParams))) {
            ChangePasswordExternal model = new ChangePasswordExternal();
            String pwmLocation = TemplateKey.PWM_LOCATION.getStringValue(templateParams);
            model.setPasswordManagementUrl(pwmLocation);
            apiModel = model;
        } else {
            NewPasswordRequired model = new NewPasswordRequired();
            String username = TemplateKey.USERNAME.getStringValue(templateParams);
            model.setUsername(StringUtils.isBlank((String)username) ? null : username);
            CaptchaProviderRenderUtil.addCaptchaProviderParametersToModels((CaptchaProviderEnabledState)model, templateParams);
            String authnMessageKey = TemplateKey.AUTHN_MESSAGE_KEY.getStringValue(templateParams);
            model.setUserMessageKey(this.isUserMustChangePassword(authnMessageKey) ? authnMessageKey : null);
            model.setExistingPasswordRequired(TemplateKey.IS_AUTHN_POLICY.getBooleanValue(templateParams) == false);
            apiModel = model;
        }
        return apiModel;
    }

    @Override
    public AuthnError getApiError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> templateParams) {
        AuthnError authnError = null;
        List<String> errorKeyList = TemplateKey.ERROR_MESSAGE_KEYS.getStringListValue(templateParams);
        List<String> fulfilledPasswordRequirements = TemplateKey.PWD_QUALITY_REQ_MET_MSG_LIST.getStringListValue(templateParams);
        List<String> failedPasswordRequirements = TemplateKey.PWD_QUALITY_REQ_NOT_MET_MSG_LIST.getStringListValue(templateParams);
        ArrayList<Object> errorDetails = new ArrayList<Object>();
        String authnMessageKey = TemplateKey.AUTHN_MESSAGE_KEY.getStringValue(templateParams);
        if (authnMessageKey != null && !this.isUserMustChangePassword(authnMessageKey) && failedPasswordRequirements.isEmpty()) {
            errorDetails.add(CommonErrorDetailSpec.PASSWORD_CHANGE_ERROR.makeInstanceBuilder().userMessageKey(authnMessageKey).build());
        }
        if (!errorKeyList.isEmpty()) {
            for (String errorKey : errorKeyList) {
                errorDetails.add(CommonErrorDetailSpec.PASSWORD_CHANGE_ERROR.makeInstanceBuilder().userMessageKey(HTML_FORM_PASSWORD_CHANGE_TEMPLATE_ERROR_MESSAGE_KEY_PREFIX + errorKey).build());
            }
        }
        if (!failedPasswordRequirements.isEmpty()) {
            errorDetails.add(this.getPasswordPolicyViolationDetail("PASSWORD_CHANGE_ERROR", "Password change error was encountered.", "authn.api.password.policy.violation", fulfilledPasswordRequirements, failedPasswordRequirements));
        }
        if (!errorDetails.isEmpty()) {
            AuthnError.Builder authnErrorBuilder = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder();
            for (AuthnErrorDetail authnErrorDetail : errorDetails) {
                authnErrorBuilder.detail(authnErrorDetail);
            }
            authnError = authnErrorBuilder.build();
        }
        return authnError;
    }

    @Override
    public Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        boolean isPolicy = this.isPolicyEnabledPasswordChange(request);
        HashMap mapping = new HashMap();
        ChangePasswordSessionState state = ChangePasswordSessionState.get(request, response);
        if (isPolicy && !AbstractPasswordManagementServlet.Stage.AUTHENTICATED.equals((Object)state.getStage())) {
            mapping.put(CommonActionSpec.CHECK_CURRENT_CREDENTIALS.getId(), CommonActionSpec.CHECK_CURRENT_CREDENTIALS.getModelClass());
        } else {
            mapping.put(CommonActionSpec.CHECK_NEW_PASSWORD.getId(), CommonActionSpec.CHECK_NEW_PASSWORD.getModelClass());
        }
        mapping.put(CommonActionSpec.CANCEL_PASSWORD_CHANGE.getId(), CommonActionSpec.CANCEL_PASSWORD_CHANGE.getModelClass());
        return mapping;
    }

    private boolean isPolicyEnabledPasswordChange(HttpServletRequest request) {
        String adapterId = ApiPasswordChangeHandler.getAdapterId(request);
        ChangePasswordConfiguration configuration = ChangePasswordConfigHelper.get(adapterId);
        return StringUtils.isNotEmpty((String)configuration.getPolicyContractId());
    }

    private boolean isUserMustChangePassword(String authenticationMessageKey) {
        return authenticationMessageKey != null && MUST_CHANGE_PASSWORD_AUTHN_RESULT.stream().anyMatch(resultEnum -> authenticationMessageKey.endsWith(resultEnum.getId()));
    }
}

