/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.render.handler.api.passwordreset;

import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public abstract class PasswordResetHandler
extends HtmlFormAuthnApiHandler {
    private static final String ACCOUNT_UNLOCK_SERVLET = "/pwdreset/Unlock";
    private static final String ERROR_SERVLET = "/pwdreset/Error";
    private static final String IDENTIFY_SERVLET = "/pwdreset/Identify";
    private static final String PING_ID_SERVLET = "/pwdreset/PingID";
    private static final String POLICY_SERVLET = "/pwdreset/Policy";
    private static final String RESET_SERVLET = "/pwdreset/Reset";
    private static final String SECURITY_CODE_SERVLET = "/pwdreset/SecurityCode";
    private static final String SUCCESS_SERVLET = "/pwdreset/Success";
    private static final String USERNAME_RECOVERY_SERVLET = "/idrecovery/Recover";

    public static void reissueRequestToHtmlFormAdapter(HttpServletRequest request, HttpServletResponse response) {
        HtmlFormAuthnApiHandler.reissueRequestToHtmlFormAdapter(request, response);
    }

    public static String getAuthnApiAppId(HttpServletRequest request) {
        return InternalAuthnApiSupport.getDefault().getAuthnApiAppId(request);
    }

    public static void reissueRequestToPasswordResetIdentifyServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, IDENTIFY_SERVLET);
    }

    public static void redirectToPasswordResetIdentifyServlet(HttpServletRequest request, HttpServletResponse response, String adapterId) throws IOException {
        AuthnApiApplication defaultApp = MgmtFactory.getAuthnApiManager().getDefaultApplication();
        if (!MgmtFactory.getAuthnApiManager().isApiEnabled() || defaultApp == null) {
            throw new ProcessRuntimeException("Failed to redirect to default authentication api application : authentication api is not enabled or default authentication application is not configured properly.");
        }
        HashMap<String, Object> stateParams = new HashMap<String, Object>();
        InternalAuthnApiSupport.getDefault().setCurrentAuthnPlugin(request, stateParams, InternalAuthnApiSupport.AuthnPluginType.IDP_ADAPTER, adapterId);
        InternalAuthnApiSupport.getDefault().saveLastAuthnApiApplication(stateParams, defaultApp.getId());
        PasswordResetHandler.redirectToApplication(request, response, stateParams, defaultApp.getId(), null, IDENTIFY_SERVLET);
    }

    public static void reissueRequestToPasswordResetSecurityCodeServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, SECURITY_CODE_SERVLET);
    }

    public static void reissueRequestToPasswordResetServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, RESET_SERVLET);
    }

    public static void redirectToPasswordResetServlet(HttpServletRequest request, HttpServletResponse response, String authnApiAppId, String authnApiFlowId) throws IOException {
        HashMap<String, Object> stateParams = new HashMap<String, Object>();
        PasswordResetSessionState sessionState = PasswordResetHandler.getSessionState(request, response);
        String adapterId = sessionState.getAdapterId();
        if (adapterId != null) {
            InternalAuthnApiSupport.getDefault().setCurrentAuthnPlugin(request, stateParams, InternalAuthnApiSupport.AuthnPluginType.IDP_ADAPTER, adapterId);
        }
        PasswordResetHandler.redirectToApplication(request, response, stateParams, authnApiAppId, authnApiFlowId, RESET_SERVLET);
    }

    public static boolean isOTLAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetSessionState sessionState = PasswordResetHandler.getSessionState(request, response);
        return sessionState.isOtlAuthenticated();
    }

    public static void reissueRequestToPasswordResetPingIDServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, PING_ID_SERVLET);
    }

    public static void reissueRequestToPasswordResetPolicyServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, POLICY_SERVLET);
    }

    public static void reissueRequestToPasswordResetAccountUnlockedServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, ACCOUNT_UNLOCK_SERVLET);
    }

    public static void redirectToPasswordResetAccountUnlockedServlet(HttpServletRequest request, HttpServletResponse response, String authnApiAppId, String authnApiFlowId) throws IOException {
        HashMap<String, Object> stateParams = new HashMap<String, Object>();
        PasswordResetSessionState sessionState = PasswordResetHandler.getSessionState(request, response);
        String adapterId = sessionState.getAdapterId();
        if (adapterId != null) {
            InternalAuthnApiSupport.getDefault().setCurrentAuthnPlugin(request, stateParams, InternalAuthnApiSupport.AuthnPluginType.IDP_ADAPTER, adapterId);
        }
        PasswordResetHandler.redirectToApplication(request, response, stateParams, authnApiAppId, authnApiFlowId, ACCOUNT_UNLOCK_SERVLET);
    }

    public static void reissueRequestToPasswordResetSuccessServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, SUCCESS_SERVLET);
    }

    public static void reissueRequestToPasswordResetErrorServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, ERROR_SERVLET);
    }

    public static void reissueRequestToUsernameRecoveryServlet(HttpServletRequest request, HttpServletResponse response) {
        PasswordResetHandler.reissueRequestToHandler(request, response, USERNAME_RECOVERY_SERVLET);
    }

    public static void redirectToPasswordResetErrorServlet(HttpServletRequest request, HttpServletResponse response, String authnApiAppId, String authnApiFlowId) throws IOException {
        HashMap<String, Object> stateParams = new HashMap<String, Object>();
        PasswordResetHandler.redirectToApplication(request, response, stateParams, authnApiAppId, authnApiFlowId, ERROR_SERVLET);
    }

    public static void redirectToAuthnApplicationHtmlFormAdapter(HttpServletRequest request, HttpServletResponse response, String authnApiAppId, String authnApiFlowId) throws IOException {
        PasswordResetHandler.redirectToApplication(request, response, null, authnApiAppId, authnApiFlowId, null);
    }

    protected static PasswordResetSessionState getSessionState(HttpServletRequest request, HttpServletResponse response) {
        return PasswordResetSessionState.get(request, response);
    }

    private static void redirectToApplication(HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams, String authnApiAppId, String authnApiFlowId, String handlerPath) throws IOException {
        if (authnApiAppId != null) {
            if (authnApiFlowId == null) {
                InternalAuthnApiSupport.getDefault().createFlowAndRedirectToAuthnApp(request, response, stateParams, authnApiAppId, handlerPath);
            } else {
                InternalAuthnApiSupport.getDefault().redirectToAuthnApp(request, response, stateParams, authnApiAppId, authnApiFlowId, handlerPath);
            }
        } else {
            throw new ProcessRuntimeException("Authentication application id is missing when redirecting to handler '" + handlerPath + "'");
        }
    }
}

