/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.validators;

import com.pingidentity.adapter.htmlform.HtmlFormAdapterConfig;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.sdk.account.AccountUnlockablePasswordCredential;
import com.pingidentity.sdk.password.ChangeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.RecoverableUsername;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class HtmlFormConfigurationValidator
implements ConfigurationValidator {
    private static final int USERNAME_COOKIE_IDLE_MIN = 1;
    private static final int USERNAME_COOKIE_IDLE_MAX = 3650;
    private static final String NOTIFICATION_SETTING_ERROR_MSG = "Please select a notification publisher or configure a default notification publisher if %s is %s.";

    public void validate(Configuration configuration) throws ValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        this.validatePCV(configuration);
        this.validateAllowPasswordChanges(configuration, errors);
        this.validateRememberMyUsername(configuration, errors);
        this.validateDeviceLifetime(configuration, errors);
        this.validateSessionIdleTimeout(configuration, errors);
        this.validatePasswordChangeEmailNotification(configuration, errors);
        this.validateUsernameRecovery(configuration, errors);
        this.validatePasswordExpiryNotification(configuration, errors);
        this.validatePingIdProperties(configuration, errors);
        this.validateAccountUnlock(configuration, errors);
        this.validatePCVSupportsPasswordChange(configuration, errors);
        this.validateCaptchaEnabledActions(configuration, errors);
        this.validateRevokeSessionWhenPwdChgReset(configuration, errors);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    private void validatePCV(Configuration configuration) throws ValidationException {
        Table table = configuration.getTable("Credential Validators");
        List rows = table.getRows();
        if (rows.isEmpty()) {
            throw new ValidationException("Please add at least one password credential validator.");
        }
    }

    private void validatePCVSupportsPasswordChange(Configuration configuration, List<String> errors) {
        boolean enableUsernameRecovery = configuration.getBooleanFieldValue("Enable Username Recovery");
        boolean accountUnlock = configuration.getBooleanFieldValue("Account Unlock");
        boolean allowPwdChanges = configuration.getBooleanFieldValue("Allow Password Changes");
        if (allowPwdChanges || !HtmlFormIdpAuthnAdapter.isResetTypeNone(configuration) || enableUsernameRecovery || accountUnlock) {
            boolean hasChangeablePasswordCredential = false;
            boolean hasResettablePasswordCredential = false;
            boolean hasUnlockablePasswordCredential = false;
            boolean hasRecoverableUsernameCredential = false;
            boolean hasExternalPwdMgmtSysLink = !StringUtils.isBlank((String)configuration.getFieldValue("Password Management System"));
            for (Row row : configuration.getTable("Credential Validators").getRows()) {
                String pcvId = row.getFieldValue("Password Credential Validator Instance");
                PasswordCredentialValidator pcv = MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
                if (pcv instanceof ResettablePasswordCredential && ((ResettablePasswordCredential)pcv).isPasswordResettable()) {
                    hasResettablePasswordCredential = true;
                }
                if (pcv instanceof ChangeablePasswordCredential && ((ChangeablePasswordCredential)pcv).isPasswordChangeable()) {
                    hasChangeablePasswordCredential = true;
                }
                if (pcv instanceof AccountUnlockablePasswordCredential) {
                    hasUnlockablePasswordCredential = true;
                }
                if (!(pcv instanceof RecoverableUsername)) continue;
                hasRecoverableUsernameCredential = true;
            }
            if (allowPwdChanges && !hasChangeablePasswordCredential && !hasExternalPwdMgmtSysLink) {
                errors.add("A password credential validator or its underlying datastore must support password changes, or an external password management system must be configured if 'Allow Password Changes' is enabled.");
            }
            if (!HtmlFormIdpAuthnAdapter.isResetTypeNone(configuration) && !hasResettablePasswordCredential) {
                errors.add("A password credential validator that supports resetting passwords must be configured if a 'Password Reset Type' is selected.");
            }
            if (accountUnlock && !hasUnlockablePasswordCredential) {
                errors.add("A password credential validator that supports unlocking an account must be configured if a 'Account Unlock' is selected.");
            }
            if (enableUsernameRecovery && !hasRecoverableUsernameCredential) {
                errors.add("A password credential validator that supports recovering a username must be configured if a 'Enable Username Recovery' is selected.");
            }
        }
    }

    private void validateRememberMyUsername(Configuration configuration, List<String> errors) {
        String maxIdleStr = configuration.getFieldValue("'Remember My Username' Lifetime");
        if (configuration.getBooleanFieldValue("Enable 'Remember My Username'") && StringUtils.isBlank((String)maxIdleStr)) {
            errors.add("You must specify a 'Remember My Username' Lifetime value");
        }
        if (StringUtils.isNotBlank((String)maxIdleStr)) {
            String integerErrorMsg = "You must specify a 'Remember My Username' Lifetime integer value between 1 and 3650";
            try {
                int maxIdle = Integer.parseInt(maxIdleStr);
                if (maxIdle < 1 || maxIdle > 3650) {
                    errors.add(integerErrorMsg);
                }
            }
            catch (NumberFormatException e) {
                errors.add(integerErrorMsg);
            }
        }
    }

    private void validateAllowPasswordChanges(Configuration configuration, List<String> errors) {
        boolean hasPolicyEnabled;
        boolean allowPwdChanges = configuration.getBooleanFieldValue("Allow Password Changes");
        boolean hasExternalPwdMgmtSysLink = !StringUtils.isBlank((String)configuration.getFieldValue("Password Management System"));
        boolean bl = hasPolicyEnabled = !StringUtils.isBlank((String)configuration.getFieldValue("Change Password Policy Contract"));
        if (allowPwdChanges && StringUtils.isBlank((String)configuration.getFieldValue("Change Password Template")) && !hasExternalPwdMgmtSysLink) {
            errors.add("Either 'Change Password Template' or 'Password Management System' must be specified if 'Allow Password Changes' is enabled.");
        }
        if (!allowPwdChanges) {
            if (!HtmlFormIdpAuthnAdapter.isResetTypeNone(configuration)) {
                errors.add("Allow Password Changes must be selected to enable Password Reset.");
            }
            if (hasPolicyEnabled) {
                errors.add("Allow Password Changes must be selected when a Change Password Policy Contract is selected.");
            }
        }
        if (hasPolicyEnabled && hasExternalPwdMgmtSysLink) {
            errors.add("Change Password Policy Contract cannot be enforced on external Password Management System.");
        }
    }

    private void validateAccountUnlock(Configuration configuration, List<String> errors) {
        boolean accountUnlock = configuration.getBooleanFieldValue("Account Unlock");
        if (accountUnlock && "NONE".equals(HtmlFormAdapterConfig.getConfigurationValue((Configuration)configuration, (String)"Password Reset Type", (String)"NONE"))) {
            String noPwdRestTypeUnlockAaccount = "A 'Password Reset Type' option (other than NONE) must be selected to enable Account Unlock.";
            errors.add(noPwdRestTypeUnlockAaccount);
        }
    }

    private void validatePingIdProperties(Configuration configuration, List<String> errors) throws ValidationException {
        String pingidBase64Key = null;
        String pingidToken = null;
        String pingidOrgAlias = null;
        byte[] pingidPropertiesBytes = configuration.getFileFieldValueAsByteArray("PingID Properties");
        if (pingidPropertiesBytes != null && pingidPropertiesBytes.length > 0) {
            Properties pingidProperties = new Properties();
            try {
                pingidProperties.load(new ByteArrayInputStream(pingidPropertiesBytes));
            }
            catch (IOException io) {
                throw new ValidationException(io.getMessage());
            }
            if (!pingidProperties.isEmpty()) {
                pingidBase64Key = pingidProperties.getProperty("use_base64_key");
                if (StringUtils.isEmpty((String)pingidBase64Key)) {
                    throw new ValidationException("Uploaded file for 'PingID Properties' does not contain the property use_base64_key.");
                }
                pingidToken = pingidProperties.getProperty("token");
                if (StringUtils.isEmpty((String)pingidToken)) {
                    throw new ValidationException("Uploaded file for 'PingID Properties' does not contain the property token.");
                }
                pingidOrgAlias = pingidProperties.getProperty("org_alias");
                if (StringUtils.isEmpty((String)pingidOrgAlias)) {
                    throw new ValidationException("Uploaded file for 'PingID Properties' does not contain the property org_alias.");
                }
            } else {
                throw new ValidationException("Uploaded file for 'PingID Properties' does not contain any properties.");
            }
        }
        this.validatePasswordResetType(configuration, pingidBase64Key, pingidToken, pingidOrgAlias, errors);
    }

    private void validatePasswordExpiryNotification(Configuration configuration, List<String> errors) {
        String error;
        int minDelayValue;
        int minThresholdValue;
        String thresholdPasswordExpiryNotification = configuration.getFieldValue("Threshold for Expiring Password Warning");
        String passwordExpiryNotificationSnoozeInterval = configuration.getFieldValue("Snooze Interval for Expiring Password Warning");
        boolean isPasswordExpiryNotificationEnabled = configuration.getBooleanFieldValue("Show Password Expiring Warning");
        boolean doReAuthOnExpiringPasswordChange = configuration.getBooleanFieldValue("Require Re-Authentication For Expiring Password Flow");
        boolean allowPasswordChangeEnabled = configuration.getBooleanFieldValue("Allow Password Changes");
        if (isPasswordExpiryNotificationEnabled && !allowPasswordChangeEnabled) {
            errors.add(String.format("'%s' cannot be enabled if '%s' is disabled.", "Show Password Expiring Warning", "Allow Password Changes"));
        }
        int thresholdPwdNotification = -1;
        if (StringUtils.isNotBlank((String)thresholdPasswordExpiryNotification) && (thresholdPwdNotification = this.getInteger(thresholdPasswordExpiryNotification, minThresholdValue = 1)) == -1) {
            String integerErrorMsg = String.format("You must specify an integer value between %d and %d for '%s'.", minThresholdValue, Integer.MAX_VALUE, "Threshold for Expiring Password Warning");
            errors.add(integerErrorMsg);
        }
        int delayPwdNotification = -1;
        if (StringUtils.isNotBlank((String)passwordExpiryNotificationSnoozeInterval) && (delayPwdNotification = this.getInteger(passwordExpiryNotificationSnoozeInterval, minDelayValue = 0)) == -1) {
            String integerErrorMsg = MessageFormat.format("You must specify an integer value between {0} and {1} for ''{2}''.", minDelayValue, 596523, "Snooze Interval for Expiring Password Warning");
            errors.add(integerErrorMsg);
        }
        if (thresholdPwdNotification != -1 && delayPwdNotification != -1 && thresholdPwdNotification * 24 < delayPwdNotification) {
            String thresholdLessThanDelay = String.format("'%s' duration cannot be less than the '%s'.", "Threshold for Expiring Password Warning", "Snooze Interval for Expiring Password Warning");
            errors.add(thresholdLessThanDelay);
        }
        if (doReAuthOnExpiringPasswordChange && !isPasswordExpiryNotificationEnabled) {
            error = String.format("'%s' cannot be enabled if '%s' is disabled", "Require Re-Authentication For Expiring Password Flow", "Show Password Expiring Warning");
            errors.add(error);
        }
        if (doReAuthOnExpiringPasswordChange && !allowPasswordChangeEnabled) {
            error = String.format("'%s' cannot be enabled if '%s' is disabled", "Require Re-Authentication For Expiring Password Flow", "Allow Password Changes");
            errors.add(error);
        }
    }

    private void validateUsernameRecovery(Configuration configuration, List<String> errors) {
        boolean enableUsernameRecovery = configuration.getBooleanFieldValue("Enable Username Recovery");
        if (enableUsernameRecovery) {
            NotificationSenderPluginInstance notificationSenderPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
            boolean isNotificationPublisherPresent = StringUtils.isNotBlank((String)configuration.getFieldValue("Notification Publisher"));
            if (!isNotificationPublisherPresent && notificationSenderPluginInstance == null) {
                errors.add("'Enable Username Recovery' cannot be enabled if a notification publisher is not selected or no default notification publisher is defined.");
            }
            if (StringUtils.isBlank((String)configuration.getFieldValue("Username Recovery Email Template"))) {
                errors.add("'Username Recovery Email Template' cannot be blank if 'Enable Username Recovery' is enabled.");
            }
            if (StringUtils.isBlank((String)configuration.getFieldValue("Username Recovery Info Template"))) {
                errors.add("'Username Recovery Info Template' cannot be blank if 'Enable Username Recovery' is enabled.");
            }
            if (StringUtils.isBlank((String)configuration.getFieldValue("Username Recovery Template"))) {
                errors.add("'Username Recovery Template' cannot be blank if 'Enable Username Recovery' is enabled.");
            }
        }
    }

    private void validatePasswordChangeEmailNotification(Configuration configuration, List<String> errors) {
        boolean enablePasswordChangeEmailNotification = configuration.getBooleanFieldValue("Change Password Email Notification");
        if (enablePasswordChangeEmailNotification) {
            if (!configuration.getBooleanFieldValue("Allow Password Changes")) {
                errors.add("'Change Password Email Notification' cannot be enabled if 'Allow Password Changes' is disabled.");
            }
            NotificationSenderPluginInstance notificationSenderPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
            boolean isNotificationPublisherPresent = StringUtils.isNotBlank((String)configuration.getFieldValue("Notification Publisher"));
            if (!isNotificationPublisherPresent && notificationSenderPluginInstance == null) {
                errors.add("'Change Password Email Notification' cannot be enabled if a notification publisher is not selected or no default notification publisher is defined.");
            }
        }
    }

    private void validateSessionIdleTimeout(Configuration configuration, List<String> errors) {
        String sessionIdleTimeoutStr = configuration.getFieldValue("Session Timeout");
        String sessionMaxTimeoutStr = configuration.getFieldValue("Session Max Timeout");
        if (StringUtils.isNotBlank((String)sessionIdleTimeoutStr) && StringUtils.isNotBlank((String)sessionMaxTimeoutStr)) {
            String errMsg = "The Session Timeout value must either be blank or an integer value that is less than or equal to the Session Max Timeout";
            try {
                int sessionIdleTimeout = Integer.parseInt(sessionIdleTimeoutStr);
                int sessionMaxTimeout = Integer.parseInt(sessionMaxTimeoutStr);
                if (sessionIdleTimeout > sessionMaxTimeout) {
                    errors.add(errMsg);
                }
            }
            catch (NumberFormatException e) {
                errors.add(errMsg);
            }
        }
    }

    private void validateDeviceLifetime(Configuration configuration, List<String> errors) {
        String maxIdleStr = configuration.getFieldValue("'This is My Device' Lifetime");
        if (configuration.getBooleanFieldValue("Enable 'This is My Device'") && StringUtils.isBlank((String)maxIdleStr)) {
            errors.add("You must specify a 'This is My Device' Lifetime value");
        }
        if (StringUtils.isNotBlank((String)maxIdleStr)) {
            String integerErrorMsg = "You must specify a 'This is My Device' Lifetime integer value between 1 and 3650";
            try {
                int maxIdle = Integer.parseInt(maxIdleStr);
                if (maxIdle < 1 || maxIdle > 3650) {
                    errors.add(integerErrorMsg);
                }
            }
            catch (NumberFormatException e) {
                errors.add(integerErrorMsg);
            }
        }
    }

    private void validateCaptchaEnabledActions(Configuration configuration, List<String> errors) {
        if (configuration.getBooleanFieldValue("CAPTCHA for Authentication") || configuration.getBooleanFieldValue("CAPTCHA for Password Reset") || configuration.getBooleanFieldValue("CAPTCHA for Username recovery") || configuration.getBooleanFieldValue("CAPTCHA for Password change")) {
            CaptchaProviderInstance captchaProviderInstance = (CaptchaProviderInstance)MgmtFactory.getCaptchaProviderPluginManager().getDefaultInstance();
            boolean isCaptchaProviderPresent = StringUtils.isNotBlank((String)configuration.getFieldValue("CAPTCHA Provider"));
            if (!isCaptchaProviderPresent && captchaProviderInstance == null) {
                errors.add("A Risk provider must be selected or a default Risk provider must be defined if Risk is enabled for any action.");
            }
        }
    }

    private void validatePasswordResetType(Configuration configuration, String pingidBase64Key, String pingidToken, String pingidOrgAlias, List<String> errors) {
        NotificationSettings notificationSettings = MgmtFactory.getNotificationMgr().getNotificationSettings();
        String policyContractId = configuration.getFieldValue("Password Reset Policy Contract");
        boolean isNotificationPublisherPresent = StringUtils.isNotBlank((String)configuration.getFieldValue("Notification Publisher"));
        String resetType = HtmlFormAdapterConfig.getConfigurationValue((Configuration)configuration, (String)"Password Reset Type", (String)"NONE");
        NotificationSenderPluginInstance notificationSenderPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
        switch (resetType) {
            case "PingID": {
                if (!StringUtils.isEmpty((String)pingidBase64Key) && !StringUtils.isEmpty((String)pingidToken) && !StringUtils.isEmpty((String)pingidOrgAlias)) break;
                errors.add("The pingid.properties settings file must be provided if Password Reset Type is PingID.");
                break;
            }
            case "SMS": {
                String smsAccountId = notificationSettings.getSmsAccountId();
                String smsAuthToken = notificationSettings.getSmsAuthToken();
                String smsFromNumber = notificationSettings.getSmsFromNumber();
                if (!StringUtils.isEmpty((String)smsAccountId) && !StringUtils.isEmpty((String)smsAuthToken) && !StringUtils.isEmpty((String)smsFromNumber)) break;
                errors.add("SMS Provider Settings must be configured if Password Reset Type is Text Message.");
                break;
            }
            case "OTL": {
                if (isNotificationPublisherPresent || notificationSenderPluginInstance != null) break;
                errors.add(String.format(NOTIFICATION_SETTING_ERROR_MSG, "Password Reset Type", "Email One-Time Link"));
                break;
            }
            case "OTP": {
                if (isNotificationPublisherPresent || notificationSenderPluginInstance != null) break;
                errors.add(String.format(NOTIFICATION_SETTING_ERROR_MSG, "Password Reset Type", "Email One-Time Password"));
                break;
            }
        }
        String msg = "The 'Password Reset Policy Contract' %s be configured if the 'Password Reset Type' is Authentication Policy.";
        if ("POLICY".equals(resetType) && StringUtils.isEmpty((String)policyContractId)) {
            errors.add(String.format(msg, "must"));
        } else if (!"POLICY".equals(resetType) && StringUtils.isNotEmpty((String)policyContractId)) {
            errors.add(String.format(msg, "can only"));
        }
    }

    private int getInteger(String value, int minValue) {
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
            if (intValue < minValue) {
                return -1;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return intValue;
    }

    private void validateRevokeSessionWhenPwdChgReset(Configuration configuration, List<String> errors) {
        boolean allowPwdChanges;
        boolean enableRevokeSessionPwdChgReset = configuration.getBooleanFieldValue("Revoke Sessions After Password Change Or Reset");
        if (enableRevokeSessionPwdChgReset && !(allowPwdChanges = configuration.getBooleanFieldValue("Allow Password Changes")) & HtmlFormIdpAuthnAdapter.isResetTypeNone(configuration)) {
            errors.add("'Allow Password Changes' or a 'Password Reset Type' option (other than NONE) must be selected to enable 'Revoke Sessions After Password Change Or Reset'.");
        }
    }
}

