/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.identifierfirst.idp;

import com.pingidentity.access.CaptchaProviderAccessor;
import com.pingidentity.adapters.identifierfirst.config.IdentifierFirstConfiguration;
import com.pingidentity.adapters.identifierfirst.utils.IdentifierFirstHelper;
import com.pingidentity.adapters.identifierfirst.utils.IdentifierFirstTemplate;
import com.pingidentity.adapters.identifierfirst.utils.PFField;
import com.pingidentity.captcha.util.CaptchaProviderUtil;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.TransactionAwareAuthenticationAdapter;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.util.log.AttributeMap;

public class IdentifierFirstAdapter
implements IdpAuthenticationAdapterV2,
TransactionAwareAuthenticationAdapter,
AuthnApiPlugin {
    private static final String ADAPTER_NAME = "Identifier First Adapter";
    private Configuration configuration;

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        boolean modifiedAuthnPolicy = false;
        AuthnPolicy authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy");
        if (Boolean.TRUE.equals(inParameters.get("com.pingidentity.adapter.input.parameter.try.lookup.authn")) && authnPolicy.allowUserInteraction()) {
            if (authnPolicy.reauthenticate()) {
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.INTERACTION_REQUIRED);
                return authnAdapterResponse;
            }
            authnPolicy = new AuthnPolicy(false, authnPolicy.reauthenticate(), authnPolicy.getRequestAuthnContexts());
            inParameters.put("com.pingidentity.adapter.input.parameter.authn.policy", authnPolicy);
            modifiedAuthnPolicy = true;
        }
        if (!AuthnApiSupport.getDefault().isApiRequest(request) || "GET".equals(request.getMethod()) || AuthnApiSupport.getDefault().isValidAuthnApiPostRequest(request, response, this.getExpectedActionIdToModelMapping())) {
            String identifier = IdentifierFirstHelper.getIdentifier(request, inParameters);
            if (this.isCancelIdentifierSelection(request) || StringUtils.isBlank((String)identifier) && this.isUserInteractionForbiddenUnderAuthenticationPolicy(inParameters)) {
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            } else if (IdentifierFirstHelper.isClearPreviouslySelectedIdentifier(request)) {
                IdentifierFirstTemplate.doClearPreviouslySelectedIdentifier(request, response, this.configuration, inParameters);
            } else if (StringUtils.isBlank((String)identifier)) {
                IdentifierFirstTemplate.doGetIdentifier(request, response, this.configuration, inParameters);
            } else {
                HashMap<String, Object> attributeMap = new HashMap<String, Object>();
                CaptchaResult captchaResult = this.checkRiskPlugin(request, response, inParameters, identifier);
                if (captchaResult != null) {
                    if (captchaResult.getResponseAttributes() != null) {
                        attributeMap.putAll((Map<String, Object>)captchaResult.getResponseAttributes());
                    }
                    if (!captchaResult.isValid()) {
                        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                        authnAdapterResponse.setUsername(identifier);
                        authnAdapterResponse.setAttributeMap(attributeMap);
                        authnAdapterResponse.setErrorMessage("Failed risk provider verification.");
                        return authnAdapterResponse;
                    }
                }
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                this.appendAttributes(attributeMap, identifier);
                authnAdapterResponse.setAttributeMap(attributeMap);
            }
        }
        if (modifiedAuthnPolicy && authnAdapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.FAILURE) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.INTERACTION_REQUIRED);
        }
        return authnAdapterResponse;
    }

    private CaptchaResult checkRiskPlugin(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters, String identifier) {
        if (IdentifierFirstConfiguration.RiskProviderCheckBox.isUseRiskProvider(this.configuration)) {
            String riskPluginId = IdentifierFirstConfiguration.RiskProviderSelectionField.getRiskProvider(this.configuration);
            CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)riskPluginId);
            CaptchaContext context = new CaptchaContext.Builder().setRequest(request).setResponse(response).setAction("identify").setInParameters(CaptchaProviderUtil.filterInParameters(inParameters, (String)identifier)).build();
            CaptchaResult result = captchaProvider.validateCaptcha(context);
            if (log.isDebugEnabled() && result != null && !result.isValid()) {
                log.debug((Object)String.format("Failed risk plugin validation. Response attributes: %s.", result.getResponseAttributes()));
            }
            return result;
        }
        return null;
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        IdpAuthnAdapterDescriptor descriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, ADAPTER_NAME, this.getContractAttributes(), true, IdentifierFirstConfiguration.makeAdapterConfigurationGuiDescriptor(), false);
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        metadataMap.put("FipsStatus", PluginFipsStatus.COMPLIANT);
        metadataMap.put("TryLookupAuthn", true);
        descriptor.setMetadata(metadataMap);
        return descriptor;
    }

    private Set<String> getContractAttributes() {
        return new HashSet<String>(Arrays.asList(PFField.SUBJECT.getKey(), PFField.DOMAIN.getKey()));
    }

    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map lookupAuthN(HttpServletRequest request, HttpServletResponse response, String partnerSpEntityId, AuthnPolicy authnPolicy, String resumePath) throws AuthnAdapterException, IOException {
        throw new UnsupportedOperationException();
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest request, HttpServletResponse response, String resumePath) throws AuthnAdapterException, IOException {
        return true;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public boolean isDeferAuthenticationSessionRegistration() {
        return true;
    }

    public void onTransactionComplete(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, AttributeMap policyResultMap) {
        throw new UnsupportedOperationException();
    }

    public void onTransactionComplete(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, AttributeMap policyResultMap, Map<String, Object> parameters) {
        int cookieLifetime = IdentifierFirstConfiguration.CookieLifeTimeField.getConfiguredCookieLifeTimeInSecond(this.configuration);
        if (cookieLifetime != 0) {
            List<String> recentIdentifiers = IdentifierFirstHelper.getRecentlySelectedIdentifiers(request, authnIdentifiersMap, this.configuration, false);
            response.addCookie(IdentifierFirstHelper.createIdentifierCookie(recentIdentifiers, this.configuration));
        }
    }

    public PluginApiSpec getApiSpec() {
        List<AuthnStateSpec> states = Collections.singletonList(CommonStateSpec.IDENTIFIER_REQUIRED);
        return new PluginApiSpec(states);
    }

    private void appendAttributes(Map<String, Object> attributeMap, String identifier) {
        attributeMap.put(PFField.SUBJECT.getKey(), identifier);
        attributeMap.put(PFField.DOMAIN.getKey(), IdentifierFirstHelper.getDomainFromIdentifier(identifier));
    }

    private boolean isCancelIdentifierSelection(HttpServletRequest request) {
        return IdentifierFirstHelper.isCancelIdentifierSelection(request) && IdentifierFirstConfiguration.AllowCancelIdentifierSelectionField.isCancellingIdentifierSelectionAllowed(this.configuration);
    }

    private boolean isUserInteractionForbiddenUnderAuthenticationPolicy(Map<String, Object> inParameters) {
        AuthnPolicy authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy");
        return authnPolicy != null && !authnPolicy.allowUserInteraction();
    }

    private Map<String, Class<?>> getExpectedActionIdToModelMapping() {
        HashMap actionIdToModelMapping = new HashMap();
        actionIdToModelMapping.put(CommonActionSpec.SUBMIT_IDENTIFIER.getId(), CommonActionSpec.SUBMIT_IDENTIFIER.getModelClass());
        actionIdToModelMapping.put(CommonActionSpec.CLEAR_IDENTIFIER.getId(), CommonActionSpec.CLEAR_IDENTIFIER.getModelClass());
        if (IdentifierFirstConfiguration.AllowCancelIdentifierSelectionField.isCancellingIdentifierSelectionAllowed(this.configuration)) {
            actionIdToModelMapping.put(CommonActionSpec.CANCEL_IDENTIFIER_SUBMISSION.getId(), CommonActionSpec.CANCEL_IDENTIFIER_SUBMISSION.getModelClass());
        }
        return actionIdToModelMapping;
    }
}

