/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.identifierfirst.utils;

import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.adapters.identifierfirst.config.IdentifierFirstConfiguration;
import com.pingidentity.adapters.identifierfirst.utils.IdentifierFirstHelper;
import com.pingidentity.adapters.identifierfirst.utils.PFField;
import com.pingidentity.adapters.identifierfirst.utils.TemplateField;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.action.ClearIdentifier;
import com.pingidentity.sdk.api.authn.model.state.IdentifierRequired;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaProviderEnabledState;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.conf.Configuration;

public class IdentifierFirstTemplate {
    private static final ParamMapping<ClearIdentifier, String> IDENTIFIER_TO_BE_CLEAR_MAPPING = new ParamMapping(PFField.CLEAR_PREVIOUS_SELECTED_SUBJECT.getKey(), ClearIdentifier.class, ClearIdentifier::getIdentifier, Function.identity());

    public static void doGetIdentifier(HttpServletRequest request, HttpServletResponse response, Configuration configuration, Map<String, Object> stateParams) throws IOException {
        Map<String, Object> templateParameters = IdentifierFirstTemplate.getTemplateParameters(request, configuration, stateParams);
        IdentifierFirstTemplate.addRiskProviderParams(request, response, configuration, templateParameters);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            IdentifierFirstTemplate.renderIdentifierFirstAuthnApiResponse(request, response, configuration, templateParameters);
        } else {
            TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)IdentifierFirstConfiguration.TemplateFileField.getTemplateFile(configuration), templateParameters);
        }
    }

    public static void doClearPreviouslySelectedIdentifier(HttpServletRequest request, HttpServletResponse response, Configuration configuration, Map<String, Object> stateParams) throws IOException {
        LinkedHashSet<String> existingIdentifiers = IdentifierFirstHelper.getExistingIdentifiers(request, configuration, false);
        String identifierToBeRemoved = new String(Base64.getEncoder().encode(((String)IDENTIFIER_TO_BE_CLEAR_MAPPING.getValue(request)).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        existingIdentifiers.remove(identifierToBeRemoved);
        ArrayList<String> identifiers = new ArrayList<String>(existingIdentifiers);
        response.addCookie(IdentifierFirstHelper.createIdentifierCookie(identifiers, configuration));
        IdentifierFirstTemplate.doGetIdentifier(request, response, configuration, stateParams);
    }

    private static LinkedHashSet<String> getExistingIdentifiers(HttpServletRequest request, Configuration configuration) {
        LinkedHashSet<String> existingIdentifiers = IdentifierFirstHelper.getExistingIdentifiers(request, configuration, true);
        existingIdentifiers.remove(IDENTIFIER_TO_BE_CLEAR_MAPPING.getValue(request));
        return existingIdentifiers;
    }

    private static Map<String, Object> getTemplateParameters(HttpServletRequest req, Configuration configuration, Map<String, Object> inParameters) {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put(TemplateField.RESUME_URL.getTemplateKey(), inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        templateParameters.put(PFField.SUBJECT.getTemplateKey(), PFField.SUBJECT.getKey());
        templateParameters.put(PFField.PREVIOUS_SUBJECTS.getTemplateKey(), IdentifierFirstTemplate.getExistingIdentifiers(req, configuration));
        templateParameters.put(PFField.CLEAR_PREVIOUS_SELECTED_SUBJECT.getTemplateKey(), PFField.CLEAR_PREVIOUS_SELECTED_SUBJECT.getKey());
        templateParameters.put(PFField.ALLOW_CANCEL_IDENTIFIER_SELECTION.getTemplateKey(), IdentifierFirstConfiguration.AllowCancelIdentifierSelectionField.isCancellingIdentifierSelectionAllowed(configuration));
        templateParameters.put(PFField.CANCEL_IDENTIFIER_SELECTION.getTemplateKey(), PFField.CANCEL_IDENTIFIER_SELECTION.getKey());
        return templateParameters;
    }

    private static void renderIdentifierFirstAuthnApiResponse(HttpServletRequest request, HttpServletResponse response, Configuration configuration, Map<String, Object> templateParams) throws IOException {
        IdentifierRequired model = new IdentifierRequired();
        model.setPreviouslySubmittedIdentifiers(new ArrayList<String>(IdentifierFirstTemplate.getExistingIdentifiers(request, configuration)));
        CaptchaProviderRenderUtil.addCaptchaProviderParametersToModels((CaptchaProviderEnabledState)model, templateParams);
        AuthnState authnState = CommonStateSpec.IDENTIFIER_REQUIRED.makeInstance(request, (Object)model);
        if (!IdentifierFirstConfiguration.AllowCancelIdentifierSelectionField.isCancellingIdentifierSelectionAllowed(configuration)) {
            authnState.removeAction("cancelIdentifierSubmission");
        }
        AuthnApiSupport.getDefault().writeAuthnStateResponse(request, response, authnState);
    }

    private static void addRiskProviderParams(HttpServletRequest request, HttpServletResponse response, Configuration configuration, Map<String, Object> templateParameters) throws IOException {
        boolean enableCaptcha = IdentifierFirstConfiguration.RiskProviderCheckBox.isUseRiskProvider(configuration);
        templateParameters.put(TemplateKey.CAPTCHA_ENABLED.getKey(), enableCaptcha);
        if (enableCaptcha) {
            String riskPluginId = IdentifierFirstConfiguration.RiskProviderSelectionField.getRiskProvider(configuration);
            CaptchaProviderRenderUtil.addCaptchaProviderParametersToTemplateParameters(request, response, riskPluginId, "identify", TemplateKey.SITE_KEY.getKey(), templateParameters);
        }
    }
}

