/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.kerberos.idp;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.adapters.kerberos.exception.KerberosException;
import com.pingidentity.adapters.kerberos.idp.Constants;
import com.pingidentity.adapters.kerberos.idp.KerberosSubject;
import com.pingidentity.adapters.kerberos.idp.KerberosValidator;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.slf4j.MDC;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.kerberos.KerberosRealmFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;

public class KerberosAuthenticationAdapter
implements IdpAuthenticationAdapterV2 {
    private static final Logger log = LogManager.getLogger(KerberosAuthenticationAdapter.class);
    private static final String SENT_AUTHN_REQUEST = "SENT_AUTHN_REQUEST";
    private static final String SENT_AUTHN_REQUEST_PROTOCOL = "SENT_AUTHN_REQUEST_PROTOCOL";
    private static final String NTLMSSP = "NTLMSSP";
    private static final String META_REFRESH_TEMPLATE = "meta.refresh.template.html";
    private static final String KERBEROS_ERROR_TEMPLATE = "kerberos.error.template.html";
    private static final String PARAM_PREFIX = "com.pingidentity.adapter.input.parameter.";
    protected IdpAuthnAdapterDescriptor adapterDescriptor;
    protected String errorRedirectUrl;
    protected boolean errorTemplate;
    protected boolean failWhenReAuthenticationRequested;
    protected String authnCtxValue;
    protected String domainId;

    public KerberosAuthenticationAdapter() {
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add("Username");
        attrNames.add("Domain/Realm Name");
        attrNames.add("ObjectSID");
        attrNames.add("SIDs");
        this.adapterDescriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, "Kerberos Adapter", attrNames, false, this.initConfGuiDesc(), false);
        this.adapterDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    private AdapterConfigurationGuiDescriptor initConfGuiDesc() {
        AdapterConfigurationGuiDescriptor adapterConfGuiDesc = new AdapterConfigurationGuiDescriptor();
        adapterConfGuiDesc.setDescription("This adapter uses Kerberos to leverage a AD Domain/Realm login for Web authentication.");
        KerberosRealmFieldDescriptor kerberosRealmFieldDescriptor = new KerberosRealmFieldDescriptor("Domain/Realm Name", "Select the Domain/Realm Name configured via Active Directory Domains/Kerberos Realms.  To Add/Modify/Remove a Domain/Realm, use the Manage Active Directory Domains/Kerberos Realms button at the bottom of this screen.");
        kerberosRealmFieldDescriptor.addValidator((FieldValidator)Constants.REQUIRED_VALIDATOR);
        adapterConfGuiDesc.addField((FieldDescriptor)kerberosRealmFieldDescriptor);
        TextFieldDescriptor redirectUrlField = new TextFieldDescriptor("Error URL Redirect", "The URL where you want the user redirected when there are errors.");
        redirectUrlField.addValidator((FieldValidator)Constants.HTTP_URL_VALIDATOR, true);
        adapterConfGuiDesc.addField((FieldDescriptor)redirectUrlField);
        CheckBoxFieldDescriptor errorTemplateKerbOnlyField = new CheckBoxFieldDescriptor("Error Template", "Provides a template (<pf_home>/server/default/conf/template/kerberos.error.template.html) to standardize browser behavior when authentication fails.");
        errorTemplateKerbOnlyField.setDefaultValue(false);
        adapterConfGuiDesc.addAdvancedField((FieldDescriptor)errorTemplateKerbOnlyField);
        CheckBoxFieldDescriptor failWhenReAuthenticationRequested = new CheckBoxFieldDescriptor("Fail When Re-Authentication is Requested", "Indicates whether Kerberos authentication should fail when PingFederate receives an authentication request from the service provider with ForceAuthn=true (SAML 2.0) or prompt=login (OpenID Connect).");
        failWhenReAuthenticationRequested.setDefaultValue(false);
        adapterConfGuiDesc.addAdvancedField((FieldDescriptor)failWhenReAuthenticationRequested);
        TextFieldDescriptor actx = new TextFieldDescriptor("Authentication Context Value", "Additional information provided to the SP to assess the level of confidence in the assertion.");
        adapterConfGuiDesc.addAdvancedField((FieldDescriptor)actx);
        return adapterConfGuiDesc;
    }

    public void configure(Configuration conf) {
        this.domainId = conf.getFieldValue("Domain/Realm Name");
        this.errorRedirectUrl = conf.getFieldValue("Error URL Redirect");
        FieldList advancedFields = conf.getAdvancedFields();
        this.authnCtxValue = advancedFields.getFieldValue("Authentication Context Value");
        this.errorTemplate = advancedFields.getBooleanFieldValue("Error Template");
        this.failWhenReAuthenticationRequested = advancedFields.getBooleanFieldValue("Fail When Re-Authentication is Requested");
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        return this.adapterDescriptor;
    }

    private void errorRedirect(HttpServletResponse response, String resumeUrl, String errorMessage) throws IOException {
        log.debug("KerberoslookupAuthN: Redirecting to {}", (Object)this.errorRedirectUrl);
        if (this.errorRedirectUrl != null && !this.errorRedirectUrl.trim().isEmpty()) {
            if (!this.errorRedirectUrl.contains("?")) {
                response.sendRedirect(this.errorRedirectUrl + "?resumeURL=" + resumeUrl + "&errorMessage=" + errorMessage);
            } else {
                response.sendRedirect(this.errorRedirectUrl + "&resumeURL=" + resumeUrl + "&errorMessage=" + errorMessage);
            }
        } else {
            MDC.put((String)"description", (String)errorMessage);
        }
    }

    private Map<String, Object> getAuthnIdentifiers(KerberosSubject kerberosSubject) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("Username", kerberosSubject.getUsername());
        returnMap.put("Domain/Realm Name", kerberosSubject.getDomain());
        returnMap.put("ObjectSID", kerberosSubject.getObjectSid());
        returnMap.put("SIDs", new AttributeValue(kerberosSubject.getSids()));
        if (this.authnCtxValue != null && !this.authnCtxValue.isEmpty()) {
            returnMap.put("org.sourceid.saml20.adapter.idp.authn.authnCtx", this.authnCtxValue);
        }
        return returnMap;
    }

    private KerberosSubject isUserValid(String tokenValue, String kerberosRealmId) throws AuthnAdapterException {
        KerberosSubject subj;
        byte[] tokenBytesArr = Base64.decodeBase64((byte[])tokenValue.getBytes(StandardCharsets.UTF_8));
        try {
            KerberosValidator krbValidator = new KerberosValidator();
            krbValidator.setKerberosRealmId(kerberosRealmId);
            subj = krbValidator.validateTGS(tokenBytesArr);
        }
        catch (KerberosException e) {
            Object reason = "";
            if (e.isKdcLoginProblem()) {
                reason = "KdcLoginProblem";
            } else if (e.isTgsValidationProblem()) {
                reason = "TgsValidationProblem";
            }
            reason = (String)reason + ": Could not validate Kerberos TGT, please make sure the service principal name is set correctly and the credential cache on client machine is refreshed by re-login to the windows domain.";
            log.debug((String)reason, (Throwable)e);
            log.error("{}: {}", reason, (Object)e.getMessage());
            throw new AuthnAdapterException((String)reason, (Throwable)e);
        }
        return subj;
    }

    public boolean logoutAuthN(Map map, HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse, String s) {
        log.debug(" + KerberoslogoutAuthN");
        log.debug(" - KerberoslogoutAuthN return: true");
        return true;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public Map lookupAuthN(HttpServletRequest request, HttpServletResponse response, String entityId, AuthnPolicy authnpolicy, String resumeUrl) throws AuthnAdapterException, IOException {
        HashMap<String, Object> inParameters = new HashMap<String, Object>();
        inParameters.put("com.pingidentity.adapter.input.parameter.partner.entityid", entityId);
        inParameters.put("com.pingidentity.adapter.input.parameter.resume.path", resumeUrl);
        inParameters.put("com.pingidentity.adapter.input.parameter.authn.policy", authnpolicy);
        AuthnAdapterResponse responseMap = this.lookupAuthN(request, response, inParameters);
        return responseMap.getAttributeMap();
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        boolean kerberosLogonFailed;
        Map<String, Object> ids;
        String resumeUrl;
        AuthnAdapterResponse adapterResponse;
        block17: {
            AuthnPolicy authnPolicy;
            log.debug("+ KerberoslookupAuthN");
            adapterResponse = new AuthnAdapterResponse();
            if (this.failWhenReAuthenticationRequested && (authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy")) != null && authnPolicy.reauthenticate()) {
                log.debug("Re-authentication requested, returning failure status.");
                log.debug("- KerberoslookupAuthN return");
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                return adapterResponse;
            }
            resumeUrl = inParameters.containsKey("com.pingidentity.adapter.input.parameter.resume.path") ? (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path") : "";
            TransactionalStateSupport txStateSupport = new TransactionalStateSupport(resumeUrl);
            ids = null;
            if (!request.getRequestURI().endsWith(resumeUrl)) {
                log.debug("Request doesn't end with ResumeUrl. Redirect to ResumeURL: {}?{}", (Object)resumeUrl, (Object)request.getQueryString());
                String queryString = "";
                response.sendRedirect(BaseUrlAccessor.getCurrentBaseUrl() + resumeUrl + queryString);
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return adapterResponse;
            }
            String authHeader = request.getHeader("Authorization");
            if (authHeader == null) {
                log.debug("WWW-Authenticate header not found");
                response.setStatus(401);
                String sentAuthenticateHeader = (String)txStateSupport.getAttribute(SENT_AUTHN_REQUEST, request, response);
                if (sentAuthenticateHeader != null && Boolean.parseBoolean(sentAuthenticateHeader)) {
                    String sentAuthenticateHeaderProtocol = (String)txStateSupport.getAttribute(SENT_AUTHN_REQUEST_PROTOCOL, request, response);
                    String currentProtocol = request.getProtocol();
                    if ("HTTP/1.1".equals(currentProtocol) && "HTTP/2.0".equals(sentAuthenticateHeaderProtocol)) {
                        log.debug("HTTP protocol changed from HTTP/2.0 to HTTP/1.1, retry Negotiate again.");
                    } else {
                        txStateSupport.removeAttribute(SENT_AUTHN_REQUEST, request, response);
                        txStateSupport.removeAttribute(SENT_AUTHN_REQUEST_PROTOCOL, request, response);
                        request.setAttribute("DO_NOT_DELETE_COOKIE", (Object)Boolean.TRUE);
                        log.debug("Login Failed: Page refreshed without responding to WWW-Authenticate header.");
                        this.errorRedirect(response, resumeUrl, "Logon failed.");
                        adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                        return adapterResponse;
                    }
                }
                response.setHeader("WWW-Authenticate", "Negotiate");
                log.debug("WWW-Authenticate: Negotiate requested from client.");
                txStateSupport.setAttribute(SENT_AUTHN_REQUEST, (Object)Boolean.TRUE.toString(), request, response);
                txStateSupport.setAttribute(SENT_AUTHN_REQUEST_PROTOCOL, (Object)request.getProtocol(), request, response);
                Object isComposite = inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
                if (isComposite != null) {
                    TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)META_REFRESH_TEMPLATE, new HashMap());
                } else if (this.errorTemplate) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("resumeUrl", resumeUrl);
                    TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)KERBEROS_ERROR_TEMPLATE, params);
                }
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                response.flushBuffer();
                return adapterResponse;
            }
            txStateSupport.removeAttribute(SENT_AUTHN_REQUEST, request, response);
            txStateSupport.removeAttribute(SENT_AUTHN_REQUEST_PROTOCOL, request, response);
            String tokenPrefix = "Negotiate ";
            String tokenValue = authHeader.substring(tokenPrefix.length());
            byte[] tokenBytesArr = Base64.decodeBase64((byte[])tokenValue.getBytes(StandardCharsets.UTF_8));
            boolean invalidToken = this.isInvalidKerberosToken(tokenBytesArr);
            if (invalidToken) {
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                String tokenString = new String(tokenBytesArr, StandardCharsets.UTF_8);
                if (tokenString.startsWith(NTLMSSP)) {
                    this.handleNTLMerror(response, resumeUrl);
                    return adapterResponse;
                }
                String message = "The token is not recognized as a valid Kerberos token.";
                log.error(message);
                log.trace("The Kerberos token is not a NegTokenInit or NegTokenTarg token and is considered invalid. The token content is: {}", (Object)authHeader);
                throw new AuthnAdapterException(message);
            }
            log.trace("Token Type = KERBEROS {}", (Object)authHeader);
            kerberosLogonFailed = false;
            try {
                KerberosSubject subj = this.isUserValid(tokenValue, this.domainId);
                if (subj != null && subj.getUsername() != null) {
                    ids = this.getAuthnIdentifiers(subj);
                } else {
                    log.error("Invalid user.");
                    kerberosLogonFailed = true;
                }
            }
            catch (AuthnAdapterException e) {
                kerberosLogonFailed = true;
                Object isComposite = inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
                if (isComposite != null) {
                    adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                    log.debug("- KerberoslookupAuthN return");
                    return adapterResponse;
                }
                if (!this.errorTemplate) break block17;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("resumeUrl", resumeUrl);
                TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)KERBEROS_ERROR_TEMPLATE, params);
                log.debug("- KerberoslookupAuthN return");
                adapterResponse.setAttributeMap(ids);
                adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                return adapterResponse;
            }
        }
        if (kerberosLogonFailed) {
            this.handleNTLMerror(response, resumeUrl);
            adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return adapterResponse;
        }
        log.debug("- KerberoslookupAuthN return");
        adapterResponse.setAttributeMap(ids);
        adapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        return adapterResponse;
    }

    private boolean isInvalidKerberosToken(byte[] tokenBytesArr) {
        boolean invalidToken = false;
        switch (tokenBytesArr[0]) {
            case -95: 
            case 96: {
                break;
            }
            default: {
                invalidToken = true;
            }
        }
        return invalidToken;
    }

    private void handleNTLMerror(HttpServletResponse response, String resumeUrl) throws IOException {
        log.error("Kerberos authentication is selected.  NTLM not allowed.");
        this.errorRedirect(response, resumeUrl, "Kerberos authentication is selected, NTLM not allowed.");
    }
}

