/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.kerberos.idp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import jcifs.spnego.asn1.ASN1OctetString;
import jcifs.spnego.asn1.ASN1Sequence;
import jcifs.spnego.asn1.ASN1TaggedObject;
import jcifs.spnego.asn1.DERBitString;
import jcifs.spnego.asn1.DERInputStream;
import jcifs.spnego.asn1.DERObjectIdentifier;
import jcifs.spnego.asn1.DERUnknownTag;

public class SpnegoParser {
    private byte[] mechanismToken;
    private byte[] mechanismListMIC;
    private String[] mechanisms;
    private int contextFlags;

    public void parse(byte[] token) throws IOException {
        ByteArrayInputStream tokenStream = new ByteArrayInputStream(token);
        DERInputStream der = new DERInputStream((InputStream)tokenStream);
        DERUnknownTag constructed = (DERUnknownTag)der.readObject();
        if (constructed.getTag() != 96) {
            throw new IOException("Malformed NegTokenInit.");
        }
        tokenStream = new ByteArrayInputStream(constructed.getData());
        der = new DERInputStream((InputStream)tokenStream);
        DERObjectIdentifier spnego = (DERObjectIdentifier)der.readObject();
        ASN1TaggedObject tagged = (ASN1TaggedObject)der.readObject();
        ASN1Sequence sequence = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
        Enumeration fields = sequence.getObjects();
        block6: while (fields.hasMoreElements()) {
            tagged = (ASN1TaggedObject)fields.nextElement();
            switch (tagged.getTagNo()) {
                case 0: {
                    sequence = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                    String[] mechanisms = new String[sequence.size()];
                    for (int i = mechanisms.length - 1; i >= 0; --i) {
                        DERObjectIdentifier mechanism = (DERObjectIdentifier)sequence.getObjectAt(i);
                        mechanisms[i] = mechanism.getId();
                    }
                    this.setMechanisms(mechanisms);
                    continue block6;
                }
                case 1: {
                    DERBitString contextFlags = DERBitString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                    this.setContextFlags(contextFlags.getBytes()[0] & 0xFF);
                    continue block6;
                }
                case 2: {
                    ASN1OctetString mechanismToken = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                    this.setMechanismToken(mechanismToken.getOctets());
                    continue block6;
                }
                case 3: {
                    ASN1OctetString mechanismListMIC = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                    this.setMechanismListMIC(mechanismListMIC.getOctets());
                    continue block6;
                }
            }
            throw new IOException("Malformed token field.");
        }
    }

    public byte[] getMechanismListMIC() {
        return this.mechanismListMIC;
    }

    public void setMechanismListMIC(byte[] mechanismListMIC) {
        this.mechanismListMIC = mechanismListMIC;
    }

    public byte[] getMechanismToken() {
        return this.mechanismToken;
    }

    public void setMechanismToken(byte[] mechanismToken) {
        this.mechanismToken = mechanismToken;
    }

    public String[] getMechanisms() {
        return this.mechanisms;
    }

    public void setMechanisms(String[] mechanisms) {
        this.mechanisms = mechanisms;
    }

    public int getContextFlags() {
        return this.contextFlags;
    }

    public void setContextFlags(int contextFlags) {
        this.contextFlags = contextFlags;
    }
}

