/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.passthrough.idp;

import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;

public class PassthroughIdpAdapter
implements IdpAuthenticationAdapterV2,
AuthnApiPlugin {
    private static final String ADAPTER_NAME = "Passthrough IdP Adapter";
    private static final String DESCRIPTION = "The Passthrough IdP Adapter sets the core contract 'username' with the incoming user ID and allows for configuration of a 'Unique User Key Attribute'. By placing the adapter downstream from an IdP connection in a policy tree, you can take advantage of additional capabilities associated with defining a user key.";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final Set<String> CORE_CONTRACT = new HashSet<String>(Collections.singletonList("username"));

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        if (inParameters.get("com.pingidentity.adapter.input.parameter.userid") != null) {
            attributeMap.put(USERNAME_ATTRIBUTE, inParameters.get("com.pingidentity.adapter.input.parameter.userid"));
        }
        authnAdapterResponse.setAttributeMap(attributeMap);
        return authnAdapterResponse;
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        IdpAuthnAdapterDescriptor descriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, ADAPTER_NAME, CORE_CONTRACT, true, new AdapterConfigurationGuiDescriptor(DESCRIPTION), false);
        descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        return descriptor;
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String partnerSpEntityId, AuthnPolicy authnPolicy, String resumePath) throws AuthnAdapterException, IOException {
        throw new UnsupportedOperationException();
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        return true;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public PluginApiSpec getApiSpec() {
        return new PluginApiSpec(Collections.emptyList());
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    public void configure(Configuration configuration) {
    }
}

