/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.captcha;

import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ReCaptchaPlugin
implements CaptchaProvider {
    protected static final String SITE_KEY_NAME = "Site Key";
    protected static final String SITE_KEY_DESC = "The site key assigned to your account by Google.";
    protected static final String SCORE_THRESHOLD_NAME = "Pass Score Threshold";
    protected static final String SCORE_THRESHOLD_DESC = "The minimum score that is returned by Google for the request to be valid. The score range returned is between 0.0 - 1.0, where 1.0 is likely a good interaction.";
    protected static final String JAVASCRIPT_FILENAME_NAME = "JavaScript File Name";
    protected static final String CAPTCHA_SCORE_CONTRACT_ATTRIBUTE = "captchaScore";
    protected static final String CAPTCHA_CHALLENGE_TIMESTAMP_CONTRACT_ATTRIBUTE = "captchaChallengeTime";
    protected static final String SITE_KEY_ATTRIBUTE = "siteKey";
    protected static final String ACTION_ATTRIBUTE = "action";
    protected static final String CAPTCHA_RESPONSE = "captchaResponse";
    protected static final String ACTION_RESPONSE = "action";
    protected static final String SCORE_RESPONSE = "score";
    private static final Pattern ALPHA_NUMERIC_SLASHES_UNDERSCORE_PATTERN = Pattern.compile("^[a-zA-Z0-9/_]+$");
    private final Log log = LogFactory.getLog(ReCaptchaPlugin.class);

    public abstract Map<String, Object> getCaptchaAttributes(CaptchaContext var1);

    public abstract CaptchaResult validateCaptcha(CaptchaContext var1);

    protected String getCaptchaResponse(CaptchaContext captchaContext) {
        HttpServletRequest request;
        AuthnApiSupport apiSupport = AuthnApiSupport.getDefault();
        if (apiSupport.isApiRequest(request = captchaContext.getRequest()) && request.getMethod().equals("POST")) {
            try {
                Map requestBody = apiSupport.deserializeAsMap(request);
                Object captchaResponseFromBody = requestBody.get(CAPTCHA_RESPONSE);
                if (captchaResponseFromBody instanceof String) {
                    return (String)captchaResponseFromBody;
                }
                this.log.debug((Object)"CAPTCHA response not of expected type.");
                return null;
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to deserialize authN API response", (Throwable)e);
                return null;
            }
        }
        return captchaContext.getRequest().getParameter("g-recaptcha-response");
    }

    protected String getAction(String action) {
        if (action != null && ALPHA_NUMERIC_SLASHES_UNDERSCORE_PATTERN.matcher(action).matches()) {
            return action;
        }
        return "defaultAction";
    }
}

