/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.access.token.management.plugins;

import com.pingidentity.access.JwksEndpointKeyAccessor;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.pf.access.token.management.plugins.CertificateSupport;
import com.pingidentity.pf.access.token.management.plugins.JwtBearerAccessTokenManagementPlugin;
import com.pingidentity.pf.access.token.management.plugins.PublicJwkSupport;
import com.pingidentity.pf.access.token.management.plugins.SymmetricKeySupport;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.jose4j.jwe.KeyManagementAlgorithm;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.EcdsaUsingShaAlgorithm;
import org.jose4j.jws.JsonWebSignatureAlgorithm;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.lang.InvalidKeyException;
import org.jose4j.lang.JoseException;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.jose.jwk.AccessTokenMgmtJwkPublishUtil;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.issuer.OAuthIssuerManager;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.token.jwt.JWTKeyDerivationUtil;

public class ConfigValidator
implements ConfigurationValidator {
    private final Log log = LogFactory.getLog(this.getClass());
    private CertificateSupport certificateSupport;
    private BearerAccessTokenMgmtPluginManager accessTokenMgmtPluginManager;
    private JWKSEndpointManager jwksEndpointManager;
    private final JwkFacilitator jwkFacilitator;
    private final OAuthIssuerManager oAuthIssuerManager;
    private static int MIN_JWT_ID_CLAIM_LENGTH_FOR_REVOCATION = 22;

    public ConfigValidator(CertificateSupport certificateSupport, BearerAccessTokenMgmtPluginManager accessTokenMgmtPluginManager, JWKSEndpointManager jwksEndpointManager, JwkFacilitator jwkFacilitator, OAuthIssuerManager oAuthIssuerManager) {
        this.certificateSupport = certificateSupport;
        this.accessTokenMgmtPluginManager = accessTokenMgmtPluginManager;
        this.jwksEndpointManager = jwksEndpointManager;
        this.jwkFacilitator = jwkFacilitator;
        this.oAuthIssuerManager = oAuthIssuerManager;
    }

    public void validate(Configuration configuration) throws ValidationException {
        Integer notBeforeOffsetMinutes;
        boolean publishKeyToJwksEndpointEnabled;
        LinkedList<String> errorMessages;
        block35: {
            errorMessages = new LinkedList<String>();
            AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
            boolean symmetricJwe = false;
            publishKeyToJwksEndpointEnabled = false;
            try {
                String jwsAlgoName;
                String jweAlgoName = configuration.getFieldValue("JWE Algorithm");
                if (StringUtils.isNotBlank((String)jweAlgoName)) {
                    String encAlgName = configuration.getFieldValue("JWE Content Encryption Algorithm");
                    if (StringUtils.isBlank((String)encAlgName)) {
                        errorMessages.add("Please select a JWE Content Encryption Algorithm (it's required when JWE Algorithm is used).");
                    } else {
                        AlgorithmFactory jweContentEncryptionAlgorithmFactory = aff.getJweContentEncryptionAlgorithmFactory();
                        if (!jweContentEncryptionAlgorithmFactory.isAvailable(encAlgName)) {
                            errorMessages.add(this.getUnavailableMsg("JWE Content Encryption Algorithm", encAlgName));
                        }
                    }
                    AlgorithmFactory jweKeyManagementAlgorithmFactory = aff.getJweKeyManagementAlgorithmFactory();
                    if (!jweKeyManagementAlgorithmFactory.isAvailable(jweAlgoName)) {
                        errorMessages.add(this.getUnavailableMsg("JWE Algorithm", jweAlgoName));
                    } else {
                        KeyManagementAlgorithm jweAlgo = (KeyManagementAlgorithm)jweKeyManagementAlgorithmFactory.getAlgorithm(jweAlgoName);
                        switch (jweAlgo.getKeyPersuasion()) {
                            case ASYMMETRIC: {
                                boolean hasJwk;
                                Field keyField = configuration.getField("Asymmetric Encryption Key");
                                PublicJsonWebKey publicJwk = PublicJwkSupport.getKey(keyField);
                                boolean hasJwksUrl = StringUtils.isNotBlank((String)configuration.getFieldValue("Asymmetric Encryption JWKS URL"));
                                boolean bl = hasJwk = publicJwk != null;
                                if (hasJwk && hasJwksUrl) {
                                    String msg = "When using asymmetric encryption, please specify either %s or %s but not both.";
                                    errorMessages.add(String.format(msg, "Asymmetric Encryption Key", "Asymmetric Encryption JWKS URL"));
                                    break;
                                }
                                if (hasJwk) {
                                    try {
                                        boolean includeX5t;
                                        PublicKey publicKey = publicJwk.getPublicKey();
                                        String keyAlg = publicKey.getAlgorithm();
                                        String algKeyAlg = jweAlgo.getKeyType();
                                        if (!StringUtils.equals((String)algKeyAlg, (String)keyAlg)) {
                                            String msg = "The type of key of the %s (%s) does not match the type needed for the selected %s (%s).";
                                            errorMessages.add(String.format(msg, "Asymmetric Encryption Key", keyAlg, "JWE Algorithm", algKeyAlg));
                                        }
                                        jweAlgo.validateEncryptionKey((Key)publicKey, null);
                                        boolean includeKid = configuration.getBooleanFieldValue("Include JWE Key ID Header Parameter");
                                        if (includeKid && publicJwk.getKeyId() == null) {
                                            String msg = "%s needs to have a Key ID (kid) parameter in order to use %s";
                                            errorMessages.add(String.format(msg, "Asymmetric Encryption Key", "Include JWE Key ID Header Parameter"));
                                        }
                                        if (!(includeX5t = configuration.getBooleanFieldValue("Include JWE X.509 Thumbprint Header Parameter")) || publicJwk.getX509CertificateSha1Thumbprint(true) != null) break;
                                        String msg = "Cannot use %s unless %s is a JWK that has an X.509 Thumbprint (x5t) or certificate chain (x5c) or is itself a certificate.";
                                        errorMessages.add(String.format(msg, "Include JWE X.509 Thumbprint Header Parameter", "Asymmetric Encryption Key"));
                                    }
                                    catch (InvalidKeyException e) {
                                        errorMessages.add("Asymmetric Encryption Key is not valid for the selected JWE Algorithm: " + e.getMessage());
                                    }
                                    break;
                                }
                                if (hasJwksUrl) break;
                                errorMessages.add("Asymmetric Encryption Key or Asymmetric Encryption JWKS URL is required for the selected JWE Algorithm");
                                break;
                            }
                            case SYMMETRIC: {
                                symmetricJwe = true;
                                String kid = configuration.getFieldValue("Active Symmetric Encryption Key ID");
                                this.checkSymmetricJweKeyLength(configuration, errorMessages, jweAlgoName, encAlgName, kid);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected value: " + jweAlgo.getKeyPersuasion());
                            }
                        }
                    }
                }
                if (StringUtils.isBlank((String)(jwsAlgoName = configuration.getFieldValue("JWS Algorithm")))) {
                    if (!symmetricJwe) {
                        errorMessages.add("Please provide integrity protection with a JWS Algorithm and/or a symmetric JWE Algorithm.");
                    }
                    break block35;
                }
                AlgorithmFactory jwsAlgorithmFactory = aff.getJwsAlgorithmFactory();
                if (!jwsAlgorithmFactory.isAvailable(jwsAlgoName)) {
                    errorMessages.add(this.getUnavailableMsg("JWS Algorithm", jwsAlgoName));
                    break block35;
                }
                JsonWebSignatureAlgorithm jwsAlgo = (JsonWebSignatureAlgorithm)jwsAlgorithmFactory.getAlgorithm(jwsAlgoName);
                KeyPersuasion keyPersuasion = jwsAlgo.getKeyPersuasion();
                Field useCentralizedKey = configuration.getField("Use Centralized Signing Key");
                Field publishKeyToJwksEndpointField = configuration.getField("Publish Keys to the PingFederate JWKS Endpoint");
                publishKeyToJwksEndpointEnabled = publishKeyToJwksEndpointField != null && publishKeyToJwksEndpointField.getValueAsBoolean();
                switch (keyPersuasion) {
                    case ASYMMETRIC: {
                        if (useCentralizedKey != null && useCentralizedKey.getValueAsBoolean()) {
                            JwksEndpointKeyAccessor jwksEndpointKeyAccessor = JwksEndpointKeyAccessor.newInstance();
                            this.checkCentralizedJwsKey(errorMessages, jwsAlgo, jwksEndpointKeyAccessor);
                            Field activeSigningCert = configuration.getField("Active Signing Certificate Key ID");
                            if (StringUtils.isNotBlank((String)activeSigningCert.getValue())) {
                                errorMessages.add(String.format("'%s' should not be selected when '%s' is enabled", "Active Signing Certificate Key ID", "Use Centralized Signing Key"));
                            }
                            if (publishKeyToJwksEndpointEnabled) {
                                errorMessages.add(String.format("'%s' functionality is not available when '%s' is selected", "Publish Keys to the PingFederate JWKS Endpoint", "Use Centralized Signing Key"));
                            }
                            break;
                        }
                        String kid = configuration.getFieldValue("Active Signing Certificate Key ID");
                        if (StringUtils.isBlank((String)kid)) {
                            String txt = "Either configuring an %s or enabling '%s' is required for the selected %s";
                            String msg = String.format(txt, "Active Signing Certificate Key ID", "Use Centralized Signing Key", "JWS Algorithm");
                            errorMessages.add(msg);
                            break;
                        }
                        this.checkJwsKey(configuration, errorMessages, jwsAlgo, kid);
                        break;
                    }
                    case SYMMETRIC: {
                        if (useCentralizedKey != null && useCentralizedKey.getValueAsBoolean()) {
                            errorMessages.add(String.format("'%s' must be disabled when using a symmetric signing algorithm.", "Use Centralized Signing Key"));
                        }
                        String kid = configuration.getFieldValue("Active Symmetric Key ID");
                        this.checkHmacKeyLength(configuration, errorMessages, jwsAlgoName, kid);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + keyPersuasion);
                    }
                }
            }
            catch (JoseException e) {
                this.log.error((Object)("Problem looking up algorithm for checking key type/requirements: " + e), (Throwable)e);
            }
        }
        this.checkInterdependence(configuration, "JWKS Endpoint Path", "JWKS Endpoint Cache Duration", errorMessages);
        this.checkInterdependence(configuration, "Asymmetric Encryption JWKS URL", "Default JWKS URL Cache Duration", errorMessages);
        this.checkNotSame(configuration, "Client ID Claim Name", "Scope Claim Name", errorMessages);
        this.checkNotSame(configuration, "Client ID Claim Name", "Access Grant GUID Claim Name", errorMessages);
        this.checkNotSame(configuration, "Access Grant GUID Claim Name", "Scope Claim Name", errorMessages);
        this.checkUniqueKid(configuration.getTable("Symmetric Keys"), errorMessages, false, configuration.getId());
        this.checkUniqueKid(configuration.getTable("Certificates"), errorMessages, publishKeyToJwksEndpointEnabled, configuration.getId());
        if (configuration.getBooleanFieldValue("Publish Key ID X.509 URL")) {
            this.checkKidCertsAlreadyPublished(configuration.getId(), configuration.getTable("Certificates"), errorMessages);
        }
        this.checkNotAllowed("Use Centralized Signing Key", configuration.getBooleanFieldValue("Use Centralized Signing Key"), "Publish Key ID X.509 URL", configuration.getBooleanFieldValue("Publish Key ID X.509 URL"), errorMessages);
        this.checkNotAllowed("Use Centralized Signing Key", configuration.getBooleanFieldValue("Use Centralized Signing Key"), "Publish Thumbprint X.509 URL", configuration.getBooleanFieldValue("Publish Thumbprint X.509 URL"), errorMessages);
        if (configuration.getBooleanFieldValue("Enable Token Revocation")) {
            this.checkRevocationRequiredFields(configuration, errorMessages);
        }
        if (configuration.getBooleanFieldValue("Use Centralized Signing Key") && !this.jwksEndpointManager.getSetting().isEnableStaticKeys()) {
            this.checkTokenLifetime(configuration, errorMessages);
        }
        if ((notBeforeOffsetMinutes = JwtBearerAccessTokenManagementPlugin.getNotBeforeOffsetConfig(configuration)) != null) {
            this.checkNbfValid(configuration, notBeforeOffsetMinutes, errorMessages);
        }
        if (!errorMessages.isEmpty()) {
            throw new ValidationException(errorMessages);
        }
    }

    void checkNbfValid(Configuration configuration, Integer notBeforeOffset, List<String> errorMessages) {
        int tokenLifetime = configuration.getIntFieldValue("Token Lifetime");
        String errorMsg = String.format("'%s' is out of range, please enter a value between %d and %d.", "Not Before Claim Offset", -1 * (tokenLifetime - 1), 0x2222222);
        if (notBeforeOffset <= 0 && tokenLifetime <= -1 * notBeforeOffset) {
            errorMessages.add(errorMsg);
        } else if (notBeforeOffset > 0x2222222) {
            errorMessages.add(errorMsg);
        }
    }

    private void checkInterdependence(Configuration c, String ifName, String thenName, List<String> errorMessages) {
        if (StringUtils.isNotBlank((String)c.getFieldValue(ifName)) && StringUtils.isBlank((String)c.getFieldValue(thenName))) {
            errorMessages.add(thenName + " is required when utilizing " + ifName);
        }
    }

    private void checkJwsKey(Configuration c, List<String> errorMessages, JsonWebSignatureAlgorithm jwsAlgo, String selectedKid) {
        Table certs = c.getTable("Certificates");
        List rows = certs.getRows();
        boolean keyFound = false;
        for (Row row : rows) {
            String kid = row.getFieldValue("Key ID");
            if (!StringUtils.equals((String)selectedKid, (String)kid)) continue;
            keyFound = true;
            String alias = row.getFieldValue("Certificate");
            X500PrivateCredential x500pc = this.certificateSupport.getDsigKeypair(alias);
            if (x500pc == null) continue;
            try {
                PrivateKey privateKey = x500pc.getPrivateKey();
                String keyAlg = privateKey.getAlgorithm();
                String algKeyAlg = jwsAlgo.getKeyType();
                if (StringUtils.equals((String)algKeyAlg, (String)keyAlg) || this.isNcipherEC(algKeyAlg, keyAlg)) {
                    jwsAlgo.validateSigningKey((Key)privateKey);
                    continue;
                }
                String msg = "The type of key of the %s (%s) does not match the type needed for the selected %s (%s).";
                errorMessages.add(String.format(msg, "Active Signing Certificate Key ID", keyAlg, "JWS Algorithm", algKeyAlg));
            }
            catch (InvalidKeyException e) {
                errorMessages.add("Active Signing Certificate Key ID is not valid for the selected JWS Algorithm: " + e.getMessage());
            }
        }
        if (!keyFound) {
            errorMessages.add("Active Signing Certificate Key ID is required for the selected JWS Algorithm");
        }
    }

    private void checkCentralizedJwsKey(List<String> errorMessages, JsonWebSignatureAlgorithm jwsAlgorithm, JwksEndpointKeyAccessor accessor) {
        String keyType = jwsAlgorithm.getKeyType();
        String errMsg = "The JWS algorithm '%s' requires a key type that is not configured in OAuth & OpenID Connect Keys.";
        String algorithmIdentifier = JwtBearerAccessTokenManagementPlugin.signingAlgorithms.get(jwsAlgorithm.getAlgorithmIdentifier());
        switch (keyType) {
            case "RSA": {
                JwksEndpointKeyAccessor.JsonWebKeyWrapper rsaKey = accessor.getCurrentRsaKey(jwsAlgorithm.getAlgorithmIdentifier());
                if (rsaKey != null) break;
                errorMessages.add(String.format(errMsg, algorithmIdentifier));
                break;
            }
            case "EC": {
                EcdsaUsingShaAlgorithm ecdsaAlgorithm = (EcdsaUsingShaAlgorithm)jwsAlgorithm;
                JwksEndpointKeyAccessor.JsonWebKeyWrapper ecKey = accessor.getCurrentEcKey(ecdsaAlgorithm.getCurveName());
                if (ecKey != null) break;
                errorMessages.add(String.format(errMsg, algorithmIdentifier));
                break;
            }
            default: {
                errorMessages.add(String.format("The type of key of %s is not a valid value", jwsAlgorithm));
            }
        }
    }

    private boolean isNcipherEC(String algKeyAlg, String keyAlg) {
        return PropertyInfo.getHSMMode() == PropertyInfo.HSM_MODE.NCIPHER && "EC".equals(algKeyAlg) && "ECDSA".equals(keyAlg);
    }

    private String getUnavailableMsg(String which, String alg) {
        String msg = "The selected %s (%s) is not available due to the capabilities and configuration of the underlying JCE provider(s).";
        return String.format(msg, which, alg);
    }

    private void checkSymmetricJweKeyLength(Configuration configuration, List<String> errorMessages, String jweAlgoName, String encAlgName, String kid) {
        Table table = configuration.getTable("Symmetric Keys");
        boolean keyFound = false;
        for (Row row : table.getRows()) {
            Key key;
            int keyBitLen;
            int neededBitLength;
            if (!StringUtils.equals((String)kid, (String)row.getFieldValue("Key ID"))) continue;
            keyFound = true;
            int unknown = -1;
            Object selectedAlgorithm = "selected ";
            if ("dir".equals(jweAlgoName)) {
                selectedAlgorithm = (String)selectedAlgorithm + "JWE content encryption algorithm";
                neededBitLength = JWTKeyDerivationUtil.getKeySize((String)encAlgName);
            } else {
                selectedAlgorithm = (String)selectedAlgorithm + "JWE algorithm";
                switch (jweAlgoName) {
                    case "A128KW": 
                    case "A128GCMKW": {
                        neededBitLength = 128;
                        break;
                    }
                    case "A192KW": 
                    case "A192GCMKW": {
                        neededBitLength = 192;
                        break;
                    }
                    case "A256KW": 
                    case "A256GCMKW": {
                        neededBitLength = 256;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + jweAlgoName);
                    }
                }
            }
            if (neededBitLength == (keyBitLen = (key = SymmetricKeySupport.getKey((FieldList)row)) != null ? key.getEncoded().length * 8 : 0) || neededBitLength == unknown) continue;
            String msg = "%s '%s' is %d bits but keys used with the %s need to be %s";
            String exactBitsMessagePart = SymmetricKeySupport.getExactBitsMessagePart(neededBitLength);
            errorMessages.add(String.format(msg, "Key ID", kid, keyBitLen, selectedAlgorithm, exactBitsMessagePart));
        }
        if (!keyFound || StringUtils.isBlank((String)kid)) {
            errorMessages.add("Active Symmetric Encryption Key ID is required for the selected JWE Algorithm");
        }
    }

    private void checkHmacKeyLength(Configuration configuration, List<String> errorMessages, String jwsAlgoName, String kid) {
        Table table = configuration.getTable("Symmetric Keys");
        boolean keyFound = false;
        for (Row row : table.getRows()) {
            if (!StringUtils.equals((String)kid, (String)row.getFieldValue("Key ID"))) continue;
            keyFound = true;
            try {
                Key key = SymmetricKeySupport.getKeyChecked((FieldList)row);
                int minBits = Integer.parseInt(jwsAlgoName.substring("HS".length()));
                int keyBitLen = key.getEncoded().length * 8;
                if (keyBitLen >= minBits) continue;
                String msg = "%s '%s' is only %d bits but keys used with the selected JWS algorithm need to be %s";
                String atLeastBitsMessagePart = SymmetricKeySupport.getAtLeastBitsMessagePart(minBits);
                errorMessages.add(String.format(msg, "Key ID", kid, keyBitLen, atLeastBitsMessagePart));
            }
            catch (ValidationException e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (!keyFound || StringUtils.isBlank((String)kid)) {
            errorMessages.add("Active Symmetric Key ID is required for the selected JWS Algorithm");
        }
    }

    private void checkUniqueKid(Table table, List<String> errMsgs, boolean checkForUniqueKeyIdsAcrossAllAtms, String instanceId) {
        HashSet<String> kids = new HashSet<String>();
        for (Row row : table.getRows()) {
            String kid = row.getFieldValue("Key ID");
            if (kids.add(kid = kid.trim())) continue;
            String msg = "Duplicate %s value '%s' - please ensure that all %s values are unique in %s";
            errMsgs.add(String.format(msg, "Key ID", kid, "Key ID", table.getName()));
        }
        if (checkForUniqueKeyIdsAcrossAllAtms && !kids.isEmpty()) {
            String uniqueRefMessage = " Key ID must be unique across all plugin instances,  OAuth & OpenID Connect Keys and Token Signing Keys when %s is enabled.";
            Set<String> oidcOAuthKeyIds = this.getOidcOAuthKeyIds();
            Map<String, Set<String>> keyIdToIssuers = this.getKeyIdToIssuers();
            for (String keyId : kids) {
                String atmIdUsingKeyId = AccessTokenMgmtJwkPublishUtil.getAtmInstanceIdForKeyId((String)keyId, (String)instanceId);
                if (atmIdUsingKeyId != null) {
                    String msg = "%s value '%s' is already used by a key in Access Token Management instance '%s'. " + uniqueRefMessage;
                    errMsgs.add(String.format(msg, "Key ID", keyId, atmIdUsingKeyId, "Publish Keys to the PingFederate JWKS Endpoint"));
                }
                this.validateKeyIdWithCentralKeys(errMsgs, keyId, uniqueRefMessage, oidcOAuthKeyIds, keyIdToIssuers);
            }
        }
    }

    private Set<String> getOidcOAuthKeyIds() {
        HashSet<String> oidcOAuthKeyIds = new HashSet<String>();
        List oidcOAuthKeys = this.jwkFacilitator.getJsonWebKeySet().getJsonWebKeys();
        for (JsonWebKey dynamicJwk : oidcOAuthKeys) {
            oidcOAuthKeyIds.add(dynamicJwk.getKeyId());
        }
        return oidcOAuthKeyIds;
    }

    private void validateKeyIdWithCentralKeys(List<String> errMsgs, String keyId, String uniqueRefMessage, Set<String> oidcOAuthKeyIds, Map<String, Set<String>> keyIdToIssuers) {
        String msg = "%s value '%s' is used in %s." + uniqueRefMessage;
        if (oidcOAuthKeyIds.contains(keyId)) {
            errMsgs.add(String.format(msg, "Key ID", keyId, "OAuth & OpenID Connect Keys", "Publish Keys to the PingFederate JWKS Endpoint"));
        }
        if (keyIdToIssuers.containsKey(keyId)) {
            Set<String> issuers = keyIdToIssuers.get(keyId);
            String issuersStr = this.getIssuersForMessage(issuers);
            errMsgs.add(String.format(msg, "Key ID", keyId, "Token Signing Keys for OAuth virtual issuer(s) " + issuersStr, "Publish Keys to the PingFederate JWKS Endpoint"));
        }
    }

    private Map<String, Set<String>> getKeyIdToIssuers() {
        Map tokenSigningKeys = this.jwkFacilitator.getIssuerToAdditionalSigningKeys();
        HashMap<String, Set<String>> keyIdToIssuers = new HashMap<String, Set<String>>();
        for (Map.Entry tokenSigningKey : tokenSigningKeys.entrySet()) {
            if (tokenSigningKey.getValue() == null) continue;
            for (String tokenSigningKeyId : ((Map)tokenSigningKey.getValue()).keySet()) {
                if (keyIdToIssuers.containsKey(tokenSigningKeyId)) {
                    ((Set)keyIdToIssuers.get(tokenSigningKeyId)).add((String)tokenSigningKey.getKey());
                    continue;
                }
                HashSet<String> issuersForKeyId = new HashSet<String>();
                issuersForKeyId.add((String)tokenSigningKey.getKey());
                keyIdToIssuers.put(tokenSigningKeyId, issuersForKeyId);
            }
        }
        return keyIdToIssuers;
    }

    private String getIssuersForMessage(Set<String> issuers) {
        HashSet<String> issuerNames = new HashSet<String>();
        for (String issuerId : issuers) {
            OAuthIssuer issuer = this.oAuthIssuerManager.getById(issuerId);
            if (issuer == null) continue;
            issuerNames.add(issuer.getName());
        }
        return "[ " + String.join((CharSequence)", ", issuerNames) + " ]";
    }

    private void checkKidCertsAlreadyPublished(String instanceId, Table table, List<String> errMsgs) {
        Map<String, X509Certificate> certKidsMap = this.getExistingPublishedKidCerts(instanceId);
        for (Row row : table.getRows()) {
            String kid = row.getFieldValue("Key ID");
            String alias = row.getFieldValue("Certificate");
            X500PrivateCredential x500 = this.certificateSupport.getDsigKeypair(alias);
            if (x500 != null) {
                X509Certificate x509Certificate = x500.getCertificate();
                if (certKidsMap.get(kid) == null || certKidsMap.get(kid).equals(x509Certificate)) continue;
                String msg = "Duplicate %s value '%s' published with different certificate - please ensure that all %s / %s pairs are unique across JWT Access Token Management Plug-ins";
                errMsgs.add(String.format(msg, "Key ID", kid, "Key ID", "Certificate", table.getName()));
                continue;
            }
            this.log.warn((Object)("Unable to find certificate and keypair for alias " + alias));
        }
    }

    private Map<String, X509Certificate> getExistingPublishedKidCerts(String instanceId) {
        HashMap<String, X509Certificate> certKidsMap = new HashMap<String, X509Certificate>();
        for (BearerAccessTokenMgmtPluginInstance instance : this.accessTokenMgmtPluginManager.getInstances()) {
            Configuration config = instance.getAdminCompositeConfiguration();
            if (!StringUtils.equals((String)instance.getDescriptor().getPluginClassName(), (String)JwtBearerAccessTokenManagementPlugin.class.getName()) || StringUtils.equals((String)config.getId(), (String)instanceId) || !config.getBooleanFieldValue("Publish Key ID X.509 URL")) continue;
            this.certificateSupport.gatherKidCerts(config, certKidsMap);
        }
        return certKidsMap;
    }

    private void checkNotSame(Configuration configuration, String name1, String name2, List<String> errMsgs) {
        String value1 = configuration.getFieldValue(name1);
        String value2 = configuration.getFieldValue(name2);
        if (StringUtils.isNotBlank((String)value1) && StringUtils.equals((String)value1, (String)value2)) {
            errMsgs.add(name1 + " and " + name2 + " need to have unique values.");
        }
    }

    private void checkNotAllowed(String sourceName, boolean sourceValue, String targetName, boolean targetValue, List<String> errMsgs) {
        if (sourceValue && targetValue) {
            errMsgs.add(String.format("'%s' functionality is not available when '%s' is selected", targetName, sourceName));
        }
    }

    private void checkRevocationRequiredFields(Configuration configuration, List<String> errorMessages) {
        if (configuration.getFieldValue("JWT ID Claim Length") == null || configuration.getIntFieldValue("JWT ID Claim Length") < MIN_JWT_ID_CLAIM_LENGTH_FOR_REVOCATION) {
            errorMessages.add("'JWT ID Claim Length' must be at least " + MIN_JWT_ID_CLAIM_LENGTH_FOR_REVOCATION + " characters long when 'Enable Token Revocation' is selected.");
        }
        if (StringUtils.isEmpty((String)configuration.getFieldValue("Client ID Claim Name"))) {
            errorMessages.add("'Client ID Claim Name' is required when 'Enable Token Revocation' is selected.");
        }
    }

    private void checkTokenLifetime(Configuration configuration, List<String> errorMessages) {
        double dynamicRotationPeriod;
        int maximumJwtAccessTokenLifetimeInMinutes;
        int tokenLifetime = configuration.getIntFieldValue("Token Lifetime");
        if (tokenLifetime > (maximumJwtAccessTokenLifetimeInMinutes = (int)((dynamicRotationPeriod = ConfigStoreFarm.getConfig((String)"jwks-endpoint-configuration").getDoubleValue("dynamic-rotation-period-in-days", 7.0)) * 60.0 * 24.0))) {
            errorMessages.add(String.format("'%s' is out of range. JWT Access Token Lifetime cannot exceed the dynamic rotation period (%d minutes) when '%s' is enabled", "Token Lifetime", maximumJwtAccessTokenLifetimeInMinutes, "Use Centralized Signing Key"));
        }
    }
}

