/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.access.token.management.plugins;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.access.AccessGrantManagerAccessor;
import com.pingidentity.access.JwksEndpointKeyAccessor;
import com.pingidentity.adapters.htmlform.validators.SubPathValidator;
import com.pingidentity.configservice.ConfigEventListener;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SignatureAlgorithm;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.crypto.jws.JwsSignatureUtil;
import com.pingidentity.pf.access.token.management.plugins.CertificateSupport;
import com.pingidentity.pf.access.token.management.plugins.ConfigValidator;
import com.pingidentity.pf.access.token.management.plugins.InternalJwksEndpointHandler;
import com.pingidentity.pf.access.token.management.plugins.InvalidTokenException;
import com.pingidentity.pf.access.token.management.plugins.JwksEndpointHandler;
import com.pingidentity.pf.access.token.management.plugins.JwtAtmCertMaps;
import com.pingidentity.pf.access.token.management.plugins.KeySelectPreRenderCallback;
import com.pingidentity.pf.access.token.management.plugins.PublicJwkSupport;
import com.pingidentity.pf.access.token.management.plugins.RemoteJwksSupport;
import com.pingidentity.pf.access.token.management.plugins.ReservedClaimNamesValidator;
import com.pingidentity.pf.access.token.management.plugins.SymmetricKeySupport;
import com.pingidentity.pf.access.token.management.plugins.X509CertificateEndpointHandler;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.logging.LoggingUtil;
import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.AccessTokenRevocable;
import com.pingidentity.sdk.oauth20.BearerAccessTokenManagementPlugin;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.sdk.util.ConfigCache;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500PrivateCredential;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.EcdsaUsingShaAlgorithm;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jws.JsonWebSignatureAlgorithm;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.keys.X509Util;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.JoseException;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ValidationUtil;
import org.sourceid.common.VersionUtil;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.jose.jwk.AccessTokenMgmtPublishableJwk;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.issuer.OAuthIssuerManager;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.DsigKeypairFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.HttpsURLValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.servlet.adapter.Handler;
import org.sourceid.websso.servlet.adapter.HandlerRegistry;

public class JwtBearerAccessTokenManagementPlugin
implements BearerAccessTokenManagementPlugin,
AccessTokenRevocable,
AccessTokenMgmtPublishableJwk {
    public static final String X509_PATH_BY_KID = "/oauth/x509/kid";
    public static final String X509_PATH_BY_X5T = "/oauth/x509/x5t";
    public static final String B64U_ENCODING = "b64u";
    public static final String HEX_ENCODING = "";
    public static final String USE_CENTRALIZED_SIGNING_KEY = "Use Centralized Signing Key";
    private static final String PI_ATM_HEADER = "pi.atm";
    private static final Log log = LogFactory.getLog(JwtBearerAccessTokenManagementPlugin.class);
    private static final ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();
    private PluginDescriptor pluginDescriptor;
    static final String JWS_ALGO = "JWS Algorithm";
    static final String TOKEN_LIFETIME = "Token Lifetime";
    static final String ACTIVE_SIGNING_CERT = "Active Signing Certificate Key ID";
    static final String CLIENT_ID_CLAIM_NAME = "Client ID Claim Name";
    static final String SCOPE_CLAIM_NAME = "Scope Claim Name";
    static final String AUTHORIZATION_DETAILS_CLAIM_NAME = "Authorization Details Claim Name";
    static final String ACCESS_GRANT_GUID_CLAIM_NAME = "Access Grant GUID Claim Name";
    static final String SPACE_DELIMIT_SCOPE_VALUES = "Space Delimit Scope Values";
    static final String JWT_ID_CLAIM_LENGTH = "JWT ID Claim Length";
    static final String AUDIENCE_CLAIM_VALUE = "Audience Claim Value";
    static final String ISSUER_CLAIM_VALUE = "Issuer Claim Value";
    static final String NOT_BEFORE_CLAIM_OFFSET = "Not Before Claim Offset";
    private static final String INCLUDE_ISSUED_AT_CLAIM = "Include Issued At Claim";
    static final String INCLUDE_KEY_ID_HEADER_PARAMETER = "Include Key ID Header Parameter";
    static final String INCLUDE_X509_THUMB_HEADER_PARAMETER = "Include X.509 Thumbprint Header Parameter";
    static final String SYMMETRIC_KEYS = "Symmetric Keys";
    static final String ACTIVE_SYMMETRIC_KEY = "Active Symmetric Key ID";
    static final String KEY_ID = "Key ID";
    static final String KEY = "Key";
    static final String ENCODING = "Encoding";
    static final String PUBLISH_KEYID_X509_URL = "Publish Key ID X.509 URL";
    static final String PUBLISH_THUMBPRINT_X509_URL = "Publish Thumbprint X.509 URL";
    static final String JWKS_PATH = "JWKS Endpoint Path";
    static final String JWKS_PATH_CACHE_AGE = "JWKS Endpoint Cache Duration";
    static final String CERTIFICATES = "Certificates";
    static final String CERTIFICATE = "Certificate";
    static final String JWE_ALGO = "JWE Algorithm";
    static final String JWE_CONTENT_ENCRYPTION_ALGO = "JWE Content Encryption Algorithm";
    static final String ACTIVE_SYMMETRIC_ENCRYPTION_KEY = "Active Symmetric Encryption Key ID";
    static final String ASYMMETRIC_ENCRYPTION_KEY = "Asymmetric Encryption Key";
    static final String ASYMMETRIC_ENCRYPTION_JWKS_URL = "Asymmetric Encryption JWKS URL";
    static final String DEFAULT_CACHE_DURATION = "Default JWKS URL Cache Duration";
    static final String INCLUDE_JWE_KEY_ID_HEADER_PARAMETER = "Include JWE Key ID Header Parameter";
    static final String INCLUDE_JWE_X509_THUMB_HEADER_PARAMETER = "Include JWE X.509 Thumbprint Header Parameter";
    private static final String TYPE_HEADER_VALUE = "Type Header Value";
    static final String ENABLE_TOKEN_REVOCATION = "Enable Token Revocation";
    private static final String EXPAND_SCOPE_GROUPS_FIELD_NAME = "Expand Scope Groups";
    static final String PUBLISH_KEYS_TO_JWKS_FIELD_NAME = "Publish Keys to the PingFederate JWKS Endpoint";
    private static final RequiredFieldValidator REQUIRED_FIELD = new RequiredFieldValidator();
    private String instanceId;
    private String jwsAlgo;
    private boolean useCentralizedKeys;
    private int tokenLife;
    private Map<String, X500PrivateCredential> signingKeys = new HashMap<String, X500PrivateCredential>();
    private Map<String, X509Certificate> kidToCertMap = new HashMap<String, X509Certificate>();
    private Map<String, X509Certificate> thumbToCertMap = new HashMap<String, X509Certificate>();
    private String activeCertKeyId;
    private String x5t;
    private Map<String, Key> symmetricKeys;
    private String activeMacKeyId;
    private String jweAlgo;
    private String jweEncAlgo;
    private String activeSymmetricEncryptionKeyId;
    private PublicJsonWebKey asymmetricEncryptionJwk;
    private RemoteJwksSupport remoteJwksSupport;
    private boolean includeJweKid;
    private boolean includeJweX5t;
    private boolean includeJwsKid;
    private String scopeClaimName;
    private String authorizationDetailsClaimName;
    private String clientIdClaimName;
    private String accessGrantGuidClaimName;
    private boolean spaceDelimitScope;
    private int jwtIdClaimLength;
    private String issuerValue;
    private String audienceValue;
    private Integer notBeforeOffsetMinutes;
    private boolean includeIssuedAt;
    private boolean expandScopeGroups;
    private final CertificateSupport certSupport;
    private final AccessGrantManager accessGrantManager;
    private final BearerAccessTokenMgmtPluginManager accessTokenMgmtPluginManager;
    private final JWKSEndpointManager jwksEndpointManager;
    private final JwkFacilitator jwkFacilitator;
    private final OAuthIssuerManager oAuthIssuerManager;
    private String typHeaderValue;
    private boolean enableTokenRevocation;
    private Set<String> multiValuedAttributes;
    private boolean publishKeysOnJwksEndpoint;
    static Map<String, String> signingAlgorithms = new LinkedHashMap<String, String>(){
        {
            this.put("ES256", "ECDSA using P-256 and SHA-256");
            this.put("ES384", "ECDSA using P-384 and SHA-384");
            this.put("ES512", "ECDSA using P-521 and SHA-512");
            this.put("HS256", "HMAC using SHA-256");
            this.put("HS384", "HMAC using SHA-384");
            this.put("HS512", "HMAC using SHA-512");
            this.put("RS256", "RSA using SHA-256");
            this.put("RS384", "RSA using SHA-384");
            this.put("RS512", "RSA using SHA-512");
            if (SignatureAlgorithm.isRSAPSSAvailable()) {
                this.put("PS256", "RSASSA-PSS using SHA-256");
                this.put("PS384", "RSASSA-PSS using SHA-384");
                this.put("PS512", "RSASSA-PSS using SHA-512");
            }
        }
    };
    private static ConfigCache<JwtAtmCertMaps> certMapsCache = new ConfigCache(JwtAtmCertMaps::new);
    private static ConfigEventListener atmPluginManagerListener = () -> certMapsCache.clear();

    public JwtBearerAccessTokenManagementPlugin() {
        this(new CertificateSupport(), AccessGrantManagerAccessor.getAccessGrantManager(), MgmtFactory.getBearerAccessTokenMgmtPluginMgr());
    }

    public JwtBearerAccessTokenManagementPlugin(CertificateSupport certSupport, AccessGrantManager agm) {
        this.certSupport = certSupport;
        this.accessGrantManager = agm;
        this.accessTokenMgmtPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        this.jwksEndpointManager = MgmtFactory.getJWKSEndpointManager();
        this.jwkFacilitator = MgmtFactory.getJwkFacilitator();
        this.oAuthIssuerManager = MgmtFactory.getOAuthIssuerManager();
        this.initDescriptors();
    }

    public JwtBearerAccessTokenManagementPlugin(CertificateSupport certSupport, AccessGrantManager agm, BearerAccessTokenMgmtPluginManager batm) {
        this.certSupport = certSupport;
        this.accessGrantManager = agm;
        this.accessTokenMgmtPluginManager = batm;
        this.jwksEndpointManager = MgmtFactory.getJWKSEndpointManager();
        this.jwkFacilitator = MgmtFactory.getJwkFacilitator();
        this.oAuthIssuerManager = MgmtFactory.getOAuthIssuerManager();
        this.initDescriptors();
    }

    private void initDescriptors() {
        HackGuiConfigDescriptor gui = new HackGuiConfigDescriptor();
        gui.setDescription("A JSON Web Token (JWT) Bearer Access Token Management Plug-in that enables PingFederate to issue (and optionally validate) cryptographically secure self-contained OAuth access tokens.");
        String kidDesc = "An identifier for the given key";
        TextFieldDescriptor keyIdField = new TextFieldDescriptor(KEY_ID, kidDesc);
        keyIdField.setSize(3);
        keyIdField.addValidator((FieldValidator)REQUIRED_FIELD);
        String symmKeysDesc = "A group of keys for use with symmetric encryption and MAC algorithms.";
        TableDescriptor symmetricKeyTable = new TableDescriptor(SYMMETRIC_KEYS, symmKeysDesc);
        symmetricKeyTable.addRowField((FieldDescriptor)keyIdField);
        TextFieldDescriptor keyField = new TextFieldDescriptor(KEY, "Encoded symmetric key", true);
        keyField.setSize(150);
        keyField.addValidator((FieldValidator)REQUIRED_FIELD);
        symmetricKeyTable.addRowField((FieldDescriptor)keyField);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> encodingOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        encodingOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Hex", HEX_ENCODING));
        encodingOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Base64[url]", B64U_ENCODING));
        SelectFieldDescriptor keyEncoding = new SelectFieldDescriptor(ENCODING, "How the binary key is encoded as a string", encodingOptions);
        symmetricKeyTable.addRowField((FieldDescriptor)keyEncoding);
        symmetricKeyTable.addValidator((RowValidator)new SymmetricKeySupport());
        gui.addTable(symmetricKeyTable);
        String certsDesc = "A group of certificates and their corresponding public/private key pairs for use with signatures";
        TableDescriptor certsTable = new TableDescriptor(CERTIFICATES, certsDesc);
        certsTable.addRowField((FieldDescriptor)keyIdField);
        String certDesc = "Requires an EC key or RSA key length of at least 2048 bits";
        SelectFieldDescriptor dsigKeypairField = this.certSupport.getCertsDesc(CERTIFICATE, certDesc);
        dsigKeypairField.addValidator((FieldValidator)REQUIRED_FIELD);
        certsTable.addRowField((FieldDescriptor)dsigKeypairField);
        gui.addTable(certsTable);
        TextFieldDescriptor tokenLifeDesc = new TextFieldDescriptor(TOKEN_LIFETIME, "Defines how long, in minutes, an access token is valid.");
        tokenLifeDesc.setSize(8);
        tokenLifeDesc.setDefaultValue("120");
        tokenLifeDesc.addValidator((FieldValidator)REQUIRED_FIELD);
        tokenLifeDesc.addValidator((FieldValidator)new IntegerValidator(1, 0x2222222), true);
        gui.addField((FieldDescriptor)tokenLifeDesc);
        String useCentralizedKeyDesc = "Select this option to use a centralized key when signing JWTs using an RSA-based or EC-based algorithm.";
        CheckBoxFieldDescriptor useCentralizedKey = new CheckBoxFieldDescriptor(USE_CENTRALIZED_SIGNING_KEY, useCentralizedKeyDesc);
        useCentralizedKey.setDefaultValue(false);
        useCentralizedKey.setDefaultForLegacyConfig("false");
        gui.addField((FieldDescriptor)useCentralizedKey);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        options.add(SelectFieldDescriptor.SELECT_ONE);
        options.addAll(signingAlgorithms.entrySet().stream().map(entry -> new AbstractSelectionFieldDescriptor.OptionValue((String)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList()));
        String desc = "The HMAC or signing algorithm used to protect the integrity of the token. For HMAC, the active symmetric key must be selected below. For RSA or EC, the active signing certificate must be selected. Integrity protection can also be achieved using symmetric encryption, in which case this field can be left unselected.";
        SelectFieldDescriptor algo = new SelectFieldDescriptor(JWS_ALGO, desc, options);
        gui.addField((FieldDescriptor)algo);
        String activeHmacKeyDesc = "The Key ID of the key to use when producing JWTs using an HMAC-based algorithm.";
        SelectFieldDescriptor activeSymmetricKey = new SelectFieldDescriptor(ACTIVE_SYMMETRIC_KEY, activeHmacKeyDesc, new String[0]);
        gui.addField((FieldDescriptor)activeSymmetricKey);
        String doKidDesc = "Indicates whether the Key ID (kid) header parameter will be included in the signature header of the token, which can help identify the appropriate key during verification.";
        CheckBoxFieldDescriptor kid = new CheckBoxFieldDescriptor(INCLUDE_KEY_ID_HEADER_PARAMETER, doKidDesc);
        kid.setDefaultValue(true);
        gui.addAdvancedField((FieldDescriptor)kid);
        String activeCertDesc = "The Key ID of the key pair and certificate to use when producing JWTs using an RSA-based or EC-based algorithm.";
        SelectFieldDescriptor activeCert = new SelectFieldDescriptor(ACTIVE_SIGNING_CERT, activeCertDesc, new String[0]);
        gui.addField((FieldDescriptor)activeCert);
        String x5tDesc = "Indicates whether the X.509 Certificate Thumbprint (x5t) header parameter will be included in the signature header of the token, which can help identify the appropriate public key during verification of asymmetrically signed tokens.";
        gui.addAdvancedField((FieldDescriptor)new CheckBoxFieldDescriptor(INCLUDE_X509_THUMB_HEADER_PARAMETER, x5tDesc));
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> jweAlgOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        jweAlgOptions.add(SelectFieldDescriptor.SELECT_ONE);
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Direct Encryption with symmetric key", "dir"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-128 Key Wrap", "A128KW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-192 Key Wrap", "A192KW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-256 Key Wrap", "A256KW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-GCM-128 key encryption", "A128GCMKW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-GCM-192 key encryption", "A192GCMKW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-GCM-256 key encryption", "A256GCMKW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("ECDH-ES", "ECDH-ES"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("ECDH-ES with AES-128 Key Wrap", "ECDH-ES+A128KW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("ECDH-ES with AES-192 Key Wrap", "ECDH-ES+A192KW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("ECDH-ES with AES-256 Key Wrap", "ECDH-ES+A256KW"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("RSAES OAEP", "RSA-OAEP"));
        jweAlgOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("RSAES OAEP using SHA-256 and MGF1 with SHA-256", "RSA-OAEP-256"));
        String jweAlgDesc = "The algorithm used to encrypt or otherwise determine the value of the content encryption key.";
        SelectFieldDescriptor jweAlgo = new SelectFieldDescriptor(JWE_ALGO, jweAlgDesc, jweAlgOptions);
        gui.addField((FieldDescriptor)jweAlgo);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> jweEncOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        jweEncOptions.add(SelectFieldDescriptor.SELECT_ONE);
        jweEncOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Composite AES-CBC-128 HMAC-SHA-256", "A128CBC-HS256"));
        jweEncOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Composite AES-CBC-192 HMAC-SHA-384", "A192CBC-HS384"));
        jweEncOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Composite AES-CBC-256 HMAC-SHA-512", "A256CBC-HS512"));
        jweEncOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-GCM-128", "A128GCM"));
        jweEncOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-GCM-192", "A192GCM"));
        jweEncOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("AES-GCM-256", "A256GCM"));
        String jweEncDesc = "The content encryption algorithm used to perform authenticated encryption on the plaintext payload of the token.";
        SelectFieldDescriptor jweEncAlgo = new SelectFieldDescriptor(JWE_CONTENT_ENCRYPTION_ALGO, jweEncDesc, jweEncOptions);
        gui.addField((FieldDescriptor)jweEncAlgo);
        String activeSymmEncKeyDesc = "The Key ID of the key to use when using a symmetric encryption algorithm.";
        SelectFieldDescriptor activeSymmetricEncKey = new SelectFieldDescriptor(ACTIVE_SYMMETRIC_ENCRYPTION_KEY, activeSymmEncKeyDesc, new String[0]);
        gui.addField((FieldDescriptor)activeSymmetricEncKey);
        String asymmetricEncKeyDesc = "An asymmetric encryption public key, which can be in either JWK format or a certificate.";
        TextAreaFieldDescriptor asymmetricEncKey = new TextAreaFieldDescriptor(ASYMMETRIC_ENCRYPTION_KEY, asymmetricEncKeyDesc, 4, 18);
        asymmetricEncKey.addValidator((FieldValidator)new PublicJwkSupport(), true);
        gui.addField((FieldDescriptor)asymmetricEncKey);
        String jwksUrlDesc = "The HTTPS URL of a JSON Web Key Set endpoint that has public key(s) for encryption.";
        TextFieldDescriptor jwks = new TextFieldDescriptor(ASYMMETRIC_ENCRYPTION_JWKS_URL, jwksUrlDesc);
        jwks.addValidator((FieldValidator)new HttpsURLValidator(), true);
        gui.addField((FieldDescriptor)jwks);
        String enableTokenRevocationDesc = "Indicates whether the access token can be revoked.";
        CheckBoxFieldDescriptor enableTokenRevocationField = new CheckBoxFieldDescriptor(ENABLE_TOKEN_REVOCATION, enableTokenRevocationDesc);
        enableTokenRevocationField.setDefaultValue(false);
        gui.addField((FieldDescriptor)enableTokenRevocationField);
        String defaultCacheDesc = "The default time in minutes to cache the content of the Asymmetric Encryption JWKS URL, which will be used when no cache directives are included or they indicate that the content has already expired.";
        TextFieldDescriptor defaultJwksCache = new TextFieldDescriptor(DEFAULT_CACHE_DURATION, "The default time in minutes to cache the content of the Asymmetric Encryption JWKS URL, which will be used when no cache directives are included or they indicate that the content has already expired.");
        defaultJwksCache.setDefaultValue("720");
        defaultJwksCache.setDefaultForLegacyConfig("720");
        defaultJwksCache.addValidator((FieldValidator)new IntegerValidator(0, 86400), true);
        gui.addAdvancedField((FieldDescriptor)defaultJwksCache);
        String doJweKidDesc = "Indicates whether the Key ID (kid) header parameter will be included in the encryption header of the token, which can help identify the appropriate key during decryption.";
        CheckBoxFieldDescriptor jweKid = new CheckBoxFieldDescriptor(INCLUDE_JWE_KEY_ID_HEADER_PARAMETER, doJweKidDesc);
        jweKid.setDefaultValue(true);
        jweKid.setDefaultForLegacyConfig(Boolean.toString(true));
        gui.addAdvancedField((FieldDescriptor)jweKid);
        String doJweX5cDesc = "Indicates whether the X.509 Certificate Thumbprint (x5t) header parameter will be included in the encryption header of the token, which can help identify the appropriate key during decryption.";
        CheckBoxFieldDescriptor jweX5c = new CheckBoxFieldDescriptor(INCLUDE_JWE_X509_THUMB_HEADER_PARAMETER, doJweX5cDesc);
        gui.addAdvancedField((FieldDescriptor)jweX5c);
        int nameSize = 20;
        String cidClaimDesc = "The name of the JWT claim used to represent the OAuth Client ID (omitted, if blank).";
        TextFieldDescriptor claimName = new TextFieldDescriptor(CLIENT_ID_CLAIM_NAME, cidClaimDesc);
        claimName.addValidator((FieldValidator)new ReservedClaimNamesValidator());
        claimName.setDefaultValue("client_id");
        claimName.setSize(nameSize);
        gui.addAdvancedField((FieldDescriptor)claimName);
        String scopeClaimDesc = "The name of the JWT claim used to represent the scope of the grant (omitted, if blank).";
        claimName = new TextFieldDescriptor(SCOPE_CLAIM_NAME, scopeClaimDesc);
        claimName.addValidator((FieldValidator)new ReservedClaimNamesValidator());
        claimName.setDefaultValue("scope");
        claimName.setSize(nameSize);
        gui.addAdvancedField((FieldDescriptor)claimName);
        String spaceScopeDesc = "Select checkbox to indicate that multiple scope strings will be delimited by spaces rather than represented as a JSON array.";
        CheckBoxFieldDescriptor checkBox = new CheckBoxFieldDescriptor(SPACE_DELIMIT_SCOPE_VALUES, spaceScopeDesc);
        checkBox.setDefaultValue(true);
        gui.addAdvancedField((FieldDescriptor)checkBox);
        String authorizationDetailsClaimDesc = "The name of the JWT claim used to represent the authorization details of the grant (omitted, if blank).";
        claimName = new TextFieldDescriptor(AUTHORIZATION_DETAILS_CLAIM_NAME, authorizationDetailsClaimDesc);
        claimName.addValidator((FieldValidator)new ReservedClaimNamesValidator());
        claimName.setDefaultValue("authorization_details");
        claimName.setSize(nameSize);
        gui.addAdvancedField((FieldDescriptor)claimName);
        String issDesc = "Indicates the value of the Issuer (iss) claim in the JWT (omitted, if blank).";
        TextFieldDescriptor issuerVal = new TextFieldDescriptor(ISSUER_CLAIM_VALUE, issDesc);
        int valueSize = 45;
        issuerVal.setSize(valueSize);
        gui.addAdvancedField((FieldDescriptor)issuerVal);
        String audDesc = "Indicates the value of the Audience (aud) claim in the JWT (omitted, if blank).";
        TextFieldDescriptor audVal = new TextFieldDescriptor(AUDIENCE_CLAIM_VALUE, audDesc);
        audVal.setSize(valueSize);
        gui.addAdvancedField((FieldDescriptor)audVal);
        String notBeforeDesc = "Indicates the number of minutes before the token issuing time to which the Not Before (nbf) claim value will be set (omitted, if blank).";
        TextFieldDescriptor notBeforeVal = new TextFieldDescriptor(NOT_BEFORE_CLAIM_OFFSET, notBeforeDesc);
        notBeforeVal.addValidator((FieldValidator & Serializable)field -> {
            try {
                Integer.parseInt(field.getValue());
            }
            catch (NumberFormatException ex) {
                throw new ValidationException("'" + field.getLabel() + "' is not a valid Integer: '" + field.getValue() + "'.");
            }
        }, true);
        notBeforeVal.setSize(valueSize);
        gui.addAdvancedField((FieldDescriptor)notBeforeVal);
        String issuedAtDesc = "Indicates whether to include the Issued At (iat) claim in the JWT.";
        CheckBoxFieldDescriptor issuedAtCheckBox = new CheckBoxFieldDescriptor(INCLUDE_ISSUED_AT_CLAIM, issuedAtDesc);
        issuedAtCheckBox.setDefaultValue(true);
        issuedAtCheckBox.setDefaultForLegacyConfig(Boolean.toString(false));
        gui.addAdvancedField((FieldDescriptor)issuedAtCheckBox);
        String jtiDesc = "Indicates the number of characters of the JWT ID (jti) claim in the JWT (omitted, if zero).";
        TextFieldDescriptor jwtId = new TextFieldDescriptor(JWT_ID_CLAIM_LENGTH, jtiDesc);
        jwtId.setDefaultValue("22");
        jwtId.setDefaultForLegacyConfig("0");
        jwtId.setSize(4);
        jwtId.addValidator((FieldValidator)REQUIRED_FIELD);
        jwtId.addValidator((FieldValidator)new IntegerValidator(0, 500), true);
        gui.addAdvancedField((FieldDescriptor)jwtId);
        String guidDesc = "The name of the JWT claim used to carry the persistent access grant GUID (omitted, if blank). If the claim is present during validation, the grant database is consulted to ensure the grant is still good.";
        TextFieldDescriptor guidClaimName = new TextFieldDescriptor(ACCESS_GRANT_GUID_CLAIM_NAME, guidDesc);
        guidClaimName.addValidator((FieldValidator)new ReservedClaimNamesValidator());
        guidClaimName.setSize(nameSize);
        gui.addAdvancedField((FieldDescriptor)guidClaimName);
        String publishKeysToJwksDesc = "Publish asymmetric signing keys to the PingFederate JWKS endpoint. If enabled, asymmetric key identifiers have to be unique across all plugin instances, OAuth & OpenID Connect Keys and Token Signing Keys.";
        CheckBoxFieldDescriptor publishKeysToJwksField = new CheckBoxFieldDescriptor(PUBLISH_KEYS_TO_JWKS_FIELD_NAME, publishKeysToJwksDesc);
        publishKeysToJwksField.setDefaultValue(false);
        publishKeysToJwksField.setDefaultForLegacyConfig(Boolean.toString(false));
        gui.addAdvancedField((FieldDescriptor)publishKeysToJwksField);
        String jwksEndpointDesc = "Path on the PingFederate server to publish a JSON Web Key Set with the keys/certificates of this plugin instance that can be used for signature verification. Must include the initial slash (example: /oauth/jwks). The resulting URL will be https://<pf_host>:<port>/ext/<JWKS Endpoint Path>). If specified, the path must be unique across all plugin instances, including child instances.";
        TextFieldDescriptor jwksEndpoint = new TextFieldDescriptor(JWKS_PATH, "Path on the PingFederate server to publish a JSON Web Key Set with the keys/certificates of this plugin instance that can be used for signature verification. Must include the initial slash (example: /oauth/jwks). The resulting URL will be https://<pf_host>:<port>/ext/<JWKS Endpoint Path>). If specified, the path must be unique across all plugin instances, including child instances.");
        jwksEndpoint.addValidator((FieldValidator)new SubPathValidator(), true);
        gui.addAdvancedField((FieldDescriptor)jwksEndpoint);
        String jwksCacheDesc = "How long, in minutes, to tell clients that they can cache the content from the JWKS Endpoint Path for this plugin.";
        TextFieldDescriptor jwksCache = new TextFieldDescriptor(JWKS_PATH_CACHE_AGE, "How long, in minutes, to tell clients that they can cache the content from the JWKS Endpoint Path for this plugin.");
        jwksCache.setDefaultValue("720");
        jwksCache.setDefaultForLegacyConfig("720");
        jwksCache.addValidator((FieldValidator)new IntegerValidator(0, 525600), true);
        gui.addAdvancedField((FieldDescriptor)jwksCache);
        String kidEndptDesc = "Indicates whether the certificates will be made accessible by Key ID at https://<pf_host>:<port>/ext/oauth/x509/kid?v=<id>. This option does not apply when 'Use Centralized Signing Key' is selected.";
        gui.addAdvancedField((FieldDescriptor)new CheckBoxFieldDescriptor(PUBLISH_KEYID_X509_URL, kidEndptDesc));
        String x5tEndptDesc = "Indicates whether the certificates will be made accessible by certificate thumbprint at https://<pf_host>:<port>/ext/oauth/x509/x5t?v=<base64url encoded SHA-1 thumbprint>. This option does not apply when 'Use Centralized Signing Key' is selected.";
        gui.addAdvancedField((FieldDescriptor)new CheckBoxFieldDescriptor(PUBLISH_THUMBPRINT_X509_URL, x5tEndptDesc));
        String expandScopeGroupDesc = "Expand scope groups into their corresponding scopes in the Access Token contents and introspection response. By default this is disabled.";
        CheckBoxFieldDescriptor expandScopeGroups = new CheckBoxFieldDescriptor(EXPAND_SCOPE_GROUPS_FIELD_NAME, expandScopeGroupDesc);
        expandScopeGroups.setDefaultValue(false);
        expandScopeGroups.setDefaultForLegacyConfig(Boolean.toString(false));
        gui.addAdvancedField((FieldDescriptor)expandScopeGroups);
        String typHeaderDesc = "Indicates the value of the Type (typ) header  in the JWT (omitted, if blank).";
        TextFieldDescriptor typHeaderValue = new TextFieldDescriptor(TYPE_HEADER_VALUE, typHeaderDesc);
        typHeaderValue.setDefaultForLegacyConfig(HEX_ENCODING);
        gui.addAdvancedField((FieldDescriptor)typHeaderValue);
        gui.addPreRenderCallback(new KeySelectPreRenderCallback(CERTIFICATES, activeCert));
        gui.addPreRenderCallback(new KeySelectPreRenderCallback(SYMMETRIC_KEYS, activeSymmetricKey));
        gui.addPreRenderCallback(new KeySelectPreRenderCallback(SYMMETRIC_KEYS, activeSymmetricEncKey));
        gui.addValidator(new ConfigValidator(this.certSupport, this.accessTokenMgmtPluginManager, this.jwksEndpointManager, this.jwkFacilitator, this.oAuthIssuerManager));
        this.pluginDescriptor = new PluginDescriptor("JSON Web Tokens", (ConfigurablePlugin)this, (GuiConfigDescriptor)gui, this.getVersion());
        HashMap<String, Boolean> metadata = new HashMap<String, Boolean>();
        metadata.put("EarlyCreateAndConfigure", true);
        metadata.put("FipsStatus", (Boolean)PluginFipsStatus.COMPLIANT);
        this.pluginDescriptor.setMetadata(metadata);
    }

    public IssuedAccessToken issueAccessToken(Map<String, AttributeValue> attributes, Scope scope, String clientId, String accessGrantGuid, int tokenManagerSequenceNumber, AuthorizationDetails authorizationDetails) {
        LinkedHashMap<String, Object> payloadMap = new LinkedHashMap<String, Object>();
        scope = scope == null ? new Scope(new String[0]) : scope;
        String scopeString = this.expandScopeGroups ? scope.expanded().getScopeStr() : scope.getScopeStr();
        Set scopeSet = this.expandScopeGroups ? scope.expanded().getScopeSet() : scope.getScopeSet();
        this.addIfNameNotBlankAndValueNotNull(payloadMap, this.scopeClaimName, this.spaceDelimitScope ? scopeString : new ArrayList(scopeSet));
        if (StringUtils.isNotBlank((String)this.authorizationDetailsClaimName)) {
            if (authorizationDetails != null && CollectionUtils.isNotEmpty((Collection)authorizationDetails.getDetails())) {
                SimpleJsonRespWriter.setForJsonSerialize(payloadMap, (String)this.authorizationDetailsClaimName, (AttributeValue)authorizationDetails.toAttributeValue(), Collections.singletonList(this.authorizationDetailsClaimName));
            } else {
                this.addIfNameNotBlankAndValueNotNull(payloadMap, this.authorizationDetailsClaimName, new ArrayList());
            }
        }
        this.addIfNameNotBlankAndValueNotNull(payloadMap, this.clientIdClaimName, clientId);
        this.addIfNameNotBlankAndValueNotNull(payloadMap, this.accessGrantGuidClaimName, accessGrantGuid);
        this.addIfValueNotBlank(payloadMap, "iss", this.issuerValue);
        this.addIfValueNotBlank(payloadMap, "aud", this.audienceValue);
        NumericDate now = NumericDate.now();
        this.addNotBeforeClaim(payloadMap, now.getValue());
        if (this.includeIssuedAt) {
            this.addToPayload(payloadMap, "iat", now.getValue());
        }
        if (this.jwtIdClaimLength > 0) {
            String jti = IDGenerator.rndAlphaNumeric((int)this.jwtIdClaimLength);
            this.addToPayload(payloadMap, "jti", jti);
            LoggingUtil.setAccessTokenJti((String)jti);
        }
        SimpleJsonRespWriter.prepareAttributeMap((AttributeMap)new AttributeMap(attributes), payloadMap, (List)(this.multiValuedAttributes != null ? new ArrayList<String>(this.multiValuedAttributes) : Collections.emptyList()));
        NumericDate expiresAt = this.getExpiresAt(attributes, now.getValue());
        this.addToPayload(payloadMap, "exp", expiresAt.getValue());
        String payload = JsonUtil.toJson(payloadMap);
        String token = null;
        boolean doJws = StringUtils.isNotBlank((String)this.jwsAlgo);
        if (doJws) {
            KeyPersuasion keyPersuasion;
            JsonWebSignature jws = new JsonWebSignature();
            jws.setAlgorithmHeaderValue(this.jwsAlgo);
            try {
                keyPersuasion = jws.getKeyPersuasion();
            }
            catch (JoseException e) {
                throw new IllegalStateException("Problem getting JWS key persuasion: " + e, e);
            }
            switch (keyPersuasion) {
                case ASYMMETRIC: {
                    if (this.useCentralizedKeys) {
                        this.populateCentralizedKeySettings(jws);
                        break;
                    }
                    X500PrivateCredential signingKey = this.signingKeys.get(this.activeCertKeyId);
                    if (signingKey == null) {
                        throw new IllegalStateException("The signing key for key id '" + this.activeCertKeyId + "' could not be found and is null.");
                    }
                    jws.setKey((Key)signingKey.getPrivateKey());
                    this.conditionallySetKeyIdHeader((JsonWebStructure)jws, this.activeCertKeyId, this.includeJwsKid);
                    this.setHeaderIfValueNotBlank((JsonWebStructure)jws, "x5t", this.x5t);
                    PkCert signingPkCert = MgmtFactory.getDsigPkCertManager().getPkCert(signingKey.getAlias());
                    JwsSignatureUtil.applyProviderOverrideContextIfNeeded((JsonWebSignature)jws, (PkCert)signingPkCert);
                    break;
                }
                case SYMMETRIC: {
                    Key macKey = this.symmetricKeys.get(this.activeMacKeyId);
                    jws.setKey(macKey);
                    this.conditionallySetKeyIdHeader((JsonWebStructure)jws, this.activeMacKeyId, this.includeJwsKid);
                    break;
                }
                default: {
                    throw this.newISE((JsonWebStructure)jws, keyPersuasion);
                }
            }
            jws.setPayload(payload);
            this.setHeaderIfValueNotBlank((JsonWebStructure)jws, PI_ATM_HEADER, Integer.toString(tokenManagerSequenceNumber, 36));
            this.setHeaderIfValueNotBlank((JsonWebStructure)jws, "typ", this.typHeaderValue);
            try {
                payload = token = jws.getCompactSerialization();
            }
            catch (JoseException e) {
                throw new IllegalStateException("Unable to create signed token: " + e, e);
            }
        }
        boolean hasSymmetricEnc = false;
        if (StringUtils.isNotBlank((String)this.jweAlgo)) {
            KeyPersuasion keyPersuasion;
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setPayload(payload);
            jwe.setAlgorithmHeaderValue(this.jweAlgo);
            jwe.setEncryptionMethodHeaderParameter(this.jweEncAlgo);
            if (doJws) {
                jwe.setContentTypeHeaderValue("JWT");
            }
            try {
                keyPersuasion = jwe.getAlgorithm().getKeyPersuasion();
            }
            catch (JoseException e) {
                throw new IllegalStateException("Problem getting JWE key persuasion: " + e, e);
            }
            switch (keyPersuasion) {
                case SYMMETRIC: {
                    Key encKey = this.symmetricKeys.get(this.activeSymmetricEncryptionKeyId);
                    this.conditionallySetKeyIdHeader((JsonWebStructure)jwe, this.activeSymmetricEncryptionKeyId, this.includeJweKid);
                    jwe.setKey(encKey);
                    hasSymmetricEnc = true;
                    break;
                }
                case ASYMMETRIC: {
                    String thumb;
                    PublicJsonWebKey encryptionJwk = this.asymmetricEncryptionJwk;
                    if (this.remoteJwksSupport != null) {
                        encryptionJwk = this.remoteJwksSupport.getEncryptionKeyFor(jwe);
                    }
                    jwe.setKey((Key)encryptionJwk.getPublicKey());
                    this.conditionallySetKeyIdHeader((JsonWebStructure)jwe, encryptionJwk.getKeyId(), this.includeJweKid);
                    if (!this.includeJweX5t || (thumb = encryptionJwk.getX509CertificateSha1Thumbprint(true)) == null) break;
                    jwe.setX509CertSha1ThumbprintHeaderValue(thumb);
                    break;
                }
                default: {
                    throw this.newISE((JsonWebStructure)jwe, keyPersuasion);
                }
            }
            this.setHeaderIfValueNotBlank((JsonWebStructure)jwe, PI_ATM_HEADER, Integer.toString(tokenManagerSequenceNumber, 36));
            this.setHeaderIfValueNotBlank((JsonWebStructure)jwe, "typ", this.typHeaderValue);
            try {
                token = jwe.getCompactSerialization();
            }
            catch (JoseException e) {
                throw new IllegalStateException("Unable to create encrypted token: " + e, e);
            }
        }
        if (token == null) {
            throw new IllegalStateException("cannot issue a token when not signed or encrypted");
        }
        if (!doJws && !hasSymmetricEnc) {
            throw new IllegalStateException("cannot issue a token without some kind of integrity protection");
        }
        return new IssuedAccessToken(token, "Bearer", Long.valueOf(expiresAt.getValueInMillis()));
    }

    private void addNotBeforeClaim(Map<String, Object> payloadMap, long nowInSeconds) {
        if (this.notBeforeOffsetMinutes != null) {
            NumericDate notBefore = NumericDate.fromSeconds((long)nowInSeconds);
            notBefore.addSeconds((long)this.notBeforeOffsetMinutes.intValue() * -60L);
            this.addToPayload(payloadMap, "nbf", notBefore.getValue());
        }
    }

    private NumericDate getExpiresAt(Map<String, AttributeValue> attributes, long nowInSeconds) {
        int expTimeInAttributeFulfillment = this.getExpTimeInAttrFulfillmentMapping(attributes);
        NumericDate expiresAt = expTimeInAttributeFulfillment != 0 ? this.computeExpiresAt(expTimeInAttributeFulfillment, nowInSeconds) : this.computeExpiresAt(this.tokenLife, nowInSeconds);
        return expiresAt;
    }

    private int getExpTimeInAttrFulfillmentMapping(Map<String, AttributeValue> attributes) {
        int expTimeInAttributeFulfillment = 0;
        if (attributes != null && attributes.containsKey("exp")) {
            AttributeValue expTimeAttrValue = attributes.get("exp");
            if (ValidationUtil.isValidInt((String)expTimeAttrValue.getValue(), (int)1)) {
                expTimeInAttributeFulfillment = Integer.parseInt(expTimeAttrValue.getValue());
            } else {
                log.debug((Object)("Invalid exp claim value in attribute contract fulfillment mapping: " + expTimeAttrValue.getValue()));
            }
        }
        return expTimeInAttributeFulfillment;
    }

    private void addToPayload(Map<String, Object> payload, String name, Object value) {
        Object previousValue = payload.put(name, value);
        if (previousValue != null && log.isDebugEnabled()) {
            log.debug((Object)("Previous value for claim/attribute named " + name + " was " + previousValue + " and was replaced with " + value + " (might there be a name conflict?)"));
        }
    }

    private IllegalStateException newISE(JsonWebStructure jwx, KeyPersuasion keyPersuasion) {
        String msg = "Unknown or unsupported key persuasion: %s for JOSE algorithm %s";
        return new IllegalStateException(String.format(msg, keyPersuasion, jwx.getAlgorithmHeaderValue()));
    }

    private void setHeaderIfValueNotBlank(JsonWebStructure jws, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            jws.setHeader(name, value);
        }
    }

    private void conditionallySetKeyIdHeader(JsonWebStructure jwx, String kid, boolean includeIt) {
        if (includeIt && kid != null) {
            jwx.setKeyIdHeaderValue(kid);
        }
    }

    private void addIfNameNotBlankAndValueNotNull(Map<String, Object> payloadMap, String name, Object value) {
        if (StringUtils.isNotBlank((String)name) && value != null) {
            this.addToPayload(payloadMap, name, value);
        }
    }

    private void addIfValueNotBlank(Map<String, Object> payloadMap, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.addToPayload(payloadMap, name, value);
        }
    }

    private AccessToken validateAccessToken(String accessTokenValue, boolean skipNbfValidation) {
        try {
            AccessToken accessToken = this.validateAT(accessTokenValue, skipNbfValidation);
            String jti = accessToken.getTokenIdentifier();
            LoggingUtil.setRequestJti((String)jti);
            if (this.enableTokenRevocation && jti != null && StateMgmtFactory.getSessionRevocationService().getRevokedSriInfo(jti) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JWT access token with jti: " + jti + " has been revoked."));
                }
                return null;
            }
            return accessToken;
        }
        catch (InvalidTokenException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Access token is not valid: " + ExceptionUtil.toStringWithCauses((Throwable)e)));
            }
        }
        catch (JoseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Problem in access token validation " + ExceptionUtil.toStringWithCauses((Throwable)e)));
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)"Unexpected problem in access token validation ", (Throwable)e);
        }
        return null;
    }

    public AccessToken validateAccessToken(String accessTokenValue) {
        return this.validateAccessToken(accessTokenValue, false);
    }

    static <T> T getAndCheckClaim(String name, Map<String, Object> claims, Class<T> valueType, boolean isRequired, boolean enforceType, boolean remove) throws InvalidTokenException {
        Object objValue = remove ? claims.remove(name) : claims.get(name);
        if (objValue == null) {
            if (isRequired) {
                throw new InvalidTokenException(name + " is a required claim.");
            }
            return null;
        }
        if (valueType.isInstance(objValue)) {
            return valueType.cast(objValue);
        }
        if (enforceType) {
            String msg = "The value for " + name + " claim is the wrong type. Expected " + valueType + " but was " + objValue.getClass();
            throw new InvalidTokenException(msg);
        }
        return null;
    }

    private AccessToken validateAT(String accessTokenValue, boolean skipNbfValidation) throws InvalidTokenException, JoseException {
        List authorizationDetailsList;
        AccessGrant byGuid;
        String kid;
        KeyPersuasion keyPersuasion;
        JsonWebStructure jsonWebStructure = JsonWebStructure.fromCompactSerialization((String)accessTokenValue);
        JsonWebSignature jws = null;
        JsonWebEncryption jwe = null;
        String payloadString = null;
        if (jsonWebStructure instanceof JsonWebEncryption) {
            jwe = (JsonWebEncryption)jsonWebStructure;
        } else {
            jws = (JsonWebSignature)jsonWebStructure;
        }
        if (jwe != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("JWE: " + jwe.getHeaders().getFullHeaderAsJsonString()));
            }
            this.verifyHeaderIfNeeded((JsonWebStructure)jwe, "typ", this.typHeaderValue);
            keyPersuasion = jwe.getAlgorithm().getKeyPersuasion();
            switch (keyPersuasion) {
                case SYMMETRIC: {
                    kid = jwe.getKeyIdHeaderValue();
                    Key key = this.chooseSymmetricKeyForDecryption(kid);
                    if (key == null) {
                        throw new InvalidTokenException("Unable to locate a symmetric key for decrypting token with Key ID '" + kid + "'");
                    }
                    jwe.setKey(key);
                    break;
                }
                case ASYMMETRIC: {
                    throw new InvalidTokenException("Unable to locally decrypt tokens using asymmetric encryption (" + jwe.getAlgorithmHeaderValue() + ").");
                }
                default: {
                    throw this.newISE((JsonWebStructure)jwe, keyPersuasion);
                }
            }
            String cty = jwe.getContentTypeHeaderValue();
            if (cty != null && (cty.equalsIgnoreCase("jwt") || cty.equalsIgnoreCase("application/jwt"))) {
                jws = new JsonWebSignature();
                jws.setCompactSerialization(jwe.getPayload());
            } else {
                payloadString = jwe.getPayload();
            }
        }
        if (jws != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("JWS: " + jws.getHeaders().getFullHeaderAsJsonString() + "." + jws.getUnverifiedPayload()));
            }
            this.verifyHeaderIfNeeded((JsonWebStructure)jws, "typ", this.typHeaderValue);
            keyPersuasion = jws.getKeyPersuasion();
            kid = jws.getKeyIdHeaderValue();
            switch (keyPersuasion) {
                case ASYMMETRIC: {
                    if (this.useCentralizedKeys) {
                        this.verifySignatureUsingCentralizedKeys(jws, kid);
                        break;
                    }
                    X509Certificate verificationCert = this.kidToCertMap.get(kid != null ? kid : this.activeCertKeyId);
                    String x5t = jws.getHeader("x5t");
                    if (x5t != null) {
                        verificationCert = this.thumbToCertMap.get(x5t);
                    }
                    if (verificationCert != null) {
                        jws.setKey((Key)verificationCert.getPublicKey());
                        break;
                    }
                    String msg = "Unable to locate a verification key for token with Key ID '%s' and/or X509 Thumbprint '%s'";
                    throw new InvalidTokenException(String.format(msg, kid, x5t));
                }
                case SYMMETRIC: {
                    Key macKey = this.chooseMacKeyForVerification(kid);
                    if (macKey == null) {
                        throw new InvalidTokenException("Unable to locate a symmetric verification key for token with Key ID '" + kid + "'");
                    }
                    jws.setKey(macKey);
                    break;
                }
                default: {
                    throw this.newISE((JsonWebStructure)jws, keyPersuasion);
                }
            }
            if (!jws.verifySignature()) {
                throw new InvalidTokenException("Invalid signature.");
            }
            payloadString = jws.getPayload();
        }
        if (payloadString == null) {
            throw new InvalidTokenException("Unable to get payload from token.");
        }
        Map payload = JsonUtil.parseJson(payloadString);
        String jwtIdValue = JwtBearerAccessTokenManagementPlugin.getAndCheckClaim("jti", payload, String.class, false, true, true);
        String tokenIssuer = this.validateIssueClaim(payload, this.issuerValue);
        List<String> tokenAudiences = this.getClaimStringValue(payload.remove("aud"));
        Long exp = JwtBearerAccessTokenManagementPlugin.getAndCheckClaim("exp", payload, Long.class, true, true, true);
        NumericDate expiresAt = NumericDate.fromSeconds((long)exp);
        if (!skipNbfValidation) {
            JwtBearerAccessTokenManagementPlugin.validateNbfClaim(payload);
        }
        String scopeString = null;
        if (StringUtils.isNotBlank((String)this.scopeClaimName)) {
            Object scopeObj = payload.remove(this.scopeClaimName);
            if (scopeObj instanceof Collection) {
                Collection scopes = (Collection)scopeObj;
                Scope scope = new Scope(scopes.toArray(new String[scopes.size()]));
                scopeString = this.expandScopeGroups ? scope.expanded().getScopeStr() : scope.getScopeStr();
            } else if (scopeObj instanceof String) {
                scopeString = (String)scopeObj;
            } else {
                log.debug((Object)"scope claim not a string or an array so ignoring value");
            }
        }
        String clientId = this.removeValue(payload, this.clientIdClaimName);
        String guid = this.removeValue(payload, this.accessGrantGuidClaimName);
        if (guid != null && (byGuid = this.accessGrantManager.getByGuid(guid)) == null) {
            throw new InvalidTokenException("Revoked, expired or otherwise invalid/unknown access grant guid: " + guid);
        }
        AuthorizationDetails authorizationDetails = null;
        if (StringUtils.isNotBlank((String)this.authorizationDetailsClaimName) && (authorizationDetailsList = JwtBearerAccessTokenManagementPlugin.getAndCheckClaim(this.authorizationDetailsClaimName, payload, List.class, false, true, true)) != null && !authorizationDetailsList.isEmpty()) {
            try {
                String authorizationDetailsJson = mapper.writeValueAsString((Object)authorizationDetailsList);
                authorizationDetails = new AuthorizationDetails(authorizationDetailsJson);
            }
            catch (IOException e) {
                log.error((Object)"unable to retrieve authorization details", (Throwable)e);
                throw new InvalidTokenException("Invalid authorization details");
            }
        }
        HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>();
        for (Map.Entry e : payload.entrySet()) {
            Object v = e.getValue();
            AttributeValue value = v instanceof Collection ? AttrValueSupport.make((Collection)((Collection)v)) : AttrValueSupport.make(v);
            attrs.put((String)e.getKey(), value);
        }
        AccessToken accessToken = new AccessToken(expiresAt.getValueInMillis(), attrs, scopeString, clientId, guid, authorizationDetails);
        if (!tokenAudiences.isEmpty()) {
            accessToken.setAudience(tokenAudiences);
        }
        if (StringUtils.isNotBlank((String)tokenIssuer)) {
            accessToken.setIssuer(tokenIssuer);
        }
        accessToken.setTokenIdentifier(jwtIdValue);
        return accessToken;
    }

    static void validateNbfClaim(Map<String, Object> payload) throws InvalidTokenException {
        Long nbfLong = JwtBearerAccessTokenManagementPlugin.getAndCheckClaim("nbf", payload, Long.class, false, true, false);
        if (nbfLong != null) {
            NumericDate notBefore = NumericDate.fromSeconds((long)nbfLong);
            NumericDate now = NumericDate.now();
            if (now.isBefore(notBefore)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The JWT is not yet valid as the evaluation time (" + now + ") is before the Not Before (nbf=" + notBefore + ") claim time."));
                }
                throw new InvalidTokenException("Token invalid based on Not Before (nbf) claim.");
            }
        }
    }

    public String removeValue(Map<String, Object> payload, String name) throws InvalidTokenException {
        if (StringUtils.isNotBlank((String)name)) {
            return JwtBearerAccessTokenManagementPlugin.getAndCheckClaim(name, payload, String.class, false, true, true);
        }
        return null;
    }

    private String validateIssueClaim(Map<String, Object> payload, String expectedvalue) throws InvalidTokenException {
        List<String> issuerFromToken = this.validateClaim(payload, "iss", expectedvalue, false);
        return issuerFromToken.isEmpty() ? null : issuerFromToken.get(0);
    }

    List<String> validateClaim(Map<String, Object> payload, String name, String expectedvalue, boolean failIfReceivedButNotExpected) throws InvalidTokenException {
        List<String> value = this.getClaimStringValue(payload.remove(name));
        if (StringUtils.isNotBlank((String)expectedvalue)) {
            if (!StringUtils.equals((String)expectedvalue, (String)String.join((CharSequence)" ", value))) {
                throw new InvalidTokenException(name + " claim validation failed - expected " + expectedvalue + " but was " + value);
            }
        } else if (failIfReceivedButNotExpected && value != null) {
            throw new InvalidTokenException(name + " claim validation failed - no claim expected but value was " + value);
        }
        return value;
    }

    private List<String> getClaimStringValue(Object claimValue) {
        List<String> claimValueSet = new ArrayList<String>();
        if (claimValue instanceof List) {
            claimValueSet = ((List)claimValue).stream().map(Object::toString).collect(Collectors.toList());
        } else if (claimValue != null) {
            claimValueSet = Collections.singletonList((String)claimValue);
        }
        return claimValueSet;
    }

    private Key chooseSymmetricKeyForDecryption(String kid) {
        return this.symmetricKeys.get(StringUtils.isNotBlank((String)kid) ? kid : this.activeSymmetricEncryptionKeyId);
    }

    private Key chooseMacKeyForVerification(String kid) {
        return this.symmetricKeys.get(StringUtils.isNotBlank((String)kid) ? kid : this.activeMacKeyId);
    }

    public boolean issuedToken(String accessTokenValue, int tokenManagerSequenceNumber) {
        boolean issuedToken = true;
        try {
            JsonWebStructure jsonWebStructure = JsonWebStructure.fromCompactSerialization((String)accessTokenValue);
            String sequenceNumberHeaderValue = jsonWebStructure.getHeaders().getStringHeaderValue(PI_ATM_HEADER);
            if (sequenceNumberHeaderValue != null) {
                int sequenceNumber = Integer.parseInt(sequenceNumberHeaderValue, 36);
                issuedToken = sequenceNumber == tokenManagerSequenceNumber;
            }
        }
        catch (JoseException joseException) {
            // empty catch block
        }
        return issuedToken;
    }

    public void configure(Configuration configuration) {
        X509Certificate activeCert;
        this.instanceId = configuration.getId();
        this.tokenLife = configuration.getIntFieldValue(TOKEN_LIFETIME);
        this.jwsAlgo = configuration.getFieldValue(JWS_ALGO);
        this.useCentralizedKeys = configuration.getBooleanFieldValue(USE_CENTRALIZED_SIGNING_KEY);
        this.kidToCertMap.clear();
        this.thumbToCertMap.clear();
        this.signingKeys.clear();
        this.certSupport.gatherCerts(configuration, this.kidToCertMap, this.thumbToCertMap, this.signingKeys);
        this.multiValuedAttributes = configuration.getMultiValuedAttributes();
        this.activeCertKeyId = configuration.getFieldValue(ACTIVE_SIGNING_CERT);
        if (!this.useCentralizedKeys && configuration.getBooleanFieldValue(INCLUDE_X509_THUMB_HEADER_PARAMETER) && (activeCert = this.kidToCertMap.get(this.activeCertKeyId)) != null) {
            this.x5t = CertificateHelper.calculateThumb((X509Certificate)activeCert);
        }
        Table symmetricKeys = configuration.getTable(SYMMETRIC_KEYS);
        List keyRows = symmetricKeys.getRows();
        this.symmetricKeys = new HashMap<String, Key>(keyRows.size());
        for (Row keyRow : keyRows) {
            String kid = keyRow.getFieldValue(KEY_ID);
            Key key = SymmetricKeySupport.getKey((FieldList)keyRow);
            this.symmetricKeys.put(kid, key);
        }
        this.activeMacKeyId = configuration.getFieldValue(ACTIVE_SYMMETRIC_KEY);
        this.includeJwsKid = configuration.getBooleanFieldValue(INCLUDE_KEY_ID_HEADER_PARAMETER);
        this.clientIdClaimName = configuration.getFieldValue(CLIENT_ID_CLAIM_NAME);
        this.scopeClaimName = configuration.getFieldValue(SCOPE_CLAIM_NAME);
        this.authorizationDetailsClaimName = configuration.getFieldValue(AUTHORIZATION_DETAILS_CLAIM_NAME) == null ? "authorization_details" : configuration.getFieldValue(AUTHORIZATION_DETAILS_CLAIM_NAME);
        this.accessGrantGuidClaimName = configuration.getFieldValue(ACCESS_GRANT_GUID_CLAIM_NAME);
        this.spaceDelimitScope = configuration.getBooleanFieldValue(SPACE_DELIMIT_SCOPE_VALUES);
        this.jwtIdClaimLength = configuration.getIntFieldValue(JWT_ID_CLAIM_LENGTH);
        this.issuerValue = configuration.getFieldValue(ISSUER_CLAIM_VALUE);
        this.audienceValue = configuration.getFieldValue(AUDIENCE_CLAIM_VALUE);
        this.notBeforeOffsetMinutes = JwtBearerAccessTokenManagementPlugin.getNotBeforeOffsetConfig(configuration);
        this.includeIssuedAt = configuration.getBooleanFieldValue(INCLUDE_ISSUED_AT_CLAIM, false);
        this.jweAlgo = configuration.getFieldValue(JWE_ALGO);
        this.jweEncAlgo = configuration.getFieldValue(JWE_CONTENT_ENCRYPTION_ALGO);
        this.activeSymmetricEncryptionKeyId = configuration.getFieldValue(ACTIVE_SYMMETRIC_ENCRYPTION_KEY);
        Field asymmetricKeyField = configuration.getField(ASYMMETRIC_ENCRYPTION_KEY);
        this.asymmetricEncryptionJwk = PublicJwkSupport.getKey(asymmetricKeyField);
        String jwksUrl = configuration.getFieldValue(ASYMMETRIC_ENCRYPTION_JWKS_URL);
        if (StringUtils.isNotBlank((String)jwksUrl)) {
            long defaultCacheDuration = configuration.getLongFieldValue(DEFAULT_CACHE_DURATION);
            this.remoteJwksSupport = new RemoteJwksSupport(jwksUrl, defaultCacheDuration);
        }
        this.includeJweKid = configuration.getBooleanFieldValue(INCLUDE_JWE_KEY_ID_HEADER_PARAMETER);
        this.includeJweX5t = configuration.getBooleanFieldValue(INCLUDE_JWE_X509_THUMB_HEADER_PARAMETER);
        this.expandScopeGroups = configuration.getBooleanFieldValue(EXPAND_SCOPE_GROUPS_FIELD_NAME);
        this.typHeaderValue = configuration.getFieldValue(TYPE_HEADER_VALUE);
        this.enableTokenRevocation = configuration.getBooleanFieldValue(ENABLE_TOKEN_REVOCATION);
        this.publishKeysOnJwksEndpoint = configuration.getBooleanFieldValue(PUBLISH_KEYS_TO_JWKS_FIELD_NAME);
        this.setUpHandlers(configuration);
    }

    static Integer getNotBeforeOffsetConfig(Configuration configuration) {
        if (StringUtils.isNotBlank((String)configuration.getFieldValue(NOT_BEFORE_CLAIM_OFFSET))) {
            return configuration.getIntFieldValue(NOT_BEFORE_CLAIM_OFFSET);
        }
        return null;
    }

    private void setUpHandlers(Configuration configuration) {
        String jwksPath = configuration.getFieldValue(JWKS_PATH);
        if (!this.useCentralizedKeys && StringUtils.isNotBlank((String)jwksPath)) {
            ArrayList<JsonWebKey> jwks = new ArrayList<JsonWebKey>();
            for (Map.Entry<String, X509Certificate> entry : this.kidToCertMap.entrySet()) {
                X509Certificate x5 = entry.getValue();
                String kid = entry.getKey();
                try {
                    PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)x5.getPublicKey());
                    jwk.setKeyId(kid);
                    jwk.setUse("sig");
                    jwk.setCertificateChain(new X509Certificate[]{x5});
                    jwk.setX509CertificateSha1Thumbprint(X509Util.x5t((X509Certificate)x5));
                    jwks.add((JsonWebKey)jwk);
                }
                catch (JoseException je) {
                    log.error((Object)("Unable to add certificate with kid " + kid + " to JWKS: " + je), (Throwable)je);
                }
            }
            int maxAgeMinutes = configuration.getIntFieldValue(JWKS_PATH_CACHE_AGE);
            HandlerRegistry.registerHandler((String)jwksPath, (Handler)new JwksEndpointHandler(jwks, maxAgeMinutes * 60));
        }
        if (this.useCentralizedKeys && StringUtils.isNotBlank((String)jwksPath)) {
            int maxAgeMinutes = configuration.getIntFieldValue(JWKS_PATH_CACHE_AGE);
            int maxAge = maxAgeMinutes * 60;
            String signingAlgorithm = configuration.getFieldValue(JWS_ALGO);
            AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
            AlgorithmFactory jwsAlgorithmFactory = aff.getJwsAlgorithmFactory();
            if (jwsAlgorithmFactory.isAvailable(signingAlgorithm)) {
                HandlerRegistry.registerHandler((String)jwksPath, (Handler)new InternalJwksEndpointHandler(maxAge, JwksEndpointKeyAccessor.newInstance()));
            }
        }
    }

    private NumericDate computeExpiresAt(int tokenLifeInMinutes, long nowInSeconds) {
        NumericDate exp = NumericDate.fromSeconds((long)nowInSeconds);
        exp.addSeconds((long)tokenLifeInMinutes * 60L);
        return exp;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    AccessGrantManager getAccessGrantManager() {
        return this.accessGrantManager;
    }

    public void revokeAllAccessTokens(String accessGrantGuid) {
    }

    public void revokeAllAccessTokensByClient(String clientId) {
    }

    public boolean revokeAccessToken(String rawAccessToken) {
        AccessToken accessToken = this.validateAccessToken(rawAccessToken, true);
        if (accessToken == null) {
            return false;
        }
        String jti = accessToken.getTokenIdentifier();
        if (jti == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("jti claim missing in access token for revocation by: " + this.instanceId));
            }
            return false;
        }
        StateMgmtFactory.getSessionRevocationService().addRevokedSri(jti, accessToken.getExpiresAt());
        return true;
    }

    public AccessToken getAccessToken(String rawAccessToken) {
        if (this.enableTokenRevocation) {
            return this.validateAccessToken(rawAccessToken, true);
        }
        return null;
    }

    public Map<String, String> getKeyIdToCertAlias(Configuration configuration) {
        Table certs;
        HashMap<String, String> keyIdCertIdToPublish = new HashMap<String, String>();
        if (this.publishKeysOnJwksEndpoint && (certs = configuration.getTable(CERTIFICATES)) != null) {
            List rows = certs.getRows();
            for (Row row : rows) {
                String alias;
                String keyId = row.getFieldValue(KEY_ID);
                if (keyId == null || !StringUtils.isNotEmpty((String)(alias = row.getFieldValue(CERTIFICATE)))) continue;
                keyIdCertIdToPublish.put(keyId, alias);
            }
        }
        return keyIdCertIdToPublish;
    }

    String getVersion() {
        return VersionUtil.getVersion();
    }

    private void populateCentralizedKeySettings(JsonWebSignature jws) {
        try {
            String keyType = jws.getKeyType();
            JwksEndpointKeyAccessor accessor = JwksEndpointKeyAccessor.newInstance();
            switch (keyType) {
                case "RSA": {
                    JwksEndpointKeyAccessor.JsonWebKeyWrapper rsaKey = accessor.getCurrentRsaKey(jws.getAlgorithm().getAlgorithmIdentifier());
                    if (rsaKey == null) {
                        throw new IllegalStateException("Unable find a key of type of " + keyType + " to perform this operation");
                    }
                    jws.setKey((Key)rsaKey.getPrivateKey());
                    this.conditionallySetKeyIdHeader((JsonWebStructure)jws, rsaKey.getKeyId(), this.includeJwsKid);
                    PkCert signingPkCert = MgmtFactory.getDsigPkCertManager().getPkCert(rsaKey.getPkCertID());
                    JwsSignatureUtil.applyProviderOverrideContextIfNeeded((JsonWebSignature)jws, (PkCert)signingPkCert);
                    break;
                }
                case "EC": {
                    JsonWebSignatureAlgorithm algorithm = jws.getAlgorithm();
                    EcdsaUsingShaAlgorithm ecdsaAlgorithm = (EcdsaUsingShaAlgorithm)algorithm;
                    JwksEndpointKeyAccessor.JsonWebKeyWrapper ecKey = accessor.getCurrentEcKey(ecdsaAlgorithm.getCurveName());
                    if (ecKey == null) {
                        throw new IllegalStateException("Unable find a key of type of " + keyType + " to perform this operation");
                    }
                    jws.setKey((Key)ecKey.getPrivateKey());
                    this.conditionallySetKeyIdHeader((JsonWebStructure)jws, ecKey.getKeyId(), this.includeJwsKid);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown key type: " + keyType);
                }
            }
        }
        catch (InvalidAlgorithmException e) {
            log.debug((Object)("Unable to populate centralized key settings for JWS: " + e.getMessage()), (Throwable)e);
        }
    }

    private void verifySignatureUsingCentralizedKeys(JsonWebSignature jws, String kid) throws InvalidTokenException {
        if (kid == null) {
            throw new InvalidTokenException("'kid' header value is required");
        }
        JwksEndpointKeyAccessor.JsonWebKeyWrapper key = JwksEndpointKeyAccessor.newInstance().getKeyById(kid);
        if (key == null) {
            throw new InvalidTokenException("Key Not Found!!");
        }
        jws.setKey(key.getJWK().getKey());
    }

    private void verifyHeaderIfNeeded(JsonWebStructure jws, String headerName, String configuredHeaderValue) throws InvalidTokenException {
        String typHeaderValue;
        if (StringUtils.isNotBlank((String)configuredHeaderValue) && !configuredHeaderValue.equals(typHeaderValue = jws.getHeaders().getStringHeaderValue(headerName))) {
            throw new InvalidTokenException("'typ' header value mismatch");
        }
    }

    static {
        MgmtFactory.getBearerAccessTokenMgmtPluginMgr().registerForConfigEvents(atmPluginManagerListener);
        HandlerRegistry.registerHandler((String)X509_PATH_BY_KID, (Handler)new X509CertificateEndpointHandler(KEY_ID, () -> ((JwtAtmCertMaps)certMapsCache.get()).getKidToCertMap()));
        HandlerRegistry.registerHandler((String)X509_PATH_BY_X5T, (Handler)new X509CertificateEndpointHandler("X.509 Thumbprint", () -> ((JwtAtmCertMaps)certMapsCache.get()).getX5tToCertMap()));
    }

    private static class HackGuiConfigDescriptor
    extends GuiConfigDescriptor {
        private HackGuiConfigDescriptor() {
        }

        public Set<Class<? extends FieldDescriptor>> getAllDescriptorTypesInUse() {
            Set typesInUse = super.getAllDescriptorTypesInUse();
            typesInUse.add(DsigKeypairFieldDescriptor.class);
            return typesInUse;
        }
    }
}

