/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.access.token.management.plugins;

import com.pingidentity.configservice.ConfigEventListener;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.SimpleJwkFilter;
import org.jose4j.lang.JoseException;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class RemoteJwksSupport
implements ConfigEventListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpsJwks httpsJwks;
    private final long defaultCacheDurationSeconds;
    private PublicJsonWebKey lastKnownGoodJwk;
    private long useLastKnownGoodJwkUntil;

    public RemoteJwksSupport(String location, long defaultCacheDurationMins) {
        this.defaultCacheDurationSeconds = defaultCacheDurationMins * 60L;
        this.httpsJwks = new HttpsJwks(location);
        this.httpsJwks.setSimpleHttpGet((SimpleGet)this.getGet());
        this.httpsJwks.setDefaultCacheDuration(this.defaultCacheDurationSeconds);
        MgmtFactory.getTrustedCAsManager().registerForConfigEvents((ConfigEventListener)this);
    }

    public PublicJsonWebKey getEncryptionKeyFor(JsonWebEncryption jwe) {
        PublicJsonWebKey encryptionJwk;
        long now = System.currentTimeMillis();
        if (now < this.useLastKnownGoodJwkUntil && this.lastKnownGoodJwk != null) {
            return this.lastKnownGoodJwk;
        }
        try {
            List jsonWebKeys = this.httpsJwks.getJsonWebKeys();
            SimpleJwkFilter filter = new SimpleJwkFilter();
            filter.setKty(jwe.getAlgorithm().getKeyType());
            filter.setUse("enc", false);
            filter.setAlg(jwe.getAlgorithmHeaderValue(), false);
            List filtered = filter.filter((Collection)jsonWebKeys);
            if (filtered.isEmpty()) {
                filter.setAlg(jwe.getAlgorithmHeaderValue(), true);
                filtered = filter.filter((Collection)jsonWebKeys);
                if (filtered.isEmpty()) {
                    filter.setUse("enc", true);
                    filtered = filter.filter((Collection)jsonWebKeys);
                }
            }
            if (filtered.isEmpty()) {
                throw new JoseException("Unable to find suitable encryption key for " + jwe.getAlgorithmHeaderValue() + " in JWKs from " + this.httpsJwks.getLocation() + " " + jsonWebKeys);
            }
            this.lastKnownGoodJwk = encryptionJwk = (PublicJsonWebKey)filtered.iterator().next();
        }
        catch (Exception e) {
            if (this.lastKnownGoodJwk != null) {
                encryptionJwk = this.lastKnownGoodJwk;
                this.useLastKnownGoodJwkUntil = now + this.defaultCacheDurationSeconds * 1000L;
                this.log.warn((Object)("Will continue using the previous encryption key for a while (retry again after " + new Date(this.useLastKnownGoodJwkUntil) + ") due to a problem getting encryption key from JWKS URL " + this.httpsJwks.getLocation() + ": " + ExceptionUtil.toStringWithCauses((Throwable)e)));
            }
            throw new RuntimeException("Problem getting encryption key from JWKS URL " + this.httpsJwks.getLocation(), e);
        }
        return encryptionJwk;
    }

    private Get getGet() {
        Get get = new Get();
        TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
        Set allTrustAnchors = trustedCAsManager.getAllTrustAnchors();
        ArrayList<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>();
        for (TrustAnchor ta : allTrustAnchors) {
            trustedCertificates.add(ta.getTrustedCert());
        }
        get.setTrustedCertificates(trustedCertificates);
        return get;
    }

    public void onConfigUpdated() {
        this.httpsJwks.setSimpleHttpGet((SimpleGet)this.getGet());
    }
}

