/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.access.token.management.plugins;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.sourceid.websso.servlet.adapter.Handler;

public class X509CertificateEndpointHandler
implements Handler {
    private static final Log log = LogFactory.getLog(X509CertificateEndpointHandler.class);
    private String message;
    private CertificateMapProvider mapProvider;
    static final String PARAMETER_NAME = "v";

    public X509CertificateEndpointHandler(String description, Map<String, X509Certificate> certMap) {
        this(description, () -> certMap);
    }

    public X509CertificateEndpointHandler(String description, CertificateMapProvider mapProvider) {
        this.message = "Please indicate the " + description + " via the v parameter.";
        this.mapProvider = mapProvider;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    public void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter(PARAMETER_NAME);
        if (id == null) {
            resp.sendError(400, this.message);
        } else {
            X509Certificate x509Certificate;
            Map<String, X509Certificate> certMap = this.mapProvider.getMap();
            X509Certificate x509Certificate2 = x509Certificate = certMap != null ? certMap.get(id) : null;
            if (x509Certificate == null) {
                resp.sendError(400, "Unknown Certificate. " + this.message);
            } else {
                resp.setContentType("text/plain");
                try (PrintWriter out = resp.getWriter();){
                    byte[] derCert = x509Certificate.getEncoded();
                    String pemCert = Base64.encode((byte[])derCert);
                    out.println("-----BEGIN CERTIFICATE-----");
                    out.println(pemCert);
                    out.println("-----END CERTIFICATE-----");
                    out.flush();
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("Certificate encoding problem.", e);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface CertificateMapProvider {
        public Map<String, X509Certificate> getMap();
    }
}

