/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.notification.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.notification.NotificationPublisherPlugin;
import com.pingidentity.sdk.notification.NotificationSenderPluginDescriptor;
import com.pingidentity.sdk.notification.PublishResult;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public class AmazonSnsNotificationPublisherPlugin
implements NotificationPublisherPlugin {
    private static final Log LOG = LogFactory.getLog(AmazonSnsNotificationPublisherPlugin.class);
    private static final String TYPE = "Amazon SNS Notification Publisher";
    private static final String DESCRIPTION = "Configure the Amazon Web Services (AWS) Simple Notification Service (SNS) Notification Publisher.";
    private static final String TOPIC_ARN_FIELD = "SNS Topic ARN";
    private static final String TOPIC_ARN_DESC = "The Topic Amazon Resource Name (ARN) to which notifications will be published. Note ARNs are in the format of arn:aws:[service]:[region]:[accountid]:[resourceType/resourcePath].";
    private static final String MAX_PAYLOAD_SIZE_FIELD = "Max Payload Size";
    private static final int MAX_PAYLOAD_SIZE_FIELD_LOWER_BOUND = 1;
    private static final int MAX_PAYLOAD_SIZE_FIELD_UPPER_BOUND = 8192;
    private static final String MAX_PAYLOAD_SIZE_DEFAULT_VALUE = "256";
    private static final String MAX_PAYLOAD_SIZE_DESC = String.format("The maximum notification payload size in kilobytes allowed. Enter a value between 1 and %d. The default value is %s.", 8192, "256");
    private static final String ACCEPTS_USER_ATTRIBUTES_CHECKBOX = "Accepts User Attributes";
    private static final String ACCEPTS_USER_ATTRIBUTES_DESC = "Whether user attributes retrieved during authentication are included in the notification payload for certain end user flows.";
    private static final String DATA_KEY = "data";
    private static final String CONFIG_KEY = "configuration";
    private static final List<String> allowedConfigKeys = Arrays.asList("com.pingidentity.notification.config.locale", "com.pingidentity.notification.config.destination.address", "com.pingidentity.notification.config.event.type");
    private static final ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
    private static final int KILOBYTE_IN_BYTES = 1024;
    private String topicARN;
    private int maxPayloadSize;
    private boolean acceptsUserAttributes;

    public PublishResult publishNotification(String eventType, Map<String, String> data, Map<String, String> config) {
        PublishResult sendResult = new PublishResult();
        try {
            SnsClient snsClient = (SnsClient)SnsClient.builder().build();
            HashMap<String, Object> dataCopyMap = new HashMap<String, Object>(data);
            this.cleanupData(dataCopyMap);
            HashMap<String, Map<String, Object>> dataConfigMap = new HashMap<String, Map<String, Object>>();
            dataConfigMap.put(DATA_KEY, dataCopyMap);
            config.entrySet().removeIf(entry -> !allowedConfigKeys.contains(entry.getKey()));
            config.put("com.pingidentity.notification.config.event.type", eventType);
            dataConfigMap.put(CONFIG_KEY, config);
            String payload = objectMapper.writeValueAsString(dataConfigMap);
            int length = payload.getBytes(StandardCharsets.UTF_8).length;
            if (length > this.maxPayloadSize * 1024) {
                String msg = String.format("the payload size exceeded the max allowable size of %dKB.", this.maxPayloadSize);
                LOG.error((Object)msg);
                throw new ProcessRuntimeException(msg);
            }
            PublishRequest publishRequest = (PublishRequest)PublishRequest.builder().message(payload).topicArn(this.topicARN).build();
            PublishResponse result = snsClient.publish(publishRequest);
            sendResult.setNotificationStatus(PublishResult.NOTIFICATION_STATUS.SUCCESS);
            LOG.debug((Object)("published message to Amazon SNS with messageId: " + result.messageId()));
            return sendResult;
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to publish notification to SNS topic", (Throwable)e);
            sendResult.setNotificationStatus(PublishResult.NOTIFICATION_STATUS.FAILURE);
            return sendResult;
        }
    }

    private void cleanupData(Map<String, Object> data) {
        this.cleanupKey("OUT_OF_SYNC", data);
        this.cleanupKey("UPDATED", data);
    }

    private void cleanupKey(String key, Map<String, Object> data) {
        if (data.containsKey(key) && data.get(key) instanceof String) {
            String value = (String)data.get(key);
            List list = Stream.of(value.split("\n\t -")).map(s -> s.replaceAll("\n\t -", "")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            data.put(key, list);
        }
    }

    public void configure(Configuration configuration) {
        this.topicARN = configuration.getFieldValue(TOPIC_ARN_FIELD);
        this.maxPayloadSize = configuration.getIntFieldValue(MAX_PAYLOAD_SIZE_FIELD);
        this.acceptsUserAttributes = configuration.getBooleanFieldValue(ACCEPTS_USER_ATTRIBUTES_CHECKBOX);
    }

    public PluginDescriptor getPluginDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor(DESCRIPTION);
        TextFieldDescriptor topicArn = new TextFieldDescriptor(TOPIC_ARN_FIELD, TOPIC_ARN_DESC);
        topicArn.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)topicArn);
        TextFieldDescriptor maxPayloadSize = new TextFieldDescriptor(MAX_PAYLOAD_SIZE_FIELD, MAX_PAYLOAD_SIZE_DESC);
        maxPayloadSize.addValidator((FieldValidator)new RequiredFieldValidator());
        maxPayloadSize.addValidator((FieldValidator)new IntegerValidator(1, 8192));
        maxPayloadSize.setDefaultValue(MAX_PAYLOAD_SIZE_DEFAULT_VALUE);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)maxPayloadSize);
        CheckBoxFieldDescriptor acceptsUserAttributesCheckbox = new CheckBoxFieldDescriptor(ACCEPTS_USER_ATTRIBUTES_CHECKBOX, ACCEPTS_USER_ATTRIBUTES_DESC);
        acceptsUserAttributesCheckbox.setDefaultValue(false);
        guiConfigDescriptor.addField((FieldDescriptor)acceptsUserAttributesCheckbox);
        NotificationSenderPluginDescriptor pluginDescriptor = new NotificationSenderPluginDescriptor(TYPE, (Plugin)this, guiConfigDescriptor, VersionUtil.getVersion());
        pluginDescriptor.setSupportsExtendedContract(false);
        pluginDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        return pluginDescriptor;
    }

    public boolean acceptsUserAttributes() {
        return this.acceptsUserAttributes;
    }
}

