/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.secretmanagers.cyberark;

import com.pingidentity.pf.secretmanagers.cyberark.CyberArkCredentialProviderHelper;
import com.pingidentity.pf.secretmanagers.cyberark.PasswordRequest;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.secretmanager.SecretInfo;
import com.pingidentity.sdk.secretmanager.SecretManager;
import com.pingidentity.sdk.secretmanager.SecretManagerDescriptor;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import javapasswordsdk.CyberArkGetPassword;
import javapasswordsdk.PSDKPasswordRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.log.AdminAuditLogger;

@CyberArkGetPassword
public class CyberArkCredentialProvider
implements SecretManager {
    private static final Log LOG = LogFactory.getLog(CyberArkCredentialProvider.class);
    private static final String TYPE = "CyberArk Credential Provider";
    private static final String TYPE_DESC = "Retrieve password from CyberArk Vault using CyberArk Credential Provider.";
    private static final String APP_ID_FIELD_NAME = "APP ID";
    private static final String APP_ID_FIELD_DESC = "The unique ID of the application issuing the password request.";
    private static final int CONNECTION_PORT_MIN = 1;
    private static final int CONNECTION_PORT_MAX = 65535;
    private static final String CONNECTION_PORT_DEFAULT = "18923";
    private static final String CONNECTION_PORT_FIELD_NAME = "Connection Port";
    private static final String CONNECTION_PORT_FIELD_DESC = "The port that the Java SDK will use to connect to the Credential Provider. Default 18923.";
    private static final int CONNECTION_TIMEOUT_MIN = 1;
    private static final String CONNECTION_TIMEOUT_DEFAULT = "30";
    private static final String CONNECTION_TIMEOUT_FIELD_NAME = "Connection Timeout (sec)";
    private static final String CONNECTION_TIMEOUT_FIELD_DESC = "Maximum timeout when retrieving credentials from the provider. The actual timeout may be less, depending on provider settings. Default 30 seconds.";
    static final String USERNAME_RETRIEVAL_PROPERTY_NAME_DEFAULT = "username";
    private static final String USERNAME_RETRIEVAL_PROPERTY_NAME_FIELD_NAME = "Username Retrieval Property Name";
    private static final String USERNAME_RETRIEVAL_PROPERTY_NAME_FIELD_DESC = "The name of the property that the username is retrieved from. For example, enter 'userdn' to retrieve the User DN property of a Windows Domain Account. Default 'username'.";
    private static final String GENERATE_SECRET_REFERENCE_ACTION_NAME = "Generate";
    private static final String GENERATE_SECRET_REFERENCE_ACTION_DESC = "Generate secret reference.";
    private static final String SAFE_PARAM_NAME = "Safe";
    private static final String SAFE_PARAM_DESC = "The name of the Safe where the password is stored.";
    private static final String OBJECT_PARAM_NAME = "Object";
    private static final String OBJECT_PARAM_DESC = "The name of the password to retrieve.";
    private static final String FOLDER_PARAM_NAME = "Folder";
    private static final String FOLDER_PARAM_DESC = "The name of the Folder where the password is stored. Default root";
    private static final String REASON_PARAM_NAME = "Reason";
    private static final String REASON_PARAM_DESC = "The reason for retrieving the password.";
    private static final String RETRIEVE_USERNAME_PARAM_NAME = "Retrieve Username";
    private static final String RETRIEVE_USERNAME_PARAM_DESC = "Retrieve Username account property from the password. The retrieved Username will be used by PingFederate for authentication.";
    private static final String VIRTUAL_USERNAME_PARAM_NAME = "Virtual Username";
    private static final String VIRTUAL_USERNAME_PARAM_DESC = "When dual accounts are enabled, this defines the virtual username which will be passed to CyberArk. The active account credentials will be returned by CyberArk and the retrieved Username will be used by PingFederate for authentication.";
    private static final String SAFE_SECRET_ID_KEY = "Safe";
    private static final String OBJECT_SECRET_ID_KEY = "Object";
    private static final String FOLDER_SECRET_ID_KEY = "Folder";
    private static final String REASON_SECRET_ID_KEY = "Reason";
    private static final String RETRIEVE_USERNAME_SECRET_ID_KEY = "RetrieveUsername";
    private static final String VIRTUAL_USERNAME_SECRET_ID_KEY = "VirtualUserName";
    private static final String VALIDATE_SECRET_REFERENCE_ACTION_NAME = "Validate";
    private static final String VALIDATE_SECRET_REFERENCE_DESC = "Validate secret reference.";
    private static final String SECRETE_REFERENCE_PARAM_NAME = "Secret Reference";
    private static final String SECRETE_REFERENCE_PARAM_DESC = "The secret reference to validate.";
    private static final String SECRET_ID_AND_QUERY_DELIMITER = ";";
    private static final Map<String, String> actionParamNameToSecretIdKey = new HashMap<String, String>();
    private String instanceId;
    private String appId;
    private String connectionPort;
    private String connectionTimeout;
    private String usernameRetrievalPropertyName;

    public void configure(Configuration configuration) {
        this.instanceId = configuration.getId();
        this.appId = configuration.getFieldValue(APP_ID_FIELD_NAME);
        this.connectionPort = configuration.getFieldValue(CONNECTION_PORT_FIELD_NAME);
        this.connectionTimeout = configuration.getFieldValue(CONNECTION_TIMEOUT_FIELD_NAME);
        this.usernameRetrievalPropertyName = configuration.getAdvancedFields().getFieldValue(USERNAME_RETRIEVAL_PROPERTY_NAME_FIELD_NAME);
        if (StringUtils.isBlank((String)this.usernameRetrievalPropertyName)) {
            this.usernameRetrievalPropertyName = USERNAME_RETRIEVAL_PROPERTY_NAME_DEFAULT;
        }
    }

    public PluginDescriptor getPluginDescriptor() {
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor();
        guiDescriptor.setDescription(TYPE_DESC);
        this.buildConfigFieldDescriptors(guiDescriptor);
        this.buildActionDescriptors(guiDescriptor);
        return new SecretManagerDescriptor(TYPE, (Plugin)this, guiDescriptor, VersionUtil.getVersion());
    }

    public SecretInfo getSecretInfo(String secretId, Map<String, Object> inParameters) throws SecretManagerException {
        PasswordRequest passwordRequest = this.buildPasswordRequest(secretId);
        return CyberArkCredentialProviderHelper.getPassword(passwordRequest, this.usernameRetrievalPropertyName);
    }

    private void buildConfigFieldDescriptors(GuiConfigDescriptor guiDescriptor) {
        TextFieldDescriptor appId = new TextFieldDescriptor(APP_ID_FIELD_NAME, APP_ID_FIELD_DESC);
        appId.addValidator((FieldValidator)new RequiredFieldValidator());
        guiDescriptor.addField((FieldDescriptor)appId);
        TextFieldDescriptor connectionPort = new TextFieldDescriptor(CONNECTION_PORT_FIELD_NAME, CONNECTION_PORT_FIELD_DESC);
        connectionPort.setDefaultValue(CONNECTION_PORT_DEFAULT);
        connectionPort.addValidator((FieldValidator)new IntegerValidator(1, 65535));
        guiDescriptor.addField((FieldDescriptor)connectionPort);
        TextFieldDescriptor connectionTimeout = new TextFieldDescriptor(CONNECTION_TIMEOUT_FIELD_NAME, CONNECTION_TIMEOUT_FIELD_DESC);
        connectionTimeout.setDefaultValue(CONNECTION_TIMEOUT_DEFAULT);
        connectionTimeout.addValidator((FieldValidator)new IntegerValidator(1, Integer.MAX_VALUE));
        guiDescriptor.addField((FieldDescriptor)connectionTimeout);
        TextFieldDescriptor usernameRetrievalPropertyName = new TextFieldDescriptor(USERNAME_RETRIEVAL_PROPERTY_NAME_FIELD_NAME, USERNAME_RETRIEVAL_PROPERTY_NAME_FIELD_DESC);
        usernameRetrievalPropertyName.setDefaultValue(USERNAME_RETRIEVAL_PROPERTY_NAME_DEFAULT);
        guiDescriptor.addAdvancedField((FieldDescriptor)usernameRetrievalPropertyName);
    }

    private void buildActionDescriptors(GuiConfigDescriptor guiDescriptor) {
        ActionDescriptor generateSecretReferenceAction = new ActionDescriptor(GENERATE_SECRET_REFERENCE_ACTION_NAME, GENERATE_SECRET_REFERENCE_ACTION_DESC, (ActionDescriptor.Action)new GenerateReferenceAction());
        TextFieldDescriptor safe = new TextFieldDescriptor("Safe", SAFE_PARAM_DESC);
        generateSecretReferenceAction.addParameter((FieldDescriptor)safe);
        TextFieldDescriptor object = new TextFieldDescriptor("Object", OBJECT_PARAM_DESC);
        generateSecretReferenceAction.addParameter((FieldDescriptor)object);
        TextFieldDescriptor folder = new TextFieldDescriptor("Folder", FOLDER_PARAM_DESC);
        generateSecretReferenceAction.addParameter((FieldDescriptor)folder);
        TextFieldDescriptor reason = new TextFieldDescriptor("Reason", REASON_PARAM_DESC);
        generateSecretReferenceAction.addParameter((FieldDescriptor)reason);
        TextFieldDescriptor virtualUsername = new TextFieldDescriptor(VIRTUAL_USERNAME_PARAM_NAME, VIRTUAL_USERNAME_PARAM_DESC);
        generateSecretReferenceAction.addParameter((FieldDescriptor)virtualUsername);
        CheckBoxFieldDescriptor retrieveUsername = new CheckBoxFieldDescriptor(RETRIEVE_USERNAME_PARAM_NAME, RETRIEVE_USERNAME_PARAM_DESC);
        generateSecretReferenceAction.addParameter((FieldDescriptor)retrieveUsername);
        guiDescriptor.addAction(generateSecretReferenceAction);
        ActionDescriptor validateSecretReferenceAction = new ActionDescriptor(VALIDATE_SECRET_REFERENCE_ACTION_NAME, VALIDATE_SECRET_REFERENCE_DESC, (ActionDescriptor.Action)new ValidateReferenceAction());
        TextFieldDescriptor secretReference = new TextFieldDescriptor(SECRETE_REFERENCE_PARAM_NAME, SECRETE_REFERENCE_PARAM_DESC);
        secretReference.addValidator((FieldValidator)new RequiredFieldValidator());
        validateSecretReferenceAction.addParameter((FieldDescriptor)secretReference);
        guiDescriptor.addAction(validateSecretReferenceAction);
    }

    private PasswordRequest buildPasswordRequest(String secretId) throws SecretManagerException {
        try {
            String[] secretIdParts;
            boolean retrieveUsernameAccountProperty = false;
            PSDKPasswordRequest psdkPasswordRequest = new PSDKPasswordRequest();
            psdkPasswordRequest.setAppID(this.appId);
            psdkPasswordRequest.setFailRequestOnPasswordChange(false);
            StringJoiner query = new StringJoiner(SECRET_ID_AND_QUERY_DELIMITER);
            block17: for (String secretIdPart : secretIdParts = secretId.split(SECRET_ID_AND_QUERY_DELIMITER)) {
                String[] secretIdKeyValue = secretIdPart.split("=", 2);
                if (secretIdKeyValue.length != 2) {
                    throw new SecretManagerException(String.format("Invalid secret id '%s'", secretIdPart));
                }
                String key = secretIdKeyValue[0];
                String val = secretIdKeyValue[1];
                switch (key) {
                    case "Reason": {
                        psdkPasswordRequest.setReason(val);
                        continue block17;
                    }
                    case "VirtualUserName": {
                        retrieveUsernameAccountProperty = true;
                        query.add(String.format("%s=%s", key, val));
                        continue block17;
                    }
                    case "Safe": 
                    case "Object": 
                    case "Folder": {
                        query.add(String.format("%s=%s", key, val));
                        continue block17;
                    }
                    case "RetrieveUsername": {
                        retrieveUsernameAccountProperty |= Boolean.parseBoolean(val);
                        continue block17;
                    }
                    default: {
                        throw new SecretManagerException(String.format("Unknown secret id key '%s'.", key));
                    }
                }
            }
            psdkPasswordRequest.setQuery(query.toString());
            if (this.connectionPort != null && !this.connectionPort.equals(CONNECTION_PORT_DEFAULT)) {
                psdkPasswordRequest.setConnectionPort(this.connectionPort);
            }
            if (this.connectionTimeout != null && !this.connectionTimeout.equals(CONNECTION_TIMEOUT_DEFAULT)) {
                psdkPasswordRequest.setConnectionTimeout(this.connectionTimeout);
            }
            return new PasswordRequest(psdkPasswordRequest, retrieveUsernameAccountProperty, this.buildSecretReference(secretId));
        }
        catch (NoClassDefFoundError e) {
            throw new SecretManagerException("CyberArk Credential Provider: Class definition not found: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new SecretManagerException("Error occurred while building password request", (Throwable)e);
        }
    }

    private String buildSecretReference(String secretId) {
        String secretReference = "OBF:MGR:" + this.instanceId;
        if (StringUtils.isNotBlank((String)secretId)) {
            return secretReference + ":" + secretId;
        }
        return secretReference;
    }

    void setAppId(String appId) {
        this.appId = appId;
    }

    void setConnectionPort(String connectionPort) {
        this.connectionPort = connectionPort;
    }

    void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    void setUsernameRetrievalPropertyName(String usernameRetrievalPropertyName) {
        this.usernameRetrievalPropertyName = usernameRetrievalPropertyName;
    }

    static {
        actionParamNameToSecretIdKey.put("Safe", "Safe");
        actionParamNameToSecretIdKey.put("Object", "Object");
        actionParamNameToSecretIdKey.put("Folder", "Folder");
        actionParamNameToSecretIdKey.put("Reason", "Reason");
        actionParamNameToSecretIdKey.put(RETRIEVE_USERNAME_PARAM_NAME, RETRIEVE_USERNAME_SECRET_ID_KEY);
        actionParamNameToSecretIdKey.put(VIRTUAL_USERNAME_PARAM_NAME, VIRTUAL_USERNAME_SECRET_ID_KEY);
    }

    @CyberArkGetPassword
    private class ValidateReferenceAction
    implements ActionDescriptor.Action {
        private ValidateReferenceAction() {
        }

        public String actionInvoked(Configuration configuration) {
            throw new UnsupportedOperationException("This operation is not supported.");
        }

        public String actionInvoked(Configuration configuration, SimpleFieldList actionFieldList) {
            CyberArkCredentialProvider.this.configure(configuration);
            String secretReference = actionFieldList.getFieldValue(CyberArkCredentialProvider.SECRETE_REFERENCE_PARAM_NAME);
            if (!SecretReferenceUtil.isSecretReference((String)secretReference)) {
                return "Secret reference is invalid.";
            }
            String secretManagerId = SecretReferenceUtil.getSecretManagerId((String)secretReference);
            if (!StringUtils.equals((String)configuration.getId(), (String)secretManagerId)) {
                return String.format("Secret manager id '%s' is invalid. Expected '%s'.", secretManagerId, configuration.getId());
            }
            AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.SECRET_MANAGER, (AdminAuditLogger.Event)AdminAuditLogger.Event.VALIDATE_SECRET_REFERENCE, (String)("Validating: " + secretReference));
            try {
                SecretInfo secretInfo = CyberArkCredentialProvider.this.getSecretInfo(SecretReferenceUtil.getSecretId((String)secretReference), Collections.emptyMap());
                AttributeValue username = (AttributeValue)secretInfo.getAttributes().get((Object)"Username");
                if (username != null) {
                    return String.format("Successfully retrieved password and username '%s'.", username.getValue());
                }
                return "Successfully retrieved password.";
            }
            catch (SecretManagerException e) {
                LOG.error((Object)("Error occurred while validating secret reference: " + ExceptionUtil.toStringWithCauses((Throwable)e)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error occurred while validating secret reference", (Throwable)e);
                }
                return e.getMessage();
            }
        }
    }

    @CyberArkGetPassword
    private class GenerateReferenceAction
    implements ActionDescriptor.Action {
        private GenerateReferenceAction() {
        }

        public String actionInvoked(Configuration configuration) {
            throw new UnsupportedOperationException("This operation is not supported.");
        }

        public String actionInvoked(Configuration configuration, SimpleFieldList actionFieldList) {
            CyberArkCredentialProvider.this.configure(configuration);
            StringJoiner secretIdJoiner = new StringJoiner(CyberArkCredentialProvider.SECRET_ID_AND_QUERY_DELIMITER);
            try {
                this.buildQuery(actionFieldList, "Safe").ifPresent(secretIdJoiner::add);
                this.buildQuery(actionFieldList, "Object").ifPresent(secretIdJoiner::add);
                this.buildQuery(actionFieldList, "Folder").ifPresent(secretIdJoiner::add);
                this.buildQuery(actionFieldList, "Reason").ifPresent(secretIdJoiner::add);
                this.buildQuery(actionFieldList, CyberArkCredentialProvider.VIRTUAL_USERNAME_PARAM_NAME).ifPresent(secretIdJoiner::add);
                if (actionFieldList.getBooleanFieldValue(CyberArkCredentialProvider.RETRIEVE_USERNAME_PARAM_NAME)) {
                    this.buildQuery(actionFieldList, CyberArkCredentialProvider.RETRIEVE_USERNAME_PARAM_NAME).ifPresent(secretIdJoiner::add);
                }
            }
            catch (IllegalArgumentException e) {
                return e.getMessage();
            }
            return CyberArkCredentialProvider.this.buildSecretReference(secretIdJoiner.toString());
        }

        private Optional<String> buildQuery(SimpleFieldList actionFieldList, String actionParamName) {
            String actionValue = actionFieldList.getFieldValue(actionParamName);
            if (StringUtils.isBlank((String)actionValue)) {
                return Optional.empty();
            }
            if (actionValue.contains(CyberArkCredentialProvider.SECRET_ID_AND_QUERY_DELIMITER)) {
                throw new IllegalArgumentException(actionParamName + " value should not contain ';'");
            }
            return Optional.of(String.format("%s=%s", actionParamNameToSecretIdKey.get(actionParamName), actionValue));
        }
    }
}

