/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors;

import com.pingidentity.access.ClientAccessor;
import com.pingidentity.access.ConnectionAccessor;
import com.pingidentity.access.ExtendedPropertyAccessor;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ExtendedPropertiesFileDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class ExtendedPropertyAuthnSelector
implements AuthenticationSelector,
AuthnApiPlugin {
    public static final String DESCRIPTION = "This authentication selector allows choosing authentication sources at runtime based on the configured Extended Property.";
    private String extendedPropertyName = null;
    private Set<String> values = null;
    private static final ConnectionAccessor connectionAccessor = new ConnectionAccessor();
    private static final ClientAccessor clientAccessor = new ClientAccessor();
    private static final ExtendedPropertyAccessor extendedPropertyAccessor = new ExtendedPropertyAccessor();
    static final String CASE_SENSITIVE_ENABLED_FIELD_NAME = "Case-Sensitive Matching";
    private static final String CASE_SENSITIVE_ENABLED_DESC = "Allows extended property value matching to be case-sensitive.";
    private static final boolean CASE_SENSITIVE_ENABLED_DEFAULT_VALUE = true;
    private static final String NO_MATCH_RESULT_VALUE = "No Match";
    private static final String NO_MATCH_RESULT_ENABLED_FIELD_NAME = "Enable 'No Match' Result Value";
    private static final String NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION = "By default, selector evaluation fails and the next applicable authentication policy is executed when the extended property value does not match any of the configured selector result values. Select this checkbox to enable an authentication policy branch in this case.";
    private static final boolean NO_MATCH_RESULT_ENABLED_DEFAULT_VALUE = false;
    private boolean caseSensitiveMatchEnabled = true;
    private volatile boolean noMatchResultEnabled = false;
    private static final Log log = LogFactory.getLog(ExtendedPropertyAuthnSelector.class);

    public void configure(Configuration configuration) {
        this.extendedPropertyName = configuration.getFieldValue("Extended Property");
        this.values = new HashSet<String>(configuration.getAdditionalAttrNames());
        this.caseSensitiveMatchEnabled = configuration.getBooleanFieldValue(CASE_SENSITIVE_ENABLED_FIELD_NAME, true);
        this.noMatchResultEnabled = configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME, false);
    }

    public PluginDescriptor getPluginDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.setDescription(DESCRIPTION);
        ExtendedPropertiesFileDescriptor selectFieldDescriptor = new ExtendedPropertiesFileDescriptor("Extended Property", "The Extended Property to evaluate authentication selection.");
        selectFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        guiConfigDescriptor.addField((FieldDescriptor)selectFieldDescriptor);
        CheckBoxFieldDescriptor enableCaseSensitiveField = new CheckBoxFieldDescriptor(CASE_SENSITIVE_ENABLED_FIELD_NAME, CASE_SENSITIVE_ENABLED_DESC);
        enableCaseSensitiveField.setDefaultValue(true);
        enableCaseSensitiveField.setDefaultForLegacyConfig(Boolean.toString(true));
        guiConfigDescriptor.addField((FieldDescriptor)enableCaseSensitiveField);
        CheckBoxFieldDescriptor resultRequestedContextDoesNotMatch = new CheckBoxFieldDescriptor(NO_MATCH_RESULT_ENABLED_FIELD_NAME, NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION);
        resultRequestedContextDoesNotMatch.setDefaultValue(false);
        resultRequestedContextDoesNotMatch.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)resultRequestedContextDoesNotMatch);
        ExtendedPropertyAuthnSelectorDescriptor authSelectorDescriptor = new ExtendedPropertyAuthnSelectorDescriptor("Extended Property Authentication Selector", (ConfigurablePlugin)this, guiConfigDescriptor, null);
        authSelectorDescriptor.setSupportsExtendedResults(true);
        authSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        guiConfigDescriptor.addValidator((ConfigurationValidator)new ExtendedPropertyAuthnSelectorConfigurationValidator());
        return authSelectorDescriptor;
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse resp, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        boolean propertyFound = false;
        if (extraParameters.containsKey("com.pingidentity.sdk.AdapterSelector.entityid")) {
            String entityId = extraParameters.get("com.pingidentity.sdk.AdapterSelector.entityid").toString();
            Map extProperties = connectionAccessor.getSpConnectionExtendedPropertyValues(entityId);
            this.populateContextResult(context, extProperties);
            propertyFound = true;
        } else if (extraParameters.containsKey("com.pingidentity.sdk.AdapterSelector.clientid") && extraParameters.get("com.pingidentity.sdk.AdapterSelector.clientid") != null) {
            String clientId = extraParameters.get("com.pingidentity.sdk.AdapterSelector.clientid").toString();
            Map extProperties = clientAccessor.getExtendedPropertyValues(clientId);
            this.populateContextResult(context, extProperties);
            propertyFound = true;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No entity Id or client Id found in Authentication parameters.");
        }
        if (context.getResult() == null && propertyFound) {
            if (this.noMatchResultEnabled) {
                context.setResult(this.getNoMatchResult());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"No matching extended properties values found.");
            }
        }
        return context;
    }

    private String getNoMatchResult() {
        if (this.noMatchResultEnabled) {
            return NO_MATCH_RESULT_VALUE;
        }
        return null;
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private void populateContextResult(AuthenticationSelectorContext context, Map<String, List<String>> extProperties) {
        if (extProperties.containsKey(this.extendedPropertyName)) {
            List<String> configuredValues = extProperties.get(this.extendedPropertyName);
            for (String configuredValue : configuredValues) {
                if (this.caseSensitiveMatchEnabled) {
                    if (!this.values.contains(configuredValue)) continue;
                    context.setResult(configuredValue);
                    return;
                }
                for (String selectorResult : this.values) {
                    if (!selectorResult.equalsIgnoreCase(configuredValue)) continue;
                    context.setResult(selectorResult);
                    return;
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No value found for extended property '" + LogGuard.encode((String)this.extendedPropertyName) + "'."));
        }
    }

    public void callback(HttpServletRequest req, HttpServletResponse resp, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    private static class ExtendedPropertyAuthnSelectorDescriptor
    extends AuthenticationSelectorDescriptor {
        public ExtendedPropertyAuthnSelectorDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptor guiConfigDesc, Set<String> results) {
            super(type, plugin, guiConfigDesc, results);
        }

        public List<String> getAdditionalResults(Configuration configuration) {
            ArrayList<String> results = new ArrayList<String>();
            if (configuration.getBooleanFieldValue(ExtendedPropertyAuthnSelector.NO_MATCH_RESULT_ENABLED_FIELD_NAME)) {
                results.add(ExtendedPropertyAuthnSelector.NO_MATCH_RESULT_VALUE);
            }
            return results;
        }

        public boolean isSortConfigurationAttributes(Configuration configuration) {
            return true;
        }
    }

    private static class ExtendedPropertyAuthnSelectorConfigurationValidator
    implements ConfigurationValidator {
        private static final String VALIDATION_ERROR_MESSAGE_NON_EXISTENT_ENTRY = "Invalid Extended Property name.";
        private static final String VALIDATION_ERROR_NO_MATCH_RESERVED = "'No Match' is a reserved result value. Please remove the problematic result value or disable the option.";

        ExtendedPropertyAuthnSelectorConfigurationValidator() {
        }

        public void validate(Configuration configuration) throws ValidationException {
            if (configuration == null) {
                return;
            }
            ArrayList<String> errors = new ArrayList<String>();
            this.checkForPropertyExistence(configuration);
            boolean noMatchEnabled = configuration.getBooleanFieldValue(ExtendedPropertyAuthnSelector.NO_MATCH_RESULT_ENABLED_FIELD_NAME);
            if (noMatchEnabled && configuration.getAdditionalAttrNames().stream().anyMatch(result -> ExtendedPropertyAuthnSelector.NO_MATCH_RESULT_VALUE.equalsIgnoreCase((String)result))) {
                errors.add(VALIDATION_ERROR_NO_MATCH_RESERVED);
            }
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }

        private void checkForPropertyExistence(Configuration configuration) throws ValidationException {
            String value = configuration.getFieldValue("Extended Property");
            Map definitions = extendedPropertyAccessor.getExtendedPropertyDefinitions();
            if (definitions == null || !definitions.containsKey(value)) {
                throw new ValidationException(VALIDATION_ERROR_MESSAGE_NON_EXISTENT_ENTRY);
            }
        }
    }
}

