/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.http;

import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class HTTPHeaderAdapterSelector
implements AuthenticationSelector,
AuthnApiPlugin {
    private final Log log = LogFactory.getLog(HTTPHeaderAdapterSelector.class);
    private final AuthenticationSelectorDescriptor authnSelectorDescriptor;
    private String headerName = null;
    List<String> expressions = new ArrayList<String>();
    private boolean enableCaseSensitiveMatch = true;
    public static final String RESULT_YES = "Yes";
    public static final String RESULT_NO = "No";
    protected static final String RESULTS_TABLE_NAME = "Results";
    protected static final String MATCH_EXPR_FIELD_NAME = "Match Expression";
    protected static final String HTTP_HEADER_NAME_FIELD_NAME = "Header Name";
    private static final String FIELD_ENABLE_CASESENSITIVE = "Case-Sensitive Matching";
    private static final String DESCRIPTION = "This authentication selector provides a means of choosing authentication sources at runtime based on HTTP headers.";
    private static final String DESC_ENABLE_CASESENSITIVE = "Allows case-sensitive expression matching to HTTP header.";
    private static final boolean DEFAULT_VALUE_ENABLE_CASESENSITIVE = true;
    private static final String INVALID_HTTP_HEADER_NAME_CHARS = "( ) < > @ , ; : \\ \" / [ ] ? = { } space tab";
    private static final String SEPARATORS = "\\(\\)\\<\\>@,;:\\\\\"/\\[\\]\\?=\\{\\}";
    private static final String SP = "\\u0020";
    private static final String CTL = "\\u0000-\\u001F\\u007F";
    private static final String INVALID_HTTP_HEADER_NAME_CHARS_REGEX = String.format(".*[%s%s%s]+.*", "\\(\\)\\<\\>@,;:\\\\\"/\\[\\]\\?=\\{\\}", "\\u0020", "\\u0000-\\u001F\\u007F");

    public HTTPHeaderAdapterSelector() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.setDescription(DESCRIPTION);
        TableDescriptor matchesTable = new TableDescriptor(RESULTS_TABLE_NAME, "A table of expressions to match against the values for the given header name.  If any expression matches, the result value is Yes.");
        TextFieldDescriptor matchExpressionField = new TextFieldDescriptor(MATCH_EXPR_FIELD_NAME, "The expression matched against the specified header.");
        matchExpressionField.addValidator((FieldValidator)new RequiredFieldValidator());
        matchExpressionField.addValidator(new FieldValidator(){
            private static final long serialVersionUID = 1L;

            public void validate(Field field) throws ValidationException {
                try {
                    Util.wildCardMatch((String)"", (String)field.getValue(), (boolean)true);
                }
                catch (PatternSyntaxException ex) {
                    throw new ValidationException("Invalid match expression " + field.getValue());
                }
            }
        });
        TextFieldDescriptor headerNameField = new TextFieldDescriptor(HTTP_HEADER_NAME_FIELD_NAME, "HTTP header to inspect for a match.");
        headerNameField.addValidator((FieldValidator)new RequiredFieldValidator());
        headerNameField.addValidator(new FieldValidator(){
            private static final long serialVersionUID = 1L;

            public void validate(Field field) throws ValidationException {
                try {
                    Pattern pattern = Pattern.compile(INVALID_HTTP_HEADER_NAME_CHARS_REGEX);
                    Matcher matcher = pattern.matcher(field.getValue());
                    if (matcher.matches()) {
                        throw new ValidationException("HTTP header name field contains one or more invalid characters.  Invalid characters are ( ) < > @ , ; : \\ \" / [ ] ? = { } space tab");
                    }
                }
                catch (PatternSyntaxException ex) {
                    throw new ValidationException("Invalid regular expression " + INVALID_HTTP_HEADER_NAME_CHARS_REGEX);
                }
            }
        });
        matchesTable.addRowField((FieldDescriptor)matchExpressionField);
        guiConfigDescriptor.addTable(matchesTable);
        guiConfigDescriptor.addField((FieldDescriptor)headerNameField);
        CheckBoxFieldDescriptor enableCaseSensitiveField = new CheckBoxFieldDescriptor(FIELD_ENABLE_CASESENSITIVE, DESC_ENABLE_CASESENSITIVE);
        enableCaseSensitiveField.setDefaultValue(true);
        enableCaseSensitiveField.setDefaultForLegacyConfig(Boolean.toString(true));
        guiConfigDescriptor.addField((FieldDescriptor)enableCaseSensitiveField);
        guiConfigDescriptor.addValidator(new ConfigurationValidator(){

            public void validate(Configuration configuration) throws ValidationException {
                List rows;
                Table table = configuration.getTable(HTTPHeaderAdapterSelector.RESULTS_TABLE_NAME);
                boolean caseSensitiveMatch = true;
                Field caseSensitiveField = configuration.getField(HTTPHeaderAdapterSelector.FIELD_ENABLE_CASESENSITIVE);
                if (caseSensitiveField != null) {
                    caseSensitiveMatch = caseSensitiveField.getValueAsBoolean();
                }
                if ((rows = table.getRows()).isEmpty()) {
                    throw new ValidationException("Please add at least one match expression to the 'Results' table.");
                }
                ArrayList<CallSite> errors = new ArrayList<CallSite>();
                HashSet<String> expressions = new HashSet<String>();
                for (Row row : rows) {
                    String expression = row.getFieldValue(HTTPHeaderAdapterSelector.MATCH_EXPR_FIELD_NAME);
                    if (!caseSensitiveMatch) {
                        expression = expression.toLowerCase();
                    }
                    if (expressions.add(expression)) continue;
                    errors.add((CallSite)((Object)("Duplicate expression: '" + row.getFieldValue(HTTPHeaderAdapterSelector.MATCH_EXPR_FIELD_NAME) + "'.")));
                }
                if (!errors.isEmpty()) {
                    throw new ValidationException(errors);
                }
            }
        });
        HashSet<String> results = new HashSet<String>();
        results.add(RESULT_YES);
        results.add(RESULT_NO);
        this.authnSelectorDescriptor = new AuthenticationSelectorDescriptor("HTTP Header Authentication Selector", (ConfigurablePlugin)this, guiConfigDescriptor, results, this.getVersion());
        this.authnSelectorDescriptor.setSupportsExtendedResults(false);
        this.authnSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        Field caseSensitiveField;
        this.headerName = configuration.getFieldValue(HTTP_HEADER_NAME_FIELD_NAME);
        Table matchTable = configuration.getTable(RESULTS_TABLE_NAME);
        if (matchTable != null && matchTable.getRows() != null) {
            for (Row matchRow : matchTable.getRows()) {
                String expr = matchRow.getFieldValue(MATCH_EXPR_FIELD_NAME);
                if (!StringUtils.isNotEmpty((String)expr)) continue;
                this.expressions.add(expr);
            }
        }
        if ((caseSensitiveField = configuration.getField(FIELD_ENABLE_CASESENSITIVE)) != null) {
            this.enableCaseSensitiveMatch = caseSensitiveField.getValueAsBoolean();
        }
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.authnSelectorDescriptor;
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse res, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        context.setResult(RESULT_NO);
        Enumeration headerValuesEnumeration = req.getHeaders(this.headerName);
        ArrayList<String> headerValuesCollection = Collections.list(headerValuesEnumeration);
        if (Util.isEmpty(headerValuesCollection)) {
            this.log.debug((Object)("HTTP header " + this.headerName + " does not exist."));
            return context;
        }
        for (String expression : this.expressions) {
            for (String headerValue : headerValuesCollection) {
                boolean match = Util.wildCardMatch((String)headerValue, (String)expression, (boolean)this.enableCaseSensitiveMatch);
                if (match) {
                    this.log.debug((Object)(expression + " matches " + headerValue + "."));
                    context.setResult(RESULT_YES);
                    return context;
                }
                this.log.debug((Object)(expression + " does not match " + headerValue + "."));
            }
        }
        return context;
    }

    public void callback(HttpServletRequest req, HttpServletResponse res, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    String getVersion() {
        return VersionUtil.getVersion();
    }
}

