/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.oauthclient;

import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.OAuthClientSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthClientAdapterSelector
implements AuthenticationSelector,
GuiConfigDescriptorBuilder,
AuthnApiPlugin {
    private final Log log = LogFactory.getLog(OAuthClientAdapterSelector.class);
    private static final String YES_RESULT = "Yes";
    private static final String NO_RESULT = "No";
    private static final String SELECTOR_DESCRIPTOR_NAME = "OAuth Client Set Authentication Selector";
    private static final String SELECTOR_DESCRIPTION = "This authentication selector chooses authentication sources at runtime based on a match found between the client ID used in the OAuth request and clients configured in the system.";
    private static final String CLIENTS_TABLE_NAME = "Clients";
    private static final String CLIENTS_TABLE_DESC = "A table of clients";
    private static final String CLIENT_ID_FIELD_NAME = "Client ID";
    private static final String CLIENT_ID_FIELD_DESC = "Select from the list of client IDs";
    private final AuthenticationSelectorDescriptor authenticationSelectorDescriptor;
    private final Set<String> selectedClientSet = new LinkedHashSet<String>();

    public OAuthClientAdapterSelector() {
        this.authenticationSelectorDescriptor = new AuthenticationSelectorDescriptor(SELECTOR_DESCRIPTOR_NAME, (ConfigurablePlugin)this, (GuiConfigDescriptorBuilder)this, new HashSet<String>(Arrays.asList(YES_RESULT, NO_RESULT)), VersionUtil.getVersion());
        this.authenticationSelectorDescriptor.setSupportsExtendedResults(false);
        this.authenticationSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse resp, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        context.setResult(NO_RESULT);
        if (extraParameters.get("com.pingidentity.sdk.AdapterSelector.clientid") != null && this.selectedClientSet.contains(extraParameters.get("com.pingidentity.sdk.AdapterSelector.clientid").toString())) {
            this.log.debug((Object)("Found client id: " + extraParameters.get("com.pingidentity.sdk.AdapterSelector.clientid").toString()));
            context.setResult(YES_RESULT);
        }
        return context;
    }

    public void callback(HttpServletRequest req, HttpServletResponse resp, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    public void configure(Configuration configuration) {
        Table clientTable = configuration.getTable(CLIENTS_TABLE_NAME);
        clientTable.getRows().forEach(row -> this.selectedClientSet.add(row.getFieldValue(CLIENT_ID_FIELD_NAME)));
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.authenticationSelectorDescriptor;
    }

    public GuiConfigDescriptor buildNewGuiDescriptor() {
        return this.buildGuiDescriptor();
    }

    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
        return this.buildGuiDescriptor();
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private GuiConfigDescriptor buildGuiDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.addValidator((ConfigurationValidator)new OAuthClientAdapterSelectorConfigurationValidator());
        guiConfigDescriptor.addTable(this.buildTableDescriptor());
        guiConfigDescriptor.setDescription(SELECTOR_DESCRIPTION);
        return guiConfigDescriptor;
    }

    private TableDescriptor buildTableDescriptor() {
        TableDescriptor tableDescriptor = new TableDescriptor(CLIENTS_TABLE_NAME, CLIENTS_TABLE_DESC);
        OAuthClientSelectionFieldDescriptor filterableSelectionFieldDescriptor = new OAuthClientSelectionFieldDescriptor(CLIENT_ID_FIELD_NAME, CLIENT_ID_FIELD_DESC, Arrays.asList(OAuthClientSelectionFieldDescriptor.GrantType.AUTHORIZATION_CODE, OAuthClientSelectionFieldDescriptor.GrantType.IMPLICIT, OAuthClientSelectionFieldDescriptor.GrantType.DEVICE_CODE));
        filterableSelectionFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        filterableSelectionFieldDescriptor.addValidator((FieldValidator)new FilterableSelectionFieldDescriptor.FilterableSelectionFieldDefaultValidator((FilterableSelectionFieldDescriptor)filterableSelectionFieldDescriptor));
        tableDescriptor.addRowField((FieldDescriptor)filterableSelectionFieldDescriptor);
        return tableDescriptor;
    }

    private static class OAuthClientAdapterSelectorConfigurationValidator
    implements ConfigurationValidator {
        private static final String VALIDATION_ERROR_MESSAGE_AT_LEASE_ONE_ENTRY = "Please add at least one client to the 'Clients' table.";
        private static final String VALIDATION_ERROR_MESSAGE_DUPLICATE_ENTRY = "Duplicate client: %s.";
        private static final String VALIDATION_ERROR_MESSAGE_NON_EXISTENT_ENTRY = "Client '%s' no longer exists. Please remove it from the 'Clients' table.";

        OAuthClientAdapterSelectorConfigurationValidator() {
        }

        public void validate(Configuration configuration) throws ValidationException {
            ArrayList<String> errors = new ArrayList<String>();
            this.assertAtLeastOneConfiguredClient(configuration);
            this.checkForConfiguredConnectionExistence(configuration, errors);
            this.checkForDuplicateConfiguredClient(configuration, errors);
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }

        private void assertAtLeastOneConfiguredClient(Configuration configuration) throws ValidationException {
            Table table = configuration.getTable(OAuthClientAdapterSelector.CLIENTS_TABLE_NAME);
            if (table.getRows().isEmpty()) {
                throw new ValidationException(VALIDATION_ERROR_MESSAGE_AT_LEASE_ONE_ENTRY);
            }
        }

        private void checkForConfiguredConnectionExistence(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(OAuthClientAdapterSelector.CLIENTS_TABLE_NAME);
            List clientIds = table.getRows().stream().map(row -> row.getFieldValue(OAuthClientAdapterSelector.CLIENT_ID_FIELD_NAME)).collect(Collectors.toCollection(ArrayList::new));
            Collection validClients = MgmtFactory.getClientManager().getValidClients(clientIds);
            if (validClients.size() != clientIds.size()) {
                clientIds.forEach(clientId -> {
                    if (!validClients.contains(clientId)) {
                        errors.add(String.format(VALIDATION_ERROR_MESSAGE_NON_EXISTENT_ENTRY, clientId));
                    }
                });
            }
        }

        private void checkForDuplicateConfiguredClient(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(OAuthClientAdapterSelector.CLIENTS_TABLE_NAME);
            HashSet clients = new HashSet();
            table.getRows().forEach(row -> {
                String clientId = row.getFieldValue(OAuthClientAdapterSelector.CLIENT_ID_FIELD_NAME);
                if (!clients.add(clientId)) {
                    errors.add(String.format(VALIDATION_ERROR_MESSAGE_DUPLICATE_ENTRY, MgmtFactory.getClientManager().getClient(clientId).getName()));
                }
            });
        }
    }
}

