/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.oauthscope;

import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.oauth20.domain.ScopeManager;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.OAuthScopeSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthScopeAdapterSelector
implements AuthenticationSelector,
GuiConfigDescriptorBuilder,
AuthnApiPlugin {
    private static final Log LOG = LogFactory.getLog(OAuthScopeAdapterSelector.class);
    private static final String SELECTOR_NAME = "OAuth Scope Authentication Selector";
    private static final String DESCRIPTION = "This authentication selector provides a means of choosing authentication sources at runtime based on the OAuth scope request received by the Authorization Endpoint. Select all scopes required to trigger a \"Yes\" result from this selector. Create multiple instances to handle boolean 'OR' cases.";
    private static final String SCOPE_CLEANUP_DESCRIPTION = "This OAuth scope is no longer provided by the OAuth Authorization Server. Uncheck this scope and re-save this authentication selector or re-add it to the authorization server.";
    private static final String SCOPES_TABLE_NAME = "Scopes";
    private static final String SCOPES_TABLE_DESC = "A table of scopes";
    private static final String SCOPE_TABLE_FIELD_NAME = "Scope";
    private static final String SCOPE_TABLE_FIELD_DESC = "Select from the list of scopes according to their scope type";
    private static final String RESULT_YES = "Yes";
    private static final String RESULT_NO = "No";
    private static final String IN_SCOPE_DELIM = " ";
    private static final String GROUP_SUFFIX = " (Group)";
    private Set<String> requiredScopes = new HashSet<String>();
    private final ScopeManager scopeManager = MgmtFactory.getScopeManager();

    private void validateOneScopeSelected(Configuration configuration) throws ValidationException {
        Table scopesTable = configuration.getTable(SCOPES_TABLE_NAME);
        boolean aScopeChecked = scopesTable != null && CollectionUtils.isNotEmpty((Collection)scopesTable.getRows()) ? true : configuration.getFields().stream().anyMatch(Field::getValueAsBoolean);
        if (!aScopeChecked) {
            throw new ValidationException("Please choose at least one valid scope.");
        }
    }

    private void validatedNoInvalidScopes(Configuration configuration, Set<String> invalidScopes, Set<String> tableScopes) throws ValidationException {
        HashSet<String> selectedInvalidScopes = new HashSet<String>();
        for (String invalidScope : invalidScopes) {
            if (!configuration.getBooleanFieldValue(invalidScope) && !tableScopes.contains(invalidScope)) continue;
            selectedInvalidScopes.add(invalidScope);
        }
        if (!selectedInvalidScopes.isEmpty()) {
            String errorMessage = "The OAuth Authorization Server doesn't support the following scopes: " + selectedInvalidScopes.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(", ")) + ". Please remove these configured scopes before saving.";
            throw new ValidationException(errorMessage);
        }
    }

    private void validateNoDuplicates(Configuration configuration, Set<String> tableScopes) throws ValidationException {
        HashSet duplicateScopes = new HashSet();
        configuration.getFields().forEach(field -> {
            if (tableScopes.contains(field.getName()) && field.getValueAsBoolean()) {
                duplicateScopes.add(field.getName());
            }
        });
        if (!tableScopes.isEmpty()) {
            HashSet scopesSeenInTable = new HashSet();
            Table scopesTable = configuration.getTable(SCOPES_TABLE_NAME);
            scopesTable.getRows().forEach(row -> {
                String scopeName = OAuthScopeSelectionFieldDescriptor.storageKeyToScopeName((String)row.getFieldValue(SCOPE_TABLE_FIELD_NAME));
                if (!scopesSeenInTable.add(scopeName)) {
                    duplicateScopes.add(scopeName);
                }
            });
        }
        if (!duplicateScopes.isEmpty()) {
            String errorMessage = "Duplicate scopes configured: " + duplicateScopes.stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(", ")) + ". Please remove these configured scopes before saving.";
            throw new ValidationException(errorMessage);
        }
    }

    public void configure(Configuration configuration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"loading configuration");
        }
        HashMap<String, String> requiredScopeDescriptions = new HashMap<String, String>();
        this.categorizeScopes(configuration, requiredScopeDescriptions, null, null);
        this.requiredScopes = requiredScopeDescriptions.keySet();
    }

    public PluginDescriptor getPluginDescriptor() {
        HashSet<String> results = new HashSet<String>();
        results.add(RESULT_YES);
        results.add(RESULT_NO);
        AuthenticationSelectorDescriptor authnSelectorDescriptor = new AuthenticationSelectorDescriptor(SELECTOR_NAME, (ConfigurablePlugin)this, (GuiConfigDescriptorBuilder)this, results, VersionUtil.getVersion());
        authnSelectorDescriptor.setSupportsExtendedContract(false);
        authnSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        return authnSelectorDescriptor;
    }

    public void callback(HttpServletRequest req, HttpServletResponse resp, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse resp, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        String reqScope;
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        context.setResult(RESULT_NO);
        if (this.requiredScopes.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"This OAuth Scope authentication selector doesn't have any required scopes. Returning a false context.");
            }
            return context;
        }
        String string = reqScope = extraParameters.containsKey("com.pingidentity.sdk.AdapterSelector.scope") ? (String)extraParameters.get("com.pingidentity.sdk.AdapterSelector.scope") : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Requested scopes: " + reqScope));
            LOG.debug((Object)("Required scopes: " + this.requiredScopes.toString()));
        }
        if (reqScope != null) {
            boolean bl;
            HashSet<String> inScopes = new HashSet<String>();
            for (String inScope : reqScope.split(IN_SCOPE_DELIM)) {
                if (inScope.isEmpty()) continue;
                inScopes.add(inScope);
            }
            if (!inScopes.isEmpty()) {
                context.setResult(RESULT_YES);
            }
            Set dynamicCommonScopes = this.scopeManager.getDynamicCommonScopes();
            Set requiredDynamicScopes = this.scopeManager.getDynamicCommonScopes();
            requiredDynamicScopes.retainAll(this.requiredScopes);
            HashSet<String> requiredStaticScopes = new HashSet<String>(this.requiredScopes);
            requiredStaticScopes.removeAll(dynamicCommonScopes);
            HashSet notStaticallyMatchedScopes = new HashSet(inScopes);
            notStaticallyMatchedScopes.removeAll(requiredStaticScopes);
            for (String string2 : inScopes) {
                if (!requiredStaticScopes.remove(string2) || !LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("Static scope '%s' requirement: satisfied.", string2));
            }
            Set staticCommonScopes = this.scopeManager.getScopeDescriptions().keySet().stream().filter(commonScope -> !dynamicCommonScopes.contains(commonScope)).collect(Collectors.toSet());
            for (String staticCommonScope : staticCommonScopes) {
                if (!notStaticallyMatchedScopes.remove(staticCommonScope) || !LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("Requested scope '%s' is best-matched to its corresponding static scope.", staticCommonScope));
            }
            for (String concreteScope : notStaticallyMatchedScopes) {
                String bestMatch = ScopeUtil.DynamicScope.getBestMatchingDynamicScopeValue((Set)dynamicCommonScopes, (String)concreteScope);
                if (!StringUtils.isBlank((String)bestMatch)) {
                    boolean requirementSatisfied = requiredDynamicScopes.remove(bestMatch);
                    if (!LOG.isDebugEnabled()) continue;
                    if (requirementSatisfied) {
                        LOG.debug((Object)String.format("Dynamic scope '%s' requirement: satisfied by requested scope '%s'.", bestMatch, concreteScope));
                        continue;
                    }
                    LOG.debug((Object)String.format("Requested scope '%s' is best-matched to dynamic scope '%s'.", concreteScope, bestMatch));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("Requested scope '%s' is not recognized.", concreteScope));
            }
            boolean bl2 = bl = requiredDynamicScopes.isEmpty() && requiredStaticScopes.isEmpty();
            if (!bl) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Scope requirement not met: " + String.join((CharSequence)",", this.requiredScopes)));
                }
                context.setResult(RESULT_NO);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning context: " + context.getResult()));
        }
        return context;
    }

    public GuiConfigDescriptor buildNewGuiDescriptor() {
        return this.buildConfiguredGuiDescriptor(null);
    }

    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor();
        guiDescriptor.setDescription(DESCRIPTION);
        TableDescriptor scopesTableDescriptor = new TableDescriptor(SCOPES_TABLE_NAME, SCOPES_TABLE_DESC);
        OAuthScopeSelectionFieldDescriptor scopeFilterableSelectionDescriptor = new OAuthScopeSelectionFieldDescriptor(SCOPE_TABLE_FIELD_NAME, SCOPE_TABLE_FIELD_DESC);
        scopeFilterableSelectionDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        scopeFilterableSelectionDescriptor.addValidator((FieldValidator)new FilterableSelectionFieldDescriptor.FilterableSelectionFieldDefaultValidator((FilterableSelectionFieldDescriptor)scopeFilterableSelectionDescriptor));
        scopesTableDescriptor.addRowField((FieldDescriptor)scopeFilterableSelectionDescriptor);
        guiDescriptor.addTable(scopesTableDescriptor);
        HashMap<String, String> requiredScopeDescriptions = new HashMap<String, String>();
        HashMap<String, String> optionalScopeDescriptions = new HashMap<String, String>();
        HashSet<String> invalidScopes = new HashSet<String>();
        this.categorizeScopes(configuration, requiredScopeDescriptions, optionalScopeDescriptions, invalidScopes);
        TreeMap<String, String> scopeFields = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        scopeFields.putAll(requiredScopeDescriptions);
        for (String string : invalidScopes) {
            if (!scopeFields.containsKey(string)) continue;
            scopeFields.put(string, SCOPE_CLEANUP_DESCRIPTION);
        }
        HashSet scopesConfiguredAsFields = new HashSet();
        if (configuration != null && CollectionUtils.isNotEmpty((Collection)configuration.getFields())) {
            configuration.getFields().forEach(field -> {
                if (field.getValueAsBoolean()) {
                    scopesConfiguredAsFields.add(field.getName());
                }
            });
        }
        scopeFields.putAll(optionalScopeDescriptions);
        for (Map.Entry entry : scopeFields.entrySet()) {
            CheckBoxFieldDescriptor scopeCheck = new CheckBoxFieldDescriptor((String)entry.getKey(), (String)entry.getValue());
            if (!scopesConfiguredAsFields.contains(entry.getKey())) {
                scopeCheck.setHidden(true);
            }
            guiDescriptor.addField((FieldDescriptor)scopeCheck);
        }
        OAuthScopeConfigValidator oAuthScopeConfigValidator = new OAuthScopeConfigValidator(this.getScopeDescriptions(), invalidScopes);
        guiDescriptor.addValidator((ConfigurationValidator)oAuthScopeConfigValidator);
        return guiDescriptor;
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private void categorizeScopes(Configuration configuration, Map<String, String> requiredScopes, Map<String, String> optionalScopes, Set<String> invalidScopes) {
        requiredScopes.clear();
        HashSet invalidTableScopes = new HashSet();
        HashSet invalidFieldScopes = new HashSet();
        if (configuration != null) {
            Table scopesTable = configuration.getTable(SCOPES_TABLE_NAME);
            if (scopesTable != null) {
                scopesTable.getRows().forEach(row -> invalidTableScopes.add(OAuthScopeSelectionFieldDescriptor.storageKeyToScopeName((String)row.getFieldValue(SCOPE_TABLE_FIELD_NAME))));
            }
            if (CollectionUtils.isNotEmpty((Collection)configuration.getFields())) {
                configuration.getFields().forEach(field -> {
                    if (field.getValueAsBoolean()) {
                        invalidFieldScopes.add(field.getName());
                    }
                });
            }
        }
        HashMap<String, String> notConfiguredScopes = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getScopeDescriptions().entrySet()) {
            String scope = entry.getKey();
            if (invalidFieldScopes.contains(scope)) {
                Field scopeCheck = configuration.getField(scope);
                if (scopeCheck.getValueAsBoolean()) {
                    requiredScopes.put(scope, entry.getValue());
                } else {
                    notConfiguredScopes.put(scope, entry.getValue());
                }
                invalidFieldScopes.remove(scope);
                continue;
            }
            if (invalidTableScopes.contains(scope)) {
                requiredScopes.put(scope, entry.getValue());
                invalidTableScopes.remove(scope);
                continue;
            }
            notConfiguredScopes.put(scope, entry.getValue());
        }
        if (invalidScopes != null) {
            invalidScopes.clear();
            invalidScopes.addAll(invalidFieldScopes);
            invalidScopes.addAll(invalidTableScopes);
        }
        if (optionalScopes != null) {
            optionalScopes.clear();
            optionalScopes.putAll(notConfiguredScopes);
        }
    }

    private Map<String, String> getScopeDescriptions() {
        TreeMap<String, String> scopeAndGroupDescriptions = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        scopeAndGroupDescriptions.putAll(this.scopeManager.getScopeDescriptions());
        for (Map.Entry entry : this.scopeManager.getScopeGroupDescriptions().entrySet()) {
            scopeAndGroupDescriptions.put((String)entry.getKey(), (String)entry.getValue() + GROUP_SUFFIX);
        }
        scopeAndGroupDescriptions.putAll(this.scopeManager.getExclusiveScopeDescriptions());
        for (Map.Entry entry : this.scopeManager.getExclusiveScopeGroupDescriptions().entrySet()) {
            scopeAndGroupDescriptions.put((String)entry.getKey(), (String)entry.getValue() + GROUP_SUFFIX);
        }
        return scopeAndGroupDescriptions;
    }

    private class OAuthScopeConfigValidator
    implements ConfigurationValidator {
        private final Map<String, String> availableScopes;
        private final Set<String> invalidScopes;

        public OAuthScopeConfigValidator(Map<String, String> availableScopes, Set<String> invalidScopes) {
            this.availableScopes = availableScopes;
            this.invalidScopes = invalidScopes;
        }

        public void validate(Configuration configuration) throws ValidationException {
            if (this.availableScopes.isEmpty()) {
                throw new ValidationException("The OAuth Authorization Server doesn't have any scopes configured. Add at least one scope to the Authorization Server in order to use this authentication selector.");
            }
            Set<String> tableScopes = new HashSet<String>();
            Table scopesTable = configuration.getTable(OAuthScopeAdapterSelector.SCOPES_TABLE_NAME);
            if (scopesTable != null && CollectionUtils.isNotEmpty((Collection)scopesTable.getRows())) {
                tableScopes = scopesTable.getRows().stream().map(row -> OAuthScopeSelectionFieldDescriptor.storageKeyToScopeName((String)row.getFieldValue(OAuthScopeAdapterSelector.SCOPE_TABLE_FIELD_NAME))).collect(Collectors.toSet());
            }
            OAuthScopeAdapterSelector.this.validateOneScopeSelected(configuration);
            OAuthScopeAdapterSelector.this.validatedNoInvalidScopes(configuration, this.invalidScopes, tableScopes);
            OAuthScopeAdapterSelector.this.validateNoDuplicates(configuration, tableScopes);
        }
    }
}

