/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.saml;

import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AdvancedAuthnPolicy;
import org.sourceid.saml20.protocol.AssertionMapKeys;

public class SamlAuthnContextAdapterSelector
implements AuthenticationSelector,
AuthnApiPlugin {
    Log log = LogFactory.getLog(SamlAuthnContextAdapterSelector.class);
    AuthenticationSelectorDescriptor authnSelectorDescriptor;
    Set<String> authnContexts = new HashSet<String>();
    boolean updateAttribute = false;
    boolean overrideAttribute = false;
    private volatile boolean notInRequestResultEnabled = false;
    private volatile boolean noMatchResultEnabled = false;
    private static String UPDATE_ATTR_CHECKBOX_NAME = "Add or Update AuthN Context Attribute";
    private static String UPDATE_ATTR_CHECKBOX_DESCRIPTION = "Indicates (when specified) if the AuthN Context attribute value will be updated with the authentication selector result value.";
    private static String DESCRIPTION = "This authentication selector selects an authentication source based on the authentication context requested by an SP, for SP-initiated SSO or through OpenID Connect.  SAML-specified contexts, or any ad-hoc context agreed upon between the IdP and SP partners, are specified on the Selector Result Values screen.";
    private static String OVERRIDE_AUTHN_CONTEXT_FIELD_NAME = "Override AuthN Context for Flow";
    private static String OVERRIDE_AUTHN_CONTEXT_FIELD_DESCRIPTION = "Indicates if the AuthN Context value for the entire policy flow should be overridden with the authentication selector result value.";
    private static String NOT_IN_REQUEST_RESULT_VALUE = "Not in Request";
    private static String NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME = "Enable '" + NOT_IN_REQUEST_RESULT_VALUE + "' Result Value";
    private static String NOT_IN_REQUEST_RESULT_ENABLED_FIELD_DESCRIPTION = "By default, selector evaluation fails and the next applicable authentication policy is executed if no requested authentication context is found. Select this checkbox to enable a policy branch in this case.";
    private static String NO_MATCH_RESULT_VALUE = "No Match";
    private static String NO_MATCH_RESULT_ENABLED_FIELD_NAME = "Enable '" + NO_MATCH_RESULT_VALUE + "' Result Value";
    private static String NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION = "By default, selector evaluation fails and the next applicable authentication policy is executed if the requested authentication context does not match any of the configured selector result values. Select this checkbox to enable a policy branch in this case.";

    public SamlAuthnContextAdapterSelector() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.setDescription(DESCRIPTION);
        HashSet<String> results = new HashSet<String>();
        CheckBoxFieldDescriptor updateAuthnContextAttribute = new CheckBoxFieldDescriptor(UPDATE_ATTR_CHECKBOX_NAME, UPDATE_ATTR_CHECKBOX_DESCRIPTION);
        updateAuthnContextAttribute.setDefaultValue(true);
        guiConfigDescriptor.addField((FieldDescriptor)updateAuthnContextAttribute);
        CheckBoxFieldDescriptor overrideAuthnContextValue = new CheckBoxFieldDescriptor(OVERRIDE_AUTHN_CONTEXT_FIELD_NAME, OVERRIDE_AUTHN_CONTEXT_FIELD_DESCRIPTION);
        overrideAuthnContextValue.setDefaultValue(true);
        overrideAuthnContextValue.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)overrideAuthnContextValue);
        CheckBoxFieldDescriptor resultRequestedContextDoesNotMatch = new CheckBoxFieldDescriptor(NO_MATCH_RESULT_ENABLED_FIELD_NAME, NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION);
        resultRequestedContextDoesNotMatch.setDefaultValue(false);
        resultRequestedContextDoesNotMatch.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)resultRequestedContextDoesNotMatch);
        CheckBoxFieldDescriptor resultNoRequestedContext = new CheckBoxFieldDescriptor(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME, NOT_IN_REQUEST_RESULT_ENABLED_FIELD_DESCRIPTION);
        resultNoRequestedContext.setDefaultValue(false);
        resultNoRequestedContext.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)resultNoRequestedContext);
        this.authnSelectorDescriptor = new SamlAuthnContextSelectorDescriptor("Requested AuthN Context Authentication Selector", (ConfigurablePlugin)this, guiConfigDescriptor, results, VersionUtil.getVersion());
        this.authnSelectorDescriptor.setSupportsExtendedResults(true);
        this.authnSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
        guiConfigDescriptor.addValidator((ConfigurationValidator)new AuthnContextSelectorValidator());
    }

    public void configure(Configuration configuration) {
        this.authnContexts.clear();
        this.authnContexts.addAll(configuration.getAdditionalAttrNames());
        this.updateAttribute = configuration.getBooleanFieldValue(UPDATE_ATTR_CHECKBOX_NAME);
        this.overrideAttribute = configuration.getBooleanFieldValue(OVERRIDE_AUTHN_CONTEXT_FIELD_NAME);
        this.notInRequestResultEnabled = configuration.getBooleanFieldValue(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME);
        this.noMatchResultEnabled = configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME);
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.authnSelectorDescriptor;
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse res, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        if (extraParameters.get("com.pingidentity.adapter.extra.parameter.authnPolicy") != null && extraParameters.get("com.pingidentity.adapter.extra.parameter.authnPolicy") instanceof AuthnPolicy) {
            boolean emptyContext = true;
            AuthnPolicy authnPolicy = (AuthnPolicy)extraParameters.get("com.pingidentity.adapter.extra.parameter.authnPolicy");
            if (authnPolicy instanceof AdvancedAuthnPolicy) {
                for (String requestedContext : ((AdvancedAuthnPolicy)authnPolicy).getRequestedAuthnContextDecl()) {
                    if (StringUtils.isNotBlank((String)requestedContext)) {
                        emptyContext = false;
                    }
                    if (!this.authnContexts.contains(requestedContext)) continue;
                    context.setResult(requestedContext);
                    break;
                }
            }
            for (String requestedContext : authnPolicy.getRequestAuthnContexts()) {
                if (StringUtils.isNotBlank((String)requestedContext)) {
                    emptyContext = false;
                }
                if (!this.authnContexts.contains(requestedContext)) continue;
                context.setResult(requestedContext);
                break;
            }
            if (StringUtils.isBlank((String)context.getResult())) {
                if (emptyContext) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"No requested AuthnContext is specified.");
                    }
                    if (this.notInRequestResultEnabled) {
                        context.setResult(this.getNotInRequestResult());
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"AuthnContext was specified but does not match any configured contexts.");
                    }
                    if (this.noMatchResultEnabled) {
                        context.setResult(this.getNoMatchResult());
                    }
                }
            }
        }
        return context;
    }

    public void callback(HttpServletRequest req, HttpServletResponse res, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
        if (this.updateAttribute) {
            String resultValue = authnSelectorContext.getResult();
            if (this.noMatchResultEnabled && NO_MATCH_RESULT_VALUE.equalsIgnoreCase(resultValue) || this.notInRequestResultEnabled && NOT_IN_REQUEST_RESULT_VALUE.equalsIgnoreCase(resultValue)) {
                return;
            }
            boolean anyAttributeValues = false;
            for (Object value : authnIdentifiers.values()) {
                anyAttributeValues |= value instanceof AttributeValue;
            }
            String attr = anyAttributeValues ? new AttributeValue(resultValue) : resultValue;
            authnIdentifiers.put(AssertionMapKeys.getAuthnCtxKey(), attr);
            this.log.debug((Object)("Attribute '" + AssertionMapKeys.getAuthnCtxKey() + "' added with value '" + resultValue + "'"));
            if (this.overrideAttribute) {
                authnIdentifiers.putIfAbsent(AssertionMapKeys.getAuthnCtxOverrideKey(), resultValue);
                this.log.debug((Object)("Attribute '" + AssertionMapKeys.getAuthnCtxOverrideKey() + "' added with value '" + resultValue + "'"));
            }
        }
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private String getNotInRequestResult() {
        if (this.notInRequestResultEnabled) {
            return NOT_IN_REQUEST_RESULT_VALUE;
        }
        return null;
    }

    private String getNoMatchResult() {
        if (this.noMatchResultEnabled) {
            return NO_MATCH_RESULT_VALUE;
        }
        return null;
    }

    private static class AuthnContextSelectorValidator
    implements ConfigurationValidator {
        private static final String VALIDATION_ERROR_NOT_IN_REQUEST_RESERVED = "'" + NOT_IN_REQUEST_RESULT_VALUE + "' is a reserved result value. Please remove the problematic result value or disable the option.";
        private static final String VALIDATION_ERROR_NO_MATCH_RESERVED = "'" + NO_MATCH_RESULT_VALUE + "' is a reserved result value. Please remove the problematic result value or disable the option.";
        private static final String VALIDATION_ERROR_OVERRIDE_AUTHN_CONTEXT = "'" + OVERRIDE_AUTHN_CONTEXT_FIELD_NAME + "' cannot be enabled when '" + UPDATE_ATTR_CHECKBOX_NAME + "' is disabled.";

        private AuthnContextSelectorValidator() {
        }

        public void validate(Configuration configuration) throws ValidationException {
            if (configuration == null) {
                return;
            }
            boolean notInRequestEnabled = configuration.getBooleanFieldValue(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME);
            boolean noMatchEnabled = configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME);
            boolean updateAuthnContextValueEnabled = configuration.getBooleanFieldValue(UPDATE_ATTR_CHECKBOX_NAME);
            boolean overrideAuthnContextValueEnabled = configuration.getBooleanFieldValue(OVERRIDE_AUTHN_CONTEXT_FIELD_NAME);
            ArrayList<String> errors = new ArrayList<String>();
            if (notInRequestEnabled && configuration.getAdditionalAttrNames().stream().anyMatch(result -> NOT_IN_REQUEST_RESULT_VALUE.equalsIgnoreCase((String)result))) {
                errors.add(VALIDATION_ERROR_NOT_IN_REQUEST_RESERVED);
            }
            if (noMatchEnabled && configuration.getAdditionalAttrNames().stream().anyMatch(result -> NO_MATCH_RESULT_VALUE.equalsIgnoreCase((String)result))) {
                errors.add(VALIDATION_ERROR_NO_MATCH_RESERVED);
            }
            if (!updateAuthnContextValueEnabled && overrideAuthnContextValueEnabled) {
                errors.add(VALIDATION_ERROR_OVERRIDE_AUTHN_CONTEXT);
            }
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }
    }

    private static class SamlAuthnContextSelectorDescriptor
    extends AuthenticationSelectorDescriptor {
        public SamlAuthnContextSelectorDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptor guiConfigDesc, Set<String> results, String version) {
            super(type, plugin, guiConfigDesc, results, version);
        }

        public List<String> getAdditionalResults(Configuration configuration) {
            ArrayList<String> results = new ArrayList<String>();
            if (configuration.getBooleanFieldValue(NOT_IN_REQUEST_RESULT_ENABLED_FIELD_NAME)) {
                results.add(NOT_IN_REQUEST_RESULT_VALUE);
            }
            if (configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME)) {
                results.add(NO_MATCH_RESULT_VALUE);
            }
            return results;
        }

        public boolean isSortConfigurationAttributes(Configuration configuration) {
            return true;
        }
    }
}

