/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.selectors.session;

import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.util.AuthnSourceKeyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AuthnSourceSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.AuthnSessionSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;

public class SessionAuthnSelector
implements AuthenticationSelector,
GuiConfigDescriptorBuilder,
AuthnApiPlugin {
    private static final Log log = LogFactory.getLog((String)"com.pingidentity.pf.selectors.session.SessionAuthnSelector");
    protected static final String SELECTOR_DESCRIPTION = "This authentication selector chooses a policy path at runtime based on whether the user already has a session for a particular source.";
    protected static final String AUTHN_SOURCES_TABLE_NAME = "Authentication Sources";
    protected static final String AUTHN_SOURCES_TABLE_DESC = "A table of authentication sources and result values";
    protected static final String AUTHN_SOURCE_FIELD_NAME = "Authentication Source";
    protected static final String AUTHN_SOURCE_FIELD_DESC = "Select from the available IdP adapters and connections";
    protected static final String RESULT_VALUE_FIELD_NAME = "Result Value";
    protected static final String RESULT_VALUE_FIELD_DESC = "The result value returned if a session exists for this source";
    protected static final String NO_SESSION_RESULT_VALUE = "No Session";
    protected static final String NO_SESSION_RESULT_ENABLED_FIELD_NAME = "Enable 'No Session' Result Value";
    protected static final String NO_SESSION_RESULT_ENABLED_FIELD_DESC = "By default, if no session exists for any of the above sources, the result value for the first source is returned. Select this checkbox to return a separate result value in this case.";
    private final AuthenticationSelectorDescriptor authenticationSelectorDescriptor;
    private final AuthnSourceSelectionFieldDescriptor authnSourceFieldDescriptor;
    private volatile List<AuthnSourceEntry> authnSourceEntries = new ArrayList<AuthnSourceEntry>();
    private volatile boolean noSessionResultEnabled = false;

    public SessionAuthnSelector() {
        this.authnSourceFieldDescriptor = new AuthnSourceSelectionFieldDescriptor(AUTHN_SOURCE_FIELD_NAME, AUTHN_SOURCE_FIELD_DESC);
        this.authnSourceFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        this.authnSourceFieldDescriptor.addValidator((FieldValidator)new AuthnSourceFieldValidator());
        this.authenticationSelectorDescriptor = new SessionSelectorDescriptor("Session Authentication Selector", (ConfigurablePlugin)this, this, Collections.emptySet(), VersionUtil.getVersion());
        this.authenticationSelectorDescriptor.setSupportsExtendedResults(false);
        this.authenticationSelectorDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse res, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        Collection sessions = (Collection)extraParameters.get("com.pingidentity.sdk.authnselector.sessions");
        Collection childNodeContexts = (Collection)extraParameters.get("com.pingidentity.sdk.authnselector.child.contexts");
        if (sessions == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extra parameter com.pingidentity.sdk.authnselector.sessions not found");
            }
        } else if (childNodeContexts == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extra parameter com.pingidentity.sdk.authnselector.child.contexts not found");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(sessions.size() + " sessions exist for this user"));
            }
            boolean foundMatch = false;
            List<AuthnSourceEntry> prunedEntries = this.pruneAuthnSourceEntries(this.authnSourceEntries, childNodeContexts);
            for (AuthnSourceEntry entry : prunedEntries) {
                if (!sessions.stream().anyMatch(session -> entry.getSourceKey().equals((Object)session.getAuthnSourceKey()))) continue;
                context.setResult(entry.getResultValue());
                foundMatch = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Found session for authn source '" + AuthnSourceKeyUtil.storageKeyToSourceName((String)entry.getStorageKey()) + "'"));
                break;
            }
            if (!foundMatch) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"None of the existing sessions matches a source in the pruned source list for this selector");
                }
                context.setResult(this.getNoSessionResult(prunedEntries));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning context '" + context.getResult() + "'"));
        }
        return context;
    }

    public void callback(HttpServletRequest req, HttpServletResponse res, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    public void configure(Configuration configuration) {
        ArrayList<AuthnSourceEntry> newEntries = new ArrayList<AuthnSourceEntry>();
        Table connectionsTable = configuration.getTable(AUTHN_SOURCES_TABLE_NAME);
        for (Row row : connectionsTable.getRows()) {
            String storageKey = row.getFieldValue(AUTHN_SOURCE_FIELD_NAME);
            String resultValue = row.getFieldValue(RESULT_VALUE_FIELD_NAME);
            AuthnSourceKey sourceKey = AuthnSourceKeyUtil.storageKeyToSourceKey((String)storageKey);
            if (sourceKey == null) continue;
            newEntries.add(new AuthnSourceEntry(storageKey, sourceKey.toPublicAuthnSourceKey(), resultValue));
        }
        this.authnSourceEntries = newEntries;
        this.noSessionResultEnabled = configuration.getBooleanFieldValue(NO_SESSION_RESULT_ENABLED_FIELD_NAME);
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.authenticationSelectorDescriptor;
    }

    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration config) {
        return this.buildGuiDescriptor();
    }

    public GuiConfigDescriptor buildNewGuiDescriptor() {
        return this.buildGuiDescriptor();
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private List<AuthnSourceEntry> pruneAuthnSourceEntries(Collection<AuthnSourceEntry> authnSourceEntries, Collection<String> childContexts) {
        ArrayList<AuthnSourceEntry> result = new ArrayList<AuthnSourceEntry>();
        for (AuthnSourceEntry entry : authnSourceEntries) {
            if (childContexts.contains(entry.getResultValue())) {
                result.add(entry);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignoring configured authn source '" + AuthnSourceKeyUtil.storageKeyToSourceName((String)entry.getStorageKey()) + "' as its result value is not in the pruned child contexts"));
        }
        return result;
    }

    private String getNoSessionResult(List<AuthnSourceEntry> prunedEntries) {
        if (this.noSessionResultEnabled) {
            return NO_SESSION_RESULT_VALUE;
        }
        if (prunedEntries.isEmpty()) {
            return null;
        }
        return prunedEntries.get(0).getResultValue();
    }

    private GuiConfigDescriptor buildGuiDescriptor() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.setDescription(SELECTOR_DESCRIPTION);
        guiConfigDescriptor.addValidator((ConfigurationValidator)new SelectorConfigurationValidator());
        guiConfigDescriptor.addTable(this.buildTableDescriptor());
        CheckBoxFieldDescriptor enableNoSessionField = new CheckBoxFieldDescriptor(NO_SESSION_RESULT_ENABLED_FIELD_NAME, NO_SESSION_RESULT_ENABLED_FIELD_DESC);
        guiConfigDescriptor.addField((FieldDescriptor)enableNoSessionField);
        return guiConfigDescriptor;
    }

    private TableDescriptor buildTableDescriptor() {
        TableDescriptor tableDescriptor = new TableDescriptor(AUTHN_SOURCES_TABLE_NAME, AUTHN_SOURCES_TABLE_DESC);
        tableDescriptor.addRowField((FieldDescriptor)this.authnSourceFieldDescriptor);
        TextFieldDescriptor resultValueFieldDescriptor = new TextFieldDescriptor(RESULT_VALUE_FIELD_NAME, RESULT_VALUE_FIELD_DESC);
        resultValueFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        tableDescriptor.addRowField((FieldDescriptor)resultValueFieldDescriptor);
        return tableDescriptor;
    }

    private static class AuthnSourceFieldValidator
    implements FieldValidator {
        private static final long serialVersionUID = 1L;

        public void validate(Field field) throws ValidationException {
            String storageKey = field.getValue();
            if (StringUtils.isBlank((String)storageKey)) {
                throw new ValidationException("'Authentication Source' is required.");
            }
            String sourceName = AuthnSourceKeyUtil.storageKeyToSourceName((String)storageKey);
            if (sourceName == null) {
                throw new ValidationException("Authentication source " + storageKey + " is not found.");
            }
        }
    }

    private static class SelectorConfigurationValidator
    implements ConfigurationValidator {
        private static final String VALIDATION_ERROR_MESSAGE_DPULICATE_SOURCE = "Duplicate authentication source: '%s'.";
        private static final String VALIDATION_ERROR_MESSAGE_DUPLICATE_RESULT_VALUE = "Duplicate result value: '%s'.";
        private static final String VALIDATION_ERROR_SESSIONS_NOT_ENABLED = "Authentication sessions are not enabled for the source '%s'. Please go to Manage Sessions and enable sessions for this source.";
        private static final String VALIDATION_ERROR_NO_SESSION_RESERVED = "'No Session' is a reserved result value and cannot be used with an authentication source.";

        public void validate(Configuration configuration) throws ValidationException {
            ArrayList<String> errors = new ArrayList<String>();
            this.checkAtLeastOneConfiguredSource(configuration);
            this.checkForDuplicateConfiguredSource(configuration, errors);
            this.checkForDuplicateResultValue(configuration, errors);
            this.checkForNoSessionResultValue(configuration, errors);
            this.checkForSessionsNotEnabled(configuration, errors);
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }

        private void checkAtLeastOneConfiguredSource(Configuration configuration) throws ValidationException {
            Table table = configuration.getTable(SessionAuthnSelector.AUTHN_SOURCES_TABLE_NAME);
            if (table.getRows().isEmpty()) {
                throw new ValidationException("Please add at least one source to the 'Authentication Sources' table.");
            }
        }

        private void checkForDuplicateConfiguredSource(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(SessionAuthnSelector.AUTHN_SOURCES_TABLE_NAME);
            HashSet storageKeys = new HashSet();
            table.getRows().forEach(row -> {
                String sourceName;
                String storageKey = row.getFieldValue(SessionAuthnSelector.AUTHN_SOURCE_FIELD_NAME);
                if (!storageKeys.add(storageKey) && (sourceName = AuthnSourceKeyUtil.storageKeyToSourceName((String)storageKey)) != null) {
                    errors.add(String.format(VALIDATION_ERROR_MESSAGE_DPULICATE_SOURCE, sourceName));
                }
            });
        }

        private void checkForDuplicateResultValue(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(SessionAuthnSelector.AUTHN_SOURCES_TABLE_NAME);
            ArrayList resultValues = new ArrayList();
            table.getRows().forEach(row -> {
                String resultValue = row.getFieldValue(SessionAuthnSelector.RESULT_VALUE_FIELD_NAME).trim();
                if (resultValues.stream().anyMatch(aValue -> resultValue.equalsIgnoreCase((String)aValue))) {
                    errors.add(String.format(VALIDATION_ERROR_MESSAGE_DUPLICATE_RESULT_VALUE, resultValue));
                } else {
                    resultValues.add(resultValue);
                }
            });
        }

        private void checkForNoSessionResultValue(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(SessionAuthnSelector.AUTHN_SOURCES_TABLE_NAME);
            if (table.getRows().stream().anyMatch(row -> SessionAuthnSelector.NO_SESSION_RESULT_VALUE.equalsIgnoreCase(row.getFieldValue(SessionAuthnSelector.RESULT_VALUE_FIELD_NAME).trim()))) {
                errors.add(VALIDATION_ERROR_NO_SESSION_RESERVED);
            }
        }

        private void checkForSessionsNotEnabled(Configuration configuration, List<String> errors) {
            Table table = configuration.getTable(SessionAuthnSelector.AUTHN_SOURCES_TABLE_NAME);
            table.getRows().forEach(row -> {
                String sourceName;
                String storageKey = row.getFieldValue(SessionAuthnSelector.AUTHN_SOURCE_FIELD_NAME);
                if (!this.sessionsEnabledForSource(storageKey) && (sourceName = AuthnSourceKeyUtil.storageKeyToSourceName((String)storageKey)) != null) {
                    errors.add(String.format(VALIDATION_ERROR_SESSIONS_NOT_ENABLED, sourceName));
                }
            });
        }

        private boolean sessionsEnabledForSource(String storageKey) {
            AuthnSourceKey sourceKey = AuthnSourceKeyUtil.storageKeyToSourceKey((String)storageKey);
            if (sourceKey == null) {
                return false;
            }
            List authnSessionSettings = MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(sourceKey);
            if (CollectionUtils.isNotEmpty((Collection)authnSessionSettings)) {
                return authnSessionSettings.stream().anyMatch(AuthnSessionSettings::isEnableSessions);
            }
            return false;
        }
    }

    private static class SessionSelectorDescriptor
    extends AuthenticationSelectorDescriptor {
        public SessionSelectorDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptorBuilder guiConfigDescBuilder, Set<String> results, String version) {
            super(type, plugin, guiConfigDescBuilder, results, version);
        }

        public List<String> getAdditionalResults(Configuration configuration) {
            ArrayList<String> results = new ArrayList<String>();
            Table connectionsTable = configuration.getTable(SessionAuthnSelector.AUTHN_SOURCES_TABLE_NAME);
            if (connectionsTable == null) {
                return results;
            }
            for (Row row : connectionsTable.getRows()) {
                String resultValue = row.getFieldValue(SessionAuthnSelector.RESULT_VALUE_FIELD_NAME);
                results.add(resultValue);
            }
            if (configuration.getBooleanFieldValue(SessionAuthnSelector.NO_SESSION_RESULT_ENABLED_FIELD_NAME)) {
                results.add(SessionAuthnSelector.NO_SESSION_RESULT_VALUE);
            }
            return results;
        }
    }

    private static class AuthnSourceEntry {
        private String storageKey;
        private AuthenticationSourceKey sourceKey;
        private String resultValue;

        public AuthnSourceEntry(String storageKey, AuthenticationSourceKey sourceKey, String resultValue) {
            this.storageKey = storageKey;
            this.sourceKey = sourceKey;
            this.resultValue = resultValue;
        }

        public String getStorageKey() {
            return this.storageKey;
        }

        public AuthenticationSourceKey getSourceKey() {
            return this.sourceKey;
        }

        public String getResultValue() {
            return this.resultValue;
        }
    }
}

