/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.scim11serviceprovider;

import com.pingidentity.pingcommons.crypto.IDGenerator;
import com.pingidentity.provisioner.saas.scim11serviceprovider.Scim11ServiceProviderPlugin;
import java.util.HashMap;
import java.util.List;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ProvisioningTargetUrls;
import org.sourceid.saml20.service.SpConnectionFactory;

public class PingOneScim11ServiceProviderPlugin
extends Scim11ServiceProviderPlugin {
    private static final long serialVersionUID = 1L;
    private static final String PLUGIN_ID = "PingOneSCIM11";
    private static final String PLUGIN_DESCRIPTION = "PingOne SCIM 1.1 Service Provider";

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    @Override
    public String getDescription() {
        return PLUGIN_DESCRIPTION;
    }

    public boolean isTestConnectionSupported() {
        if (!MgmtFactory.getPingOneAdminService().isAssociated()) {
            return super.isTestConnectionSupported();
        }
        return false;
    }

    public boolean isUserSelectable() {
        return false;
    }

    @Override
    protected List<FieldDescriptor> createDescriptors() {
        if (!MgmtFactory.getPingOneAdminService().isAssociated()) {
            return super.createDescriptors();
        }
        SpConnectionFactory spConnFactory = MgmtFactory.getPingOneAdminService().getSpConnectionFactory();
        ProvisioningTargetUrls targetUrls = spConnFactory.getProvisioningTargetUrls();
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("usersUrl", targetUrls.getUsersUrl());
        fieldMap.put("groupsUrl", targetUrls.getGroupsUrl());
        fieldMap.put("authentication", "basic");
        fieldMap.put("basicAuthUser", "prov-" + IDGenerator.rndAlphaNumeric((int)10));
        fieldMap.put("basicAuthPass", IDGenerator.rndAlphaNumeric((int)25));
        fieldMap.put("deprovisionMethod", "deleteUser");
        fieldMap.put("isPatchSupported", "true");
        fieldMap.put("useDnAsGroupName", "true");
        List<FieldDescriptor> descriptors = super.createDescriptors();
        for (FieldDescriptor descriptor : descriptors) {
            if (!fieldMap.containsKey(descriptor.getName())) continue;
            descriptor.setDefaultValue((String)fieldMap.get(descriptor.getName()));
        }
        return descriptors;
    }
}

