/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.scim11serviceprovider;

import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.scim11serviceprovider.OAuth2BearerTokenAuthFilter;
import com.pingidentity.provisioner.saas.scim11serviceprovider.Scim11ContextProvider;
import com.pingidentity.provisioner.saas.scim11serviceprovider.UserWithCustomAttributes;
import com.pingidentity.provisioner.sdk.AbstractSaasPluginWithGroups;
import com.pingidentity.provisioner.sdk.SaasGroupData;
import com.pingidentity.provisioner.sdk.SaasPluginException;
import com.pingidentity.provisioner.sdk.SaasPluginFieldInfo;
import com.pingidentity.provisioner.sdk.SaasUserData;
import com.pingidentity.sdk.PluginFipsStatus;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.URLValidator;
import org.sourceid.saml20.domain.CoreUserOutboundScimAttributeConstants;
import org.sourceid.saml20.domain.scim.model.Schema;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;
import org.sourceid.saml20.domain.scim.util.CustomAttributesUtil;
import scim.schemas.core.v1.Address;
import scim.schemas.core.v1.Group;
import scim.schemas.core.v1.MultiValuedAttribute;
import scim.schemas.core.v1.Name;
import scim.schemas.core.v1.Resource;
import scim.schemas.core.v1.User;

public class Scim11ServiceProviderPlugin
extends AbstractSaasPluginWithGroups {
    private static final long serialVersionUID = 1L;
    private static final String PLUGIN_ID = "SCIM11";
    private static final String PLUGIN_DESCRIPTION = "SCIM 1.1 Service Provider";
    protected static final String FIELD_USERS_URL = "usersUrl";
    protected static final String FIELD_USERS_URL_DESC = "Users Resource URL";
    protected static final String FIELD_GROUPS_URL = "groupsUrl";
    protected static final String FIELD_GROUPS_URL_DESC = "Groups Resource URL";
    private static final String FIELD_ENT_USER_EXT = "enableEntExt";
    protected static final String FIELD_DEPROVISION_METHOD = "deprovisionMethod";
    protected static final String FIELD_DEPROVISION_METHOD_DESC = "Deprovision Method";
    protected static final String FIELD_DEPROVISION_OPT_DELETE_NAME = "Delete User";
    protected static final String FIELD_DEPROVISION_OPT_DELETE_VAL = "deleteUser";
    protected static final String FIELD_DEPROVISION_OPT_DISABLE_NAME = "Disable User";
    protected static final String FIELD_DEPROVISION_OPT_DISABLE_VAL = "disableUser";
    protected static final String FIELD_AUTH = "authentication";
    protected static final String FIELD_AUTH_DESC = "Authentication Method";
    protected static final String FIELD_AUTH_OPT_NONE_NAME = "None";
    protected static final String FIELD_AUTH_OPT_NONE_VAL = "none";
    protected static final String FIELD_AUTH_OPT_BASIC_NAME = "Basic Authentication";
    protected static final String FIELD_AUTH_OPT_BASIC_VAL = "basic";
    protected static final String FIELD_AUTH_OPT_OAUTH2_BEARER_TOKEN = "OAuth 2.0 Bearer Token";
    protected static final String FIELD_AUTH_OPT_OAUTH2_BEARER_TOKEN_VAL = "oauth_bearer_token";
    protected static final String FIELD_BASIC_AUTH_USER = "basicAuthUser";
    protected static final String FIELD_BASIC_AUTH_USER_DESC = "User";
    protected static final String FIELD_BASIC_AUTH_PASS = "basicAuthPass";
    protected static final String FIELD_BASIC_AUTH_PASS_DESC = "Password";
    protected static final String FIELD_PATCH_SUPPORTED = "isPatchSupported";
    protected static final String FIELD_PATCH_SUPPORTED_DESC = "SCIM SP supports PATCH updates";
    protected static final String FIELD_DN_AS_GROUP_NAME = "useDnAsGroupName";
    protected static final String FIELD_DN_AS_GROUP_NAME_DESC = "Provision groups with distinguished name";
    protected static final String FIELD_CLIENT_ID = "clientId";
    protected static final String FIELD_CLIENT_ID_DESC = "Client ID";
    protected static final String FIELD_CLIENT_SECRET = "clientSecret";
    protected static final String FIELD_CLIENT_SECRET_DESC = "Client Secret";
    protected static final String FIELD_TOKEN_ENDPOINT_URL = "tokenEndpoint";
    protected static final String FIELD_TOKEN_ENDPOINT_URL_DESC = "Token Endpoint URL";
    protected static final String FIELD_RATE_LIMIT_CODE = "rateLimitErrorCode";
    protected static final String FIELD_RATE_LIMIT_CODE_DESC = "Rate Limit Error Code";
    protected static final String FIELD_RATE_LIMIT_CODE_DEFAULT = "429";
    private static final String PROPS_CORE_USER = "com/pingidentity/provisioner/saas/scim11serviceprovider/scim11-user-fields.properties";
    private static final String PROPS_ENT_USER = "com/pingidentity/provisioner/saas/scim11serviceprovider/scim11-enterpriseuser-fields.properties";
    private static final String DEFAULT_MAPPINGS = "com/pingidentity/provisioner/saas/scim11serviceprovider/mappings.default.properties";
    private static final String MASKED_VALUE = "*****";
    private static final String SCIM_VERSION = "urn:scim:schemas:core:1.0";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile List<FieldDescriptor> descriptors;
    private static List<SaasPluginFieldInfo> coreUserFieldInfo;
    private static List<SaasPluginFieldInfo> entUserFieldInfo;
    private static Properties defaultMappings;
    private Client restClient;
    private ClientFilter clientAuthFilter;
    private String usersUrl;
    private String groupsUrl;
    private boolean isEntUser;
    private String authMethod;
    private String basicAuthUser;
    private String basicAuthPass;
    private boolean isPatchSupported;
    private boolean usingDnAsGroupName;
    private String deprovisionMethod = "disableUser";
    private String clientId;
    private String clientSecret;
    private String tokenEndpoint;
    private Integer rateLimitErrorCode = Integer.valueOf("429");

    public Scim11ServiceProviderPlugin() {
        this.setSaasUsernameFieldCode(CoreUserOutboundScimAttributeConstants.USER_FIELD_USERNAME.getId());
    }

    public String getDescription() {
        return PLUGIN_DESCRIPTION;
    }

    public String getId() {
        return PLUGIN_ID;
    }

    public Map<String, Object> getMetadata() {
        return Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT);
    }

    protected Properties loadDefaultMappings() throws IOException {
        return defaultMappings;
    }

    public void checkSaasConnection() throws SaasPluginException {
        boolean groupConfigured = StringUtils.isNotEmpty((String)this.groupsUrl);
        if (StringUtils.isNotEmpty((String)this.usersUrl) && groupConfigured) {
            try {
                URL tempUserUrl = new URL(this.usersUrl);
                URL tempGroupUrl = new URL(this.groupsUrl);
                if (!tempUserUrl.getHost().equalsIgnoreCase(tempGroupUrl.getHost())) {
                    throw new SaasPluginException("Users and Groups Connection URL must have the same host name");
                }
            }
            catch (MalformedURLException e) {
                throw new SaasPluginException((Throwable)e);
            }
        }
        this.checkUserConnection();
        if (groupConfigured) {
            this.checkGroupConnection();
        }
    }

    private void checkUserConnection() throws SaasPluginException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Testing SCIM connection to " + this.usersUrl));
        }
        try {
            if (!this.checkConnection(this.usersUrl)) {
                throw new SaasPluginException("SCIM users connection failed");
            }
        }
        catch (Exception e) {
            throw new SaasPluginException("SCIM users connection failed", (Throwable)e);
        }
    }

    private void checkGroupConnection() throws SaasPluginException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Testing SCIM connection to " + this.groupsUrl));
        }
        try {
            if (!this.checkConnection(this.groupsUrl)) {
                throw new SaasPluginException("SCIM groups connection failed");
            }
        }
        catch (Exception e) {
            throw new SaasPluginException("SCIM groups connection failed", (Throwable)e);
        }
    }

    private boolean checkConnection(String baseUrl) {
        Response.Status httpStatus;
        ClientResponse response;
        String fakeResourceId = "11111111-1111-1111-1111-111111111111";
        boolean retry = false;
        int retryCount = 0;
        do {
            WebResource resource;
            try {
                resource = this.restClient.resource(this.getResourceUrl(baseUrl, fakeResourceId));
            }
            catch (SaasPluginException e) {
                this.log.debug((Object)("Check connection failed. " + e.getMessage()));
                return false;
            }
            response = (ClientResponse)resource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            httpStatus = Response.Status.fromStatusCode((int)response.getStatus());
            if (!FIELD_AUTH_OPT_OAUTH2_BEARER_TOKEN_VAL.equals(this.authMethod) || httpStatus != Response.Status.UNAUTHORIZED) continue;
            this.log.debug((Object)"Access has token expired.  Getting a new token and retrying...");
            retry = true;
            ((OAuth2BearerTokenAuthFilter)this.clientAuthFilter).resetAccessToken();
        } while (retry && ++retryCount <= 1);
        if (httpStatus == Response.Status.NOT_FOUND) {
            this.log.info((Object)"SCIM connection successful");
            return true;
        }
        if (httpStatus == Response.Status.OK) {
            response.getEntity(User.class);
            this.log.info((Object)"SCIM connection successful");
            return true;
        }
        return false;
    }

    public void closeSaasConnection() throws SaasPluginException {
        if (this.restClient != null) {
            this.restClient.destroy();
            this.restClient = null;
        }
    }

    public String createUser(SaasUserData saasUserData) throws SaasPluginException {
        UserWithCustomAttributes user = this.createUserPojo(saasUserData);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Attempting to create SCIM 1.1 User...");
        }
        boolean maskUsername = saasUserData.getMaskedFields().contains(CoreUserOutboundScimAttributeConstants.USER_FIELD_USERNAME.getId());
        UserWithCustomAttributes createdUser = this.provisionUser(user, this.usersUrl, false, maskUsername);
        if (this.log.isInfoEnabled()) {
            String maskedName = this.getMaskedUsername(user.getUserName(), maskUsername);
            this.log.info((Object)("User '" + maskedName + "' was successfully created on the SCIM Service Provider"));
        }
        return createdUser != null ? createdUser.getId() : null;
    }

    public List<FieldDescriptor> getConnectionParameterDescriptors() {
        if (this.descriptors != null) {
            return this.descriptors;
        }
        this.descriptors = Collections.unmodifiableList(this.createDescriptors());
        return this.descriptors;
    }

    public List<SaasPluginFieldInfo> getFieldInfo() throws SaasPluginException {
        LinkedList<SaasPluginFieldInfo> fieldInfos = new LinkedList<SaasPluginFieldInfo>();
        fieldInfos.addAll(coreUserFieldInfo);
        if (this.isEntUser) {
            fieldInfos.addAll(entUserFieldInfo);
        }
        return fieldInfos;
    }

    public String getSaasUserIdFieldName() {
        return CoreUserOutboundScimAttributeConstants.USER_FIELD_USERNAME.getId();
    }

    public SaasUserData getUser(String saasUserGuid, String saasUsername) throws SaasPluginException {
        Name name;
        WebResource userResource;
        ClientResponse response;
        Response.Status httpStatus;
        if (saasUserGuid == null) {
            return null;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Attempting to retrieve user '" + saasUserGuid + "'"));
        }
        if ((httpStatus = Response.Status.fromStatusCode((int)(response = (ClientResponse)(userResource = this.restClient.resource(this.getResourceUrl(this.usersUrl, saasUserGuid))).accept(new String[]{"application/json"}).get(ClientResponse.class)).getStatus())) == Response.Status.NOT_FOUND) {
            return null;
        }
        if (httpStatus.getFamily() != Response.Status.Family.SUCCESSFUL) {
            String errorMessage = "Unable to retrieve existing user '" + saasUserGuid + "' from service provider. Server returned status '" + response.getStatus() + "'";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)(errorMessage + " with response: " + (String)response.getEntity(String.class)));
            }
            throw new SaasPluginException(errorMessage);
        }
        this.logDebugResponse(response);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Successfully retrieved user '" + saasUserGuid + "'"));
        }
        User returnedUser = (User)response.getEntity(User.class);
        SaasUserData userData = new SaasUserData(saasUserGuid);
        Map attrMap = userData.getAttributeMap();
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_USERNAME.getId(), returnedUser.getUserName());
        if (returnedUser.getActive() != null) {
            userData.setAccountEnabled(returnedUser.getActive().booleanValue());
        }
        if ((name = returnedUser.getName()) != null) {
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_FORMATTED_NAME.getId(), name.getFormatted());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_FAMILY_NAME.getId(), name.getFamilyName());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_GIVEN_NAME.getId(), name.getGivenName());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_MIDDLE_NAME.getId(), name.getMiddleName());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_PREFIX.getId(), name.getHonorificPrefix());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_SUFFIX.getId(), name.getHonorificSuffix());
        }
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_DISPLAY_NAME.getId(), returnedUser.getDisplayName());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_NICKNAME.getId(), returnedUser.getNickName());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_PROFILE_URL.getId(), returnedUser.getProfileUrl());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_TITLE.getId(), returnedUser.getTitle());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_USER_TYPE.getId(), returnedUser.getUserType());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_PREF_LANG.getId(), returnedUser.getPreferredLanguage());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_LOCALE.getId(), returnedUser.getLocale());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_TIMEZONE.getId(), returnedUser.getTimezone());
        this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_PASSWORD.getId(), returnedUser.getPassword());
        this.addMVAttrToAttrMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_EMAIL.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_EMAIL_TYPE.getId(), returnedUser.getEmails());
        this.addMVAttrToAttrMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_PHONE_NUM.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_PHONE_NUM_TYPE.getId(), returnedUser.getPhoneNumbers());
        this.addMVAttrToAttrMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_IMS.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_IMS_TYPE.getId(), returnedUser.getIms());
        this.addMVAttrToAttrMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_PHOTO.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_PHOTO_TYPE.getId(), returnedUser.getPhotos());
        List addresses = returnedUser.getAddresses();
        if (addresses != null && !addresses.isEmpty()) {
            Address address = this.getPrimaryAddress(addresses);
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_FORMATTED_ADDR.getId(), address.getFormatted());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_STREET_ADDR.getId(), address.getStreetAddress());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_LOCALITY.getId(), address.getLocality());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_REGION.getId(), address.getRegion());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_POSTAL_CODE.getId(), address.getPostalCode());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_COUNTRY.getId(), address.getCountry());
            this.addValueToAttributeMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_ADDR_TYPE.getId(), address.getType());
        }
        this.addMVAttrToAttrMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_ENTITLEMENTS.getId(), returnedUser.getEntitlements());
        this.addMVAttrToAttrMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_ROLES.getId(), returnedUser.getRoles());
        this.addMVAttrToAttrMap(attrMap, CoreUserOutboundScimAttributeConstants.USER_FIELD_CERTS.getId(), returnedUser.getEntitlements());
        return userData;
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD_STORE"}, justification="introduced by java 11 language level change")
    public void initSaasConnection(List<Field> fields) throws SaasPluginException {
        for (Field f : fields) {
            String fieldLimitStr;
            String fieldName = f.getName();
            if (FIELD_AUTH.equals(fieldName)) {
                this.authMethod = f.getValue();
                continue;
            }
            if (FIELD_BASIC_AUTH_PASS.equals(fieldName)) {
                this.basicAuthPass = f.getValue();
                continue;
            }
            if (FIELD_BASIC_AUTH_USER.equals(fieldName)) {
                this.basicAuthUser = f.getValue();
                continue;
            }
            if (FIELD_CLIENT_ID.equals(fieldName)) {
                this.clientId = f.getValue();
                continue;
            }
            if (FIELD_CLIENT_SECRET.equals(fieldName)) {
                this.clientSecret = f.getValue();
                continue;
            }
            if (FIELD_TOKEN_ENDPOINT_URL.equals(fieldName)) {
                this.tokenEndpoint = f.getValue();
                continue;
            }
            if (FIELD_ENT_USER_EXT.equals(fieldName)) {
                this.isEntUser = f.getValueAsBoolean();
                continue;
            }
            if (FIELD_GROUPS_URL.equals(fieldName)) {
                this.groupsUrl = StringUtils.strip((String)f.getValue());
                continue;
            }
            if (FIELD_USERS_URL.equals(fieldName)) {
                this.usersUrl = StringUtils.strip((String)f.getValue());
                continue;
            }
            if (FIELD_PATCH_SUPPORTED.equals(fieldName)) {
                this.isPatchSupported = f.getValueAsBoolean();
                continue;
            }
            if (FIELD_DN_AS_GROUP_NAME.equals(fieldName)) {
                this.usingDnAsGroupName = f.getValueAsBoolean();
                continue;
            }
            if (FIELD_DEPROVISION_METHOD.equals(fieldName)) {
                String val = f.getValue();
                if (val == null) continue;
                this.deprovisionMethod = val;
                continue;
            }
            if (!FIELD_RATE_LIMIT_CODE.equals(fieldName) || !StringUtils.isNotBlank((String)(fieldLimitStr = f.getValue()))) continue;
            this.rateLimitErrorCode = Integer.parseInt(fieldLimitStr);
        }
        if (this.restClient == null) {
            DefaultClientConfig clientConfig = new DefaultClientConfig(new Class[]{Scim11ContextProvider.class});
            this.restClient = Client.create((ClientConfig)clientConfig);
            if (FIELD_AUTH_OPT_BASIC_VAL.equals(this.authMethod)) {
                if (StringUtils.isBlank((String)this.basicAuthPass) || StringUtils.isBlank((String)this.basicAuthUser)) {
                    throw new SaasPluginException("Expected user and password for basic authentication method.");
                }
                this.clientAuthFilter = new HTTPBasicAuthFilter(this.basicAuthUser, this.basicAuthPass);
            } else if (FIELD_AUTH_OPT_OAUTH2_BEARER_TOKEN_VAL.equals(this.authMethod)) {
                this.clientAuthFilter = new OAuth2BearerTokenAuthFilter(this.tokenEndpoint, this.clientId, this.clientSecret, this.basicAuthUser, this.basicAuthPass);
            }
            if (this.clientAuthFilter != null) {
                this.restClient.addFilter(this.clientAuthFilter);
            }
        }
        this.checkSaasConnection();
    }

    public String updateUser(SaasUserData existingSaasUserData, SaasUserData updatedSaasUserData) throws SaasPluginException {
        UserWithCustomAttributes updatedUser = this.createUserPojo(updatedSaasUserData);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Attempting to update SCIM 1.1 User...");
        }
        this.provisionUser(updatedUser, this.getResourceUrl(this.usersUrl, updatedSaasUserData.getSaasUserGuid()), true, existingSaasUserData.getMaskedFields().contains(CoreUserOutboundScimAttributeConstants.USER_FIELD_USERNAME.getId()));
        if (this.log.isInfoEnabled()) {
            String maskedName = this.getMaskedUsername(updatedUser.getUserName(), existingSaasUserData.getMaskedFields().contains(CoreUserOutboundScimAttributeConstants.USER_FIELD_USERNAME.getId()));
            this.log.info((Object)("User '" + maskedName + "' was successfully updated on the SCIM Service Provider"));
        }
        return updatedUser.getId();
    }

    protected List<FieldDescriptor> createDescriptors() {
        ArrayList<FieldDescriptor> tempDescriptors = new ArrayList<FieldDescriptor>(6);
        TextFieldDescriptor userUrlDescriptor = new TextFieldDescriptor(FIELD_USERS_URL, FIELD_USERS_URL_DESC);
        userUrlDescriptor.setLabel(FIELD_USERS_URL_DESC);
        userUrlDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        userUrlDescriptor.addValidator((FieldValidator)new URLValidator(), true);
        TextFieldDescriptor groupUrlDescriptor = new TextFieldDescriptor(FIELD_GROUPS_URL, FIELD_GROUPS_URL_DESC);
        groupUrlDescriptor.setLabel(FIELD_GROUPS_URL_DESC);
        groupUrlDescriptor.addValidator((FieldValidator)new URLValidator(), true);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>(3);
        optValues.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_AUTH_OPT_NONE_NAME, FIELD_AUTH_OPT_NONE_VAL));
        optValues.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_AUTH_OPT_BASIC_NAME, FIELD_AUTH_OPT_BASIC_VAL));
        optValues.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_AUTH_OPT_OAUTH2_BEARER_TOKEN, FIELD_AUTH_OPT_OAUTH2_BEARER_TOKEN_VAL));
        RadioGroupFieldDescriptor authMethodDescriptor = new RadioGroupFieldDescriptor(FIELD_AUTH, FIELD_AUTH_DESC, optValues);
        authMethodDescriptor.setDefaultValue(FIELD_AUTH_OPT_BASIC_VAL);
        TextFieldDescriptor userDescriptor = new TextFieldDescriptor(FIELD_BASIC_AUTH_USER, FIELD_BASIC_AUTH_USER_DESC);
        userDescriptor.setLabel(FIELD_BASIC_AUTH_USER_DESC);
        TextFieldDescriptor passwordDescriptor = new TextFieldDescriptor(FIELD_BASIC_AUTH_PASS, FIELD_BASIC_AUTH_PASS_DESC, true);
        passwordDescriptor.setLabel(FIELD_BASIC_AUTH_PASS_DESC);
        TextFieldDescriptor clientIdDescriptor = new TextFieldDescriptor(FIELD_CLIENT_ID, FIELD_CLIENT_ID_DESC);
        clientIdDescriptor.setLabel(FIELD_CLIENT_ID_DESC);
        TextFieldDescriptor clientSecretDescriptor = new TextFieldDescriptor(FIELD_CLIENT_SECRET, FIELD_CLIENT_SECRET_DESC, true);
        clientSecretDescriptor.setLabel(FIELD_CLIENT_SECRET_DESC);
        TextFieldDescriptor tokenEndpointUrlDescriptor = new TextFieldDescriptor(FIELD_TOKEN_ENDPOINT_URL, FIELD_TOKEN_ENDPOINT_URL_DESC);
        tokenEndpointUrlDescriptor.setLabel(FIELD_TOKEN_ENDPOINT_URL_DESC);
        tokenEndpointUrlDescriptor.addValidator((FieldValidator)new URLValidator(), true);
        CheckBoxFieldDescriptor patchDescriptor = new CheckBoxFieldDescriptor(FIELD_PATCH_SUPPORTED, FIELD_PATCH_SUPPORTED_DESC);
        patchDescriptor.setDefaultValue(true);
        CheckBoxFieldDescriptor dnAsGroupNameDescriptor = new CheckBoxFieldDescriptor(FIELD_DN_AS_GROUP_NAME, FIELD_DN_AS_GROUP_NAME_DESC);
        dnAsGroupNameDescriptor.setDefaultValue(true);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> deprovisionOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>(3);
        deprovisionOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_DEPROVISION_OPT_DELETE_NAME, FIELD_DEPROVISION_OPT_DELETE_VAL));
        deprovisionOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_DEPROVISION_OPT_DISABLE_NAME, FIELD_DEPROVISION_OPT_DISABLE_VAL));
        RadioGroupFieldDescriptor deprovisionDescriptor = new RadioGroupFieldDescriptor(FIELD_DEPROVISION_METHOD, FIELD_DEPROVISION_METHOD_DESC, deprovisionOptions);
        deprovisionDescriptor.setDefaultValue(FIELD_DEPROVISION_OPT_DISABLE_VAL);
        TextFieldDescriptor rateLimitingDescriptor = new TextFieldDescriptor(FIELD_RATE_LIMIT_CODE, FIELD_RATE_LIMIT_CODE_DESC);
        rateLimitingDescriptor.setLabel(FIELD_RATE_LIMIT_CODE_DESC);
        rateLimitingDescriptor.addValidator((FieldValidator)new IntegerValidator(1, 999), true);
        rateLimitingDescriptor.setDefaultValue(FIELD_RATE_LIMIT_CODE_DEFAULT);
        tempDescriptors.add((FieldDescriptor)userUrlDescriptor);
        tempDescriptors.add((FieldDescriptor)groupUrlDescriptor);
        tempDescriptors.add((FieldDescriptor)authMethodDescriptor);
        tempDescriptors.add((FieldDescriptor)userDescriptor);
        tempDescriptors.add((FieldDescriptor)passwordDescriptor);
        tempDescriptors.add((FieldDescriptor)clientIdDescriptor);
        tempDescriptors.add((FieldDescriptor)clientSecretDescriptor);
        tempDescriptors.add((FieldDescriptor)tokenEndpointUrlDescriptor);
        tempDescriptors.add((FieldDescriptor)patchDescriptor);
        tempDescriptors.add((FieldDescriptor)dnAsGroupNameDescriptor);
        tempDescriptors.add((FieldDescriptor)deprovisionDescriptor);
        tempDescriptors.add((FieldDescriptor)rateLimitingDescriptor);
        return tempDescriptors;
    }

    private String getMaskedUsername(String username, boolean isMasked) {
        String maskedName = username;
        if (isMasked) {
            maskedName = MASKED_VALUE;
        }
        return maskedName;
    }

    public String deprovisionUser(SaasUserData existingSaasUserData, SaasUserData updatedSaasUserData) throws SaasPluginException {
        if (FIELD_DEPROVISION_OPT_DELETE_VAL.equals(this.deprovisionMethod)) {
            this.deleteUser(updatedSaasUserData.getSaasUserGuid());
            return updatedSaasUserData.getSaasUserGuid();
        }
        return this.updateUser(existingSaasUserData, updatedSaasUserData);
    }

    private void deleteUser(String guid) throws SaasPluginException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Attempting to delete resource '" + guid + "'"));
        }
        String resourceUrl = this.getResourceUrl(this.usersUrl, guid);
        WebResource webResource = this.restClient.resource(resourceUrl);
        WebResource.Builder requestBuilder = webResource.accept(new String[]{"application/json"});
        ClientResponse response = (ClientResponse)requestBuilder.delete(ClientResponse.class);
        if (Response.Status.fromStatusCode((int)response.getStatus()).getFamily() != Response.Status.Family.SUCCESSFUL) {
            String errorMessage = "Unable to delete user '" + guid + "'. Server returned status '" + response.getStatus() + "'";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)(errorMessage + " with response: " + (String)response.getEntity(String.class)));
            }
            throw new SaasPluginException(errorMessage);
        }
        this.logDebugResponse(response);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Successfully deleted resource '" + guid + "'"));
        }
    }

    private void addValueToAttributeMap(Map<String, List<String>> attrMap, String attrName, String val) {
        if (val == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(val);
        attrMap.put(attrName, list);
    }

    private void addMVAttrToAttrMap(Map<String, List<String>> attrMap, String attrValName, String attrTypeName, List<MultiValuedAttribute> vals) {
        if (vals == null || vals.isEmpty()) {
            return;
        }
        MultiValuedAttribute mva = this.getPrimary(vals);
        String val = mva.getValue();
        if (val == null || !(val instanceof String)) {
            return;
        }
        String strVal = val;
        String type = mva.getType();
        ArrayList<String> valList = new ArrayList<String>(1);
        valList.add(strVal);
        attrMap.put(attrValName, valList);
        if (type != null && attrTypeName != null) {
            ArrayList<String> typeList = new ArrayList<String>(1);
            typeList.add(type);
            attrMap.put(attrTypeName, typeList);
        }
    }

    private void addMVAttrToAttrMap(Map<String, List<String>> attrMap, String attrValName, List<MultiValuedAttribute> vals) {
        this.addMVAttrToAttrMap(attrMap, attrValName, null, vals);
    }

    private static List<SaasPluginFieldInfo> convertFieldInfoToSaasPluginFieldInfo(List<FieldInfo> fieldInfos) {
        LinkedList<SaasPluginFieldInfo> saasPluginFieldInfos = new LinkedList<SaasPluginFieldInfo>();
        for (FieldInfo fi : fieldInfos) {
            SaasPluginFieldInfo saasPluginFieldInfo = new SaasPluginFieldInfo(fi.getCode(), fi.getLabel());
            saasPluginFieldInfo.setDefault(fi.getDefault());
            saasPluginFieldInfo.setMaxLength(fi.getMaxLength());
            saasPluginFieldInfo.setMinLength(fi.getMinLength());
            saasPluginFieldInfo.setMultiValue(fi.isMultiValue());
            saasPluginFieldInfo.setNotes((Collection)fi.getNotes());
            saasPluginFieldInfo.setOptions(fi.getOptions());
            saasPluginFieldInfo.setRegEx(fi.getRegEx());
            saasPluginFieldInfo.setRequired(fi.isRequired());
            saasPluginFieldInfo.setUnique(fi.isUnique());
            saasPluginFieldInfo.setLdapMap(fi.isLdapMap());
            saasPluginFieldInfo.setPersistForMembership(fi.isPersistForMembership());
            saasPluginFieldInfos.add(saasPluginFieldInfo);
        }
        return saasPluginFieldInfos;
    }

    private List<MultiValuedAttribute> createSimpleMVAttributes(List<String> sourceVals) {
        if (sourceVals == null) {
            return null;
        }
        ArrayList<MultiValuedAttribute> attrs = new ArrayList<MultiValuedAttribute>();
        for (String sourceVal : sourceVals) {
            if (sourceVal == null) continue;
            MultiValuedAttribute entitlementAttr = new MultiValuedAttribute();
            entitlementAttr.setValue(sourceVal);
            attrs.add(entitlementAttr);
        }
        return attrs;
    }

    private List<MultiValuedAttribute> createValueTypeMVAttribute(SaasUserData saasUserData, String valName, String typeName) {
        ArrayList<MultiValuedAttribute> list = new ArrayList<MultiValuedAttribute>();
        String value = saasUserData.getAttributeFirstValue(valName);
        String type = saasUserData.getAttributeFirstValue(typeName);
        if (value == null) {
            return null;
        }
        MultiValuedAttribute attr = new MultiValuedAttribute();
        attr.setValue(value);
        attr.setType(type);
        list.add(attr);
        return list;
    }

    private Group createGroupPojo(SaasGroupData saasGroupData) {
        MultiValuedAttribute memberAttr;
        Group group = new Group();
        group.setId(saasGroupData.getGuid());
        group.setDisplayName(saasGroupData.getName());
        group.setExternalId(saasGroupData.getInternalGuid());
        ArrayList<MultiValuedAttribute> memberAttrs = new ArrayList<MultiValuedAttribute>();
        if (saasGroupData.getMembersIterator() != null) {
            Iterator usersIterator = saasGroupData.getMembersIterator();
            while (usersIterator.hasNext()) {
                SaasUserData user = (SaasUserData)usersIterator.next();
                if (user == null || user.getSaasUserGuid() == null) continue;
                memberAttr = new MultiValuedAttribute();
                memberAttr.setValue(user.getSaasUserGuid());
                memberAttrs.add(memberAttr);
            }
        }
        if (saasGroupData.getSubGroupMembersIterator() != null) {
            Iterator subGroupsIterator = saasGroupData.getSubGroupMembersIterator();
            while (subGroupsIterator.hasNext()) {
                SaasGroupData saasSubGroupData = (SaasGroupData)subGroupsIterator.next();
                if (saasSubGroupData == null || saasSubGroupData.getGuid() == null) continue;
                memberAttr = new MultiValuedAttribute();
                memberAttr.setValue(saasSubGroupData.getGuid());
                memberAttrs.add(memberAttr);
            }
        }
        if (!memberAttrs.isEmpty()) {
            group.setMembers(memberAttrs);
        }
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(SCIM_VERSION);
        group.setSchemas(schemas);
        return group;
    }

    private UserWithCustomAttributes createUserPojo(SaasUserData saasUserData) {
        ProvisionerConfig provisionerConfig;
        Map rawLdapMap;
        UserWithCustomAttributes user = new UserWithCustomAttributes();
        user.setId(saasUserData.getSaasUserGuid());
        user.setExternalId(saasUserData.getInternalGuid());
        user.setUserName(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_USERNAME.getId()));
        Name name = new Name();
        name.setFormatted(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_FORMATTED_NAME.getId()));
        name.setFamilyName(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_FAMILY_NAME.getId()));
        name.setGivenName(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_GIVEN_NAME.getId()));
        name.setMiddleName(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_MIDDLE_NAME.getId()));
        name.setHonorificPrefix(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_PREFIX.getId()));
        name.setHonorificSuffix(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_SUFFIX.getId()));
        user.setName(name);
        user.setDisplayName(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_DISPLAY_NAME.getId()));
        user.setNickName(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_NICKNAME.getId()));
        user.setProfileUrl(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_PROFILE_URL.getId()));
        user.setTitle(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_TITLE.getId()));
        user.setUserType(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_USER_TYPE.getId()));
        user.setPreferredLanguage(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_PREF_LANG.getId()));
        user.setLocale(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_LOCALE.getId()));
        user.setTimezone(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_TIMEZONE.getId()));
        user.setActive(saasUserData.isAccountEnabled());
        user.setPassword(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_PASSWORD.getId()));
        user.setEmails(this.createValueTypeMVAttribute(saasUserData, CoreUserOutboundScimAttributeConstants.USER_FIELD_EMAIL.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_EMAIL_TYPE.getId()));
        user.setPhoneNumbers(this.createValueTypeMVAttribute(saasUserData, CoreUserOutboundScimAttributeConstants.USER_FIELD_PHONE_NUM.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_PHONE_NUM_TYPE.getId()));
        user.setIms(this.createValueTypeMVAttribute(saasUserData, CoreUserOutboundScimAttributeConstants.USER_FIELD_IMS.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_IMS_TYPE.getId()));
        user.setPhotos(this.createValueTypeMVAttribute(saasUserData, CoreUserOutboundScimAttributeConstants.USER_FIELD_PHOTO.getId(), CoreUserOutboundScimAttributeConstants.USER_FIELD_PHOTO_TYPE.getId()));
        ArrayList<Address> addresses = new ArrayList<Address>();
        Address address = new Address();
        address.setFormatted(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_FORMATTED_ADDR.getId()));
        address.setStreetAddress(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_STREET_ADDR.getId()));
        address.setLocality(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_LOCALITY.getId()));
        address.setRegion(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_REGION.getId()));
        address.setPostalCode(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_POSTAL_CODE.getId()));
        address.setCountry(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_COUNTRY.getId()));
        address.setType(saasUserData.getAttributeFirstValue(CoreUserOutboundScimAttributeConstants.USER_FIELD_ADDR_TYPE.getId()));
        addresses.add(address);
        if (address.getFormatted() != null || address.getStreetAddress() != null || address.getLocality() != null || address.getRegion() != null || address.getPostalCode() != null || address.getCountry() != null) {
            user.setAddresses(addresses);
        }
        user.setEntitlements(this.createSimpleMVAttributes(saasUserData.getAttributeValues(CoreUserOutboundScimAttributeConstants.USER_FIELD_ENTITLEMENTS.getId())));
        user.setRoles(this.createSimpleMVAttributes(saasUserData.getAttributeValues(CoreUserOutboundScimAttributeConstants.USER_FIELD_ROLES.getId())));
        user.setX509Certificates(this.createSimpleMVAttributes(saasUserData.getAttributeValues(CoreUserOutboundScimAttributeConstants.USER_FIELD_CERTS.getId())));
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(SCIM_VERSION);
        user.setSchemas(schemas);
        Map mapAttributesMap = saasUserData.getMapAttributesMap();
        if (mapAttributesMap != null && (rawLdapMap = (Map)mapAttributesMap.get("ldapAttributesMap")) != null) {
            HashMap<String, Object> ldapMap = new HashMap<String, Object>();
            for (Map.Entry rawLdapAttr : rawLdapMap.entrySet()) {
                String ldapName = (String)rawLdapAttr.getKey();
                List values = (List)rawLdapAttr.getValue();
                if (values.size() == 1) {
                    ldapMap.put(ldapName, values.get(0));
                    continue;
                }
                if (values.isEmpty()) continue;
                ldapMap.put(ldapName, values);
            }
            user.setMap(ldapMap);
        }
        if (this.getSpConnection() != null && (provisionerConfig = (ProvisionerConfig)this.getSpConnection().getModuleConfiguration(ProvisionerConfig.class)) != null && provisionerConfig.getCustomScim() != null && provisionerConfig.getCustomScim().getAttributes() != null && provisionerConfig.getCustomScim().getSchemas() != null && provisionerConfig.getCustomScim().getSchemas().size() > 0) {
            List<String> customAttributesInDotNotation = this.findCustomAttributes(saasUserData, provisionerConfig);
            this.addCustomAttributesToUser(user.getAnyAttributes(), provisionerConfig.getCustomScim(), customAttributesInDotNotation, saasUserData);
            if (provisionerConfig.getCustomScim() != null && provisionerConfig.getCustomScim().getSchemas() != null && provisionerConfig.getCustomScim().getSchemas().iterator() != null) {
                String schema = (String)provisionerConfig.getCustomScim().getSchemas().iterator().next();
                List existingSchemas = user.getSchemas();
                existingSchemas.add(schema);
                user.setSchemas(existingSchemas);
            }
        }
        return user;
    }

    private void addComplexMultiValue(Map<String, Object> attributeMap, Schema schema, SaasUserData saasUserData, String[] parts, String dotNotation) {
        List subAttributesList;
        List values = (List)saasUserData.getAttributeMap().get(dotNotation);
        String value = (String)values.iterator().next();
        String type = parts[1];
        if (attributeMap.containsKey(parts[0])) {
            subAttributesList = (List)attributeMap.get(parts[0]);
            boolean foundType = false;
            for (Map map : subAttributesList) {
                if (!map.get("type").equals(type)) continue;
                map.put(parts[2], value);
                foundType = true;
            }
            if (!foundType) {
                HashMap<String, String> subAttributes = new HashMap<String, String>();
                subAttributes.put(parts[2], value);
                subAttributes.put("type", parts[1]);
                subAttributesList.add(subAttributes);
            }
        } else {
            subAttributesList = new ArrayList();
            HashMap<String, String> subAttributes = new HashMap<String, String>();
            subAttributes.put(parts[2], value);
            subAttributes.put("type", parts[1]);
            subAttributesList.add(subAttributes);
        }
        attributeMap.put(parts[0], subAttributesList);
    }

    private void addComplexNonMultiValue(Map<String, Object> attributeMap, Schema schema, SaasUserData saasUserData, String[] parts, String dotNotation) {
        Map<String, Object> subAttributeMap = new HashMap();
        List values = (List)saasUserData.getAttributeMap().get(dotNotation);
        if (attributeMap.containsKey(parts[0])) {
            subAttributeMap = (Map)attributeMap.get(parts[0]);
        }
        subAttributeMap.put(parts[1], values.get(0));
        attributeMap.put(parts[0], subAttributeMap);
    }

    private void addSimpleAttribute(Map<String, Object> attributeMap, Schema schema, SaasUserData saasUserData, String[] parts, String dotNotation) {
        SchemaAttribute attr = schema.findAttribute(parts[0]);
        if (attr != null) {
            if (attr.isMultiValued().booleanValue()) {
                List values = (List)saasUserData.getAttributeMap().get(dotNotation);
                attributeMap.put(attr.getName(), values);
            } else {
                List values = (List)saasUserData.getAttributeMap().get(dotNotation);
                if (values != null) {
                    attributeMap.put(attr.getName(), values.get(0));
                }
            }
        }
    }

    private void addCustomAttributesToUser(Map<String, Object> customAttributes, Schema schema, List<String> customAttributesInDotNotation, SaasUserData saasUserData) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String dotNotation : customAttributesInDotNotation) {
            String[] parts = dotNotation.split("\\.");
            if (parts.length == 3) {
                this.addComplexMultiValue(attributeMap, schema, saasUserData, parts, dotNotation);
                continue;
            }
            if (parts.length == 2) {
                this.addComplexNonMultiValue(attributeMap, schema, saasUserData, parts, dotNotation);
                continue;
            }
            if (parts.length != 1) continue;
            this.addSimpleAttribute(attributeMap, schema, saasUserData, parts, dotNotation);
        }
        if (attributeMap == null || attributeMap.isEmpty()) {
            return;
        }
        if (schema.getSchemas() != null && schema.getSchemas().iterator() != null) {
            customAttributes.put((String)schema.getSchemas().iterator().next(), attributeMap);
        } else {
            customAttributes.put("urn:scim:schemas:extension:custom:1.0", attributeMap);
        }
    }

    private List<String> findCustomAttributes(SaasUserData saasUserData, ProvisionerConfig provisionerConfig) {
        Schema schema = provisionerConfig.getCustomScim();
        ArrayList sortedAttributeIds = new ArrayList();
        ArrayList<String> customAttributes = new ArrayList<String>();
        sortedAttributeIds.addAll(CustomAttributesUtil.getCustomAttributeIdsWithDotNotation((Schema)schema));
        for (String dotNotation : saasUserData.getAttributeMap().keySet()) {
            if (!sortedAttributeIds.contains(dotNotation)) continue;
            customAttributes.add(dotNotation);
        }
        return customAttributes;
    }

    private <T extends MultiValuedAttribute> T getPrimary(List<T> list) {
        MultiValuedAttribute primary = (MultiValuedAttribute)list.get(0);
        for (MultiValuedAttribute mva : list) {
            Boolean isPrimary = mva.isPrimary();
            if (isPrimary == null || !isPrimary.booleanValue()) continue;
            primary = mva;
            break;
        }
        return (T)primary;
    }

    private Address getPrimaryAddress(List<Address> addresses) {
        Address primary = addresses.get(0);
        for (Address address : addresses) {
            Boolean isPrimary = address.isPrimary();
            if (isPrimary == null || !isPrimary.booleanValue()) continue;
            primary = address;
            break;
        }
        return primary;
    }

    private String getResourceUrl(String baseUrl, String id) throws SaasPluginException {
        URIBuilder resourceUrlBuilder;
        if (id == null) {
            throw new SaasPluginException("Unable to retrieve resource.  Id is null.");
        }
        id = Util.urlEncodeUTF8((String)id);
        try {
            resourceUrlBuilder = new URIBuilder(baseUrl);
        }
        catch (URISyntaxException e) {
            throw new SaasPluginException((Throwable)e);
        }
        Object path = resourceUrlBuilder.getPath();
        path = ((String)path).endsWith("/") ? (String)path + id : (String)path + "/" + id;
        resourceUrlBuilder.setPath((String)path);
        return resourceUrlBuilder.toString();
    }

    private void logDebugResponse(ClientResponse response) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SCIM Service Provider returned the following:\n");
        buffer.append("HTTP Status Code: ").append(response.getStatus()).append('\n');
        buffer.append("HTTP Headers:\n");
        MultivaluedMap headers = response.getHeaders();
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                buffer.append('\t').append(header).append(": ").append(value).append("\n");
            }
        }
        this.log.debug((Object)buffer.toString());
    }

    private <T extends Resource> T provisionResource(T resource, Class<T> resourceClass, String resourceUrl, String resourceName, boolean updateOperation, boolean usePatch, boolean mergeMembership, boolean maskUsername) throws SaasPluginException {
        ClientResponse response;
        WebResource webResource = this.restClient.resource(resourceUrl);
        WebResource.Builder requestBuilder = (WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json");
        if (updateOperation) {
            if (usePatch && mergeMembership) {
                requestBuilder.header("X-HTTP-Method-Override", (Object)"PATCH");
                response = (ClientResponse)requestBuilder.post(ClientResponse.class, resource);
            } else {
                response = (ClientResponse)requestBuilder.put(ClientResponse.class, resource);
            }
        } else {
            response = (ClientResponse)requestBuilder.post(ClientResponse.class, resource);
        }
        int statusCode = response.getStatus();
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        if (statusCode == 405 && usePatch && this.log.isErrorEnabled()) {
            this.log.error((Object)"SCIM service provider does not support PATCH! Reconfigure your connection to disable PATCH support");
        }
        if (status == null || status.getFamily() != Response.Status.Family.SUCCESSFUL) {
            String maskedName = this.getMaskedUsername(resourceName, maskUsername);
            String errorMessage = "Unable to provision resource '" + maskedName + "'. Server returned status '" + response.getStatus() + "'";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)(errorMessage + " with response: " + (String)response.getEntity(String.class)));
            }
            SaasPluginException exception = new SaasPluginException(errorMessage);
            if (this.rateLimitErrorCode != null && this.rateLimitErrorCode == statusCode) {
                exception.setStopSession(true);
                this.log.error((Object)"Stopping provisioning cycle.");
            }
            throw exception;
        }
        this.logDebugResponse(response);
        return (T)((Resource)response.getEntity(resourceClass));
    }

    private Group provisionGroup(Group group, String resourceUrl, boolean updateOperation, boolean mergeMembership) throws SaasPluginException {
        Group returnedGroup = this.provisionResource(group, Group.class, resourceUrl, group.getDisplayName(), updateOperation, this.isPatchSupported, mergeMembership, false);
        if ((returnedGroup == null || returnedGroup.getId() == null) && this.log.isWarnEnabled()) {
            this.log.warn((Object)"Group was provisioned, but the SCIM Service Provider returned a group with a null ID! This violates SCIM standards. This may affect future provisioning attempts.");
        }
        return returnedGroup;
    }

    private UserWithCustomAttributes provisionUser(UserWithCustomAttributes user, String resourceUrl, boolean updateOperation, boolean maskUsername) throws SaasPluginException {
        UserWithCustomAttributes returnedUser = this.provisionResource(user, UserWithCustomAttributes.class, resourceUrl, user.getUserName(), updateOperation, false, false, maskUsername);
        if ((returnedUser == null || returnedUser.getId() == null) && this.log.isWarnEnabled()) {
            this.log.warn((Object)"User was provisioned, but the SCIM Service Provider returned a user with a null ID! This violates SCIM standards. This may affect future provisioning attempts.");
        }
        return returnedUser;
    }

    private Group queryGroup(SaasGroupData saasGroup) throws SaasPluginException {
        ClientResponse response;
        Response.Status httpStatus;
        WebResource groupResource = this.restClient.resource(this.getResourceUrl(this.groupsUrl, saasGroup.getGuid()));
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Checking if group '" + saasGroup.getName() + "' exists on the Service Provider"));
        }
        if ((httpStatus = Response.Status.fromStatusCode((int)(response = (ClientResponse)groupResource.accept(new String[]{"application/json"}).get(ClientResponse.class)).getStatus())) == Response.Status.NOT_FOUND) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Group '" + saasGroup.getName() + "' does not exist"));
            }
            return null;
        }
        if (httpStatus.getFamily() != Response.Status.Family.SUCCESSFUL) {
            String errorMessage = "Unable to get group '" + saasGroup.getName() + "'. Server returned status '" + response.getStatus() + "'";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)(errorMessage + " with response: " + (String)response.getEntity(String.class)));
            }
            throw new SaasPluginException(errorMessage);
        }
        this.logDebugResponse(response);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Group '" + saasGroup.getName() + "' exists"));
        }
        return (Group)response.getEntity(Group.class);
    }

    public boolean doesGroupExist(SaasGroupData saasGroup) throws SaasPluginException {
        if (saasGroup.hasGuid()) {
            return this.queryGroup(saasGroup) != null;
        }
        return false;
    }

    public String updateGroup(SaasGroupData saasGroup, boolean mergeMembership) throws SaasPluginException {
        Group group = this.createGroupPojo(saasGroup);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Attempting to update SCIM 1.1 Group...");
        }
        this.provisionGroup(group, this.getResourceUrl(this.groupsUrl, saasGroup.getGuid()), true, mergeMembership);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Group '" + saasGroup.getName() + "' was successfully updated on the SCIM Service Provider"));
        }
        return saasGroup.getGuid();
    }

    public String createGroup(SaasGroupData saasGroup) throws SaasPluginException {
        Group group = this.createGroupPojo(saasGroup);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Attempting to create SCIM 1.1 Group...");
        }
        Group returnedGroup = this.provisionGroup(group, this.groupsUrl, false, false);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Group '" + saasGroup.getName() + "' was successfully created on the SCIM Service Provider"));
        }
        return returnedGroup != null ? returnedGroup.getId() : null;
    }

    public void deleteGroup(SaasGroupData saasGroup) throws SaasPluginException {
        WebResource webResource = this.restClient.resource(this.getResourceUrl(this.groupsUrl, saasGroup.getGuid()));
        WebResource.Builder requestBuilder = (WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json");
        ClientResponse response = (ClientResponse)requestBuilder.delete(ClientResponse.class);
        Response.Status httpStatus = Response.Status.fromStatusCode((int)response.getStatus());
        if (httpStatus.getFamily() != Response.Status.Family.SUCCESSFUL && httpStatus != Response.Status.NOT_FOUND) {
            String errorMessage = "Unable to delete resource '" + saasGroup.getName() + "'. Server returned status '" + response.getStatus() + "'";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)(errorMessage + " with response: " + (String)response.getEntity(String.class)));
            }
            throw new SaasPluginException(errorMessage);
        }
        this.logDebugResponse(response);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Successfully deleted resource '" + saasGroup.getName() + "'"));
        }
    }

    public boolean isConfiguredForGroups() {
        return !StringUtils.isEmpty((String)this.groupsUrl);
    }

    public boolean isUsingDnAsGroupName() {
        return this.usingDnAsGroupName;
    }

    public boolean hasLocalFieldsInfo() {
        return true;
    }

    static {
        try {
            List coreUserFields = FieldInfo.parseFieldsInfo((String)PROPS_CORE_USER);
            coreUserFieldInfo = Collections.unmodifiableList(Scim11ServiceProviderPlugin.convertFieldInfoToSaasPluginFieldInfo(coreUserFields));
            List entUserField = FieldInfo.parseFieldsInfo((String)PROPS_ENT_USER);
            entUserFieldInfo = Collections.unmodifiableList(Scim11ServiceProviderPlugin.convertFieldInfoToSaasPluginFieldInfo(entUserField));
            defaultMappings = new Properties();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            defaultMappings.load(classLoader.getResourceAsStream(DEFAULT_MAPPINGS));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load user fields!");
        }
    }
}

