/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.selectors;

import com.pingidentity.access.ClusterAccessor;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class ClusterNodeAdapterSelector
implements AuthenticationSelector,
AuthnApiPlugin {
    private AuthnSelectorManager authnSelectorManager = MgmtFactory.getAuthnSelectorManager();
    private static final String DESCRIPTION = "This authentication selector provides a means of choosing authentication sources at runtime based on the cluster node on which it is executing.";
    private static final String SELECTOR_NAME = "Cluster Node Authentication Selector";
    private static final Logger log = LogManager.getLogger(ClusterNodeAdapterSelector.class);
    private final PluginDescriptor pluginDescriptor;
    private Set<String> values = null;
    private static final String NODE = "Node Property";
    private static final String NODE_TAG = "Node Tag";
    private static final String NODE_INDEX = "Node Index";
    private String nodeProperty = "Node Index";
    private static String NO_MATCH_RESULT_VALUE = "No Match";
    private static String NO_MATCH_RESULT_ENABLED_FIELD_NAME = "Enable '" + NO_MATCH_RESULT_VALUE + "' Result Value";
    private static String NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION = "By default, selector evaluation fails and the next applicable authentication policy is executed when the node index or node tag value does not match any of the configured selector result values. Select this checkbox to enable an authentication policy branch in this case.";
    private static final boolean NO_MATCH_RESULT_ENABLED_DEFAULT_VALUE = false;
    private volatile boolean noMatchResultEnabled = false;

    public ClusterNodeAdapterSelector() {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor(DESCRIPTION);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> nodeOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        nodeOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(NODE_INDEX, NODE_INDEX));
        nodeOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(NODE_TAG, NODE_TAG));
        SelectFieldDescriptor nodeProperty = new SelectFieldDescriptor(NODE, "The property used to determine the selector result value.", nodeOptions);
        guiConfigDescriptor.addField((FieldDescriptor)nodeProperty);
        CheckBoxFieldDescriptor resultRequestedContextDoesNotMatch = new CheckBoxFieldDescriptor(NO_MATCH_RESULT_ENABLED_FIELD_NAME, NO_MATCH_RESULT_ENABLED_FIELD_DESCRIPTION);
        resultRequestedContextDoesNotMatch.setDefaultValue(false);
        resultRequestedContextDoesNotMatch.setDefaultForLegacyConfig(Boolean.toString(false));
        guiConfigDescriptor.addField((FieldDescriptor)resultRequestedContextDoesNotMatch);
        guiConfigDescriptor.addValidator((ConfigurationValidator)new ClusterNodeAdapterSelectorValidator());
        this.pluginDescriptor = new ClusterNodeAdapterSelectorDescriptor(SELECTOR_NAME, (ConfigurablePlugin)this, guiConfigDescriptor, null, VersionUtil.getVersion());
        this.pluginDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        this.values = new HashSet<String>(configuration.getAdditionalAttrNames());
        if (ModeSupport.getMode() == Mode.STANDALONE) {
            log.warn("The cluster node authentication selector should not be used in standalone mode.");
        }
        this.nodeProperty = StringUtils.isBlank((String)configuration.getFieldValue(NODE)) ? NODE_INDEX : configuration.getFieldValue(NODE);
        this.noMatchResultEnabled = configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME, false);
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public void callback(HttpServletRequest req, HttpServletResponse resp, Map authnIdentifiers, AuthenticationSourceKey authnSourceKey, AuthenticationSelectorContext authnSelectorContext) {
    }

    public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse resp, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
        AuthenticationSelectorContext context = new AuthenticationSelectorContext();
        context.setResultType(AuthenticationSelectorContext.ResultType.CONTEXT);
        if (NODE_INDEX.equals(this.nodeProperty)) {
            this.selectNodeIndexContext(context);
        } else if (NODE_TAG.equals(this.nodeProperty)) {
            this.selectNodeTagContext(context, extraParameters);
        }
        if (context.getResult() == null) {
            if (this.noMatchResultEnabled) {
                context.setResult(this.getNoMatchResult());
            }
            if (log.isDebugEnabled()) {
                log.debug("No matching node result found for node property (" + this.nodeProperty + ")");
            }
        }
        return context;
    }

    private void selectNodeTagContext(AuthenticationSelectorContext context, Map<String, Object> extraParameters) {
        String id = (String)extraParameters.get("com.pingidentity.adapter.extra.parameter.instanceid");
        ConfigurablePluginInstance instance = this.authnSelectorManager.getInstance(id);
        Set results = instance.getExtendedContractAttributes();
        for (String nodeTag : PropertyInfo.getPingFederateNodeTags()) {
            if (!results.contains(nodeTag)) continue;
            log.debug("Cluster selector result for (Node Tag): " + nodeTag);
            context.setResult(nodeTag);
            break;
        }
    }

    private void selectNodeIndexContext(AuthenticationSelectorContext context) {
        String nodeIndex = Integer.toString(ClusterAccessor.getNodeIndex());
        if (this.values.contains(nodeIndex)) {
            log.debug("Cluster selector result for (Node Index): " + nodeIndex);
            context.setResult(nodeIndex);
        }
    }

    private String getNoMatchResult() {
        if (this.noMatchResultEnabled) {
            return NO_MATCH_RESULT_VALUE;
        }
        return null;
    }

    public PluginApiSpec getApiSpec() {
        return null;
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return new AuthnApiPluginDescriptor.Builder().interactive(false).build();
    }

    private static class ClusterNodeAdapterSelectorValidator
    implements ConfigurationValidator {
        private static final String VALIDATION_ERROR_NO_MATCH_RESERVED = "'" + NO_MATCH_RESULT_VALUE + "' is a reserved result value. Please remove the problematic result value or disable the option.";

        private ClusterNodeAdapterSelectorValidator() {
        }

        public void validate(Configuration configuration) throws ValidationException {
            if (configuration == null) {
                return;
            }
            boolean noMatchEnabled = configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME);
            ArrayList<String> errors = new ArrayList<String>();
            if (noMatchEnabled && configuration.getAdditionalAttrNames().stream().anyMatch(result -> NO_MATCH_RESULT_VALUE.equalsIgnoreCase((String)result))) {
                errors.add(VALIDATION_ERROR_NO_MATCH_RESERVED);
            }
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }
    }

    private static class ClusterNodeAdapterSelectorDescriptor
    extends AuthenticationSelectorDescriptor {
        public ClusterNodeAdapterSelectorDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptor guiConfigDesc, Set<String> results, String version) {
            super(type, plugin, guiConfigDesc, results, version);
        }

        public List<String> getAdditionalResults(Configuration configuration) {
            ArrayList<String> results = new ArrayList<String>();
            if (configuration.getBooleanFieldValue(NO_MATCH_RESULT_ENABLED_FIELD_NAME)) {
                results.add(NO_MATCH_RESULT_VALUE);
            }
            return results;
        }

        public boolean isSortConfigurationAttributes(Configuration configuration) {
            return true;
        }
    }
}

