/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.dynamo;

import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamoDBConfiguration {
    private static final Log log = LogFactory.getLog(DynamoDBConfiguration.class);
    private final long apiCallTimeout;
    private final long apiCallAttemptTimeout;
    private final String endpointOverride;

    public DynamoDBConfiguration(long apiCallTimeout, long apiCallAttemptTimeout, String endpointOverride) {
        this.apiCallTimeout = apiCallTimeout;
        this.apiCallAttemptTimeout = apiCallAttemptTimeout;
        this.endpointOverride = endpointOverride;
    }

    public long getApiCallTimeout() {
        return this.apiCallTimeout;
    }

    public long getApiCallAttemptTimeout() {
        return this.apiCallAttemptTimeout;
    }

    public String getEndpointOverride() {
        return this.endpointOverride;
    }

    public static int getBatchSize(int defaultBatchSize, int configuredBatchSize) {
        int batchSize;
        if (configuredBatchSize < 1 || configuredBatchSize > 100) {
            batchSize = defaultBatchSize;
            log.warn((Object)("Invalid batch size: " + configuredBatchSize + ". Using default batch size of " + defaultBatchSize + ". DynamoDB batch size should be greater than 0 and less than 100."));
        } else {
            batchSize = configuredBatchSize;
        }
        return batchSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamoDBConfiguration other = (DynamoDBConfiguration)o;
        if (this.apiCallTimeout != other.apiCallTimeout) {
            return false;
        }
        if (this.apiCallAttemptTimeout != other.apiCallAttemptTimeout) {
            return false;
        }
        return Objects.equals(this.endpointOverride, other.endpointOverride);
    }

    public int hashCode() {
        return Objects.hash(this.apiCallTimeout, this.apiCallAttemptTimeout, this.endpointOverride);
    }
}

