/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.email;

import com.pingidentity.pf.email.EmailUtilSystemSettings;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class EmailSettings {
    private String templateFile;
    private Map<String, String> params;
    private String sendTo = "";
    private Locale locale;
    private int sendAttemptCount = 0;
    private long sendAfter = 0L;
    private EmailUtilSystemSettings emailSystemSettings;
    private boolean sendNotification = false;
    public static final String BASE_URL = "BASE_URL";
    public static final String COMPANY_LOGO_EXISTS = "COMPANY_LOGO_EXISTS";
    public static final String ADAPTER_ID = "ADAPTER_ID";
    public static final String PCV_ID = "PCV_ID";

    public EmailSettings(String templateFile, String sendTo, boolean sendNotification, long sendAfter, Locale locale, EmailUtilSystemSettings emailSenderSettings, Map<String, String> params) {
        this.locale = locale;
        this.sendAfter = sendAfter;
        this.init(templateFile, sendTo, sendNotification, emailSenderSettings, params);
    }

    public EmailSettings(String templateFile, String sendTo, boolean sendNotification, Locale locale, EmailUtilSystemSettings emailSenderSettings, Map<String, String> params) {
        this.locale = locale;
        this.init(templateFile, sendTo, sendNotification, emailSenderSettings, params);
    }

    public EmailSettings(String templateFile, String sendTo, boolean sendNotification, EmailUtilSystemSettings emailSystemSettings, Map<String, String> params) {
        this.init(templateFile, sendTo, sendNotification, emailSystemSettings, params);
    }

    private void init(String templateFile, String sendTo, boolean sendNotification, EmailUtilSystemSettings emailSystemSettings, Map<String, String> params) {
        this.templateFile = templateFile;
        this.sendTo = sendTo;
        this.emailSystemSettings = emailSystemSettings;
        this.params = params;
        this.sendAfter = new Date().getTime();
        this.sendNotification = sendNotification;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getSendTo() {
        return this.sendTo;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getSendAttemptCount() {
        return this.sendAttemptCount;
    }

    public EmailUtilSystemSettings getEmailSystemSettings() {
        return this.emailSystemSettings;
    }

    public long getSendAfter() {
        return this.sendAfter;
    }

    public void setTemplateFile(String templateFile) {
        this.templateFile = templateFile;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setSendTo(String sendTo) {
        this.sendTo = sendTo;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setSendAttemptCount(int sendAttemptCount) {
        this.sendAttemptCount = sendAttemptCount;
    }

    public void setSendAfter(long sendAfter) {
        this.sendAfter = sendAfter;
    }

    public void setEmailSystemSettings(EmailUtilSystemSettings emailSystemSettings) {
        this.emailSystemSettings = emailSystemSettings;
    }

    public boolean isSendNotification() {
        return this.sendNotification;
    }

    public void setSendNotification(boolean sendNotification) {
        this.sendNotification = sendNotification;
    }
}

