/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.email.util;

import com.pingidentity.common.util.EscapeUtils;
import com.pingidentity.pf.email.EmailServerSettings;
import com.pingidentity.pf.email.EmailUtilSystemSettings;
import com.pingidentity.pf.email.lang.EmailLanguagePackMessages;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.sourceid.common.StringSubstituter;

public class EmailUtil {
    private static final String MESSAGE_TEMPLATE_TEST_HTML = "message-template-test.html";
    private static Log log = LogFactory.getLog(EmailUtil.class);
    private final EmailUtilSystemSettings emailSystemSettings;
    private final EscapeUtils escapeUtils = new EscapeUtils();

    public EmailUtil(EmailUtilSystemSettings emailSystemSettings) {
        this.emailSystemSettings = emailSystemSettings;
    }

    public boolean sendTestEmail(EmailServerSettings settings, String sendTo, Map<String, Object> params) {
        EmailServerSettings emailSettings = settings.clone();
        emailSettings.setEnableEmailNotification(true);
        return this.sendEmail(MESSAGE_TEMPLATE_TEST_HTML, params, emailSettings, sendTo);
    }

    public boolean sendEmail(String templateFile, Map<String, Object> values, EmailServerSettings settings, String sendTo) {
        return this.sendEmail(templateFile, values, settings, null, sendTo);
    }

    public boolean sendEmail(String templateFile, Map<String, Object> params, EmailServerSettings notificationSettings, Locale locale, String sendTo) {
        String emailSubject = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        EmailLanguagePackMessages emailLanguagePack = this.emailSystemSettings.getEmailLanguagePackMessages(locale);
        String content = this.loadTemplate(templateFile, params, locale, emailLanguagePack);
        try {
            String message = emailLanguagePack.getMessage(templateFile);
            emailSubject = StringSubstituter.substituteValuesTolarateUnkownKey((String)message, params);
        }
        catch (Exception e) {
            log.error((Object)("Unable to read and substitute email subject for template " + templateFile + ". " + e));
        }
        boolean success = this.emailSystemSettings.getSender().sendNotification(sendTo, emailSubject, content, notificationSettings, this.emailSystemSettings.getTrustManagers());
        return success;
    }

    private String loadTemplate(String templateFile, Map<String, Object> params, Locale locale, EmailLanguagePackMessages emailLanguagePack) {
        String string;
        VelocityContext context = new VelocityContext(params, this.emailSystemSettings.getVelocityToolsContext());
        context.put("params", params);
        context.put("escape", (Object)this.escapeUtils);
        context.put("locale", (Object)locale);
        context.put("templateMessages", (Object)emailLanguagePack);
        StringWriter sw = new StringWriter();
        try {
            Template template = this.emailSystemSettings.getVelocityEngine().getTemplate(templateFile, "UTF-8");
            if (template != null) {
                template.merge((Context)context, (Writer)sw);
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error((Object)("Problem loading template file: " + templateFile), (Throwable)e);
                return "";
            }
        }
        sw.close();
        return string;
    }
}

