/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.email.util;

import com.pingidentity.pf.email.EmailServerSettings;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SmtpUtil {
    private static final Log log = LogFactory.getLog(SmtpUtil.class);
    private static final String DEFAULT_SMTP_PORT = "465";
    private static final int MILLISECONDS_IN_SECOND = 1000;

    SmtpUtil() {
    }

    public boolean sendEmail(final EmailServerSettings settings, String sendTo, String subject, String message, TrustManager[] trustManagers) {
        Authenticator auth = null;
        Properties props = new Properties();
        if (settings.isUseDebugging()) {
            props.put("mail.debug", "true");
        }
        props.put("mail.smtp.host", settings.getSmtpServer());
        props.put("mail.smtp.port", settings.getSmtpPort());
        props.put("mail.mime.charset", "utf-8");
        String timeoutMsStr = "30000";
        try {
            timeoutMsStr = String.valueOf(Integer.parseInt(settings.getTimeout()) * 1000);
        }
        catch (NumberFormatException e) {
            log.debug((Object)"Unable to set configured smtp time, defaulting to 30s");
        }
        props.put("mail.smtp.connectiontimeout", timeoutMsStr);
        props.put("mail.smtp.timeout", timeoutMsStr);
        props.put("mail.smtp.writetimeout", timeoutMsStr);
        if (settings.isAllowUtf8MsgHeaders()) {
            props.put("mail.mime.allowutf8", "true");
        }
        if (StringUtils.isNotBlank((String)settings.getUser()) && StringUtils.isNotBlank((String)settings.getPassword())) {
            props.put("mail.smtp.auth", "true");
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(settings.getUser(), settings.getPassword());
                }
            };
        }
        if (settings.isUseSSL() || settings.isUseTLS()) {
            if (settings.isUseSSL()) {
                props.put("mail.smtp.ssl.enable", "true");
            } else if (settings.isUseTLS()) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            if (StringUtils.isNotBlank((String)settings.getSslSmtpPort())) {
                props.put("mail.smtp.ssl.socketFactory.port", settings.getSslSmtpPort());
            } else {
                props.put("mail.smtp.ssl.socketFactory.port", DEFAULT_SMTP_PORT);
            }
            if (settings.isVerifyHostname()) {
                props.put("mail.smtp.ssl.checkserveridentity", (Object)true);
            }
            props.put("mail.smtp.socketFactory.fallback", (Object)false);
            props.put("mail.smtp.ssl.socketFactory", this.getSSLSocketFactory(trustManagers));
        }
        Session session = Session.getInstance((Properties)props, auth);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(settings.getFrom(), settings.getSender()));
            msg.setSubject(subject, StandardCharsets.UTF_8.name());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(message, StandardCharsets.UTF_8.name(), "html");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
            msg.setSentDate(new Date());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)sendTo, (boolean)false));
            Transport.send((Message)msg);
            log.debug((Object)("Email notification with subject '" + subject + "' has been sent to " + sendTo));
            return true;
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            log.error((Object)("Unable to send email notification with subject '" + subject + "' to " + sendTo), e);
            return false;
        }
    }

    private SSLSocketFactory getSSLSocketFactory(TrustManager[] trustManagers) {
        SSLSocketFactory sslSocketFactory;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, null);
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error creating SSL socket factory for SMTP", e);
        }
        return sslSocketFactory;
    }
}

