/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingid;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ConnectionFieldKey;
import com.pingidentity.integrations.provisioner.pingidforworkforce.ProvisionerInformationKey;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.pingid.PingIdInitialSetupAdminService;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.pingone.impl.ProvisioningConfigHelper;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMapping;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.mgmt.FieldInfoManager;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.templates.mgmt.SaaSLdapTemplateFileManager;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ProvisioningParameters;

public class PingIdSpConnectionBuilder {
    private static final Log log = LogFactory.getLog(ProvisioningConfigHelper.class);
    private final PingOneAdminService pingOneService = MgmtFactory.getPingOneAdminService();
    public static final String CONNECTOR_TYPE_NAME = ProvisionerInformationKey.PROVISIONER_INFORMATION.getKey();
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private final PingIdInitialSetupAdminService pingIdInitialSetupAdminService = MgmtFactory.getPingIdInitialSetupAdminService();
    private ProvisioningParameters provisioningParams;
    private SpConnection connection;

    public PingIdSpConnectionBuilder(ProvisioningParameters parameters, SpConnection templateSpConnection) {
        this.connection = templateSpConnection;
        if (this.connection != null) {
            this.connection.setActive(true);
            this.provisioningParams = parameters;
            this.createProvisioningConnection(this.connection, this.provisioningParams);
        }
    }

    public void createProvisioningConnection(SpConnection spConnection, ProvisioningParameters provisioningParams) {
        log.debug((Object)("Adding provisioning configuration to SP connection " + spConnection.getEntityId()));
        ConnectionModuleSupport runtimeModuleSupport = ConnectionModuleSupport.getInstance();
        ProvisionerConfig provisionerConfig = (ProvisionerConfig)runtimeModuleSupport.createNewConfiguration("SaasProvisioner", spConnection.getRoleType());
        if (provisionerConfig == null) {
            throw new RuntimeException("Failed to create configuration object for connection module SaasProvisioner");
        }
        provisionerConfig.setType(CONNECTOR_TYPE_NAME);
        provisionerConfig.setEntityId(spConnection.getEntityId());
        if (provisioningParams != null && provisioningParams.getLdapDataSource() != null) {
            SaasTarget saasTarget = this.makeSaasTarget();
            provisionerConfig.setTarget(saasTarget);
            Channel channel = this.makeChannel(provisioningParams, saasTarget);
            provisionerConfig.addChannel(channel);
        }
        spConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)provisionerConfig);
    }

    private SaasTarget makeSaasTarget() {
        SaasPluginManager pluginManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin plugin = pluginManager.getPluginInstance(CONNECTOR_TYPE_NAME);
        ArrayList<Field> fields = new ArrayList<Field>();
        SaasTarget target = new SaasTarget(CONNECTOR_TYPE_NAME, new SimpleFieldList(fields));
        Map<String, String> targetValues = this.getTargetValueMap();
        for (FieldDescriptor desc : plugin.getParameterDescriptors()) {
            String name = desc.getName();
            String label = desc.getLabel();
            if (targetValues.containsKey(name)) {
                fields.add(new Field(name, label, targetValues.get(name)));
                continue;
            }
            fields.add(new Field(name, label, desc.getDefaultValue()));
        }
        target.setParameterValues(new SimpleFieldList(fields));
        return target;
    }

    private Map<String, String> getTargetValueMap() {
        HashMap<String, String> targetFieldValues = new HashMap<String, String>();
        try {
            Properties props = new Properties();
            String pingIdProperties = this.pingOneService.downloadPingIdProperties();
            props.load(new StringReader(pingIdProperties));
            URL idpUrl = new URL(props.getProperty("idp_url"));
            targetFieldValues.put(ConnectionFieldKey.DOMAIN.getKey(), idpUrl.getHost());
            targetFieldValues.put(ConnectionFieldKey.BASE64_KEY.getKey(), props.getProperty("use_base64_key"));
            targetFieldValues.put(ConnectionFieldKey.ORG_ALIAS.getKey(), props.getProperty("org_alias"));
            targetFieldValues.put(ConnectionFieldKey.TOKEN.getKey(), props.getProperty("token"));
            targetFieldValues.put("PingID Properties", Obfuscator.obfuscate((String)pingIdProperties));
        }
        catch (IOException e) {
            log.error((Object)("Unable to download and parse pingid.properties file." + e.getMessage()));
            log.debug((Object)e.getStackTrace());
        }
        return targetFieldValues;
    }

    private String getLdapTypeDescription(ProvisioningParameters provisioningParams) {
        LdapInfo.LdapType ldapType = provisioningParams.getLdapDataSource().getLdapType();
        String ldapTypeDesc = ldapType.getDescription();
        if (ldapType == LdapInfo.LdapType.SunDirectoryServer) {
            ldapTypeDesc = "Oracle Directory Server";
        }
        return ldapTypeDesc;
    }

    private Channel makeChannel(ProvisioningParameters provisioningParams, SaasTarget target) {
        Channel channel = new Channel("Channel 1");
        SaaSLdapTemplateFileManager templateMgr = SaaSLdapTemplateFileManager.getInstance();
        LdapDataSource datasource = provisioningParams.getLdapDataSource();
        String ldapDesc = this.getLdapTypeDescription(provisioningParams);
        Properties properties = templateMgr.getSaaSLdapTemplateProperties(ldapDesc);
        if (properties == null) {
            throw new RuntimeException("Cannot find SaaS LDAP template");
        }
        ChannelSource source = ChannelSource.Factory.newInstance((Properties)properties);
        source.setDataSourceId(datasource.getId());
        source.setUserBaseDN(provisioningParams.getBaseDn());
        source.setGroupDNForUsers(provisioningParams.getGroupDnForUsers());
        source.setUserNestedSearch(provisioningParams.isNestedGroupsForUsers());
        channel.setSource(source);
        try {
            String usernameFieldCode = FieldInfoManager.getInstance().getSaasUsernameFieldCode(target);
            channel.setSaasUsernameFieldCode(usernameFieldCode);
            if (LdapInfo.LdapType.ActiveDirectory == datasource.getLdapType()) {
                channel.setidentityMapping(IdentityMapping.getDefaultIdentityMapping((String)datasource.getLdapType().name(), (SaasTarget)target));
            } else {
                List activeDirMapping = IdentityMapping.getDefaultIdentityMapping((String)LdapInfo.LdapType.ActiveDirectory.name(), (SaasTarget)target);
                for (IdentityMappingField field : activeDirMapping) {
                    if (!field.getFieldInfo().getCode().equals(usernameFieldCode)) continue;
                    field.getFieldConfig().clearAttributeNames();
                    field.getFieldConfig().addAttributeName("uid");
                }
                channel.setidentityMapping(activeDirMapping);
            }
        }
        catch (SaasException e) {
            throw new RuntimeException("Unexpected error retrieving field info from provisioning target: " + e, e);
        }
        channel.setActive(true);
        return channel;
    }

    public void save() {
        log.debug((Object)"Saving populated SP Connection");
        this.connection.setCreationTime((Calendar)new XmlCalendar(new Date()));
        this.connectionManager.saveSpConnection(this.connection);
        this.pingIdInitialSetupAdminService.saveProvisioningConnectionId(this.connection.getId());
    }
}

