/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.crypto.jws.JwsSignatureUtil;
import com.pingidentity.pingcommons.crypto.B64;
import com.pingidentity.pingone.api.AccessTokenResponse;
import com.pingidentity.pingone.api.IdpConfig;
import com.pingidentity.pingone.api.LicenseResponse;
import com.pingidentity.pingone.api.OpenIdConfiguration;
import com.pingidentity.pingone.api.PingDockInfo;
import com.pingidentity.pingone.api.PingOneAdminApiException;
import com.pingidentity.pingone.api.PingOneClientInfo;
import com.pingidentity.pingone.api.PingOneOAuthClientInfo;
import com.pingidentity.pingone.api.RegisterClientRequest;
import com.pingidentity.pingone.impl.AccessTokenHolder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.util.ObjectMapperFactory;

public class PingOneAdminApiClient
implements AutoCloseable {
    public static final String PROFILE_CDP = "cdp";
    public static final String PROFILE_PRV = "prv";
    public static final String WEBPORTAL_DESKTOP_URLPATTERN = "webportal.desktop.urlpattern";
    public static final String PROVISIONING_BASE_URL = "provisioning.baseurl";
    public static final String ALL_CLIENTS_ENDPOINT = "/as/clients";
    public static final String ALL_OAUTH_CLIENTS_ENDPOINT = "/as/clients/oauth";
    public static final String CLIENT_ENDPOINT = "/as/clients/%s";
    public static final String OAUTH_CLIENT_ENDPOINT = "/as/clients/%s/oauth";
    public static final String TOKEN_ENDPOINT = "/as/token.oauth2";
    public static final String JWKS_ENDPOINT = "/jwks";
    public static final String ACCOUNTS_ENDPOINT = "/accounts";
    public static final String LICENSE_ENDPOINT = "/accounts/%s/licenses/pingfederate/%s";
    public static final String IDENTITY_BRIDGES_ENDPOINT = "/identitybridges";
    public static final String IDP_METADATA_ENDPOINT = "/identitybridges/%s/pingfederate/metadata";
    public static final String SP_DEFAULT_METADATA_ENDPOINT = "/identitybridges/%s/samlsp/defaultmetadata";
    public static final String SP_METADATA_ENDPOINT = "/identitybridges/%s/samlsp/metadata";
    public static final String IDP_CONFIGS_ENDPOINT = "/accounts/%s/idpconfigs";
    public static final String PING_DOCK_ENDPOINT = "/pingdock/%s";
    public static final String OPENID_CONFIGURATION_ENDPOINT = "/.well-known/openid-configuration";
    public static final String PING_PID_PROPERTIES_ENDPOINT = "/pingid/%s/settingsfile";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "application/xml";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String METADATA_XML = "metadataXml";
    private static final String PROVISIONING_USERNAME = "provisioningUsername";
    private static final String PROVISIONING_PASSWORD = "provisioningPassword";
    private static final String PROFILE = "profile";
    private static Log log = LogFactory.getLog(PingOneAdminApiClient.class);
    private ObjectMapper mapper;
    private PkCert keyPair;
    private AccessTokenHolder accessTokenHolder;
    private CloseableHttpClient httpClient;
    private RequestConfig requestConfig;
    private String clientId;
    private String accountId;
    private ClientOptions clientOptions = new ClientOptions();

    public PingOneAdminApiClient(AccessTokenHolder accessTokenHolder) {
        this.accessTokenHolder = accessTokenHolder;
        this.mapper = ObjectMapperFactory.buildLowerCaseWithUnderscoresObjectMapper();
    }

    public PingOneAdminApiClient(AccessTokenHolder accessTokenHolder, PkCert keyPair, String accountId, String clientId) {
        this(accessTokenHolder);
        this.keyPair = keyPair;
        this.accountId = accountId;
        this.clientId = clientId;
    }

    public void setClientOptions(ClientOptions options) {
        this.clientOptions = options;
    }

    public void initialize() {
        this.requestConfig = RequestConfig.custom().setConnectTimeout(this.clientOptions.getConnTimeoutMillis()).setConnectionRequestTimeout(this.clientOptions.getConnTimeoutMillis()).setSocketTimeout(this.clientOptions.getConnTimeoutMillis()).setStaleConnectionCheckEnabled(false).build();
        this.httpClient = this.makeHttpClient();
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            log.debug((Object)("Error closing HTTP client instance: " + e));
        }
    }

    public PingOneOAuthClientInfo registerOAuthClient(String initialAccessToken, String initiateLoginUri, List<PkCert> keyPairs) throws IOException {
        if (keyPairs == null || keyPairs.size() < 1) {
            throw new IllegalArgumentException("You must provide at least one authentication key pair");
        }
        this.keyPair = keyPairs.get(0);
        RegisterClientRequest request = this.makeRegisterClientRequest(initiateLoginUri, keyPairs);
        String body = this.mapper.writeValueAsString((Object)request);
        String response = this.postJson(this.makeApiEndpoint(ALL_OAUTH_CLIENTS_ENDPOINT, new String[0]), body, initialAccessToken, false);
        PingOneOAuthClientInfo clientInfo = (PingOneOAuthClientInfo)this.mapper.readValue(response, PingOneOAuthClientInfo.class);
        this.clientId = clientInfo.getClientId();
        this.accountId = clientInfo.getCustomerUuid();
        return clientInfo;
    }

    public void unregisterClient() throws IOException {
        this.checkClientRegistered();
        HttpDelete delete = new HttpDelete(this.makeApiEndpoint(CLIENT_ENDPOINT, this.clientId));
        this.doRequest((HttpRequestBase)delete, null, this.getAccessToken(false), true);
        this.clientId = null;
        this.accountId = null;
        this.keyPair = null;
    }

    public OpenIdConfiguration getOpenIdConfiguration() throws IOException {
        HttpGet httpGet = new HttpGet(this.makeApiEndpoint(OPENID_CONFIGURATION_ENDPOINT, this.clientId));
        String response = this.doRequest((HttpRequestBase)httpGet, APPLICATION_JSON, null, false);
        OpenIdConfiguration opendIdConfig = (OpenIdConfiguration)this.mapper.readValue(response, OpenIdConfiguration.class);
        return opendIdConfig;
    }

    public PingOneClientInfo getClient() throws IOException {
        this.checkClientRegistered();
        HttpGet httpGet = new HttpGet(this.makeApiEndpoint(CLIENT_ENDPOINT, this.clientId));
        String response = this.doRequest((HttpRequestBase)httpGet, APPLICATION_JSON, this.getAccessToken(false), true);
        PingOneClientInfo clientInfo = (PingOneClientInfo)this.mapper.readValue(response, PingOneClientInfo.class);
        return clientInfo;
    }

    public PingOneOAuthClientInfo updateOAuthClient(String initiateLoginUri, List<PkCert> keyPairs) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating OAuth client, key pairs=" + keyPairs.stream().map(Cert::getAlias).collect(Collectors.joining(","))));
        }
        this.checkClientRegistered();
        RegisterClientRequest request = this.makeRegisterClientRequest(initiateLoginUri, keyPairs);
        String body = this.mapper.writeValueAsString((Object)request);
        String response = this.putJson(this.makeApiEndpoint(OAUTH_CLIENT_ENDPOINT, this.clientId), body, this.getAccessToken(false), true);
        PingOneOAuthClientInfo clientInfo = (PingOneOAuthClientInfo)this.mapper.readValue(response, PingOneOAuthClientInfo.class);
        return clientInfo;
    }

    public IdpConfig getIdpConfig(String profileName) throws IOException {
        this.checkClientRegistered();
        try {
            URI uri = new URIBuilder(this.makeApiEndpoint(IDP_CONFIGS_ENDPOINT, this.accountId)).addParameter(PROFILE, profileName).build();
            HttpGet httpGet = new HttpGet(uri);
            String response = this.doRequest((HttpRequestBase)httpGet, APPLICATION_JSON, this.getAccessToken(false), true);
            ObjectMapper camelCaseMapper = ObjectMapperFactory.buildCamelCaseObjectMapper();
            IdpConfig idpConfig = (IdpConfig)camelCaseMapper.readValue(response, IdpConfig.class);
            return idpConfig;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected error downloading IdP config", e);
        }
    }

    public PingDockInfo getPingDockInfo() throws IOException {
        this.checkClientRegistered();
        HttpGet httpGet = new HttpGet(this.makeApiEndpoint(PING_DOCK_ENDPOINT, this.accountId));
        String response = this.doRequest((HttpRequestBase)httpGet, APPLICATION_JSON, this.getAccessToken(false), true);
        ObjectMapper camelCaseMapper = ObjectMapperFactory.buildCamelCaseObjectMapper();
        PingDockInfo pingDockInfo = (PingDockInfo)camelCaseMapper.readValue(response, PingDockInfo.class);
        return pingDockInfo;
    }

    public String downloadDefaultSpMetadata() throws IOException {
        this.checkClientRegistered();
        HttpGet httpGet = new HttpGet(this.getDefaultSpMetadataEndpoint());
        return this.doRequest((HttpRequestBase)httpGet, APPLICATION_XML, this.getAccessToken(false));
    }

    public String downloadAccountSpecificSpMetadata() throws IOException {
        this.checkClientRegistered();
        HttpGet httpGet = new HttpGet(this.getAccountSpecificSpMetadataEndpoint());
        return this.doRequest((HttpRequestBase)httpGet, APPLICATION_XML, this.getAccessToken(false));
    }

    public String getDefaultSpMetadataEndpoint() {
        return this.makeApiEndpoint(SP_DEFAULT_METADATA_ENDPOINT, this.accountId);
    }

    public String getAccountSpecificSpMetadataEndpoint() {
        return this.makeApiEndpoint(SP_METADATA_ENDPOINT, this.accountId);
    }

    public void uploadIdpMetadata(String metadata, String provisioningUsername, String provisioningPassword) throws IOException {
        this.checkClientRegistered();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(METADATA_XML, metadata));
        if (provisioningUsername != null && provisioningPassword != null) {
            params.add(new BasicNameValuePair(PROVISIONING_USERNAME, provisioningUsername));
            params.add(new BasicNameValuePair(PROVISIONING_PASSWORD, provisioningPassword));
        }
        HttpPost post = new HttpPost(this.makeApiEndpoint(IDP_METADATA_ENDPOINT, this.accountId));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        post.setEntity((HttpEntity)entity);
        this.doRequest((HttpRequestBase)post, null, this.getAccessToken(false));
    }

    public String downloadLicense() throws IOException {
        this.checkClientRegistered();
        String pfVersion = this.getMajorMinorVersion(PropertyInfo.getPingFederateVersion());
        HttpGet httpGet = new HttpGet(this.makeApiEndpoint(LICENSE_ENDPOINT, this.accountId, pfVersion));
        String response = this.doRequest((HttpRequestBase)httpGet, APPLICATION_JSON, this.getAccessToken(false));
        LicenseResponse licenseResponse = (LicenseResponse)this.mapper.readValue(response, LicenseResponse.class);
        if (licenseResponse == null || StringUtils.isBlank((String)licenseResponse.getLicense())) {
            throw new PingOneAdminApiException("No license associated with this PingOne account.");
        }
        return new String(B64.decodeToBytes((String)licenseResponse.getLicense()), StandardCharsets.UTF_8);
    }

    public JsonWebKeySet getKeySet() throws IOException {
        this.checkClientRegistered();
        try {
            HttpGet httpGet = new HttpGet(this.clientOptions.getJwksUri());
            String response = this.doRequest((HttpRequestBase)httpGet, APPLICATION_JSON, null);
            return new JsonWebKeySet(response);
        }
        catch (JoseException e) {
            throw new RuntimeException("Unexpected error retrieving JWK set", e);
        }
    }

    private String getMajorMinorVersion(String pfVersion) {
        int firstDot = pfVersion.indexOf(46);
        if (firstDot < 0) {
            return pfVersion;
        }
        int secondDot = pfVersion.indexOf(46, firstDot + 1);
        if (secondDot < 0) {
            return pfVersion;
        }
        return pfVersion.substring(0, secondDot);
    }

    private void checkClientRegistered() {
        if (this.keyPair == null || this.clientId == null || this.accountId == null) {
            throw new IllegalStateException("To make API calls, you must either call registerClient() or provide a keyPair, clientId and accountId in the constructor");
        }
    }

    private String getAccessToken(boolean refresh) throws IOException {
        String result = this.accessTokenHolder.getAccessToken();
        if (result == null || refresh) {
            result = this.retrieveAccessToken();
            this.accessTokenHolder.setAccessToken(result);
        }
        return result;
    }

    private String retrieveAccessToken() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving access token using client authn key pair " + this.keyPair.getAlias()));
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        params.add(new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        params.add(new BasicNameValuePair("client_assertion", this.makeClientAuthenticationJwt()));
        params.add(new BasicNameValuePair(Parameters.CLIENT_ID, this.clientId));
        HttpPost post = new HttpPost(this.makeApiEndpoint(TOKEN_ENDPOINT, new String[0]));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        post.setEntity((HttpEntity)entity);
        String response = this.doRequest((HttpRequestBase)post, APPLICATION_JSON, null, false);
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)this.mapper.readValue(response, AccessTokenResponse.class);
        return accessTokenResponse.getAccessToken();
    }

    private String putJson(String resource, String json, String accessToken, boolean refreshAccessTokenIfNecessary) throws IOException {
        HttpPut put = new HttpPut(resource);
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        put.setEntity((HttpEntity)entity);
        return this.doRequest((HttpRequestBase)put, APPLICATION_JSON, accessToken, refreshAccessTokenIfNecessary);
    }

    private String postJson(String resource, String json, String accessToken, boolean refreshAccessTokenIfNecessary) throws IOException {
        HttpPost post = new HttpPost(resource);
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        return this.doRequest((HttpRequestBase)post, APPLICATION_JSON, accessToken, refreshAccessTokenIfNecessary);
    }

    private String doRequest(HttpRequestBase request, String acceptContentType, String accessToken) throws IOException {
        return this.doRequest(request, acceptContentType, accessToken, true);
    }

    private String doRequest(HttpRequestBase request, String acceptContentType, String accessToken, boolean refreshAccessTokenIfNecessary) throws IOException {
        log.debug((Object)("Sending " + request.getMethod() + " request to " + request.getURI()));
        request.setConfig(this.requestConfig);
        if (acceptContentType != null) {
            this.addAcceptHeader(request, acceptContentType);
        }
        this.addAdditionalHeaders(request);
        if (accessToken != null) {
            this.setRequestAccessToken(request, accessToken);
        }
        boolean done = false;
        int statusCode = 0;
        String responseString = null;
        while (!done) {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            responseString = null;
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseString = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            }
            if (((statusCode = response.getStatusLine().getStatusCode()) == 401 || statusCode == 403) && accessToken != null && refreshAccessTokenIfNecessary) {
                log.debug((Object)("Service returned " + statusCode + ", refreshing access token"));
                refreshAccessTokenIfNecessary = false;
                accessToken = this.getAccessToken(true);
                this.setRequestAccessToken(request, accessToken);
                continue;
            }
            done = true;
        }
        if (statusCode / 100 != 2) {
            String message = request.getMethod() + " request to " + request.getURI() + " returned " + statusCode + ": " + responseString;
            log.debug((Object)message);
            throw new PingOneAdminApiException(message, statusCode);
        }
        log.debug((Object)(request.getMethod() + " request to " + request.getURI() + " returned " + statusCode));
        return responseString;
    }

    private RegisterClientRequest makeRegisterClientRequest(String initiateLoginUri, Collection<PkCert> keyPairs) {
        RegisterClientRequest request = new RegisterClientRequest();
        request.setInitiateLoginUri(initiateLoginUri);
        try {
            ArrayList<Map<String, Object>> jwks = new ArrayList<Map<String, Object>>();
            for (PkCert pkCert : keyPairs) {
                PublicKey publicKey = pkCert.getX509Certificate().getPublicKey();
                JsonWebKey jwk = JsonWebKey.Factory.newJwk((Key)publicKey);
                jwk.setKeyId(pkCert.getAlias());
                jwk.setUse("sig");
                jwk.setAlgorithm("RS256");
                Map jwkJsonObj = jwk.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
                jwks.add(jwkJsonObj);
            }
            request.setJwks(jwks);
        }
        catch (JoseException e) {
            throw new RuntimeException("Unexpected error building PingOne registration request", e);
        }
        return request;
    }

    private void addAcceptHeader(HttpRequestBase request, String contentType) {
        request.addHeader("Accept", contentType);
    }

    private void addAdditionalHeaders(HttpRequestBase request) {
        request.addHeader("Connection", "Keep-Alive");
    }

    private void setRequestAccessToken(HttpRequestBase request, String accessToken) {
        request.setHeader("Authorization", "Bearer " + accessToken);
    }

    private String makeClientAuthenticationJwt() {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(this.clientId);
            claims.setSubject(this.clientId);
            claims.setStringListClaim("aud", Arrays.asList(this.clientOptions.getClientAuthnTokenAudience()));
            NumericDate issuedAt = NumericDate.fromMilliseconds((long)(System.currentTimeMillis() - 30000L));
            claims.setIssuedAt(issuedAt);
            claims.setExpirationTimeMinutesInTheFuture((float)this.clientOptions.getClientAuthnTokenLifetimeMins());
            claims.setGeneratedJwtId();
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)this.keyPair.getPrivateKey());
            jws.setKeyIdHeaderValue(this.keyPair.getAlias());
            jws.setAlgorithmHeaderValue("RS256");
            JwsSignatureUtil.applyProviderOverrideContextIfNeeded((JsonWebSignature)jws, (PkCert)this.keyPair);
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new RuntimeException("Unexpected error generating client authentication JWT", e);
        }
    }

    public String getPingIdPropertiesFileEndpoint() {
        return this.makeApiEndpoint(PING_PID_PROPERTIES_ENDPOINT, this.accountId);
    }

    public String downloadPingIdPropertiesFile() throws IOException {
        this.checkClientRegistered();
        HttpGet httpGet = new HttpGet(this.getPingIdPropertiesFileEndpoint());
        return this.doRequest((HttpRequestBase)httpGet, TEXT_PLAIN, this.getAccessToken(false));
    }

    private CloseableHttpClient makeHttpClient() {
        try {
            TrustManager[] trustMgrArray = new TrustManager[]{PingSslClientTrustManager.getInstance()};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustMgrArray, SecurityProviderUtil.getSecureRandom());
            X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER;
            if (this.clientOptions.isDisableHostnameVerification()) {
                hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).useSystemProperties().setUserAgent("PingFederate").build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected error creating HTTP client", e);
        }
    }

    private String makeApiEndpoint(String relativeEndpoint, String ... params) {
        if (params.length == 0) {
            return this.clientOptions.getBaseUrl() + relativeEndpoint;
        }
        return String.format(this.clientOptions.getBaseUrl() + relativeEndpoint, params);
    }

    public static class ClientOptions {
        private String baseUrl = "https://admin-api.pingone.com/v3";
        private int connTimeoutMillis = 10000;
        private int clientAuthnTokenLifetimeMins = 10;
        private String clientAuthnTokenAudience = "https://admin.pingone.com";
        private String jwksUri = this.baseUrl + "/jwks";
        private boolean disableHostnameVerification = false;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public int getConnTimeoutMillis() {
            return this.connTimeoutMillis;
        }

        public void setConnTimeoutMillis(int connTimeoutMillis) {
            this.connTimeoutMillis = connTimeoutMillis;
        }

        public int getClientAuthnTokenLifetimeMins() {
            return this.clientAuthnTokenLifetimeMins;
        }

        public void setClientAuthnTokenLifetimeMins(int clientAuthnTokenLifetimeMins) {
            this.clientAuthnTokenLifetimeMins = clientAuthnTokenLifetimeMins;
        }

        public String getClientAuthnTokenAudience() {
            return this.clientAuthnTokenAudience;
        }

        public void setClientAuthnTokenAudience(String clientAuthnTokenAudience) {
            this.clientAuthnTokenAudience = clientAuthnTokenAudience;
        }

        public String getJwksUri() {
            return this.jwksUri;
        }

        public void setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
        }

        public boolean isDisableHostnameVerification() {
            return this.disableHostnameVerification;
        }

        public void setDisableHostnameVerification(boolean disableHostnameVerification) {
            this.disableHostnameVerification = disableHostnameVerification;
        }
    }
}

