/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.pingidentity.crypto.Password;
import org.sourceid.config.ConfigStore;

public class ConnectionFactoryLocalState {
    private static final String SIGNING_KEY_PAIR_ALIAS = "SigningKeyPairAlias";
    private static final String PROVISIONING_USERNAME = "ProvisioningUsername";
    private static final String ENCRYPTED_PROVISIONING_PASSWORD = "EncryptedProvisioningPassword";
    private static final String METADATA_UPLOAD_PENDING = "MetadataUploadPending";
    private ConfigStore configStore;

    public void clear() {
        this.configStore.startBatchUpdate();
        this.setSigningKeyPairAlias(null);
        this.setProvisioningUsername(null);
        this.setProvisioningPassword(null);
        this.setMetadataUploadPending(false);
        this.configStore.commitBatchUpdate();
    }

    public ConnectionFactoryLocalState(ConfigStore store) {
        this.configStore = store;
    }

    public String getSigningKeyPairAlias() {
        return this.configStore.getStringValue(SIGNING_KEY_PAIR_ALIAS, null);
    }

    public void setSigningKeyPairAlias(String signingKeyPairAlias) {
        this.configStore.setStringValue(SIGNING_KEY_PAIR_ALIAS, signingKeyPairAlias);
    }

    public String getProvisioningUsername() {
        return this.configStore.getStringValue(PROVISIONING_USERNAME, null);
    }

    public void setProvisioningUsername(String username) {
        this.configStore.setStringValue(PROVISIONING_USERNAME, username);
    }

    public String getEncryptedProvisioningPassword() {
        return this.configStore.getStringValue(ENCRYPTED_PROVISIONING_PASSWORD, null);
    }

    public void setEncryptedProvisioningPassword(String value) {
        this.configStore.setStringValue(ENCRYPTED_PROVISIONING_PASSWORD, value);
    }

    public String getProvisioningPassword() {
        String encrypted = this.getEncryptedProvisioningPassword();
        if (encrypted == null) {
            return null;
        }
        return Password.decodeAndDeobfuscate((String)encrypted);
    }

    public void setProvisioningPassword(String password) {
        if (password == null) {
            this.setEncryptedProvisioningPassword(null);
        } else {
            String encrypted = Password.obfuscateAndEncode((String)password);
            this.setEncryptedProvisioningPassword(encrypted);
        }
    }

    public boolean isMetadataUploadPending() {
        return this.configStore.getBooleanValue(METADATA_UPLOAD_PENDING, false);
    }

    public void setMetadataUploadPending(boolean pending) {
        this.configStore.setBooleanValue(METADATA_UPLOAD_PENDING, pending);
    }
}

