/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.pingone.api.PingOneAdminApiClient;
import com.pingidentity.pingone.api.PingOneAdminApiException;
import com.pingidentity.pingone.impl.PingOneAdminServiceImpl;
import com.pingidentity.pingone.impl.PingOneSpConnectionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MetadataSource;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.w3c.dom.Node;

public class PingOneMetadataSource
implements MetadataSource {
    public static final String ID = "2e7edf08-9f16-4fd7-9ade-4e99fd422bb5";
    private static final String GENERIC_URL = "https://admin-api.pingone.com";
    private PingOneAdminServiceImpl adminService;
    private PingOneSpConnectionFactory connFactory;

    public PingOneMetadataSource(PingOneAdminServiceImpl adminService, PingOneSpConnectionFactory connFactory) {
        this.adminService = adminService;
        this.connFactory = connFactory;
    }

    public String getId() {
        return ID;
    }

    public String getUrl() {
        if (this.adminService.isAssociated()) {
            PingOneAdminApiClient client = this.adminService.makeApiClient();
            try {
                String string = client.getAccountSpecificSpMetadataEndpoint();
                if (client != null) {
                    client.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PingOneAdminApiException pingOneAdminApiException) {
                    // empty catch block
                }
            }
        }
        return GENERIC_URL;
    }

    public String getName() {
        return "PingOne SP Connection Metadata";
    }

    public Collection<ConnectionBase> getConnectionsUsingSource() {
        SpConnection spConn;
        ArrayList<ConnectionBase> result = new ArrayList<ConnectionBase>();
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        if (metadataLocal.getEnableSaml20IdP() && (spConn = this.connFactory.getManagedSpConnection()) != null && spConn.isActive()) {
            result.add((ConnectionBase)spConn);
        }
        return result;
    }

    public XmlObject getMetadataXml() throws MetadataImportException {
        if (!this.connFactory.hasManagedSpConnection()) {
            throw new MetadataImportException("No managed SP connection to PingOne is currently configured");
        }
        PingOneAdminApiClient client = this.adminService.makeApiClient();
        try {
            Node node = XmlBeansUtil.parseToNode((String)client.downloadAccountSpecificSpMetadata());
            XmlObject xmlObject = XmlObject.Factory.parse((Node)node);
            if (client != null) {
                client.close();
            }
            return xmlObject;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException | XmlException e) {
                throw new MetadataImportException("Error retrieving SP metadata from PingOne", e);
            }
        }
    }

    public boolean isEnableBrowserSsoComparison() {
        return false;
    }

    public boolean isNotifyForDownloadErrors() {
        return false;
    }
}

