/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import com.pingidentity.pingone.api.PingOneAdminApiClient;
import com.pingidentity.pingone.api.PingOneAdminApiException;
import com.pingidentity.pingone.impl.ConnectionFactoryConfig;
import com.pingidentity.pingone.impl.ConnectionFactoryLocalState;
import com.pingidentity.pingone.impl.ExtendedMetadata;
import com.pingidentity.pingone.impl.PingOneAdminServiceImpl;
import com.pingidentity.pingone.impl.PingOneMetadataSource;
import com.pingidentity.pingone.impl.ProvisioningConfigHelper;
import com.pingidentity.provisioner.channel.runner.ProvisionerRunner;
import com.pingidentity.provisioner.domain.mgmt.SpringApplicationContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.config.ConfigFilePaths;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigStoreLocation;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IncomingBindings;
import org.sourceid.saml20.domain.KeyRotationSettings;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.ConnectionListener;
import org.sourceid.saml20.domain.mgmt.LocalSettingsListener;
import org.sourceid.saml20.domain.mgmt.MetadataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.MediatorListener;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.saml20.domain.util.MetadataImportException;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.service.ConnectionFactoryMetadata;
import org.sourceid.saml20.service.ProvisioningParameters;
import org.sourceid.saml20.service.ProvisioningTargetUrls;
import org.sourceid.saml20.service.SpConnectionFactory;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.websso.Protocol;
import org.w3c.dom.Node;

public class PingOneSpConnectionFactory
implements SpConnectionFactory,
ConnectionListener,
LocalSettingsListener,
MediatorListener {
    protected static final String SP_CONNECTION_ID = "SpConnectionId";
    protected static final String P1_CONN_FACTORY_CONFIG_NAME = "p1-conn-factory-config";
    protected static final String P1_CONN_FACTORY_STATE_NAME = "p1-conn-factory-state";
    protected static final String P1_CONN_FACTORY_LOCAL_STATE_NAME = "p1-conn-factory-local-state";
    private static Log log = LogFactory.getLog(PingOneSpConnectionFactory.class);
    private ConfigStore configStore = ConfigStoreFarm.getConfig((String)"p1-conn-factory-config");
    private ConfigStore stateStore = ConfigStoreFarm.getConfig((String)"p1-conn-factory-state");
    private ConfigStore localStateStore = ConfigStoreFarm.getConfig((ConfigStoreLocation)ConfigStoreLocation.LOCAL, (String)"p1-conn-factory-local-state");
    private ConnectionFactoryConfig factoryConfig = this.makeFactoryConfig();
    private ConnectionFactoryLocalState factoryState = new ConnectionFactoryLocalState(this.localStateStore);
    private ProvisioningConfigHelper provisioningConfigHelper = new ProvisioningConfigHelper();
    private String cachedIdpMetadata = null;
    private boolean initialized = false;
    private PingOneAdminServiceImpl adminService;

    public PingOneSpConnectionFactory(PingOneAdminServiceImpl adminService) {
        this.adminService = adminService;
    }

    public synchronized void reload() {
        this.initialize();
        if (MgmtFactory.getMediator().isConsole()) {
            SpConnection spConn = this.getManagedSpConnection();
            if (spConn == null) {
                this.cachedIdpMetadata = null;
            } else {
                this.cachedIdpMetadata = this.loadIdpMetadata();
                if (this.cachedIdpMetadata == null && this.isActive(spConn)) {
                    if (MgmtFactory.getMediator().isStandalone()) {
                        this.factoryState.setMetadataUploadPending(true);
                    } else {
                        this.factoryState.setMetadataUploadPending(false);
                    }
                }
            }
        }
    }

    public synchronized void upgradeConfiguration() {
        if (MgmtFactory.getMediator().isConsole()) {
            this.migrateSigningKeyRotationSettings();
        }
    }

    private void initialize() {
        if (!this.initialized) {
            MgmtFactory.getConnectionManager().addConnectionListener((ConnectionListener)this);
            MgmtFactory.getLocalSettingsManager().addSettingsListener((LocalSettingsListener)this);
            MgmtFactory.getMediator().addListener((MediatorListener)this);
            if (MgmtFactory.getMediator().isConsole()) {
                MgmtFactory.getMetadataUpdateScheduleManager().addMetadataSource((MetadataSource)new PingOneMetadataSource(this.adminService, this));
            }
            this.initialized = true;
        }
    }

    private void migrateSigningKeyRotationSettings() {
        SpConnection spConn = this.getManagedSpConnection();
        if (spConn != null && spConn.getSigningKeyRotationSettings() != null) {
            PkCert signingKey = spConn.getSigningPkCert();
            if (signingKey == null) {
                log.debug((Object)"Not migrating signing key rotation settings, as signing key is not present");
            } else {
                DSignRotationSetting currSettings = MgmtFactory.getDSignRotationSettingsManager().getRotationSetting(signingKey.getAlias());
                if (currSettings != null && currSettings.isEnableCertRotation()) {
                    log.debug((Object)"Not migrating signing key rotation settings, as rotation is already enabled for the key");
                } else {
                    log.debug((Object)"Migrating signing key rotation settings");
                    KeyRotationSettings oldSettings = spConn.getSigningKeyRotationSettings();
                    DSignRotationSetting newSettings = new DSignRotationSetting(signingKey.getAlias(), true);
                    newSettings.setKeyAlgorithm("RSA");
                    newSettings.setKeySize(oldSettings.getKeySize());
                    newSettings.setSignatureAlgorithm(oldSettings.getSignatureAlgorithm());
                    newSettings.setValidityPeriodDays(oldSettings.getValidityPeriodDays());
                    newSettings.setRotationBufferMins(oldSettings.getRotationBufferMins());
                    newSettings.setActivationBufferMins(oldSettings.getRotationBufferMins() / 3);
                    MgmtFactory.getDSignRotationSettingsManager().addRotationSetting(newSettings);
                }
            }
            spConn.setSigningKeyRotationSettings(null);
            MgmtFactory.getConnectionManager().saveSpConnection(spConn);
        }
    }

    public synchronized ConnectionFactoryMetadata getFactoryMetadata() {
        ConnectionFactoryMetadata metadata = new ConnectionFactoryMetadata();
        metadata.setSigningPkCertDn(this.getSigningKeyPairDn());
        metadata.setApplicationDockEndpoint(this.adminService.getApplicationDockEndpoint());
        metadata.setGlobalEntityId(this.generateEntityId(false));
        metadata.setConnectionTargetType("PingOneSCIM11");
        return metadata;
    }

    public synchronized SpConnection createSpConnection() throws IOException {
        this.checkAssociated();
        SpConnection conn = this.downloadMetadataAndMakeConnection();
        conn.setId(null);
        conn.setConnectionTargetType("PingOneSCIM11");
        String virtualServerId = this.generateEntityId(true);
        VirtualIdentity virtualIdentity = new VirtualIdentity();
        virtualIdentity.setVirtualEntityId(virtualServerId, DomainMode.CONFIGTIME);
        virtualIdentity.setVirtualSourceId(HashUtil.hashToBytes((String)virtualServerId, (HashAlgorithm)HashAlgorithm.SHA1));
        conn.setDefaultVirtualIdentity(virtualIdentity);
        conn.setVirtualIdentities(Arrays.asList(virtualIdentity));
        conn.setName(this.makeUniqueConnectionName());
        IncomingBindings incomingBindings = new IncomingBindings();
        incomingBindings.setPostBinding(true);
        incomingBindings.setArtifactBinding(false);
        incomingBindings.setRedirectBinding(false);
        incomingBindings.setSoapBinding(false);
        conn.setIncomingBindings(incomingBindings);
        conn.getEnabledProfiles().setIdpInitiatedSLOEnabled(false);
        AttributeContract contract = conn.getAttributeContract();
        if (contract == null) {
            contract = new AttributeContract();
        }
        String USER_PRINCIPAL_NAME = "userPrincipalName";
        String OBJECT_GUID = "objectGuid";
        contract.addMutableAttributeName("userPrincipalName");
        contract.addMutableAttributeInfo("userPrincipalName", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        contract.addMutableAttributeName("objectGuid");
        contract.addMutableAttributeInfo("objectGuid", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        conn.setAttributeContract(contract);
        return conn;
    }

    public synchronized SpConnection getManagedSpConnection() {
        String spConnectionId = this.getSpConnectionId();
        if (spConnectionId == null) {
            return null;
        }
        return MgmtFactory.getConnectionManager().getSpConnectionBySystemId(spConnectionId);
    }

    public synchronized void clearManagedSpConnection() {
        this.setSpConnectionId(null);
        this.clearExtendedMetadata();
        this.factoryState.setMetadataUploadPending(false);
    }

    public synchronized boolean hasManagedSpConnection() {
        String spConnectionId = this.getSpConnectionId();
        if (spConnectionId == null) {
            return false;
        }
        MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
        return metadataDirectory.getSpConnectionBySystemId(spConnectionId, false) != null;
    }

    public synchronized void addCredentialsToConnection(SpConnection spConnection) {
        this.checkAssociated();
        PkCert signingKeyPair = this.getSigningKeyPair(spConnection);
        spConnection.setSigningKeyAlias(signingKeyPair.getAlias());
        spConnection.setSigningAlgorithm(SignatureAlgorithms.getInstance().algNameToUri("RSA_SHA256"));
        spConnection.setIncludeCertInXmlSigs(false);
        spConnection.setIncludeRawKeyInXmlSigs(false);
    }

    public synchronized void addProvisioningToConnection(SpConnection spConnection, ProvisioningParameters provisioningParams) {
        this.checkAssociated();
        this.provisioningConfigHelper.configureProvisioning(spConnection, provisioningParams, this.factoryConfig.getProvisioningFieldCodes());
    }

    public synchronized ProvisioningTargetUrls getProvisioningTargetUrls() {
        this.checkAssociated();
        String baseUrl = this.adminService.getProvisioningBaseUrl();
        String usersUrl = baseUrl + "/v1/Users";
        String groupsUrl = baseUrl + "/v1/Groups";
        return new ProvisioningTargetUrls(usersUrl, groupsUrl);
    }

    public synchronized void onConnectionSaved(ConnectionBase conn, boolean newConnection) {
        SpConnection spConn;
        if (conn instanceof SpConnection && "PingOneSCIM11".equals((spConn = (SpConnection)conn).getConnectionTargetType())) {
            if (newConnection && this.adminService.isAssociated()) {
                this.clearExtendedMetadata();
                this.factoryState.setMetadataUploadPending(false);
                this.setSpConnectionId(conn.getId());
                if (this.provisioningConfigHelper.hasProvisioningConfiguration(spConn)) {
                    ProvisionerRunner provisionerRunner = (ProvisionerRunner)SpringApplicationContext.getBean((String)"provisionerRunner", ProvisionerRunner.class);
                    if (provisionerRunner == null) {
                        log.error((Object)"Failed to get provisionerRunner bean from Spring application context");
                    } else {
                        try {
                            provisionerRunner.activateProvisionerIfNecessary();
                        }
                        catch (Exception e) {
                            log.error((Object)"Error activating provisioner", (Throwable)e);
                        }
                    }
                }
            }
            if (conn.getId().equals(this.getSpConnectionId())) {
                if (!Objects.equals(this.factoryState.getSigningKeyPairAlias(), spConn.getSigningKeyAlias())) {
                    this.factoryState.setSigningKeyPairAlias(spConn.getSigningKeyAlias());
                }
                this.handleConfigUpdate(false);
            }
        }
    }

    public void onConnectionDeleted(ConnectionBase connection) {
    }

    public synchronized void onLocalSettingsSaved(LocalSettings settings) {
        this.handleConfigUpdate(false);
    }

    public synchronized void onConfigPublished() {
        this.handleConfigUpdate(true);
    }

    public synchronized void uploadIdpMetadata() throws IOException {
        SpConnection spConn = this.getManagedSpConnection();
        if (spConn == null) {
            throw new IllegalStateException("uploadIdpMetadata invoked, but no managed SP connection found");
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            if (!this.isClustered()) {
                this.saveExtendedMetadata(this.getExtendedMetadata(spConn));
            }
            this.uploadIdpMetadata(this.getExtendedMetadata());
            this.factoryState.setMetadataUploadPending(false);
            auditLoggerScope.log(AdminAuditLogger.Component.PINGONE_IDP_METADATA, AdminAuditLogger.Event.UPDATE);
        }
    }

    public synchronized boolean hasSavedIdpMetadata() {
        return this.getExtendedMetadata() != null;
    }

    public synchronized boolean isMetadataUploadPending() {
        return this.factoryState.isMetadataUploadPending();
    }

    public synchronized void shutdown() {
        MgmtFactory.getMetadataUpdateScheduleManager().removeMetadataSource("2e7edf08-9f16-4fd7-9ade-4e99fd422bb5");
        MgmtFactory.getConnectionManager().removeConnectionListener((ConnectionListener)this);
        MgmtFactory.getLocalSettingsManager().removeSettingsListener((LocalSettingsListener)this);
        MgmtFactory.getMediator().removeListener((MediatorListener)this);
    }

    protected synchronized ConnectionFactoryConfig makeFactoryConfig() {
        return new ConnectionFactoryConfig(this.configStore);
    }

    protected synchronized void saveExtendedMetadata(ExtendedMetadata extendedMetadata) {
        try {
            this.cachedIdpMetadata = extendedMetadata.getIdpMetadata();
            FileUtils.writeStringToFile((File)new File(this.getIdpMetadataPath()), (String)this.cachedIdpMetadata, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error saving IdP metadata to disk", e);
        }
        this.factoryState.setProvisioningUsername(extendedMetadata.getProvisioningUsername());
        this.factoryState.setProvisioningPassword(extendedMetadata.getProvisioningPassword());
    }

    protected synchronized void clearExtendedMetadata() {
        this.cachedIdpMetadata = null;
        this.factoryState.setProvisioningUsername(null);
        this.factoryState.setProvisioningPassword(null);
        this.deleteIdpMetadata();
    }

    protected synchronized String loadIdpMetadata() {
        try {
            return FileUtils.readFileToString((File)new File(this.getIdpMetadataPath()), (String)"UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    protected synchronized void deleteIdpMetadata() {
        File idpMetadataFile = new File(this.getIdpMetadataPath());
        if (idpMetadataFile.exists()) {
            log.debug((Object)"Deleting stored IdP metadata");
            boolean delete = idpMetadataFile.delete();
            if (!delete) {
                log.debug((Object)"Deleting stored IdP metadata failed");
            }
        }
    }

    protected synchronized String getIdpMetadataPath() {
        return ConfigFilePaths.getPingOneIdpMetadataPath();
    }

    protected synchronized String getSpConnectionId() {
        return this.stateStore.getStringValue(SP_CONNECTION_ID, null);
    }

    protected synchronized void setSpConnectionId(String id) {
        this.stateStore.setStringValue(SP_CONNECTION_ID, id);
    }

    protected synchronized void uploadIdpMetadata(ExtendedMetadata extMetadata) throws IOException {
        String metadata = this.prepareMetadataForUpload(extMetadata);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Uploading IdP metadata to PingOne: " + metadata));
        } else {
            log.debug((Object)"Uploading IdP metadata to PingOne");
        }
        try (PingOneAdminApiClient apiClient = this.makeApiClient();){
            apiClient.uploadIdpMetadata(metadata, extMetadata.getProvisioningUsername(), extMetadata.getProvisioningPassword());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected error uploading SP connection metadata to PingOne: " + e, e);
        }
    }

    protected synchronized void handleConfigUpdate(boolean published) {
        ExtendedMetadata newExtMetadata;
        SpConnection spConn = this.getManagedSpConnection();
        if (this.adminService.isAssociated() && spConn != null && this.isActive(spConn) && (!this.isClustered() || published) && !(newExtMetadata = this.getExtendedMetadata(spConn)).equals(this.getExtendedMetadata())) {
            this.factoryState.setMetadataUploadPending(true);
            if (published) {
                this.saveExtendedMetadata(newExtMetadata);
            }
        }
    }

    protected synchronized ExtendedMetadata getExtendedMetadata(SpConnection spConn) {
        ExtendedMetadata newExtMetadata = new ExtendedMetadata();
        String idpMetadata = this.getConnectionIdpMetadata(spConn);
        newExtMetadata.setIdpMetadata(idpMetadata);
        ProvisioningConfigHelper.ProvisioningCredentials provisioningCreds = this.getProvisioningCredentials(spConn);
        if (provisioningCreds != null) {
            newExtMetadata.setProvisioningUsername(provisioningCreds.getUsername());
            newExtMetadata.setProvisioningPassword(provisioningCreds.getPassword());
        }
        return newExtMetadata;
    }

    protected synchronized boolean isActive(SpConnection spConn) {
        MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
        return metadataLocal.getEnableSaml20IdP() && spConn.isActive();
    }

    protected synchronized SpConnection downloadMetadataAndMakeConnection() throws IOException {
        PingOneAdminApiClient apiClient = this.makeApiClient();
        try {
            String metadata = apiClient.downloadDefaultSpMetadata();
            SpConnection spConn = (SpConnection)MetadataImportExportUtil.importSingleConnection((InputStream)new ByteArrayInputStream(metadata.getBytes("UTF-8")), (MetadataImportExportUtil.ImportExpectedConnectionType)MetadataImportExportUtil.ImportExpectedConnectionType.SP, (Protocol)Protocol.SAML20);
            EncryptionSettings settings = spConn.getEncryptionSettings();
            if (settings != null) {
                settings.setEncryptionCert(null);
            }
            SpConnection spConnection = spConn;
            if (apiClient != null) {
                apiClient.close();
            }
            return spConnection;
        }
        catch (Throwable throwable) {
            try {
                if (apiClient != null) {
                    try {
                        apiClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unexpected error creating SP connection: " + e, e);
            }
            catch (MetadataImportException e) {
                throw new IOException("Error importing PingOne SP metadata: " + e, e);
            }
        }
    }

    protected synchronized String generateEntityId(boolean randomize) {
        StringBuilder companySegmentBuilder = new StringBuilder();
        if (this.adminService.getCompanyName() != null) {
            for (char ch : this.adminService.getCompanyName().toLowerCase().toCharArray()) {
                if (('0' > ch || ch > '9') && ('a' > ch || ch > 'z')) continue;
                companySegmentBuilder.append(ch);
            }
        }
        String companySegment = companySegmentBuilder.toString();
        Object result = "urn:saml2";
        if (randomize) {
            result = (String)result + ":" + IDGenerator.rndAlphaNumeric((int)15);
        }
        if (!companySegment.isEmpty()) {
            result = (String)result + ":" + companySegment;
        }
        return result;
    }

    protected synchronized ExtendedMetadata getExtendedMetadata() {
        if (this.cachedIdpMetadata == null) {
            return null;
        }
        ExtendedMetadata extMetadata = new ExtendedMetadata();
        extMetadata.setIdpMetadata(this.cachedIdpMetadata);
        extMetadata.setProvisioningUsername(this.factoryState.getProvisioningUsername());
        extMetadata.setProvisioningPassword(this.factoryState.getProvisioningPassword());
        return extMetadata;
    }

    protected synchronized String getConnectionIdpMetadata(SpConnection spConn) {
        MetaDataInfo mdi = new MetaDataInfo();
        MetadataImportExportUtil.populateMetaDataInfoWithConnection((MetaDataInfo)mdi, (ConnectionBase)spConn);
        mdi.setExportIDPRole(true);
        byte[] bytes = MetadataImportExportUtil.getMetaDataRawBytes((MetaDataInfo)mdi, null, null, (boolean)false, (PathUtil)MetaDataFactory.getLocalMetaData().getPathUtil(), (boolean)false, (boolean)true);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected error getting connection IdP metadata", e);
        }
    }

    protected synchronized PingOneAdminApiClient makeApiClient() throws PingOneAdminApiException {
        return this.adminService.makeApiClient();
    }

    protected synchronized void checkAssociated() {
        this.adminService.checkAssociated();
    }

    protected synchronized boolean isClustered() {
        return MgmtFactory.getMediator().isDistributable();
    }

    protected synchronized ProvisioningConfigHelper.ProvisioningCredentials getProvisioningCredentials(SpConnection spConn) {
        return this.provisioningConfigHelper.getProvisioningCredentials(spConn);
    }

    protected synchronized boolean isSuppressMetadataUploadErrors() {
        return false;
    }

    protected synchronized PkCert createSigningKeyPair(SpConnection spConn) {
        log.info((Object)"Creating signing keypair for PingOne SP connection");
        try {
            DSignRotationSetting rotationSettings = this.makeDefaultSigningKeyRotationSettings();
            Date validFrom = new Date(System.currentTimeMillis() - (long)(this.adminService.getAllowedClockSkewSecs() * 1000));
            PkCert result = new PkCert.Builder().cn(this.getSigningKeyPairCn()).validDays(rotationSettings.getValidityPeriodDays()).keyAlgo(rotationSettings.getKeyAlgorithm()).keySize(rotationSettings.getKeySize()).sigAlgorithm(rotationSettings.getSignatureAlgorithm()).certificateType(CertificateGenerator.CertificateType.dsigSigningCert).validFrom(validFrom).build();
            MgmtFactory.getDsigPkCertManager().savePkCert(result);
            this.factoryState.setSigningKeyPairAlias(result.getAlias());
            rotationSettings.setCertAlias(result.getAlias());
            MgmtFactory.getDSignRotationSettingsManager().addRotationSetting(rotationSettings);
            return result;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Unexpected error creating signing keypair for PingOne SP connection: " + e, e);
        }
    }

    protected synchronized DSignRotationSetting makeDefaultSigningKeyRotationSettings() {
        DSignRotationSetting rotationSettings = new DSignRotationSetting(null, true);
        rotationSettings.setKeyAlgorithm("RSA");
        rotationSettings.setKeySize(this.factoryConfig.getSigningKeyPairKeySize());
        rotationSettings.setRotationBufferMins(this.factoryConfig.getSigningKeyPairRotationBufferMins());
        rotationSettings.setActivationBufferMins(this.factoryConfig.getSigningKeyPairActivationBufferMins());
        rotationSettings.setSignatureAlgorithm(this.factoryConfig.getSigningKeyPairSignatureAlgorithm());
        rotationSettings.setValidityPeriodDays(this.factoryConfig.getSigningKeyPairLifetimeDays());
        return rotationSettings;
    }

    protected synchronized String prepareMetadataForUpload(ExtendedMetadata extMetadata) {
        EntityDescriptorDocument doc = this.getEntityDescriptorDocument(extMetadata.getIdpMetadata());
        MetadataImportExportUtil.setValidityPeriod((EntityDescriptorType)doc.getEntityDescriptor());
        doc.getEntityDescriptor().setID(XmlIDUtil.createID());
        return this.getMetadata(doc);
    }

    protected synchronized String getMetadata(EntityDescriptorDocument doc) {
        return XmlBeansUtil.xmlText((XmlObject)doc);
    }

    protected synchronized EntityDescriptorDocument getEntityDescriptorDocument(String metadata) {
        try {
            Node node = XmlBeansUtil.parseToNode((String)metadata);
            XmlObject xmlObj = XmlObject.Factory.parse((Node)node);
            return (EntityDescriptorDocument)xmlObj;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error parsing metadata", e);
        }
    }

    protected synchronized PkCert getSigningKeyPair(SpConnection spConn) {
        PkCert keyPair;
        if (this.factoryState.getSigningKeyPairAlias() != null && (keyPair = MgmtFactory.getDsigPkCertManager().getPkCert(this.factoryState.getSigningKeyPairAlias())) != null) {
            Calendar threshold = Calendar.getInstance();
            threshold.add(12, this.factoryConfig.getSigningKeyPairRotationBufferMins());
            if (keyPair.getX509Certificate().getNotAfter().after(threshold.getTime())) {
                return keyPair;
            }
        }
        return this.createSigningKeyPair(spConn);
    }

    private String makeUniqueConnectionName() {
        String DEFAULT_NAME = "PingOne";
        Object name = "PingOne";
        int i = 1;
        while (this.isConnectionNameInUse((String)name)) {
            name = "PingOne-" + i++;
        }
        return name;
    }

    private boolean isConnectionNameInUse(String name) {
        for (SpConnection spConn : MgmtFactory.getConnectionManager().getAllSpConnections()) {
            if (!spConn.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getSigningKeyPairDn() {
        return "CN=" + this.getSigningKeyPairCn();
    }

    private String getSigningKeyPairCn() {
        String cn = this.adminService.getCompanyName();
        if (StringUtils.isEmpty((String)cn)) {
            cn = this.adminService.getAccountId();
        }
        return cn;
    }
}

