/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.jws.JwsSignatureUtil;
import com.pingidentity.pingone.api.OpenIdConfiguration;
import com.pingidentity.pingone.impl.PingOneAdminServiceImpl;
import com.pingidentity.pingone.impl.PingOneMessage;
import com.pingidentity.pingone.impl.PingOneMessageHandler;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.container.jdk.client.JdkClientContainer;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.util.NodeIndex;

public class PingOneWebSocketConnectionManager {
    private static final String CONNECT_RETRY_INTERVAL_SECS = "ConnectRetryIntervalSecs";
    private static final String AUTHENTICATION_TIMEOUT_SECS = "AuthenticationTimeoutSecs";
    private static final String PING_INTERVAL_SECS = "PingIntervalSecs";
    private static final Log log = LogFactory.getLog(PingOneWebSocketConnectionManager.class);
    private ConfigStore configStore = ConfigStoreFarm.getConfig((String)"p1-web-socket-config");
    private PingOneAdminServiceImpl adminService;
    private LinkedBlockingQueue<ConnMgrMessage> messageQueue = new LinkedBlockingQueue();
    private Set<StateListener> stateListeners = new HashSet<StateListener>();
    private Map<String, PingOneMessageHandler> messageHandlers = new HashMap<String, PingOneMessageHandler>();
    private Thread connMgrThread = null;
    private volatile ConnMgrState currentState;
    private Session webSocketSession;

    public PingOneWebSocketConnectionManager(PingOneAdminServiceImpl adminService) {
        this.adminService = adminService;
    }

    public void activate() {
        log.debug((Object)"Activating web socket connnection manager");
        this.startThread();
        this.messageQueue.add(new ConnMgrMessage(ConnMgrMessageType.ACTIVATE));
    }

    public void deactivate() {
        log.debug((Object)"Deactivating web socket connnection manager");
        this.messageQueue.add(new ConnMgrMessage(ConnMgrMessageType.DEACTIVATE));
    }

    public void shutdown() {
        log.debug((Object)"Shutting down web socket connnection manager");
        this.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(StateListener listener) {
        Set<StateListener> set = this.stateListeners;
        synchronized (set) {
            this.stateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(StateListener listener) {
        Set<StateListener> set = this.stateListeners;
        synchronized (set) {
            this.stateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageHandler(PingOneMessageHandler handler) {
        Map<String, PingOneMessageHandler> map = this.messageHandlers;
        synchronized (map) {
            this.messageHandlers.put(handler.getHandledMessageType(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(PingOneMessageHandler handler) {
        Map<String, PingOneMessageHandler> map = this.messageHandlers;
        synchronized (map) {
            PingOneMessageHandler currentHandler = this.messageHandlers.get(handler.getHandledMessageType());
            if (Objects.equals(currentHandler, handler)) {
                this.messageHandlers.remove(handler.getHandledMessageType());
            }
        }
    }

    public void sendMessage(PingOneMessage message) {
        this.messageQueue.add(new OutgoingWebSocketMessage(message));
    }

    protected synchronized void startThread() {
        if (this.connMgrThread == null) {
            log.debug((Object)"Starting connection manager thread");
            this.connMgrThread = new Thread(PingOneWebSocketConnectionManager.class.getSimpleName()){

                @Override
                public void run() {
                    PingOneWebSocketConnectionManager.this.run();
                }
            };
            this.connMgrThread.setDaemon(true);
            this.connMgrThread.start();
        }
    }

    protected synchronized void stopThread() {
        if (this.connMgrThread != null) {
            log.debug((Object)"Stopping connection manager thread");
            this.messageQueue.add(new ConnMgrMessage(ConnMgrMessageType.SHUTDOWN));
            this.connMgrThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChanged(String newStateName) {
        HashSet<StateListener> listenersCopy;
        Set<StateListener> set = this.stateListeners;
        synchronized (set) {
            listenersCopy = new HashSet<StateListener>(this.stateListeners);
        }
        for (StateListener listener : listenersCopy) {
            listener.onStateChanged(newStateName);
        }
    }

    protected void run() {
        log.debug((Object)"Connection manager thread running");
        this.setCurrentState(new InactiveState());
        boolean shutdown = false;
        block11: while (!shutdown) {
            ConnMgrMessage msg = null;
            try {
                if (this.currentState.getTimerTimestamp() >= 0L) {
                    long delay = Math.max(0L, this.currentState.getTimerTimestamp() - System.currentTimeMillis());
                    msg = this.messageQueue.poll(delay, TimeUnit.MILLISECONDS);
                    if (System.currentTimeMillis() >= this.currentState.getTimerTimestamp()) {
                        this.currentState.cancelTimer();
                        this.currentState.onTimeout();
                    }
                } else {
                    msg = this.messageQueue.take();
                }
                if (msg == null) continue;
                switch (msg.messageType) {
                    case SHUTDOWN: {
                        this.closeSession();
                        this.setCurrentState(new InactiveState());
                        shutdown = true;
                        break;
                    }
                    case DEACTIVATE: {
                        if (this.currentState instanceof InactiveState) continue block11;
                        this.closeSession();
                        this.setCurrentState(new InactiveState());
                        break;
                    }
                    case ACTIVATE: {
                        if (!(this.currentState instanceof InactiveState)) continue block11;
                        this.setCurrentState(new ConnectingState());
                        break;
                    }
                    case INCOMING_WEB_SOCKET_MSG: {
                        this.currentState.onMessage(((IncomingWebSocketMessage)msg).contents);
                        break;
                    }
                    case OUTGOING_WEB_SOCKET_MSG: {
                        this.currentState.sendMessage(((OutgoingWebSocketMessage)msg).contents);
                        break;
                    }
                    case SESSION_ERROR: {
                        SessionErrorMessage sessionErrorMsg = (SessionErrorMessage)msg;
                        if (this.webSocketSession == null || !this.webSocketSession.getId().equals(sessionErrorMsg.session.getId())) continue block11;
                        this.closeSession();
                        this.setCurrentState(new DelayBeforeConnectingState());
                        break;
                    }
                    case SESSION_CLOSED: {
                        SessionClosedMessage connClosedMsg = (SessionClosedMessage)msg;
                        if (this.webSocketSession == null || !this.webSocketSession.getId().equals(connClosedMsg.session.getId())) continue block11;
                        this.clearSession();
                        this.setCurrentState(new DelayBeforeConnectingState());
                        break;
                    }
                    default: {
                        log.error((Object)("Unexpected message type: " + msg.messageType));
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Unexpected error in event handler", t);
            }
        }
        log.debug((Object)"Connection manager thread exiting");
    }

    protected void closeSession() {
        if (this.webSocketSession != null) {
            try {
                this.webSocketSession.close();
            }
            catch (IOException e) {
                log.debug((Object)("Error closing session: " + e));
            }
        }
        this.clearSession();
    }

    protected void clearSession() {
        this.webSocketSession = null;
    }

    protected void setCurrentState(ConnMgrState newState) {
        this.currentState = newState;
        this.currentState.onEnter();
        this.notifyStateChanged(this.currentState.toString());
    }

    protected String getNodeType() {
        Mediator mediator = MgmtFactory.getMediator();
        if (mediator.isStandalone()) {
            return "Standalone";
        }
        if (mediator.isConsole()) {
            return "Admin";
        }
        return "Engine";
    }

    protected String getNodeIndex() {
        return Integer.toString(NodeIndex.getIndex());
    }

    protected String getLocalIpAddress() {
        String localAddrStr = null;
        localAddrStr = MgmtFactory.getMediator().isConsole() ? PropertyInfo.getConsoleBindAddress() : PropertyInfo.getEngineBindAddress();
        if (StringUtils.isEmpty((String)localAddrStr) || localAddrStr.equals("0.0.0.0")) {
            localAddrStr = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements() && localAddrStr == null) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements() && localAddrStr == null) {
                        InetAddress addr = addresses.nextElement();
                        if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress() || addr.isLinkLocalAddress()) continue;
                        localAddrStr = addr.getHostAddress();
                    }
                }
            }
            catch (SocketException e) {
                log.warn((Object)("Error retrieving local IP address: " + e));
            }
        }
        return StringUtils.defaultString((String)localAddrStr);
    }

    protected List<String> getWebSocketEndpoints() throws IOException {
        return ((OpenIdConfiguration)this.adminService.getPingOneOpenIdConfiguration().getValue()).getWssEndpoints();
    }

    protected long getConnectRetryIntervalMillis() {
        return this.configStore.getIntValue(CONNECT_RETRY_INTERVAL_SECS, 30) * 1000;
    }

    protected long getAuthenticationTimeoutMillis() {
        return this.configStore.getIntValue(AUTHENTICATION_TIMEOUT_SECS, 10) * 1000;
    }

    protected long getPingIntervalMillis() {
        return this.configStore.getIntValue(PING_INTERVAL_SECS, 60) * 1000;
    }

    protected ClientManager makeClientManager() {
        ClientManager webSocketClient = ClientManager.createClient((String)JdkClientContainer.class.getName());
        webSocketClient.setDefaultMaxSessionIdleTimeout(-1L);
        return webSocketClient;
    }

    protected boolean isSuppressExceptions() {
        return false;
    }

    protected ConnMgrState getCurrentState() {
        return this.currentState;
    }

    protected Endpoint makeClientEndpoint() {
        return new Endpoint(){

            public void onOpen(Session session, EndpointConfig endpointConfig) {
            }

            public void onClose(Session session, CloseReason closeReason) {
                log.debug((Object)("Session closed with reason " + closeReason));
                PingOneWebSocketConnectionManager.this.messageQueue.add(new SessionClosedMessage(session));
            }

            public void onError(Session session, Throwable thr) {
                log.debug((Object)"Session error", thr);
                PingOneWebSocketConnectionManager.this.messageQueue.add(new SessionErrorMessage(session));
            }
        };
    }

    protected class ConnectedState
    extends ConnMgrState {
        private boolean receivedPingAck;

        protected ConnectedState() {
            this.receivedPingAck = true;
        }

        @Override
        public void onEnter() {
            this.setTimer(PingOneWebSocketConnectionManager.this.getPingIntervalMillis());
        }

        @Override
        public void onTimeout() {
            if (!this.receivedPingAck) {
                log.debug((Object)"PingAck was not received, disconnecting");
                PingOneWebSocketConnectionManager.this.closeSession();
                PingOneWebSocketConnectionManager.this.setCurrentState(new ConnectingState());
            } else {
                try {
                    log.trace((Object)"Sending Ping message to remote");
                    PingOneWebSocketConnectionManager.this.webSocketSession.getBasicRemote().sendText(PingOneMessage.makeRequest("Ping").toJson());
                    this.receivedPingAck = false;
                    this.setTimer(PingOneWebSocketConnectionManager.this.getPingIntervalMillis());
                }
                catch (IOException e) {
                    log.debug((Object)("Error sending Ping message to remote, disconnecting: " + e));
                    PingOneWebSocketConnectionManager.this.closeSession();
                    PingOneWebSocketConnectionManager.this.setCurrentState(new ConnectingState());
                }
            }
        }

        @Override
        public void onMessage(PingOneMessage message) {
            String messageType = message.getMessageType();
            String logMessage = "Received message: " + message;
            if ("PingAck".equals(messageType) || "PF.StatusRequest".equals(messageType)) {
                log.trace((Object)logMessage);
            } else {
                log.debug((Object)logMessage);
            }
            if ("PingAck".equals(messageType)) {
                this.receivedPingAck = true;
            } else {
                this.handleMessage(message);
            }
        }

        @Override
        public void sendMessage(PingOneMessage message) {
            String logMessage = "Sending message " + message;
            if ("PF.StatusResponse".equals(message.getMessageType())) {
                log.trace((Object)logMessage);
            } else {
                log.debug((Object)logMessage);
            }
            try {
                PingOneWebSocketConnectionManager.this.webSocketSession.getBasicRemote().sendText(message.toJson());
            }
            catch (IOException e) {
                log.error((Object)("Error sending " + message + " to remote, disconnecting: " + e));
                PingOneWebSocketConnectionManager.this.closeSession();
                PingOneWebSocketConnectionManager.this.setCurrentState(new ConnectingState());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(PingOneMessage message) {
            PingOneMessageHandler handler = null;
            Map<String, PingOneMessageHandler> map = PingOneWebSocketConnectionManager.this.messageHandlers;
            synchronized (map) {
                handler = PingOneWebSocketConnectionManager.this.messageHandlers.get(message.getMessageType());
            }
            if (handler != null) {
                handler.onMessage(message);
            }
        }
    }

    protected class AuthenticatingState
    extends ConnMgrState {
        protected AuthenticatingState() {
        }

        @Override
        public void onEnter() {
            PkCert keyPair = PingOneWebSocketConnectionManager.this.adminService.getClientAuthnKeyPair();
            if (keyPair == null) {
                PingOneWebSocketConnectionManager.this.closeSession();
                PingOneWebSocketConnectionManager.this.setCurrentState(new InactiveState());
            } else {
                PingOneMessage pfConnectMsg = this.makePfConnectMessage(keyPair);
                try {
                    log.debug((Object)"Sending PF.Connect message to remote");
                    PingOneWebSocketConnectionManager.this.webSocketSession.getBasicRemote().sendText(pfConnectMsg.toJson());
                    this.setTimer(PingOneWebSocketConnectionManager.this.getAuthenticationTimeoutMillis());
                }
                catch (IOException e) {
                    log.error((Object)"Error sending PF.Connect message", (Throwable)e);
                    PingOneWebSocketConnectionManager.this.closeSession();
                    PingOneWebSocketConnectionManager.this.setCurrentState(new DelayBeforeConnectingState());
                }
            }
        }

        @Override
        public void onTimeout() {
            log.error((Object)"Timed out waiting for response to PF.Connect message, disconnecting");
            PingOneWebSocketConnectionManager.this.closeSession();
            PingOneWebSocketConnectionManager.this.setCurrentState(new DelayBeforeConnectingState());
        }

        @Override
        public void onMessage(PingOneMessage msg) {
            String messageType = msg.getMessageType();
            if ("PF.ConnectAck".equals(messageType)) {
                log.debug((Object)("Received message: " + messageType));
                PingOneWebSocketConnectionManager.this.setCurrentState(new ConnectedState());
            } else {
                log.debug((Object)("Received unexpected message type " + messageType + " in state " + this));
            }
        }

        private PingOneMessage makePfConnectMessage(PkCert keyPair) {
            PingOneMessage msg = PingOneMessage.makeRequest("PF.Connect");
            msg.setField("customerUuid", PingOneWebSocketConnectionManager.this.adminService.getAccountId());
            msg.setField("clientId", PingOneWebSocketConnectionManager.this.adminService.getClientId());
            msg.setField("nodeIndex", PingOneWebSocketConnectionManager.this.getNodeIndex());
            msg.setField("token", this.makePfConnectJwt(keyPair));
            return msg;
        }

        private String makePfConnectJwt(PkCert keyPair) {
            try {
                JwtClaims claims = new JwtClaims();
                claims.setExpirationTimeMinutesInTheFuture((float)PingOneWebSocketConnectionManager.this.adminService.getClientAuthnTokenLifetimeMins());
                claims.setClaim("nodeType", (Object)PingOneWebSocketConnectionManager.this.getNodeType());
                claims.setClaim("nodeIndex", (Object)PingOneWebSocketConnectionManager.this.getNodeIndex());
                claims.setClaim("ip", (Object)PingOneWebSocketConnectionManager.this.getLocalIpAddress());
                claims.setClaim("pfVersion", (Object)PropertyInfo.getPingFederateVersion());
                JsonWebSignature jws = new JsonWebSignature();
                jws.setPayload(claims.toJson());
                jws.setKey((Key)keyPair.getPrivateKey());
                jws.setKeyIdHeaderValue(keyPair.getAlias());
                jws.setAlgorithmHeaderValue("RS256");
                JwsSignatureUtil.applyProviderOverrideContextIfNeeded((JsonWebSignature)jws, (PkCert)keyPair);
                return jws.getCompactSerialization();
            }
            catch (JoseException e) {
                throw new RuntimeException("Unexpected error generating client authentication JWT", e);
            }
        }
    }

    protected class ConnectingState
    extends ConnMgrState {
        protected ConnectingState() {
        }

        @Override
        public void onEnter() {
            this.checkConnect();
        }

        @Override
        public void onTimeout() {
            this.checkConnect();
        }

        protected void checkConnect() {
            if (PingOneWebSocketConnectionManager.this.adminService.isMonitoringEnabled()) {
                this.doConnect();
            } else {
                log.debug((Object)"Monitoring is no longer enabled, setting state to inactive");
                PingOneWebSocketConnectionManager.this.setCurrentState(new InactiveState());
            }
        }

        protected void doConnect() {
            boolean connected = false;
            List<Object> endpoints = new ArrayList();
            try {
                endpoints = PingOneWebSocketConnectionManager.this.getWebSocketEndpoints();
            }
            catch (IOException e) {
                log.error((Object)"Failed to obtain websocket endpoints from PingOne OpenID configuration", (Throwable)e);
            }
            if (endpoints.isEmpty()) {
                log.error((Object)"PingOne OpenID configuration contains no websocket endpoints");
            } else {
                for (String string : endpoints) {
                    ClientManager webSocketClient = PingOneWebSocketConnectionManager.this.makeClientManager();
                    ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
                    try {
                        log.debug((Object)("Connecting to web socket endpoint " + string));
                        PingOneWebSocketConnectionManager.this.webSocketSession = webSocketClient.connectToServer(PingOneWebSocketConnectionManager.this.makeClientEndpoint(), config, new URI(string));
                        log.debug((Object)("Connected successfully to endpoint " + string));
                        this.addMessageHandler(PingOneWebSocketConnectionManager.this.webSocketSession);
                        PingOneWebSocketConnectionManager.this.setCurrentState(new AuthenticatingState());
                        connected = true;
                        break;
                    }
                    catch (IOException | URISyntaxException | DeploymentException e) {
                        if (PingOneWebSocketConnectionManager.this.isSuppressExceptions()) continue;
                        log.error((Object)("Failed to connect to web socket endpoint " + string), e);
                    }
                }
            }
            if (!connected) {
                this.setTimer(PingOneWebSocketConnectionManager.this.getConnectRetryIntervalMillis());
            }
        }

        protected void addMessageHandler(Session session) {
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String msgText) {
                    try {
                        log.trace((Object)("Received incoming web socket message: " + msgText));
                        PingOneMessage message = PingOneMessage.fromJson(msgText);
                        PingOneWebSocketConnectionManager.this.messageQueue.add(new IncomingWebSocketMessage(message));
                    }
                    catch (JsonProcessingException e) {
                        log.error((Object)("Failed to parse incoming web socket message: " + msgText), (Throwable)e);
                    }
                }
            });
        }
    }

    protected class DelayBeforeConnectingState
    extends ConnMgrState {
        protected DelayBeforeConnectingState() {
        }

        @Override
        public void onEnter() {
            this.setTimer(PingOneWebSocketConnectionManager.this.getConnectRetryIntervalMillis());
        }

        @Override
        public void onTimeout() {
            PingOneWebSocketConnectionManager.this.setCurrentState(new ConnectingState());
        }
    }

    protected class InactiveState
    extends ConnMgrState {
        protected InactiveState() {
        }
    }

    protected abstract class ConnMgrState {
        private long timerTimestamp = -1L;

        protected ConnMgrState() {
        }

        public void onEnter() {
        }

        public void onMessage(PingOneMessage message) {
        }

        public void sendMessage(PingOneMessage message) {
            log.debug((Object)("In state " + this + ", message " + message + " will be discarded"));
        }

        public long getTimerTimestamp() {
            return this.timerTimestamp;
        }

        public void onTimeout() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        public void setTimer(long delay) {
            this.timerTimestamp = System.currentTimeMillis() + delay;
        }

        public void cancelTimer() {
            this.timerTimestamp = -1L;
        }
    }

    protected class SessionClosedMessage
    extends SessionMessage {
        public SessionClosedMessage(Session session) {
            super(ConnMgrMessageType.SESSION_CLOSED, session);
        }
    }

    protected class SessionErrorMessage
    extends SessionMessage {
        public SessionErrorMessage(Session session) {
            super(ConnMgrMessageType.SESSION_ERROR, session);
        }
    }

    protected class SessionMessage
    extends ConnMgrMessage {
        public Session session;

        public SessionMessage(ConnMgrMessageType msgType, Session session) {
            super(msgType);
            this.session = session;
        }
    }

    protected class OutgoingWebSocketMessage
    extends ConnMgrMessage {
        public PingOneMessage contents;

        public OutgoingWebSocketMessage(PingOneMessage contents) {
            super(ConnMgrMessageType.OUTGOING_WEB_SOCKET_MSG);
            this.contents = contents;
        }
    }

    protected class IncomingWebSocketMessage
    extends ConnMgrMessage {
        public PingOneMessage contents;

        public IncomingWebSocketMessage(PingOneMessage contents) {
            super(ConnMgrMessageType.INCOMING_WEB_SOCKET_MSG);
            this.contents = contents;
        }
    }

    protected class ConnMgrMessage {
        public ConnMgrMessageType messageType;

        public ConnMgrMessage(ConnMgrMessageType msgType) {
            this.messageType = msgType;
        }
    }

    protected static enum ConnMgrMessageType {
        ACTIVATE,
        DEACTIVATE,
        SHUTDOWN,
        INCOMING_WEB_SOCKET_MSG,
        OUTGOING_WEB_SOCKET_MSG,
        SESSION_ERROR,
        SESSION_CLOSED;

    }

    protected static class MessageField {
        public static final String CUSTOMER_UUID = "customerUuid";
        public static final String CLIENT_ID = "clientId";
        public static final String NODE_INDEX = "nodeIndex";
        public static final String TOKEN = "token";
        public static final String NODE_TYPE = "nodeType";
        public static final String IP = "ip";
        public static final String PF_VERSION = "pfVersion";
        public static final String BODY = "body";

        protected MessageField() {
        }
    }

    public static class MessageType {
        public static final String PF_CONNECT = "PF.Connect";
        public static final String PF_CONNECT_ACK = "PF.ConnectAck";
        public static final String PING = "Ping";
        public static final String PING_ACK = "PingAck";
        public static final String PF_STATUS_REQUEST = "PF.StatusRequest";
        public static final String PF_STATUS_RESPONSE = "PF.StatusResponse";
    }

    public static interface StateListener {
        public void onStateChanged(String var1);
    }
}

