/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMapping;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.mgmt.FieldInfoManager;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.templates.mgmt.SaaSLdapTemplateFileManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.service.ProvisioningParameters;

public class ProvisioningConfigHelper {
    private static final Log log = LogFactory.getLog(ProvisioningConfigHelper.class);
    private static final String FIELD_AUTH = "authentication";
    private static final String FIELD_AUTH_OPT_BASIC_VAL = "basic";
    private static final String FIELD_BASIC_AUTH_USER = "basicAuthUser";
    private static final String FIELD_BASIC_AUTH_PASS = "basicAuthPass";
    private static final String LDAP_ATTRIBUTES_MAP_FIELD_CODE = "ldapAttributesMap";
    private static final String USER_PRINCIPAL_NAME_ATTRIBUTE = "userPrincipalName";

    public ProvisioningCredentials getProvisioningCredentials(SpConnection spConnection) {
        ProvisionerConfig provisionerConfig = null;
        if (spConnection.getConnectionModuleConfigurations() != null) {
            for (ConnectionModuleConfiguration config : spConnection.getConnectionModuleConfigurations()) {
                if (!config.getModuleId().equals("SaasProvisioner") || !(config instanceof ProvisionerConfig)) continue;
                provisionerConfig = (ProvisionerConfig)config;
            }
        }
        if (provisionerConfig == null) {
            return null;
        }
        SaasTarget target = provisionerConfig.getTarget();
        SimpleFieldList parameters = target.getParameterValues();
        String authType = parameters.getFieldValue(FIELD_AUTH);
        if (FIELD_AUTH_OPT_BASIC_VAL.equals(authType)) {
            return new ProvisioningCredentials(parameters.getFieldValue(FIELD_BASIC_AUTH_USER), parameters.getFieldValue(FIELD_BASIC_AUTH_PASS));
        }
        return null;
    }

    public boolean hasProvisioningConfiguration(SpConnection spConnection) {
        return spConnection.hasModuleConfiguration("SaasProvisioner");
    }

    public void configureProvisioning(SpConnection spConnection, ProvisioningParameters provisioningParams, List<String> fieldCodes) {
        log.debug((Object)("Adding provisioning configuration to SP connection " + spConnection.getEntityId()));
        ConnectionModuleSupport runtimeModuleSupport = ConnectionModuleSupport.getInstance();
        ProvisionerConfig provisionerConfig = (ProvisionerConfig)runtimeModuleSupport.createNewConfiguration("SaasProvisioner", spConnection.getRoleType());
        if (provisionerConfig == null) {
            throw new RuntimeException("Failed to create configuration object for connection module SaasProvisioner");
        }
        provisionerConfig.setType("PingOneSCIM11");
        provisionerConfig.setEntityId(spConnection.getEntityId());
        if (provisioningParams != null && provisioningParams.getLdapDataSource() != null) {
            SaasTarget saasTarget = this.makeSaasTarget();
            provisionerConfig.setTarget(saasTarget);
            Channel channel = this.makeChannel(saasTarget, provisioningParams, fieldCodes);
            provisionerConfig.addChannel(channel);
        }
        spConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)provisionerConfig);
    }

    private Channel makeChannel(SaasTarget saasTarget, ProvisioningParameters provisioningParams, List<String> fieldCodes) {
        String ldapTypeDesc;
        Channel channel = new Channel("Channel 1");
        SaaSLdapTemplateFileManager templateMgr = SaaSLdapTemplateFileManager.getInstance();
        Properties properties = templateMgr.getSaaSLdapTemplateProperties(ldapTypeDesc = this.getLdapTypeDescription(provisioningParams));
        if (properties == null) {
            throw new RuntimeException("Cannot find SaaS LDAP template");
        }
        ChannelSource source = ChannelSource.Factory.newInstance((Properties)properties);
        source.setDataSourceId(provisioningParams.getLdapDataSource().getId());
        source.setUserBaseDN(provisioningParams.getBaseDn());
        source.setGroupDNForUsers(provisioningParams.getGroupDnForUsers());
        source.setUserNestedSearch(provisioningParams.isNestedGroupsForUsers());
        source.setGroupFilterForGroups("objectClass=group");
        channel.setSource(source);
        this.addIdentityMappingFields(channel, saasTarget, provisioningParams, fieldCodes);
        channel.setActive(true);
        return channel;
    }

    private String getLdapTypeDescription(ProvisioningParameters provisioningParams) {
        LdapInfo.LdapType ldapType = provisioningParams.getLdapDataSource().getLdapType();
        String ldapTypeDesc = ldapType.getDescription();
        if (ldapType == LdapInfo.LdapType.SunDirectoryServer) {
            ldapTypeDesc = "Oracle Directory Server";
        }
        return ldapTypeDesc;
    }

    private void addIdentityMappingFields(Channel channel, SaasTarget saasTarget, ProvisioningParameters provisioningParams, List<String> fieldCodes) {
        try {
            List fields = IdentityMapping.getDefaultIdentityMapping((String)provisioningParams.getLdapDataSource().getLdapType().name(), (SaasTarget)saasTarget);
            List identityMapping = channel.getIdentityMapping();
            for (IdentityMappingField field : fields) {
                if (!fieldCodes.contains(field.getFieldInfo().getCode())) continue;
                if (field.getFieldInfo().getCode().equals(LDAP_ATTRIBUTES_MAP_FIELD_CODE)) {
                    field.setFieldConfig(this.makeLdapAttributesMapFieldConfig());
                }
                identityMapping.add(field);
            }
            channel.setSaasUsernameFieldCode(FieldInfoManager.getInstance().getSaasUsernameFieldCode(saasTarget));
        }
        catch (SaasException e) {
            throw new RuntimeException("Unexpected error retrieving field info from provisioning target: " + e, e);
        }
    }

    private FieldConfig makeLdapAttributesMapFieldConfig() {
        FieldConfig config = new FieldConfig();
        config.addAttributeName(USER_PRINCIPAL_NAME_ATTRIBUTE);
        return config;
    }

    private SaasTarget makeSaasTarget() {
        SaasPluginManager pluginManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin plugin = pluginManager.getPluginInstance("PingOneSCIM11");
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldDescriptor desc : plugin.getParameterDescriptors()) {
            fields.add(new Field(desc.getName(), desc.getLabel(), desc.getDefaultValue()));
        }
        SaasTarget target = new SaasTarget("PingOneSCIM11", new SimpleFieldList(fields));
        return target;
    }

    public static class ProvisioningCredentials {
        private String username;
        private String password;

        public ProvisioningCredentials() {
        }

        public ProvisioningCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

