/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import org.sourceid.config.ConfigStore;

public class ServiceState {
    private static final String ASSOCIATED = "Associated";
    private static final String KEY_PAIR_ALIAS = "KeyPairAlias";
    private static final String PREVIOUS_KEY_PAIR_ALIAS = "PreviousKeyPairAlias";
    private static final String ACCOUNT_ID = "AccountId";
    private static final String CLIENT_ID = "ClientId";
    private static final String COMPANY_NAME = "CompanyName";
    private static final String APPLICATION_DOCK_ENDPOINT = "ApplicationDockEndpoint";
    private static final String PROVISIONING_BASE_URL = "ProvisioningBaseUrl";
    private ConfigStore configStore;

    public ServiceState(ConfigStore store) {
        this.configStore = store;
    }

    public void clear() {
        this.startBatchUpdate();
        this.setAssociated(false);
        this.setKeyPairAlias(null);
        this.setAccountId(null);
        this.setClientId(null);
        this.setCompanyName(null);
        this.setApplicationDockEndpoint(null);
        this.commitBatchUpdate();
    }

    public void startBatchUpdate() {
        this.configStore.startBatchUpdate();
    }

    public void commitBatchUpdate() {
        this.configStore.commitBatchUpdate();
    }

    public void cancelBatchUpdate() {
        this.configStore.cancelBatchUpdate();
    }

    public boolean isAssociated() {
        return this.configStore.getBooleanValue(ASSOCIATED, false);
    }

    public void setAssociated(boolean associated) {
        this.configStore.setBooleanValue(ASSOCIATED, associated);
    }

    public String getKeyPairAlias() {
        return this.configStore.getStringValue(KEY_PAIR_ALIAS, null);
    }

    public void setKeyPairAlias(String keyPairAlias) {
        this.configStore.setStringValue(KEY_PAIR_ALIAS, keyPairAlias);
    }

    public String getPreviousKeyPairAlias() {
        return this.configStore.getStringValue(PREVIOUS_KEY_PAIR_ALIAS, null);
    }

    public void setPreviousKeyPairAlias(String keyPairAlias) {
        this.configStore.setStringValue(PREVIOUS_KEY_PAIR_ALIAS, keyPairAlias);
    }

    public String getAccountId() {
        return this.configStore.getStringValue(ACCOUNT_ID, null);
    }

    public void setAccountId(String accountId) {
        this.configStore.setStringValue(ACCOUNT_ID, accountId);
    }

    public String getClientId() {
        return this.configStore.getStringValue(CLIENT_ID, null);
    }

    public void setClientId(String clientId) {
        this.configStore.setStringValue(CLIENT_ID, clientId);
    }

    public String getCompanyName() {
        return this.configStore.getStringValue(COMPANY_NAME, null);
    }

    public void setCompanyName(String companyName) {
        this.configStore.setStringValue(COMPANY_NAME, companyName);
    }

    public String getApplicationDockEndpoint() {
        return this.configStore.getStringValue(APPLICATION_DOCK_ENDPOINT, null);
    }

    public void setApplicationDockEndpoint(String applicationDockEndpoint) {
        this.configStore.setStringValue(APPLICATION_DOCK_ENDPOINT, applicationDockEndpoint);
    }

    public String getProvisioningBaseUrl() {
        return this.configStore.getStringValue(PROVISIONING_BASE_URL, null);
    }

    public void setProvisioningBaseUrl(String baseUrl) {
        this.configStore.setStringValue(PROVISIONING_BASE_URL, baseUrl);
    }
}

