/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.common;

import com.pingidentity.auth.login.WebAuthNUtil;
import com.pingidentity.localidentity.ConnectedIdentity;
import com.pingidentity.localidentity.ConnectedIdentityInfo;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.unboundid.ldap.sdk.DN;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public final class ConnectedIdentityUtils {
    private ConnectedIdentityUtils() {
        throw new AssertionError((Object)"not allowed");
    }

    public static ConnectedIdentity findConnectedIdentity(String authSourceId, LocalIdentityDTO<DN> dto) {
        List matchingIdentities = dto.getConnectedIdentities().stream().filter(t -> t.getAuthSourceId().equals(authSourceId)).collect(Collectors.toList());
        if (matchingIdentities.size() > 0) {
            return (ConnectedIdentity)matchingIdentities.get(0);
        }
        return null;
    }

    public static List<ConnectedIdentityInfo> createConnectedIdentityInfo(HttpServletRequest req, LocalIdentityDTO<DN> dto, LocalIdentityProfile lip) {
        ArrayList<ConnectedIdentityInfo> identities = new ArrayList<ConnectedIdentityInfo>(lip.getAuthSources().size());
        for (LocalIdentityAuthSource source : lip.getAuthSources()) {
            String sourceName = source.getSource();
            if ("FIDO".equals(sourceName)) {
                sourceName = WebAuthNUtil.getSourceName((HttpServletRequest)req);
            }
            ConnectedIdentityInfo info = new ConnectedIdentityInfo(source.getId(), sourceName);
            ConnectedIdentity connectedIdentity = ConnectedIdentityUtils.findConnectedIdentity(source.getId(), dto);
            if (connectedIdentity != null) {
                info.setConnected(true);
            }
            identities.add(info);
        }
        return identities;
    }
}

