/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.common;

import com.pingidentity.common.util.TimeUtil;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.unboundid.ldap.sdk.DN;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.token.jwt.LocalIdentityJwtClaimName;
import org.sourceid.util.log.AttributeMap;

public final class EmailFieldUtils {
    private static final Log log = LogFactory.getLog(EmailFieldUtils.class);

    private EmailFieldUtils() {
        throw new AssertionError((Object)"not allowed");
    }

    public static boolean isEmailStatusVerified(LocalIdentityProfile lip, LocalIdentityDTO<DN> dto) {
        return EmailFieldUtils.isEmailStatusVerified(lip, dto, true);
    }

    public static boolean isEmailStatusVerified(LocalIdentityProfile lip, LocalIdentityDTO<DN> dto, boolean doLog) {
        String emailValue;
        String statusLipFieldId;
        Map ldapAttributes = dto.getAttributes();
        String statusValue = ldapAttributes.get(statusLipFieldId = lip.getEmailOwnershipVerificationConfig().getFieldStoringVerificationStatus()) == null ? null : ((String[])ldapAttributes.get(statusLipFieldId))[0];
        String emailField = EmailFieldUtils.getEmailVerifyFieldId(lip);
        String string = emailValue = ldapAttributes.get(emailField) == null ? null : ((String[])ldapAttributes.get(emailField))[0];
        if ("TRUE".equalsIgnoreCase(statusValue)) {
            if (doLog) {
                log.debug((Object)("The email " + emailValue + " has the ownership status field set to true."));
            }
            return true;
        }
        return false;
    }

    public static boolean isValidEmail(LocalIdentityProfile lip, LocalIdentityDTO<DN> dto, AttributeMap refAttributes) {
        String currentEmail = EmailFieldUtils.getEmailAddress(lip, dto);
        String emailInJwt = refAttributes.getSingleValue(LocalIdentityJwtClaimName.EMAIL.getLocalIdentityAttributeName());
        log.debug((Object)("Validating email: " + emailInJwt));
        return currentEmail.equalsIgnoreCase(emailInJwt);
    }

    public static String getEmailAddress(LocalIdentityProfile lip, LocalIdentityDTO<DN> dto) {
        String emailField = lip.getEmailOwnershipVerificationConfig().getFieldUsedForOwnershipVerification();
        Map ldapAttributes = dto.getAttributes();
        String[] emailValues = (String[])ldapAttributes.get(emailField);
        return emailValues[0];
    }

    public static LocalIdentityDTO<DN> updateVerifyEmailStatus(LocalIdentityProfile lip, LocalIdentityDTO<DN> dto, Map<String, FieldData<?>> updatedAttributes) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        LocalIdentityStorageManager localIdentityStorageManager = lip.getStorageManager();
        return localIdentityStorageManager.updateIdentity(lip, (DN)dto.getIdentifier(), updatedAttributes);
    }

    public static boolean isEmailVerificationEnabled(LocalIdentityProfile lip) {
        return lip.getEmailOwnershipVerificationConfig() != null && lip.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled();
    }

    public static String getEmailVerifyFieldId(LocalIdentityProfile lip) {
        return lip.getEmailOwnershipVerificationConfig().getFieldUsedForOwnershipVerification();
    }

    public static boolean isExpired(AttributeMap attributes, LocalIdentityProfile lip) throws ParseException {
        Date createDate = EmailFieldUtils.getCreationTime(attributes);
        return EmailFieldUtils.isExpired(createDate, lip);
    }

    public static boolean isExpired(Date createDate, LocalIdentityProfile lip) {
        Date now = new Date();
        long result = now.getTime() / 60000L - createDate.getTime() / 60000L;
        log.debug((Object)("Number of minutes since token was generated: " + result));
        return result > (long)lip.getEmailOwnershipVerificationConfig().getOtlTimeToLive();
    }

    public static Date getCreationTime(AttributeMap attributes) throws ParseException {
        Date creationTime;
        try {
            String timeValue = attributes.getSingleValue(LocalIdentityJwtClaimName.CREATION_TIME.getLocalIdentityAttributeName());
            creationTime = TimeUtil.decodeGeneralizedTime((String)timeValue);
        }
        catch (ParseException e) {
            log.error((Object)("Error parsing Date for stored expiration, returning expired" + e.getMessage()));
            log.debug((Object)e);
            throw e;
        }
        return creationTime;
    }

    public static boolean doEmailVerificationCheck(LocalIdentityProfile localIdentityProfile, Map<String, FieldData<?>> updatedAttributes) {
        boolean shouldSendAnEmail = false;
        if (localIdentityProfile.getEmailOwnershipVerificationConfig() != null && localIdentityProfile.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled()) {
            String statusLipFieldId = localIdentityProfile.getEmailOwnershipVerificationConfig().getFieldStoringVerificationStatus();
            String emailFieldId = localIdentityProfile.getEmailOwnershipVerificationConfig().getFieldUsedForOwnershipVerification();
            if (updatedAttributes.containsKey(emailFieldId)) {
                List fields = localIdentityProfile.getFieldConfig().getListOfAllFields();
                String[] parameterValue = new String[]{"FALSE"};
                for (LocalIdentityField field : fields) {
                    if (!field.getData().getId().equals(statusLipFieldId)) continue;
                    updatedAttributes.put(statusLipFieldId, field.getFieldData(parameterValue));
                    break;
                }
                shouldSendAnEmail = true;
            }
        }
        return shouldSendAnEmail;
    }

    public static boolean isEmailValuePresent(LocalIdentityProfile lip, Map<String, Object> params) {
        boolean isEmailValuePresent = false;
        String emailVerifyFieldId = EmailFieldUtils.getEmailVerifyFieldId(lip);
        String emailValue = String.valueOf(params.get(emailVerifyFieldId));
        if (StringUtils.isNotBlank((String)emailValue)) {
            isEmailValuePresent = true;
        }
        return isEmailValuePresent;
    }
}

