/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.handler;

import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.common.EmailFieldUtils;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.unboundid.ldap.sdk.DN;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.websso.servlet.localidentity.LipHandler;

public abstract class BaseLipHandler
implements LipHandler {
    protected boolean isCSRFCheckRequired(HttpServletRequest req) {
        List<String> csrfExemptHttpMethods = Arrays.asList("GET", "TRACE", "HEAD", "OPTIONS");
        boolean result = true;
        if (csrfExemptHttpMethods.contains(req.getMethod())) {
            result = false;
        }
        return result;
    }

    protected boolean isCSRFValid(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String csrfToken = CrossSiteRequestForgeryHelper.validateCSRFToken((HttpServletRequest)req, (HttpServletResponse)resp);
        if (StringUtils.isBlank((String)csrfToken)) {
            resp.sendError(400);
            return false;
        }
        return true;
    }

    protected LocalIdentityDTO<DN> updateUserVerifyEmailStatus(LocalIdentityProfile lip, LocalIdentityDTO<DN> dto) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        HashMap updatedAttributes = new HashMap();
        String statusLipFieldId = lip.getEmailOwnershipVerificationConfig().getFieldStoringVerificationStatus();
        List fields = lip.getFieldConfig().getListOfAllFields();
        String[] parameterValue = new String[]{"TRUE"};
        for (LocalIdentityField field : fields) {
            if (!field.getData().getId().equals(statusLipFieldId)) continue;
            updatedAttributes.put(statusLipFieldId, field.getFieldData(parameterValue));
            break;
        }
        return EmailFieldUtils.updateVerifyEmailStatus(lip, dto, updatedAttributes);
    }
}

