/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.handler;

import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.locale.StandardTemplateMessage;
import com.pingidentity.locale.TemplateBannerMessage;
import com.pingidentity.locale.TemplateMessage;
import com.pingidentity.locale.TemplateMessageHolder;
import com.pingidentity.localidentity.LocalIdentityAuditLogger;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityLdapDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.pingidentity.localidentity.common.ConnectedIdentityUtils;
import com.pingidentity.localidentity.common.EmailCommunicationUtils;
import com.pingidentity.localidentity.common.EmailFieldUtils;
import com.pingidentity.localidentity.common.LocalIdentityStorageUtils;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.RequiredFieldValidator;
import com.pingidentity.localidentity.handler.BaseLipHandler;
import com.pingidentity.localidentity.type.LocalIdentityValidationResult;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.util.log.AttributeMap;

public class ProfileHandler
extends BaseLipHandler {
    private static final Log log = LogFactory.getLog(ProfileHandler.class);
    private static final String SAVE = "pf.save";
    private static final String CHANGE_PASS = "pf.change.pass";
    private static final String SET_PASS = "pf.set.pass";
    private static final String DELETE = "pf.delete";
    private static final String LOGOUT = "pf.logout";
    private static final String CONNECT = "pf.connect.identity";
    private static final String DISCONNECT = "pf.disconnect.identity";
    private static final String NEW_PASS = "pf.new.pass";
    private static final String CURRENT_PASS = "pf.current.pass";
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    public void handle(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile lip, LocalIdentityDTO<DN> dto, AttributeMap attributeMap) {
        try {
            this.doManage(req, resp, lip, dto);
        }
        catch (IOException e) {
            log.error((Object)("Error occurred on " + LocalIdentityUtils.getProfileManagementPath() + ": " + e.getLocalizedMessage()));
        }
    }

    private void doManage(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile localIdentityProfile, LocalIdentityDTO<DN> dto) throws IOException {
        ProfileMessages messages;
        Map<String, FieldData<?>> updatedAttributes;
        boolean success;
        block43: {
            boolean isHttpPostAction;
            String save = req.getParameter(SAVE);
            String changePw = req.getParameter(CHANGE_PASS);
            String setPw = req.getParameter(SET_PASS);
            String delete = req.getParameter(DELETE);
            String logout = req.getParameter(LOGOUT);
            String connect = req.getParameter(CONNECT);
            String disconnect = req.getParameter(DISCONNECT);
            String sendEmail = req.getParameter("pf.otp.email.send");
            String verifyOtp = req.getParameter("pf.otp.email.verify.otp");
            boolean bl = isHttpPostAction = StringUtils.isNotBlank((String)save) || StringUtils.isNotBlank((String)changePw) || StringUtils.isNotBlank((String)setPw) || StringUtils.isNotBlank((String)delete) || StringUtils.isNotBlank((String)logout) || StringUtils.isNotBlank((String)connect) || StringUtils.isNotBlank((String)disconnect) || StringUtils.isNotBlank((String)sendEmail) || StringUtils.isNotBlank((String)verifyOtp);
            if (isHttpPostAction && !"POST".equals(req.getMethod())) {
                resp.sendError(405);
                return;
            }
            if (this.isCSRFCheckRequired(req) && !this.isCSRFValid(req, resp)) {
                return;
            }
            success = false;
            updatedAttributes = null;
            messages = new ProfileMessages();
            try {
                block44: {
                    if (!isHttpPostAction) break block43;
                    if (StringUtils.isNotBlank((String)logout) && "clicked".equals(logout)) {
                        this.redirectToStartSLO(req, resp, localIdentityProfile.getId());
                        return;
                    }
                    if (StringUtils.isNotBlank((String)delete) && "clicked".equals(delete)) {
                        LocalIdentityAuditLogger.init((LocalIdentityAuditLogger.LocalIdentityAuditEvent)LocalIdentityAuditLogger.LocalIdentityAuditEvent.ACCOUNT_DELETE, dto, (LocalIdentityProfile)localIdentityProfile, null, (HttpServletRequest)req, (HttpServletResponse)resp);
                        LocalIdentityStorageUtils.deleteUser(localIdentityProfile, (DN)dto.getIdentifier(), req, resp);
                        LocalIdentityAuditLogger.log();
                        this.redirectToStartSLO(req, resp, localIdentityProfile.getId());
                        return;
                    }
                    if (StringUtils.isNotBlank((String)changePw) && "clicked".equals(changePw)) {
                        LocalIdentityAuditLogger.init((LocalIdentityAuditLogger.LocalIdentityAuditEvent)LocalIdentityAuditLogger.LocalIdentityAuditEvent.PWD_CHANGE, dto, (LocalIdentityProfile)localIdentityProfile, null, (HttpServletRequest)req, (HttpServletResponse)resp);
                        try {
                            StandardTemplateMessage errorMessage = this.validatePasswordFields(req);
                            if (errorMessage == null) {
                                this.doUpdatePassword(localIdentityProfile, dto, req);
                                LocalIdentityAuditLogger.log();
                                success = true;
                                break block44;
                            }
                            messages.setPasswordError(errorMessage);
                        }
                        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                            messages.setPasswordError(new StandardTemplateMessage(e.getResult().getMessageKey()));
                            if (e.getResult().getMessageKey().equals("local.identity.srvr.msg.invalid.credentials")) {
                                LocalIdentityAuditLogger.logFailure((String)"Existing password not correct");
                                break block44;
                            }
                            LocalIdentityAuditLogger.logFailure((String)"Unexpected error with resetting the password (see server log)");
                        }
                    } else if (StringUtils.isNotBlank((String)setPw) && "clicked".equals(setPw)) {
                        LocalIdentityAuditLogger.init((LocalIdentityAuditLogger.LocalIdentityAuditEvent)LocalIdentityAuditLogger.LocalIdentityAuditEvent.PWD_SET, dto, (LocalIdentityProfile)localIdentityProfile, null, (HttpServletRequest)req, (HttpServletResponse)resp);
                        if (dto.hasPassword()) {
                            log.debug((Object)"Preventing illegal new password set. User already has a password.");
                            return;
                        }
                        try {
                            dto = this.doSetPassword(localIdentityProfile, dto, req);
                            LocalIdentityAuditLogger.log();
                            success = true;
                        }
                        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                            messages.setPasswordError(new StandardTemplateMessage(e.getResult().getMessageKey()));
                            LocalIdentityAuditLogger.logFailure((String)"Unexpected error with setting the password (see server log)");
                        }
                    } else if (StringUtils.isNotBlank((String)sendEmail) && "clicked".equals(sendEmail)) {
                        if (EmailFieldUtils.isEmailStatusVerified(localIdentityProfile, dto, true)) {
                            StandardTemplateMessage message = new StandardTemplateMessage("local.identity.profile.emailAddressVerifiedNotification");
                            messages.addMessage((TemplateMessage)new TemplateBannerMessage(message.getMessageKey(), null, TemplateBannerMessage.TemplateMessageType.NOTICE));
                        } else {
                            try {
                                EmailCommunicationUtils.sendEmailVerification(req, resp, localIdentityProfile, dto);
                                String emailField = EmailFieldUtils.getEmailVerifyFieldId(localIdentityProfile);
                                String emailValue = dto.getAttributes().get(emailField) == null ? null : ((String[])dto.getAttributes().get(emailField))[0];
                                String[] params = new String[]{emailValue};
                                StandardTemplateMessage emailSentMessage = new StandardTemplateMessage("local.identity.profile.sendEmailVerification", params);
                                messages.addMessage((TemplateMessage)new TemplateBannerMessage(emailSentMessage.getMessageKey(), (String[])emailSentMessage.getParams(), TemplateBannerMessage.TemplateMessageType.SUCCESS));
                            }
                            catch (IOException e) {
                                StandardTemplateMessage message = new StandardTemplateMessage("local.identity.profile.errorSendVerificationEmail");
                                messages.addMessage((TemplateMessage)new TemplateBannerMessage(message.getMessageKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR));
                            }
                        }
                    } else if (StringUtils.isNotBlank((String)verifyOtp) && "clicked".equals(verifyOtp)) {
                        if (LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)localIdentityProfile) && !EmailFieldUtils.isEmailStatusVerified(localIdentityProfile, dto)) {
                            String otpSubmitted = req.getParameter("oneTimePasscode");
                            LocalIdentityValidationResult localIdentityValidationResult = LocalIdentityUtils.validateOtp((HttpServletRequest)req, (HttpServletResponse)resp, (String)otpSubmitted, (LocalIdentityProfile)localIdentityProfile, dto);
                            if (localIdentityValidationResult.getValidationResultType() == LocalIdentityValidationResult.ValidationResultType.Success) {
                                LocalIdentityAuditLogger.init((LocalIdentityAuditLogger.LocalIdentityAuditEvent)LocalIdentityAuditLogger.LocalIdentityAuditEvent.EMAIL_ADDRESS_VERIFY, dto, (LocalIdentityProfile)localIdentityProfile, null, (HttpServletRequest)req, (HttpServletResponse)resp);
                                LocalIdentityAuditLogger.log();
                                messages.addMessage((TemplateMessage)new TemplateBannerMessage("local.identity.profile.emailSuccessfullyVerified", null, TemplateBannerMessage.TemplateMessageType.SUCCESS));
                                dto = this.updateUserVerifyEmailStatus(localIdentityProfile, dto);
                            } else {
                                StandardTemplateMessage message = new StandardTemplateMessage("local.identity.profile." + localIdentityValidationResult.getErrorKey());
                                messages.addMessage((TemplateMessage)new TemplateBannerMessage(message.getMessageKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR));
                            }
                        }
                    } else if (StringUtils.isNotBlank((String)save) && "clicked".equals(save)) {
                        updatedAttributes = this.getUpdatedProfileFieldValues(req, localIdentityProfile, dto.getAttributes());
                        List requiredFields = localIdentityProfile.getFieldConfig().getFilteredProfileFields().stream().filter(LocalIdentityField::isRequired).collect(Collectors.toList());
                        RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator(req, requiredFields);
                        requiredFieldValidator.validate();
                        if (!requiredFieldValidator.isValid()) {
                            log.debug((Object)"Required fields were missing. Re-rendering profile page with errors.");
                            requiredFieldValidator.getErrors().getTemplateMessages().forEach(arg_0 -> ((ProfileMessages)messages).addMessage(arg_0));
                        } else if (updatedAttributes != null && !updatedAttributes.isEmpty()) {
                            try {
                                LocalIdentityAuditLogger.init((LocalIdentityAuditLogger.LocalIdentityAuditEvent)LocalIdentityAuditLogger.LocalIdentityAuditEvent.PROFILE_ATTRIBUTE_CHANGE, dto, (LocalIdentityProfile)localIdentityProfile, null, (HttpServletRequest)req, (HttpServletResponse)resp);
                                LocalIdentityAuditLogger.setAttributes((List)localIdentityProfile.getFieldConfig().getFilteredProfileFields(), updatedAttributes);
                                boolean shouldSendAnEmail = EmailFieldUtils.doEmailVerificationCheck(localIdentityProfile, updatedAttributes);
                                dto = LocalIdentityStorageUtils.updateUser(localIdentityProfile, (DN)dto.getIdentifier(), updatedAttributes);
                                LocalIdentityAuditLogger.log();
                                if (shouldSendAnEmail) {
                                    try {
                                        EmailCommunicationUtils.sendEmailVerification(req, resp, localIdentityProfile, dto);
                                        StandardTemplateMessage message = new StandardTemplateMessage("local.identity.profile.sendEmailVerificationGeneric");
                                        messages.addMessage((TemplateMessage)new TemplateBannerMessage(message.getMessageKey(), null, TemplateBannerMessage.TemplateMessageType.SUCCESS));
                                    }
                                    catch (IOException e) {
                                        StandardTemplateMessage message = new StandardTemplateMessage("local.identity.profile.errorSendVerificationEmail");
                                        messages.addMessage((TemplateMessage)new TemplateBannerMessage(message.getMessageKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR));
                                    }
                                }
                                success = true;
                            }
                            catch (LocalIdentityStorageUtils.ModifyIdentityException e) {
                                messages.addMessage((TemplateMessage)e.getMessageWrapper());
                            }
                        }
                    } else {
                        if (StringUtils.isNotBlank((String)connect)) {
                            this.connectUser(connect, localIdentityProfile, req, resp);
                            return;
                        }
                        if (StringUtils.isNotBlank((String)disconnect)) {
                            try {
                                LocalIdentityAuditLogger.init((LocalIdentityAuditLogger.LocalIdentityAuditEvent)LocalIdentityAuditLogger.LocalIdentityAuditEvent.AUTHN_SOURCE_DISCONNECT, dto, (LocalIdentityProfile)localIdentityProfile, (String)disconnect, (HttpServletRequest)req, (HttpServletResponse)resp);
                                LocalIdentityStorageUtils.disconnectIdentity(disconnect, dto, localIdentityProfile);
                                dto = LocalIdentityStorageUtils.retrieveUserData(localIdentityProfile, (DN)dto.getIdentifier());
                                LocalIdentityAuditLogger.log();
                                success = true;
                            }
                            catch (LocalIdentityStorageUtils.DisconnectIdentityException e) {
                                messages.addMessage((TemplateMessage)new TemplateBannerMessage(e.getMessageWrapper().getMessageKey(), (String[])e.getMessageWrapper().getParams(), TemplateBannerMessage.TemplateMessageType.ERROR));
                            }
                        }
                    }
                }
                updatedAttributes = this.getUpdatedProfileFieldValues(req, localIdentityProfile, dto.getAttributes());
            }
            catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Profile management update/delete failed.", (Throwable)e);
                }
                log.error((Object)("Profile management update/delete failed due to: " + e.getMessage()));
                messages.addMessage((TemplateMessage)new TemplateBannerMessage(e.getResult().getMessageKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR));
            }
        }
        this.renderProfilePage(req, resp, dto, localIdentityProfile, LocalIdentityUtils.getProfileManagementPathWithLipId((String)localIdentityProfile.getId()), updatedAttributes, success, messages);
    }

    private void redirectToStartSLO(HttpServletRequest req, HttpServletResponse resp, String lipId) throws IOException {
        String sloTargetResource = MetadataLocalHelper.getSpSloSuccessUrl((MetadataLocal)this.metadataLocal);
        if (StringUtils.isBlank((String)sloTargetResource)) {
            log.warn((Object)"Default SP SLO Url is not defined. Please specify one under 'SP Default URLs'. Redirecting to /sp/startSSO.ping instead.");
            String ProfilePageLocation = this.metadataLocal.getBaseUrl() + LocalIdentityUtils.getProfileManagementPathWithLipId((String)lipId);
            sloTargetResource = BaseUrlUtil.getCurrentBaseUrl((String)ProfilePageLocation);
        }
        sloTargetResource = URLEncoder.encode(sloTargetResource, "UTF-8");
        String sloPath = MetadataLocalHelper.getIdpInitiateSloPath((MetadataLocal)this.metadataLocal);
        Object redirectString = sloPath + "?TargetResource=%s";
        redirectString = String.format((String)redirectString, sloTargetResource);
        redirectString = AdapterPathSupport.convertPath((HttpServletRequest)req, (HttpServletResponse)resp, (String)redirectString);
        resp.sendRedirect((String)redirectString);
    }

    private void doUpdatePassword(LocalIdentityProfile profile, LocalIdentityDTO<DN> dto, HttpServletRequest req) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        try {
            LocalIdentityStorageUtils.updatePassword(profile, (DN)dto.getIdentifier(), req.getParameter(CURRENT_PASS), req.getParameter(NEW_PASS));
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)("Failed to update password for " + dto.getIdentifier() + " due to " + e.getMessage()));
            throw e;
        }
    }

    private LocalIdentityDTO<DN> doSetPassword(LocalIdentityProfile profile, LocalIdentityDTO<DN> originalDto, HttpServletRequest req) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        String newPassword = req.getParameter(NEW_PASS);
        StandardTemplateMessage errorMessage = null;
        if (StringUtils.isBlank((String)newPassword)) {
            errorMessage = new StandardTemplateMessage("local.identity.profile.enterNewPassword");
        }
        if (errorMessage == null) {
            try {
                return LocalIdentityStorageUtils.setPassword(profile, (DN)originalDto.getIdentifier(), newPassword);
            }
            catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                log.error((Object)("Failed to set password for " + originalDto.getIdentifier() + " due to " + e.getMessage()));
                throw e;
            }
        }
        return originalDto;
    }

    public Map<String, FieldData<?>> getUpdatedProfileFieldValues(HttpServletRequest req, LocalIdentityProfile localIdentityProfile, Map<String, String[]> existingAttributes) {
        HashMap attributesKeyValueMap = new HashMap();
        List fields = localIdentityProfile.getFieldConfig().getFilteredProfileFields();
        for (LocalIdentityField field : fields) {
            String[] existingValue;
            String fieldId;
            String[] parameterValue;
            boolean equal;
            if (field.isReadOnly() || (equal = field.compareData(parameterValue = req.getParameterValues(fieldId = field.getData().getId()), existingValue = existingAttributes.get(fieldId)))) continue;
            attributesKeyValueMap.put(fieldId, field.getFieldData(parameterValue));
        }
        return attributesKeyValueMap;
    }

    private StandardTemplateMessage validatePasswordFields(HttpServletRequest request) {
        StandardTemplateMessage errorMessage = null;
        if (StringUtils.isBlank((String)request.getParameter(CURRENT_PASS))) {
            errorMessage = new StandardTemplateMessage("local.identity.profile.enterCurrentPassword");
        } else if (StringUtils.isBlank((String)request.getParameter(NEW_PASS))) {
            errorMessage = new StandardTemplateMessage("local.identity.profile.enterNewPassword");
        }
        return errorMessage;
    }

    private void connectUser(String authSourceId, LocalIdentityProfile profile, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String targetResource = this.getTargetResource();
        targetResource = URLEncoder.encode(targetResource, "UTF-8");
        LocalIdentityAuthSource authSource = profile.getAuthSourceById(authSourceId);
        String redirectString = "/sp/startSSO.ping?SpSessionAuthnAdapterId=idprofile%s&TargetResource=%s&PolicyAction=%s&AccountLinking=true";
        redirectString = String.format(redirectString, profile.getId(), targetResource, authSource.getSource());
        redirectString = AdapterPathSupport.convertPath((HttpServletRequest)req, (HttpServletResponse)resp, (String)redirectString);
        resp.sendRedirect(redirectString);
    }

    private String getTargetResource() {
        return BaseUrlUtil.getCurrentBaseUrl((String)(this.metadataLocal.getBaseUrl() + "/pf/idprofile.ping"));
    }

    private void renderProfilePage(HttpServletRequest req, HttpServletResponse resp, LocalIdentityDTO<DN> dto, LocalIdentityProfile localIdentityProfile, String resumeUrl, Map<String, FieldData<?>> updatedAttributes, boolean success, ProfileMessages messages) throws TemplateRendererUtilException {
        Map<String, Object> groomedParameters = this.groomParameters(localIdentityProfile.getFieldConfig().getListOfAllFields(), dto.getAttributes(), updatedAttributes);
        Map<String, Object> hiddenFieldValues = this.getHiddenFieldValues(localIdentityProfile.getFieldConfig().getListOfHiddenProfileFields(), dto.getAttributes());
        resumeUrl = AdapterPathSupport.convertPath((HttpServletRequest)req, (HttpServletResponse)resp, (String)resumeUrl);
        boolean emailVerificationEnabled = EmailFieldUtils.isEmailVerificationEnabled(localIdentityProfile);
        boolean emailStatusVerified = emailVerificationEnabled && EmailFieldUtils.isEmailStatusVerified(localIdentityProfile, dto, false);
        boolean emailValuePresent = emailVerificationEnabled && EmailFieldUtils.isEmailValuePresent(localIdentityProfile, groomedParameters);
        boolean isDisplaySendEmailButton = emailVerificationEnabled && !emailStatusVerified && emailValuePresent;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", resumeUrl);
        params.put("isDisplaySendEmailButton", isDisplaySendEmailButton);
        params.put("emailVerifyFieldId", emailVerificationEnabled && emailStatusVerified ? EmailFieldUtils.getEmailVerifyFieldId(localIdentityProfile) : "");
        params.put("isOtpEmailVerification", LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)localIdentityProfile));
        params.put("otpVerification", "pf.otp.email.verify.otp");
        params.put("fields", localIdentityProfile.getFieldConfig().getFilteredProfileFields());
        params.put("hiddenFieldValues", hiddenFieldValues);
        params.put("sendEmailVerification", "pf.otp.email.send");
        params.put("save", SAVE);
        params.put("changepass", CHANGE_PASS);
        params.put("setpass", SET_PASS);
        params.put("delete", DELETE);
        params.put("logout", LOGOUT);
        params.put("connect", CONNECT);
        params.put("disconnect", DISCONNECT);
        params.put("pass", NEW_PASS);
        params.put("currentPass", CURRENT_PASS);
        params.put("socialConnections", ConnectedIdentityUtils.createConnectedIdentityInfo(req, dto, localIdentityProfile));
        params.put("hasLocalIdentity", dto.hasPassword());
        params.put("displayDelete", localIdentityProfile.getProfileConfig().isDeleteIdentityEnabled());
        params.put("messages", (Object)messages);
        params.put("success", success);
        params.put("passwordMessage", messages.getPasswordError());
        params.put("populateValues", groomedParameters);
        String csrfTokenParamName = "cSRFToken";
        String csrfToken = CrossSiteRequestForgeryHelper.getCSRFToken((HttpServletRequest)req, (HttpServletResponse)resp);
        params.put(csrfTokenParamName, csrfToken);
        if (dto instanceof LocalIdentityLdapDTO) {
            HashMap<String, String> userAttributes = new HashMap<String, String>();
            Collection ldapAttributes = ((LocalIdentityLdapDTO)dto).getLdapAttributes();
            for (Attribute attribute : ldapAttributes) {
                userAttributes.put(attribute.getName(), attribute.getValue());
            }
            params.put("userAttributes", userAttributes);
        }
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)localIdentityProfile.getProfileConfig().getTemplateName(), params);
    }

    private Map<String, Object> getHiddenFieldValues(List<LocalIdentityField<?>> hiddenFields, Map<String, String[]> attributes) {
        HashMap<String, Object> hiddenValues = new HashMap<String, Object>();
        hiddenFields.forEach(field -> {
            String[] value = (String[])attributes.get(field.getData().getId());
            if (value != null && value.length > 0) {
                if (value.length > 1) {
                    hiddenValues.put(field.getData().getId(), value);
                } else {
                    hiddenValues.put(field.getData().getId(), value[0]);
                }
            } else {
                hiddenValues.put(field.getData().getId(), "");
            }
        });
        return hiddenValues;
    }

    private Map<String, Object> groomParameters(List<LocalIdentityField<?>> profileFields, Map<String, String[]> inParameters, Map<String, FieldData<?>> updatedAttributes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (LocalIdentityField<?> field : profileFields) {
            if (updatedAttributes != null && updatedAttributes.containsKey(field.getData().getId())) {
                FieldData<?> fieldData = updatedAttributes.get(field.getData().getId());
                if (field.isMultiValue()) {
                    result.put(field.getData().getId(), fieldData.getValues());
                    continue;
                }
                Object value = FieldData.Type.BOOLEAN.equals((Object)fieldData.getFieldDataType()) ? String.valueOf(fieldData.getFirstValue()).toUpperCase() : fieldData.getFirstValue();
                result.put(field.getData().getId(), value);
                continue;
            }
            if (!inParameters.containsKey(field.getData().getId()) || inParameters.get(field.getData().getId()) == null) {
                result.put(field.getData().getId(), "");
                continue;
            }
            if (field.isMultiValue()) {
                result.put(field.getData().getId(), inParameters.get(field.getData().getId()));
                continue;
            }
            String[] value = inParameters.get(field.getData().getId());
            if (value != null) {
                result.put(field.getData().getId(), value[0]);
                continue;
            }
            result.put(field.getData().getId(), "");
        }
        return result;
    }

    private static class ProfileMessages
    extends TemplateMessageHolder {
        private StandardTemplateMessage passwordError;

        private ProfileMessages() {
        }

        public StandardTemplateMessage getPasswordError() {
            return this.passwordError;
        }

        public void setPasswordError(StandardTemplateMessage passwordError) {
            this.passwordError = passwordError;
        }
    }
}

